/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.gui.ChatRenderer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ProgressBarRenderer;
import com.limegroup.gnutella.gui.download.DownloadButtons;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.download.DownloadHeaderMouseListener;
import com.limegroup.gnutella.gui.download.DownloadList;
import com.limegroup.gnutella.gui.download.DownloadMouseListener;
import com.limegroup.gnutella.gui.download.DownloadPopupMenu;
import com.limegroup.gnutella.gui.download.DownloadSelectionListener;
import com.limegroup.gnutella.gui.download.DownloadTableModel;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public final class DownloadMediator {
    private static final SettingsManager SETTINGS = SettingsManager.instance();
    private static final JPanel MAIN_PANEL = new PaddedPanel(GUIMediator.getStringResource("DOWNLOAD_TITLE"));
    private static final DownloadList LIST = new DownloadList();
    private static final AbstractTableModel DATA_MODEL = new DownloadTableModel(LIST);
    private static final JTable TABLE = new JTable(DATA_MODEL);
    private static final DownloadPopupMenu POPUP_MENU = new DownloadPopupMenu();
    private static final DownloadButtons BUTTONS = new DownloadButtons();
    private static int _totalDownloads = 0;
    private static boolean _mp3Launched = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ProgressBarHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ChatHolder;

    public DownloadMediator() {
        TABLE.addMouseListener(new DownloadMouseListener());
        int n = TABLE.getRowHeight();
        TABLE.setRowHeight(n + 1);
        TABLE.setShowGrid(false);
        DownloadSelectionListener downloadSelectionListener = new DownloadSelectionListener();
        TABLE.getSelectionModel().addListSelectionListener(downloadSelectionListener);
        JTableHeader jTableHeader = TABLE.getTableHeader();
        jTableHeader.addMouseListener(new DownloadHeaderMouseListener());
        JScrollPane jScrollPane = new JScrollPane(TABLE);
        JPanel jPanel = new JPanel();
        TABLE.getColumnModel().getColumn(0).setPreferredWidth(150);
        TABLE.getColumnModel().getColumn(1).setPreferredWidth(15);
        TABLE.getColumnModel().getColumn(2).setPreferredWidth(120);
        TABLE.getColumnModel().getColumn(3).setPreferredWidth(35);
        TABLE.getColumnModel().getColumn(4).setPreferredWidth(15);
        ProgressBarRenderer progressBarRenderer = new ProgressBarRenderer(TABLE);
        TABLE.setDefaultRenderer(class$com$limegroup$gnutella$gui$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$ProgressBarHolder = DownloadMediator.class$("com.limegroup.gnutella.gui.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$ProgressBarHolder, progressBarRenderer);
        TABLE.setDefaultRenderer(class$com$limegroup$gnutella$gui$ChatHolder == null ? (class$com$limegroup$gnutella$gui$ChatHolder = DownloadMediator.class$("com.limegroup.gnutella.gui.ChatHolder")) : class$com$limegroup$gnutella$gui$ChatHolder, new ChatRenderer());
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.white);
        jScrollPane.getViewport().setBackground(Color.white);
        jPanel.add(jScrollPane);
        MAIN_PANEL.add(jPanel);
        MAIN_PANEL.add(BUTTONS.getComponent());
        DownloadMediator.handleNoRowsSelected();
    }

    public static int getTotalDownloads() {
        return _totalDownloads;
    }

    public static int getCurrentDownloads() {
        return LIST.getCurrentDownloads();
    }

    public static void addDownload(Downloader downloader) {
        if (!LIST.containsDownloader(downloader)) {
            ++_totalDownloads;
            DownloadMediator.clearSelection();
            LIST.add(downloader);
            DATA_MODEL.fireTableRowsInserted(0, 0);
        }
    }

    public static void removeDownload(Downloader downloader) {
        int n;
        if (SETTINGS.getClearCompletedDownload() && downloader.getState() == 4 && (n = LIST.getDownloaderIndex(downloader)) != -1) {
            DownloadMediator.removeDownloadAtIndex(n);
        }
    }

    static void removeDownloadAtIndex(int n) {
        LIST.remove(n);
        DATA_MODEL.fireTableRowsDeleted(n, n);
    }

    public static void updateConnectionStats() {
        LIST.updateConnectionStats();
        DATA_MODEL.fireTableRowsUpdated(0, LIST.size());
    }

    public static Component getComponent() {
        return MAIN_PANEL;
    }

    static void launchSelectedDownloads() {
        final int[] nArray = TABLE.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        String string = "";
        _mp3Launched = false;
        while (n < n2) {
            final int n3 = n++;
            new Thread(){

                public void run() {
                    DownloadDataLine downloadDataLine = LIST.get(nArray[n3]);
                    Downloader downloader = downloadDataLine.getDownloader();
                    File file = downloader.getDownloadFragment();
                    if (file != null) {
                        if (SettingsManager.instance().getPlayerEnabled() && LimeXMLUtils.isMP3File(file) && !_mp3Launched) {
                            PlayListGUI.instance().launchSong(file);
                            _mp3Launched = true;
                        } else {
                            try {
                                Launcher.launchFile(file);
                            }
                            catch (IOException iOException) {
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }.start();
        }
    }

    static void killSelectedDownloads() {
        int[] nArray = TABLE.getSelectedRows();
        int n = nArray.length;
        --n;
        while (n >= 0) {
            int n2 = nArray[n];
            LIST.remove(n2);
            DATA_MODEL.fireTableRowsDeleted(n2, n2);
            --n;
        }
        DownloadMediator.clearSelection();
    }

    static void resumeSelectedDownloads() {
        int[] nArray = TABLE.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            DownloadDataLine downloadDataLine = LIST.get(nArray[n]);
            Downloader downloader = downloadDataLine.getDownloader();
            try {
                downloader.resume();
            }
            catch (AlreadyDownloadingException alreadyDownloadingException) {
                GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", "\"" + alreadyDownloadingException.getFilename() + "\".");
            }
            ++n;
        }
    }

    static void chatWithSelectedDownloads() {
        RouterService routerService = GUIMediator.instance().getRouter();
        int[] nArray = TABLE.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            DownloadDataLine downloadDataLine = LIST.get(nArray[n]);
            Downloader downloader = downloadDataLine.getDownloader();
            Endpoint endpoint = downloader.getChatEnabledHost();
            if (endpoint != null) {
                routerService.createChat(endpoint.getHostname(), endpoint.getPort());
            }
            ++n;
        }
    }

    static void clearCompletedDownloads() {
        LIST.clearCompleted();
        DownloadMediator.clearSelection();
    }

    static void handleRightMouseClick(int n, int n2) {
        POPUP_MENU.show(TABLE, n, n2);
    }

    static void handleMouseDoubleClick() {
        DownloadMediator.launchSelectedDownloads();
    }

    static void handleColumnHeaderClick(int n) {
        TableColumnModel tableColumnModel = TABLE.getColumnModel();
        int n2 = tableColumnModel.getColumnIndexAtX(n);
        int n3 = TABLE.convertColumnIndexToModel(n2);
        if (n3 != -1) {
            LIST.sort(n3);
            DATA_MODEL.fireTableDataChanged();
        }
        DownloadMediator.clearSelection();
    }

    static void handleRowSelection(int n) {
        DownloadDataLine downloadDataLine = LIST.get(n);
        boolean bl = downloadDataLine.getChatEnabled();
        POPUP_MENU.setItemEnabled(0, true);
        POPUP_MENU.setItemEnabled(1, true);
        POPUP_MENU.setItemEnabled(2, true);
        POPUP_MENU.setItemEnabled(3, bl);
        BUTTONS.setButtonEnabled(0, true);
        BUTTONS.setButtonEnabled(1, true);
        BUTTONS.setButtonEnabled(2, true);
        BUTTONS.setButtonEnabled(3, bl);
    }

    static void handleNoRowsSelected() {
        BUTTONS.setButtonEnabled(0, false);
        BUTTONS.setButtonEnabled(1, false);
        BUTTONS.setButtonEnabled(2, false);
        BUTTONS.setButtonEnabled(3, false);
        BUTTONS.setButtonEnabled(4, false);
        POPUP_MENU.setItemEnabled(0, false);
        POPUP_MENU.setItemEnabled(1, false);
        POPUP_MENU.setItemEnabled(2, false);
        POPUP_MENU.setItemEnabled(3, false);
    }

    static void setButtonEnabled(int n, boolean bl) {
        BUTTONS.setButtonEnabled(n, bl);
    }

    private static void clearSelection() {
        TABLE.clearSelection();
        DownloadMediator.handleNoRowsSelected();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

