/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.gui.ProgressBarHolder;
import com.limegroup.gnutella.gui.SizeHolder;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.List;

final class DownloadList
implements Comparator {
    private final ArrayList LIST = new ArrayList();
    private int _ascending = 1;
    private int _col = 0;

    DownloadList() {
    }

    int size() {
        return this.LIST.size();
    }

    void sort(int n) {
        this._ascending = -this._ascending;
        this._col = n;
        Collections.sort((List)this.LIST, (Comparator)this);
    }

    void add(Downloader downloader) {
        this.LIST.add(0, (Object)new DownloadDataLine(downloader));
    }

    DownloadDataLine get(int n) {
        return (DownloadDataLine)this.LIST.get(n);
    }

    void remove(int n) {
        ((DownloadDataLine)this.LIST.get(n)).shutdown();
        this.LIST.remove(n);
    }

    Object getValueAt(int n, int n2) {
        return ((DownloadDataLine)this.LIST.get(n)).getValueAt(n2);
    }

    boolean containsDownloader(Downloader downloader) {
        int n = this.LIST.size();
        int n2 = 0;
        while (n2 < n) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.LIST.get(n2);
            if (downloadDataLine.containsDownloader(downloader)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    int getDownloaderIndex(Downloader downloader) {
        int n = this.LIST.size();
        int n2 = 0;
        while (n2 < n) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.LIST.get(n2);
            if (downloadDataLine.containsDownloader(downloader)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    int countActiveDownloads() {
        int n = this.LIST.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.LIST.get(n3);
            if (!downloadDataLine.isInactive()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    int getCurrentDownloads() {
        int n = this.LIST.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.LIST.get(n3);
            if (downloadDataLine.isDownloading()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    void updateConnectionStats() {
        int n = this.LIST.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.LIST.get(n2);
            downloadDataLine.update();
            if (downloadDataLine.isInactive()) {
                bl = true;
            }
            ++n2;
        }
        DownloadMediator.setButtonEnabled(4, bl);
    }

    void clearCompleted() {
        int n = this.LIST.size();
        --n;
        int n2 = this.LIST.size() - 1;
        while (n2 >= 0) {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.LIST.get(n2);
            if (downloadDataLine.isInactive()) {
                DownloadMediator.removeDownloadAtIndex(n2);
            }
            --n2;
        }
        DownloadMediator.setButtonEnabled(4, false);
    }

    public int compare(Object object, Object object2) {
        DownloadDataLine downloadDataLine = (DownloadDataLine)object;
        DownloadDataLine downloadDataLine2 = (DownloadDataLine)object2;
        switch (this._col) {
            case 0: 
            case 2: 
            case 5: {
                String string = ((String)downloadDataLine.getValueAt(this._col)).toLowerCase();
                String string2 = ((String)downloadDataLine2.getValueAt(this._col)).toLowerCase();
                return string.compareTo(string2) * this._ascending;
            }
            case 1: {
                SizeHolder sizeHolder = (SizeHolder)downloadDataLine.getValueAt(this._col);
                SizeHolder sizeHolder2 = (SizeHolder)downloadDataLine2.getValueAt(this._col);
                int n = sizeHolder.getSize();
                int n2 = sizeHolder2.getSize();
                return (n - n2) * this._ascending;
            }
            case 3: {
                boolean bl = (Boolean)downloadDataLine.getValueAt(this._col);
                boolean bl2 = (Boolean)downloadDataLine2.getValueAt(this._col);
                if (bl == bl2) {
                    return 0;
                }
                if (bl && !bl2) {
                    return -this._ascending;
                }
                return this._ascending;
            }
            case 4: {
                ProgressBarHolder progressBarHolder = (ProgressBarHolder)downloadDataLine.getValueAt(this._col);
                ProgressBarHolder progressBarHolder2 = (ProgressBarHolder)downloadDataLine2.getValueAt(this._col);
                int n = progressBarHolder.getValue();
                int n3 = progressBarHolder2.getValue();
                return (n - n3) * this._ascending;
            }
        }
        return -1;
    }
}

