/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ProgressBarHolder;
import com.limegroup.gnutella.gui.SizeHolder;
import com.sun.java.util.collections.Iterator;
import java.text.DecimalFormat;
import java.text.NumberFormat;

final class DownloadDataLine {
    private final Downloader DOWNLOADER;
    private final SizeHolder SIZE;
    private final ProgressBarHolder PROGRESS = new ProgressBarHolder();
    private static final String QUEUED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_QUEUED");
    private static final String CONNECTING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_CONNECTING");
    private static final String WAITING_STATE_START = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_START");
    private static final String WAITING_STATE_MIDDLE = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_MIDDLE");
    private static final String WAITING_STATE_END = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_END");
    private static final String COMPLETE_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_COMPLETE");
    private static final String ABORTED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_ABORTED");
    private static final String FAILED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_FAILED");
    private static final String DOWNLOADING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_DOWNLOADING");
    private static final String LIBRARY_MOVE_FAILED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_LIBRARY_MOVE_FAILED");
    private String _fileName;
    private String _status;
    private String _speed;
    private int _amountRead = 0;
    private boolean _completed = false;
    private Boolean _chatEnabled;
    private int _state;

    DownloadDataLine(Downloader downloader) {
        this.DOWNLOADER = downloader;
        this.SIZE = new SizeHolder(this.DOWNLOADER.getContentLength());
        this._fileName = this.DOWNLOADER.getFileName();
        if (this._fileName == null) {
            this._fileName = "";
        }
        this._status = "";
        this._speed = "0 KB/s";
        this._chatEnabled = new Boolean(this.DOWNLOADER.hasChatEnabledHost());
    }

    Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this._fileName;
            }
            case 1: {
                return this.SIZE;
            }
            case 2: {
                return this._status;
            }
            case 3: {
                return this._chatEnabled;
            }
            case 4: {
                return this.PROGRESS;
            }
            case 5: {
                return this._speed;
            }
        }
        return null;
    }

    int getLength() {
        return this.SIZE.getSize();
    }

    void shutdown() {
        this.DOWNLOADER.stop();
    }

    boolean containsDownloader(Downloader downloader) {
        return this.DOWNLOADER.equals(downloader);
    }

    Downloader getDownloader() {
        return this.DOWNLOADER;
    }

    String getIPName() {
        return DownloadDataLine.getHostDescription(this.DOWNLOADER);
    }

    boolean isCompleted() {
        return this._completed;
    }

    boolean getChatEnabled() {
        return this._chatEnabled;
    }

    void update() {
        String string = this.DOWNLOADER.getFileName();
        if (string != null) {
            this._fileName = string;
        }
        this.SIZE.setSize(this.DOWNLOADER.getContentLength());
        this._amountRead = this.DOWNLOADER.getAmountRead();
        this._speed = "";
        this._chatEnabled = new Boolean(this.DOWNLOADER.hasChatEnabledHost());
        this.updateStatus();
    }

    private void updateStatus() {
        this._state = this.DOWNLOADER.getState();
        switch (this._state) {
            case 0: {
                this._status = QUEUED_STATE;
                break;
            }
            case 1: {
                String string = this.DOWNLOADER.getAddress();
                if (string == null) {
                    string = "";
                }
                Assert.that(string != null, "Null address in connecting state");
                int n = this.DOWNLOADER.getRemainingStateTime();
                this._status = CONNECTING_STATE + string + " (" + n + "s)";
                break;
            }
            case 3: {
                int n = this.DOWNLOADER.getRemainingStateTime();
                int n2 = this.DOWNLOADER.getRetriesWaiting();
                this._status = WAITING_STATE_START + n + WAITING_STATE_MIDDLE + n2 + WAITING_STATE_END;
                break;
            }
            case 4: {
                if (this._completed) break;
                this._completed = true;
                this._status = COMPLETE_STATE;
                this.PROGRESS.setValue(100);
                break;
            }
            case 5: {
                this._status = ABORTED_STATE;
                break;
            }
            case 6: {
                this._status = FAILED_STATE;
                break;
            }
            case 2: {
                String string = DownloadDataLine.getHostDescription(this.DOWNLOADER);
                Assert.that(string != null, "Null address in downloading state");
                this._status = DOWNLOADING_STATE + string;
                double d = (double)this._amountRead / (double)this.SIZE.getSize();
                int n = (int)(d * 100.0);
                this.PROGRESS.setValue(n);
                double d2 = this.DOWNLOADER.getMeasuredBandwidth();
                if (!(d2 >= 0.0)) break;
                DecimalFormat decimalFormat = new DecimalFormat();
                ((NumberFormat)decimalFormat).setMaximumFractionDigits(1);
                this._speed = decimalFormat.format(d2) + " KB/s";
                break;
            }
            case 7: {
                this._status = LIBRARY_MOVE_FAILED_STATE;
                this.PROGRESS.setValue(100);
                break;
            }
            default: {
                Assert.that(false, "Unknown status " + this.DOWNLOADER.getState() + " of downloader");
            }
        }
    }

    private static String getHostDescription(Downloader downloader) {
        int n = 0;
        Endpoint endpoint = null;
        Iterator iterator = downloader.getHosts();
        while (iterator.hasNext()) {
            endpoint = (Endpoint)iterator.next();
            ++n;
        }
        if (n == 1) {
            Assert.that(endpoint != null, "Null last");
            return endpoint.getHostname();
        }
        return n + " " + GUIMediator.getStringResource("DOWNLOAD_HOSTS_LABEL");
    }

    boolean isInactive() {
        return this._state == 4 || this._state == 5 || this._state == 6 || this._state == 7;
    }

    boolean isDownloading() {
        return this._state == 2;
    }
}

