/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.ConnectionView;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.UploadView;
import com.limegroup.gnutella.gui.chat.ChatFactory;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.search.SearchView;
import com.sun.java.util.collections.Vector;
import java.io.File;
import javax.swing.SwingUtilities;

public final class VisualConnectionCallback
implements ActivityCallback {
    private final GUIMediator MEDIATOR = GUIMediator.instance();
    private final HandleQueryString HANDLE_QUERY_STRING = new HandleQueryString();
    private final SearchView SEARCH_VIEW;
    private final DownloadMediator DOWNLOAD_MEDIATOR;
    private final MonitorView MONITOR_VIEW;
    private final UploadView UPLOAD_VIEW;
    private final ConnectionView CONNECTION_VIEW;
    private final LibraryMediator LIBRARY_MEDIATOR;

    VisualConnectionCallback() {
        MainFrame mainFrame = this.MEDIATOR.getMainFrame();
        this.SEARCH_VIEW = mainFrame.getSearchView();
        this.DOWNLOAD_MEDIATOR = mainFrame.getDownloadMediator();
        this.MONITOR_VIEW = mainFrame.getMonitorView();
        this.UPLOAD_VIEW = mainFrame.getUploadView();
        this.CONNECTION_VIEW = mainFrame.getConnectionView();
        this.LIBRARY_MEDIATOR = mainFrame.getLibraryMediator();
    }

    public void connectionInitializing(Connection connection) {
        ConnectionInitializing connectionInitializing = new ConnectionInitializing(connection);
        SwingUtilities.invokeLater(connectionInitializing);
    }

    public void connectionInitialized(Connection connection) {
        ConnectionInitialized connectionInitialized = new ConnectionInitialized(connection);
        SwingUtilities.invokeLater(connectionInitialized);
    }

    public void connectionClosed(Connection connection) {
        ConnectionClosed connectionClosed = new ConnectionClosed(connection);
        SwingUtilities.invokeLater(connectionClosed);
    }

    public void knownHost(Endpoint endpoint) {
        KnownHost knownHost = new KnownHost(endpoint);
        SwingUtilities.invokeLater(knownHost);
    }

    public void handleQueryReply(QueryReply queryReply) {
        this.SEARCH_VIEW.handleQueryReply(queryReply);
    }

    public void handleQueryString(String string) {
        this.HANDLE_QUERY_STRING.addQueryString(string);
    }

    public void addSharedDirectory(final File file, final File file2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.LIBRARY_MEDIATOR.addSharedDirectory(file, file2);
            }
        });
    }

    public void addSharedFile(final File file, final File file2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualConnectionCallback.this.LIBRARY_MEDIATOR.addSharedFile(file, file2);
            }
        });
    }

    public void clearSharedFiles() {
        this.LIBRARY_MEDIATOR.clearLibrary();
    }

    public void error(int n) {
        Error error = new Error(n, null);
        SwingUtilities.invokeLater(error);
    }

    public void error(int n, Throwable throwable) {
        Error error = new Error(n, throwable);
        SwingUtilities.invokeLater(error);
    }

    public void error(Throwable throwable) {
        Error error = new Error(throwable);
        SwingUtilities.invokeLater(error);
    }

    public void addDownload(Downloader downloader) {
        AddDownload addDownload = new AddDownload(downloader);
        SwingUtilities.invokeLater(addDownload);
    }

    public void removeDownload(Downloader downloader) {
        RemoveDownload removeDownload = new RemoveDownload(downloader);
        SwingUtilities.invokeLater(removeDownload);
    }

    public void downloadsComplete() {
        Finalizer.setDownloadsComplete();
    }

    public void addUpload(Uploader uploader) {
        AddUpload addUpload = new AddUpload(uploader);
        SwingUtilities.invokeLater(addUpload);
    }

    public void removeUpload(Uploader uploader) {
        RemoveUpload removeUpload = new RemoveUpload(uploader);
        SwingUtilities.invokeLater(removeUpload);
    }

    public void uploadsComplete() {
        Finalizer.setUploadsComplete();
    }

    public void acceptChat(Chatter chatter) {
        ChatFactory.instance().acceptChat(chatter);
    }

    public void receiveMessage(Chatter chatter) {
        ChatFactory.instance().recieveMessage(chatter);
    }

    public void chatUnavailable(Chatter chatter) {
        ChatFactory.instance().chatUnavailable(chatter);
    }

    public void chatErrorMessage(Chatter chatter, String string) {
        ChatFactory.instance().chatErrorMessage(chatter, string);
    }

    private class Error
    implements Runnable {
        private int message;
        private Throwable problem;

        public Error(int n, Throwable throwable) {
            this.message = n;
            this.problem = throwable;
        }

        private Error(Throwable throwable) {
            this.problem = throwable;
        }

        public void run() {
            String string = null;
            switch (this.message) {
                case 0: {
                    string = "ERROR_PORT";
                    break;
                }
                case 1: {
                    string = "ERROR_INCOMING_CONNECTIONS";
                    break;
                }
                case 2: {
                    string = "ERROR_INTERNAL";
                }
            }
            if (string != null && this.problem == null) {
                VisualConnectionCallback.this.MEDIATOR;
                GUIMediator.showError(string);
            } else if (string == null) {
                VisualConnectionCallback.this.MEDIATOR;
                GUIMediator.showInternalError(this.problem);
            } else if (string != null && this.problem != null) {
                VisualConnectionCallback.this.MEDIATOR;
                GUIMediator.showInternalError(string, this.problem);
            }
        }
    }

    private class RemoveUpload
    implements Runnable {
        private Uploader mgr;

        public RemoveUpload(Uploader uploader) {
            this.mgr = uploader;
        }

        public void run() {
            VisualConnectionCallback.this.UPLOAD_VIEW.removeConnection(this.mgr);
        }
    }

    private class AddUpload
    implements Runnable {
        private Uploader up;

        public AddUpload(Uploader uploader) {
            this.up = uploader;
        }

        public void run() {
            VisualConnectionCallback.this.UPLOAD_VIEW.addConnection(this.up);
        }
    }

    private class RemoveDownload
    implements Runnable {
        private Downloader mgr;

        public RemoveDownload(Downloader downloader) {
            this.mgr = downloader;
        }

        public void run() {
            VisualConnectionCallback.this.DOWNLOAD_MEDIATOR;
            DownloadMediator.removeDownload(this.mgr);
        }
    }

    private class AddDownload
    implements Runnable {
        private Downloader mgr;

        public AddDownload(Downloader downloader) {
            this.mgr = downloader;
        }

        public void run() {
            VisualConnectionCallback.this.DOWNLOAD_MEDIATOR;
            DownloadMediator.addDownload(this.mgr);
        }
    }

    private class HandleQueryString
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addQueryString(String string) {
            this.list.add((Object)string);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            while (this.list.size() > 0) {
                String string = (String)this.list.elementAt(0);
                this.list.remove(0);
                VisualConnectionCallback.this.MONITOR_VIEW.handleQueryString(string);
            }
            this.active = false;
        }
    }

    private class KnownHost
    implements Runnable {
        private Endpoint e;

        public KnownHost(Endpoint endpoint) {
            this.e = endpoint;
        }

        public void run() {
        }
    }

    private class ConnectionClosed
    implements Runnable {
        private Connection c;

        public ConnectionClosed(Connection connection) {
            this.c = connection;
        }

        public void run() {
            VisualConnectionCallback.this.CONNECTION_VIEW.removeConnection(this.c);
        }
    }

    private class ConnectionInitialized
    implements Runnable {
        private Connection c;

        public ConnectionInitialized(Connection connection) {
            this.c = connection;
        }

        public void run() {
            VisualConnectionCallback.this.CONNECTION_VIEW.renameConnection(this.c);
            VisualConnectionCallback.this.CONNECTION_VIEW.updateConnection(this.c);
        }
    }

    private class ConnectionInitializing
    implements Runnable {
        private Connection c;

        public ConnectionInitializing(Connection connection) {
            this.c = connection;
        }

        public void run() {
            VisualConnectionCallback.this.CONNECTION_VIEW.addConnection(this.c);
        }
    }
}

