/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ProgressBarHolder;
import com.limegroup.gnutella.gui.ProgressBarRenderer;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class UploadView
extends PaddedPanel {
    public static final int FILE = 0;
    public static final int HOST = 1;
    public static final int SIZE = 2;
    public static final int STATUS = 3;
    public static final int BAR = 4;
    public static final int SPEED = 5;
    public static final int NUMBER_OF_COLUMNS = 6;
    private AbstractTableModel _dataModel;
    private JTable _tableView;
    private JScrollPane _scrollpane;
    private JPanel _tablepane;
    private UploadList _list;
    private SettingsManager _settings = SettingsManager.instance();
    private int _totUploads;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ProgressBarHolder;

    UploadView() {
        super(GUIMediator.getStringResource("UPLOAD_TITLE"));
        this.setLayout(new BoxLayout(this, 1));
        this._totUploads = 0;
        this._list = new UploadList();
        this._dataModel = new UploadTableModel();
        this._tableView = new JTable(this._dataModel);
        String string = GUIMediator.getStringResource("UPLOAD_CHAT_BUTTON_LABEL");
        JMenuItem jMenuItem = new JMenuItem(string);
        ChatListener chatListener = new ChatListener();
        jMenuItem.addActionListener(chatListener);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jMenuItem);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int[] nArray = UploadView.this._tableView.getSelectedRows();
                    int n = 0;
                    while (n < nArray.length) {
                        Upload upload = UploadView.this._list.getUploadAt(n);
                        Uploader uploader = upload.getUploader();
                        if (uploader.chatEnabled()) {
                            jPopupMenu.show(UploadView.this._tableView, mouseEvent.getX(), mouseEvent.getY());
                        }
                        ++n;
                    }
                }
            }
        };
        this._tableView.addMouseListener(mouseAdapter);
        int n = this._tableView.getRowHeight();
        this._tableView.setRowHeight(n + 1);
        this._tableView.setShowGrid(false);
        this._scrollpane = new JScrollPane(this._tableView);
        this._tablepane = new JPanel();
        this._tablepane.setBackground(Color.white);
        this._scrollpane.getViewport().setBackground(Color.white);
        this._tablepane.setLayout(new BoxLayout(this._tablepane, 1));
        this._tablepane.add(this._scrollpane);
        JTableHeader jTableHeader = this._tableView.getTableHeader();
        this._tableView.getColumnModel().getColumn(0).setPreferredWidth(180);
        this._tableView.getColumnModel().getColumn(1).setPreferredWidth(70);
        this._tableView.getColumnModel().getColumn(2).setPreferredWidth(70);
        this._tableView.getColumnModel().getColumn(3).setPreferredWidth(180);
        jTableHeader.addMouseListener(new ColumnSorter());
        this.add(this._tablepane);
        this.setProgressBarRenderer();
        KillListener killListener = new KillListener();
        ClearListener clearListener = new ClearListener();
        String[] stringArray = new String[]{"UPLOAD_KILL_BUTTON_LABEL", "UPLOAD_CLEAR_BUTTON_LABEL"};
        String[] stringArray2 = new String[]{"UPLOAD_KILL_BUTTON_TIP", "UPLOAD_CLEAR_BUTTON_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{killListener, clearListener};
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray, 0, 14);
        this.add(buttonRow);
    }

    public void addConnection(Uploader uploader) {
        ++this._totUploads;
        this._list.addRow(uploader);
        this._dataModel.fireTableRowsInserted(0, 0);
    }

    public int getCurrentUploads() {
        return this._list.getCurrentNumUploads();
    }

    public int getTotalUploads() {
        return this._totUploads;
    }

    private void setProgressBarRenderer() {
        ProgressBarRenderer progressBarRenderer = new ProgressBarRenderer(this._tableView);
        this._tableView.setDefaultRenderer(class$com$limegroup$gnutella$gui$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$ProgressBarHolder = UploadView.class$("com.limegroup.gnutella.gui.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$ProgressBarHolder, progressBarRenderer);
    }

    public void removeConnection(Uploader uploader) {
        int n = uploader.getState();
        if (this._settings.getClearCompletedUpload() && (n == 4 || n == 6 || n == 2 || n == 5 || n == 7 || n == 1)) {
            this._list.removeConnection(uploader);
        }
        this._dataModel.fireTableDataChanged();
    }

    public void updateConnectionStats() {
        this._list.updateConnectionStats();
    }

    public void sort(int n) {
        this._list.sort(n);
        this._dataModel.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UploadComp
    implements Comparator {
        private int col_;
        private int mode_;
        private final int ASCENDING = 0;

        public UploadComp(int n, int n2) {
            this.col_ = n;
            this.mode_ = n2;
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            Upload upload = (Upload)object;
            Upload upload2 = (Upload)object2;
            switch (this.col_) {
                case 0: 
                case 1: 
                case 3: {
                    String string = (String)upload.getAt(this.col_);
                    String string2 = (String)upload2.getAt(this.col_);
                    if (this.mode_ == 0) {
                        n = string2.compareTo(string);
                        break;
                    }
                    n = string.compareTo(string2);
                    break;
                }
                case 4: {
                    ProgressBarHolder progressBarHolder = (ProgressBarHolder)upload.getAt(this.col_);
                    ProgressBarHolder progressBarHolder2 = (ProgressBarHolder)upload2.getAt(this.col_);
                    int n2 = progressBarHolder.getValue();
                    int n3 = progressBarHolder2.getValue();
                    if (this.mode_ == 0) {
                        n = -(n2 - n3);
                        break;
                    }
                    n = n2 - n3;
                    break;
                }
                case 2: {
                    SizeHolder sizeHolder = (SizeHolder)upload.getAt(this.col_);
                    SizeHolder sizeHolder2 = (SizeHolder)upload2.getAt(this.col_);
                    int n4 = sizeHolder.getSize();
                    int n5 = sizeHolder2.getSize();
                    if (this.mode_ == 0) {
                        n = -(n4 - n5);
                        break;
                    }
                    n = n4 - n5;
                    break;
                }
            }
            return n;
        }
    }

    private class ColumnSorter
    extends MouseAdapter {
        private ColumnSorter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = UploadView.this._tableView.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = UploadView.this._tableView.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                UploadView.this.sort(n2);
            }
        }
    }

    private class Upload {
        private Uploader _uploader;
        private String _fileName;
        private String _hostName;
        private String _status;
        private ProgressBarHolder _progressBar;
        private int _currentSize;
        private int _priorSize;
        private String _rate;
        private SizeHolder _size;

        public Upload(Uploader uploader) {
            this._uploader = uploader;
            this._fileName = uploader.getFileName();
            this._hostName = uploader.getHost();
            this._progressBar = new ProgressBarHolder();
            this._currentSize = 0;
            this._status = this.getStatus();
            this._size = new SizeHolder(uploader.getFileSize());
            this._rate = this.rateToString(this.getRate());
        }

        public int getState() {
            return this._uploader.getState();
        }

        public Uploader getUploader() {
            return this._uploader;
        }

        public String getFileName() {
            return this._fileName;
        }

        public String getHostName() {
            return this._hostName;
        }

        public int getFileSize() {
            return this._size.getSize();
        }

        public int getCurrentSize() {
            return this._currentSize;
        }

        public ProgressBarHolder getProgressBar() {
            return this._progressBar;
        }

        public String getSpeed() {
            return this._rate;
        }

        private String rateToString(double d) {
            DecimalFormat decimalFormat = new DecimalFormat();
            ((NumberFormat)decimalFormat).setMaximumFractionDigits(1);
            return decimalFormat.format(d) + GUIMediator.getStringResource("UPLOAD_STRING_KBPSEC");
        }

        public Object getAt(int n) {
            switch (n) {
                case 0: {
                    return this._fileName;
                }
                case 1: {
                    return this._hostName;
                }
                case 3: {
                    return this.getStatus();
                }
                case 4: {
                    return this._progressBar;
                }
                case 2: {
                    return this._size;
                }
                case 5: {
                    double d = this.getRate();
                    this._rate = this.rateToString(this.getRate());
                    return this._rate;
                }
            }
            return new String("");
        }

        public void setAt(int n, Object object) {
            switch (n) {
                case 0: {
                    this._fileName = (String)object;
                    break;
                }
                case 1: {
                    this._hostName = (String)object;
                    break;
                }
                case 3: {
                    this._status = (String)object;
                    break;
                }
                case 4: {
                    this._progressBar = (ProgressBarHolder)object;
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    this._rate = (String)object;
                }
            }
        }

        public String getStatus() {
            int n = this._uploader.getState();
            switch (n) {
                case 0: {
                    this._status = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_CONNECTING");
                    break;
                }
                case 3: {
                    this._status = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_UPLOADING");
                    break;
                }
                case 2: {
                    this._status = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_LIMITREACHED");
                    break;
                }
                case 1: {
                    this._status = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_FREELOADER");
                    break;
                }
                case 6: {
                    this._status = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_PUSHFAILED");
                    break;
                }
                case 5: {
                    this._status = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_INTERRUPTED");
                    break;
                }
                case 4: {
                    this._status = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_COMPLETE");
                    break;
                }
                case 7: {
                    this._status = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_FNF");
                    break;
                }
                default: {
                    Assert.that(false, "Internal error: upload in unknown state.");
                }
            }
            return this._status;
        }

        public void update() {
            this.setCurrentSize();
            this.setProgressValue(this.getPercent());
            this.getRate();
        }

        private double getRate() {
            return this._uploader.getMeasuredBandwidth();
        }

        private int getPercent() {
            double d = (double)this._currentSize / (double)this._size.getSize();
            int n = (int)(d * 100.0);
            return n;
        }

        private void setCurrentSize() {
            this._priorSize = this._currentSize;
            this._currentSize = this._uploader.amountUploaded();
        }

        private void setProgressValue(int n) {
            this._progressBar.setValue(n);
        }
    }

    private class SizeHolder {
        String _string;
        int _size;

        private SizeHolder(int n) {
            this._string = GUIUtils.toKilobytes(n);
            this._size = n;
        }

        public String toString() {
            return this._string;
        }

        private int getSize() {
            return this._size;
        }
    }

    private class UploadList {
        private ArrayList _list = new ArrayList();
        private boolean _ascending = false;

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return GUIMediator.getStringResource("UPLOAD_TABLE_STRING_NAME");
                }
                case 1: {
                    return GUIMediator.getStringResource("UPLOAD_TABLE_STRING_HOST");
                }
                case 2: {
                    return GUIMediator.getStringResource("UPLOAD_TABLE_STRING_SIZE");
                }
                case 3: {
                    return GUIMediator.getStringResource("UPLOAD_TABLE_STRING_STATUS");
                }
                case 4: {
                    return GUIMediator.getStringResource("UPLOAD_TABLE_STRING_PROGRESS");
                }
                case 5: {
                    return GUIMediator.getStringResource("UPLOAD_TABLE_STRING_SPEED");
                }
            }
            return new String("");
        }

        public int getNumRows() {
            return this._list.size();
        }

        public int getNumColumns() {
            return 6;
        }

        public Object getAt(int n, int n2) {
            Upload upload = (Upload)this._list.get(n);
            return upload.getAt(n2);
        }

        public void setAt(int n, int n2, Object object) {
            Upload upload = (Upload)this._list.get(n);
            upload.setAt(n2, object);
        }

        public void removeConnection(Uploader uploader) {
            int n = 0;
            while (n < this._list.size()) {
                Upload upload = (Upload)this._list.get(n);
                Uploader uploader2 = upload.getUploader();
                if (uploader2 == uploader) {
                    this.removeRow(n);
                    break;
                }
                ++n;
            }
        }

        public void removeRow(int n) {
            try {
                Upload upload = (Upload)this._list.get(n);
                Uploader uploader = upload.getUploader();
                uploader.stop();
                this._list.remove(n);
                UploadView.this._dataModel.fireTableRowsDeleted(n, n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        public void addRow(Uploader uploader) {
            if (this._list.contains((Object)uploader)) {
                return;
            }
            Upload upload = new Upload(uploader);
            this._list.add(0, (Object)upload);
        }

        public void updateConnectionStats() {
            int n = 0;
            while (n < this._list.size()) {
                Upload upload = (Upload)this._list.get(n);
                upload.update();
                UploadView.this._dataModel.fireTableRowsUpdated(n, n);
                ++n;
            }
        }

        public Upload getUploadAt(int n) {
            return (Upload)this._list.get(n);
        }

        public int getCurrentNumUploads() {
            int n = 0;
            int n2 = 0;
            while (n2 < this._list.size()) {
                Upload upload = (Upload)this._list.get(n2);
                if (upload.getState() == 3) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        public void clearCompleted() {
            int n = this._list.size() - 1;
            while (n >= 0) {
                Upload upload = (Upload)this._list.get(n);
                int n2 = upload.getState();
                if (n2 == 4 || n2 == 6 || n2 == 2 || n2 == 5 || n2 == 7 || n2 == 1) {
                    this._list.remove(n);
                }
                --n;
            }
        }

        public void sort(int n) {
            UploadComp uploadComp;
            if (this._ascending) {
                uploadComp = new UploadComp(n, 0);
                this._ascending = false;
            } else {
                uploadComp = new UploadComp(n, 1);
                this._ascending = true;
            }
            Collections.sort((List)this._list, (Comparator)uploadComp);
        }
    }

    private class UploadTableModel
    extends AbstractTableModel {
        private UploadTableModel() {
        }

        public int getColumnCount() {
            return UploadView.this._list.getNumColumns();
        }

        public int getRowCount() {
            return UploadView.this._list.getNumRows();
        }

        public Object getValueAt(int n, int n2) {
            if (n >= UploadView.this._list.getNumRows() || n2 >= UploadView.this._list.getNumColumns()) {
                return new String("");
            }
            return UploadView.this._list.getAt(n, n2);
        }

        public String getColumnName(int n) {
            return UploadView.this._list.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n >= UploadView.this._list.getNumRows()) {
                return;
            }
            UploadView.this._list.setAt(n, n2, object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    private class ChatListener
    implements ActionListener {
        private ChatListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RouterService routerService = GUIMediator.instance().getRouter();
            int[] nArray = UploadView.this._tableView.getSelectedRows();
            int n = nArray.length - 1;
            while (n >= 0) {
                Upload upload = UploadView.this._list.getUploadAt(n);
                Uploader uploader = upload.getUploader();
                if (uploader.chatEnabled()) {
                    String string = uploader.getChatHost();
                    int n2 = uploader.getChatPort();
                    routerService.createChat(string, n2);
                }
                --n;
            }
        }
    }

    private class ClearListener
    implements ActionListener {
        private ClearListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UploadView.this._list.clearCompleted();
            UploadView.this._dataModel.fireTableDataChanged();
        }
    }

    private class KillListener
    implements ActionListener {
        private KillListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = UploadView.this._tableView.getSelectedRows();
            int n = 0;
            while (n < nArray.length) {
                UploadView.this._list.removeRow(nArray[n]);
                ++n;
            }
            UploadView.this._dataModel.fireTableDataChanged();
        }
    }
}

