/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.CBanner;
import com.limegroup.gnutella.gui.ConnectionView;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.NonWindowsCBanner;
import com.limegroup.gnutella.gui.SwitchBannerAds;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class StatusLine
extends JPanel
implements SwitchBannerAds {
    private JPanel switchedPanel;
    private CardLayout switcher;
    private JLabel sharingLabel;
    private ConnectionView connectionView;
    private boolean labelAvailable = true;
    private static StatusLine myInstance = null;
    private static Component cbanner;
    private JPanel centerPanel = null;
    private static MediaPlayerComponent myMPC;
    private String STATS_AVAILABLE_STRING = GUIMediator.getStringResource("STATISTICS_AVAILABLE");
    private String STATS_FILE_STRING = GUIMediator.getStringResource("STATISTICS_FILES");
    private String STATS_DISCONNECTED_STRING = GUIMediator.getStringResource("STATISTICS_DISCONNECTED");
    private String STATS_SHARING_STRING = GUIMediator.getStringResource("STATISTICS_SHARING");
    private final boolean debugOn = false;
    static final long[] VALUES;
    static final long[] BVALUES;
    static final String[] SUFFIXES;
    static final String[] BSUFFIXES;

    public StatusLine() {
        super(new BorderLayout());
        Serializable serializable;
        this.createConnectButtons();
        this.sharingLabel = new JLabel("           ");
        this.sharingLabel.setHorizontalAlignment(0);
        this.sharingLabel.setToolTipText("The number of files you are sharing.");
        this.setStatistics(0L, 0L, 0L, 0);
        this.setConnected(false);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.centerPanel = null;
        JPanel jPanel = null;
        if (GUIMediator.shouldShowAds()) {
            jPanel = new JPanel(new FlowLayout(0, 0, 15));
            this.centerPanel = new JPanel();
            serializable = new BoxLayout(this.centerPanel, 0);
        } else {
            jPanel = new JPanel(new FlowLayout(0));
            this.centerPanel = new BoxPanel(0);
        }
        jPanel.add(this.switchedPanel);
        jPanel.add(this.sharingLabel);
        this.add((Component)jPanel, "West");
        if (GUIMediator.shouldShowAds()) {
            cbanner = CommonUtils.isWindows() ? new CBanner(this) : new NonWindowsCBanner().getComponent();
            this.centerPanel.add(cbanner);
            this.add((Component)this.centerPanel, "Center");
        }
        if (!CommonUtils.isMacClassic()) {
            myMPC = new MediaPlayerComponent();
            serializable = myMPC.getMediaPanel();
            this.add((Component)serializable, "East");
        }
        myInstance = this;
    }

    public void switchToHomeGrownBanners() {
        this.centerPanel.remove(cbanner);
        cbanner = new NonWindowsCBanner().getComponent();
        this.centerPanel.add(cbanner);
        this.centerPanel.validate();
    }

    static void reloadAds() {
        NonWindowsCBanner.loadAds();
    }

    static void cleanup() {
        if (GUIMediator.shouldShowAds() && CommonUtils.isWindows() && cbanner instanceof CBanner) {
            CBanner cfr_ignored_0 = (CBanner)cbanner;
            CBanner.cleanup();
        }
    }

    private void createConnectButtons() {
        this.switchedPanel = new JPanel();
        this.switcher = new CardLayout();
        this.switchedPanel.setLayout(this.switcher);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        ImageIcon imageIcon = GUIMediator.getImageResource("connected.gif");
        jPanel.add(new JLabel(imageIcon));
        this.switchedPanel.add("connect", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        ImageIcon imageIcon2 = GUIMediator.getImageResource("disconnected.gif");
        jPanel2.add(new JLabel(imageIcon2));
        this.switchedPanel.add("disconnect", jPanel2);
        if (!GUIMediator.shouldShowAds()) {
            this.switchedPanel.setMaximumSize(new Dimension(60, 30));
        }
    }

    public void setConnected(boolean bl) {
        if (bl) {
            JPanel jPanel = this.switchedPanel;
            synchronized (jPanel) {
                this.switcher.first(this.switchedPanel);
            }
        }
        JPanel jPanel = this.switchedPanel;
        synchronized (jPanel) {
            this.switcher.last(this.switchedPanel);
        }
    }

    public String setStatistics(long l, long l2, long l3, int n) {
        String string = l == 0L ? this.STATS_DISCONNECTED_STRING : StatusLine.suffix(l2, false) + " " + this.STATS_FILE_STRING + " / " + StatusLine.suffix(l3 * 1000L, true) + " " + this.STATS_AVAILABLE_STRING;
        this.sharingLabel.setText(this.STATS_SHARING_STRING + " " + String.valueOf(n) + " " + this.STATS_FILE_STRING);
        if (n == 0) {
            this.sharingLabel.setForeground(new Color(208, 0, 5));
        } else {
            this.sharingLabel.setForeground((Color)UIManager.get("Label.foreground"));
        }
        return string;
    }

    public void setStatus(String string, boolean bl) {
    }

    public static void songDoubleClicked() {
        if (myInstance != null) {
            MediaPlayerComponent.songDoubleClicked();
        }
    }

    public static void launchSong(File file) {
        if (myInstance != null && file != null) {
            MediaPlayerComponent.launchSong(file);
        }
    }

    private void debug(String string) {
    }

    private static String suffix(long l, boolean bl) {
        String[] stringArray;
        long[] lArray = bl ? BVALUES : VALUES;
        String[] stringArray2 = stringArray = bl ? BSUFFIXES : SUFFIXES;
        if (l < lArray[lArray.length - 1]) {
            return bl ? l + " bytes" : l + "";
        }
        int n = lArray.length - 1;
        while (n >= 0) {
            if (l < lArray[n]) break;
            --n;
        }
        Assert.that(++n >= 0);
        Assert.that(l >= lArray[n]);
        if (n > 0) {
            Assert.that(l < lArray[n - 1]);
        }
        return l / lArray[n] + stringArray[n];
    }

    static {
        VALUES = new long[]{1000000000000L, 1000000000L, 1000000L, 1000L};
        BVALUES = new long[]{0x10000000000L, 0x40000000L, 0x100000L, 1024L};
        SUFFIXES = new String[]{"T", "B", "M", "K"};
        BSUFFIXES = new String[]{" TB", " GB", " MB", " KB"};
    }
}

