/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatisticsView
extends JDialog {
    private final String STATS_TITLE = "STATS_TITLE";
    private final int STATISTICS_WIDTH = 420;
    private final int STATISTICS_HEIGHT = 170;
    private JPanel _netConnPanel;
    private JLabel _numConnLabel;
    private JLabel _numUploadLabel;
    private JLabel _numDownloadLabel;
    private JPanel _netStatPanel;
    private JPanel _statOnlyPanel;
    private JLabel _numHostsLabel;
    private JLabel _numFilesLabel;
    private JLabel _numKBLabel;
    private JButton _updateButton;
    private JPanel _netInfoPanel;
    private JLabel _numMessagesText;
    private JLabel _numSearchesText;
    private JLabel _numRoutingErrorText;
    private JLabel _numDroppedMsgsText;
    private JLabel _numDownloadText;
    private JLabel _numUploadText;
    private SettingsManager _settings;

    public StatisticsView() {
        super(GUIMediator.getAppFrame());
        this.setTitle(GUIMediator.getStringResource("STATS_TITLE"));
        this._settings = SettingsManager.instance();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.createConnStats();
        jPanel.add(this._netConnPanel);
        this.createNetStats();
        jPanel.add(this._netStatPanel);
        this.createNetInfo();
        jPanel.add(this._netInfoPanel);
        this.getContentPane().add(jPanel);
        ((Component)this).setSize(420, 170);
    }

    public void updateStatistics() {
        int n = GUIMediator.instance().getRouter().getTotalMessages();
        int n2 = GUIMediator.instance().getRouter().getNumLocalSearches();
        int n3 = GUIMediator.instance().getRouter().getTotalDroppedMessages();
        int n4 = GUIMediator.instance().getRouter().getTotalRouteErrors();
        int n5 = GUIMediator.instance().getRouter().getNumConnections();
        int n6 = (int)GUIMediator.instance().getRouter().getNumHosts();
        long l = GUIMediator.instance().getRouter().getNumFiles();
        long l2 = GUIMediator.instance().getRouter().getTotalFileSize();
        int n7 = GUIMediator.instance().getRouter().getNumSharedFiles();
        int n8 = GUIMediator.instance().getTotalUploads();
        int n9 = GUIMediator.instance().getCurrentUploads();
        int n10 = GUIMediator.instance().getTotalDownloads();
        int n11 = GUIMediator.instance().getCurrentDownloads();
        String string = null;
        string = l2 > 9999L ? l2 / 1024L + " MB" : l2 + " KB";
        this._numMessagesText.setText(String.valueOf(n));
        this._numSearchesText.setText(String.valueOf(n2));
        this._numRoutingErrorText.setText(String.valueOf(n4));
        this._numDroppedMsgsText.setText(String.valueOf(n3));
        this._numDownloadText.setText(String.valueOf(n10));
        this._numUploadText.setText(String.valueOf(n8));
        this._numConnLabel.setText(String.valueOf(n5) + " " + GUIMediator.getStringResource("STATS_NET"));
        this._numUploadLabel.setText(String.valueOf(n9) + " " + GUIMediator.getStringResource("STATS_UPLOADS"));
        this._numDownloadLabel.setText(String.valueOf(n11) + " " + GUIMediator.getStringResource("STATS_DOWNLOADS"));
        this._numHostsLabel.setText(String.valueOf(n6 + 1) + " " + GUIMediator.getStringResource("STATS_HOSTS"));
        this._numFilesLabel.setText(String.valueOf(l) + " " + GUIMediator.getStringResource("STATS_FILES"));
        this._numKBLabel.setText(string);
    }

    private void createConnStats() {
        this._netConnPanel = new JPanel();
        this._netConnPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this._netConnPanel.setBorder(BorderFactory.createTitledBorder(GUIMediator.getStringResource("STATS_CONNECTION_TITLE")));
        this._numConnLabel = new JLabel("0" + GUIMediator.getStringResource("STATS_NET"));
        this._numUploadLabel = new JLabel("0" + GUIMediator.getStringResource("STATS_UPLOADS"));
        this._numDownloadLabel = new JLabel("0" + GUIMediator.getStringResource("STATS_DOWNLOADS"));
        jPanel.add(this._numConnLabel);
        jPanel.add(this._numUploadLabel);
        jPanel.add(this._numDownloadLabel);
        this._netConnPanel.add((Component)jPanel, "North");
    }

    private void createNetStats() {
        this._netStatPanel = new JPanel();
        this._netStatPanel.setLayout(new BorderLayout());
        this._netStatPanel.setBorder(BorderFactory.createTitledBorder(GUIMediator.getStringResource("STATS_NETWORK_TITLE")));
        this._statOnlyPanel = new JPanel();
        this._statOnlyPanel.setLayout(new GridLayout(0, 1));
        this._numHostsLabel = new JLabel("1" + GUIMediator.getStringResource("STATS_HOSTS"));
        this._numFilesLabel = new JLabel("0" + GUIMediator.getStringResource("STATS_FILES"));
        this._numKBLabel = new JLabel("0 MB        ");
        this._updateButton = new JButton(GUIMediator.getStringResource("STATS_BUTTON_LABEL"));
        this._statOnlyPanel.add(this._numHostsLabel);
        this._statOnlyPanel.add(this._numFilesLabel);
        this._statOnlyPanel.add(this._numKBLabel);
        this._netStatPanel.add((Component)this._statOnlyPanel, "North");
        this._netStatPanel.add((Component)this._updateButton, "South");
        this._updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().getRouter().updateHorizon();
            }
        });
    }

    private void createNetInfo() {
        this._netInfoPanel = new JPanel();
        this._netInfoPanel.setBorder(BorderFactory.createTitledBorder(GUIMediator.getStringResource("STATS_NETWORK_INFO_TITLE")));
        this._netInfoPanel.setLayout(new BoxLayout(this._netInfoPanel, 0));
        this._numMessagesText = new JLabel("0       ", 2);
        this._numSearchesText = new JLabel("0       ", 2);
        this._numRoutingErrorText = new JLabel("0       ", 2);
        this._numDroppedMsgsText = new JLabel("0       ", 2);
        this._numDownloadText = new JLabel("0       ", 2);
        this._numUploadText = new JLabel("0       ", 2);
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(new JLabel(GUIMediator.getStringResource("STATS_TOTAL_MESSAGES")));
        jPanel.add(new JLabel(GUIMediator.getStringResource("STATS_LOCAL_SEARCHES")));
        jPanel.add(new JLabel(GUIMediator.getStringResource("STATS_ROUTING_ERRORS")));
        jPanel.add(new JLabel(GUIMediator.getStringResource("STATS_DROPPED_MESSAGES")));
        jPanel.add(new JLabel(GUIMediator.getStringResource("STATS_DOWNLOAD_COUNT")));
        jPanel.add(new JLabel(GUIMediator.getStringResource("STATS_UPLOAD_COUNT")));
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this._numMessagesText);
        jPanel2.add(this._numSearchesText);
        jPanel2.add(this._numRoutingErrorText);
        jPanel2.add(this._numDroppedMsgsText);
        jPanel2.add(this._numDownloadText);
        jPanel2.add(this._numUploadText);
        this._netInfoPanel.add(jPanel);
        this._netInfoPanel.add(jPanel2);
    }
}

