/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.Expand;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LimeLookAndFeel;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;

final class ResourceManager {
    private static ResourceManager _instance;
    private static final LookAndFeel LOOK_AND_FEEL;
    private final String WINDOWS_LIBRARY_NAME = "LimeWire20";
    private final String WINDOWS_LIBRARY_FULL_NAME = "LimeWire20.dll";
    private final String AD_LIBRARY_NAME = "CBanner2";
    private final String AD_LIBRARY_FULL_NAME = "CBanner2.dll";
    private static final String IMAGES_PREFIX = "com/limegroup/gnutella/gui/images/";
    private static ResourceBundle _resourceBundle;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ResourceManager;

    static final ResourceManager instance() {
        if (_instance == null) {
            _instance = new ResourceManager();
        }
        return _instance;
    }

    private ResourceManager() {
        if (CommonUtils.isWindows()) {
            this.copyResourceFile("LimeWire20.dll");
            this.loadLibrary("LimeWire20");
        }
        if (GUIMediator.shouldShowAds() && CommonUtils.isWindows()) {
            this.copyResourceFile("CBanner2.dll");
            this.loadLibrary("CBanner2");
        }
        ResourceManager.unpackWarFiles();
    }

    final LookAndFeel getLookAndFeel() {
        return LOOK_AND_FEEL;
    }

    static final ImageIcon getImageResource(String string) {
        ClassLoader classLoader = (class$com$limegroup$gnutella$gui$ResourceManager == null ? (class$com$limegroup$gnutella$gui$ResourceManager = ResourceManager.class$("com.limegroup.gnutella.gui.ResourceManager")) : class$com$limegroup$gnutella$gui$ResourceManager).getClassLoader();
        URL uRL = null;
        if (classLoader == null) {
            uRL = ClassLoader.getSystemResource(IMAGES_PREFIX + string);
            return new ImageIcon(uRL);
        }
        uRL = classLoader.getResource(IMAGES_PREFIX + string);
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(IMAGES_PREFIX + string);
        }
        return new ImageIcon(uRL);
    }

    static final String getStringResource(String string) {
        return _resourceBundle.getString(string);
    }

    /*
     * Loose catch block
     */
    private final void copyResourceFile(String string) {
        block22: {
            if (CommonUtils.isWindows()) {
                int n;
                File file = new File(string);
                if (file.exists()) {
                    return;
                }
                ClassLoader classLoader = this.getClass().getClassLoader();
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : ClassLoader.getSystemResourceAsStream(string);
                if (inputStream == null) {
                    return;
                }
                fileOutputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                inputStream.close();
                fileOutputStream.close();
                Object var9_8 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    break block22;
                }
                catch (IOException iOException) {}
                break block22;
                {
                    catch (FileNotFoundException fileNotFoundException) {
                        file.delete();
                        Object var9_9 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                            break block22;
                        }
                        catch (IOException iOException) {}
                        break block22;
                    }
                    catch (IOException iOException) {
                        file.delete();
                        Object var9_10 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                            break block22;
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private void loadLibrary(String string) {
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            GUIMediator.showInternalError(unsatisfiedLinkError);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unpackWarFiles() {
        File file = new File(SettingsManager.instance().getPath());
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".war");
            }
        });
        int n = stringArray.length;
        Expand expand = new Expand();
        expand.setDest("lib");
        int n2 = 0;
        while (true) {
            block6: {
                File file2;
                Object var7_6;
                if (n2 >= n) {
                    return;
                }
                expand.setSrc(stringArray[n2]);
                try {
                    try {
                        expand.execute();
                    }
                    catch (IOException iOException) {
                        var7_6 = null;
                        file2 = new File(file, stringArray[n2]);
                        file2.delete();
                        break block6;
                    }
                    var7_6 = null;
                    file2 = new File(file, stringArray[n2]);
                    file2.delete();
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    file2 = new File(file, stringArray[n2]);
                    file2.delete();
                    throw throwable;
                }
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LOOK_AND_FEEL = new LimeLookAndFeel();
        SettingsManager settingsManager = SettingsManager.instance();
        Locale locale = new Locale(settingsManager.getLanguage(), settingsManager.getCountry());
        _resourceBundle = ResourceBundle.getBundle("MessagesBundle", locale);
    }
}

