/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.sun.java.util.collections.Hashtable;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Dictionary;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class PreferencingPanel
extends TitledPaddedPanel {
    private SettingsManager settings = SettingsManager.instance();
    private WholeNumberField files;
    private JSlider allowed;

    public PreferencingPanel() {
        super("Connection Preferencing");
        JLabel jLabel = new JLabel("Clients sharing fewer than ");
        this.files = new WholeNumberField(this.settings.getFreeloaderFiles(), 3);
        Serializable serializable = new Dimension(8, 20);
        this.files.setMinimumSize((Dimension)serializable);
        this.files.setPreferredSize((Dimension)serializable);
        this.files.setMaximumSize((Dimension)serializable);
        serializable = new JLabel(" files are freeloaders");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(this.files);
        jPanel.add((Component)serializable);
        jPanel.add(Box.createHorizontalGlue());
        int n = Math.max(10, this.settings.getFreeloaderAllowed());
        this.allowed = new JSlider(10, 100, n);
        Object object = new Hashtable();
        object = new Hashtable();
        object.put((Object)new Integer(10), (Object)new JLabel("Rarely"));
        object.put((Object)new Integer(100), (Object)new JLabel("Always"));
        this.allowed.setLabelTable((Dictionary)object);
        this.allowed.setPaintLabels(true);
        object = new JLabel("Allow Freeloaders:  ");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add((Component)object);
        jPanel2.add(this.allowed);
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(jPanel2);
    }

    public void commit() {
        Assert.that(this.settings != null);
        Assert.that(this.files != null);
        Assert.that(this.allowed != null);
        try {
            this.settings.setFreeloaderFiles(this.files.getValue());
            this.settings.setFreeloaderAllowed(this.allowed.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.that(false);
        }
    }

    public void reset() {
        Assert.that(this.settings != null);
        Assert.that(this.files != null);
        Assert.that(this.allowed != null);
        this.files.setValue(this.settings.getFreeloaderFiles());
        this.allowed.setValue(this.settings.getFreeloaderAllowed());
    }
}

