/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;

public class MultiLineLabel
extends JTextArea {
    private static final int DEFAULT_LABEL_WIDTH = 200;

    public MultiLineLabel(String string) {
        this.setText(string);
    }

    public MultiLineLabel(String string, int n) {
        this.setText(string, n);
    }

    public MultiLineLabel(String string, int n, int n2, int n3) {
        super(n2, n3);
        this.setText(string, n);
    }

    public void setText(String string, int n) {
        super.setText(this.createSizedString(string, n));
    }

    public void setText(String string) {
        super.setText(this.createSizedString(string, 200));
    }

    public void updateUI() {
        super.updateUI();
        this.setWrapStyleWord(true);
        this.setHighlighter(null);
        this.setEditable(false);
        LookAndFeel.installBorder(this, "Label.border");
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
    }

    private String createSizedString(String string, int n) {
        String string2 = new String();
        if (string == null) {
            return null;
        }
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = new String();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (fontMetrics.stringWidth(string3 + string4) > n) {
                string2 = string2 + string3 + "\n";
                string3 = string4 + " ";
                continue;
            }
            string3 = string3 + string4 + " ";
        }
        if (string3 != null) {
            string2 = string2 + string3;
        }
        return string2;
    }
}

