/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ConnectionView;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.StatisticsView;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.UploadView;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.SearchView;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class MainFrame {
    private static final int APP_WIDTH = 730;
    private static final int APP_HEIGHT = 600;
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private final JTabbedPane TABBED_PANE = new JTabbedPane(1);
    private final SearchView SEARCH_VIEW = new SearchView();
    private final int SEARCH_VIEW_TAB_INDEX = 0;
    private final DownloadMediator DOWNLOAD_MEDIATOR = new DownloadMediator();
    private final MonitorView MONITOR_VIEW = new MonitorView();
    private int MONITOR_VIEW_TAB_INDEX = 1;
    private boolean showMonitorView = true;
    private final UploadView UPLOAD_VIEW = new UploadView();
    private final ConnectionView CONNECTION_VIEW = new ConnectionView();
    private int CONNECTION_VIEW_TAB_INDEX = 2;
    private boolean showConnectionView = true;
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final PlayListGUI PLAYLIST_VIEW = PlayListGUI.instance();
    private int LIBRARY_VIEW_TAB_INDEX = 3;
    private boolean showLibraryView = true;
    private final StatisticsView STATISTICS_VIEW = new StatisticsView();
    private final OptionsMediator OPTIONS_MEDIATOR = OptionsMediator.instance();
    private final StatusLine STATUS_LINE = new StatusLine();
    private final MenuMediator MENU_MEDIATOR = MenuMediator.instance();
    private final JFrame FRAME;

    MainFrame(JFrame jFrame) {
        this.FRAME = jFrame;
        ((Component)this.FRAME).setSize(730, 600);
        Container container = this.FRAME.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(this.TABBED_PANE);
        ImageIcon imageIcon = GUIMediator.getImageResource("plug2.gif");
        ((Frame)this.FRAME).setIconImage(imageIcon.getImage());
        this.FRAME.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent windowEvent) {
                GUIMediator.restoreView();
            }

            public void windowClosing(WindowEvent windowEvent) {
                GUIMediator.close();
            }
        });
        this.FRAME.setDefaultCloseOperation(0);
        this.setFrameDimensions();
        this.addSplitTab(this.SEARCH_VIEW.getComponent(), DownloadMediator.getComponent(), "SEARCH", "search.gif", 300);
        this.addSplitTab(this.MONITOR_VIEW, this.UPLOAD_VIEW, "MONITOR", "monitor.gif", 300);
        this.addTab(this.CONNECTION_VIEW, "CONNECTIONS", "connections.gif");
        Component component = this.LIBRARY_MEDIATOR.getComponent();
        if (CommonUtils.isMacClassic()) {
            this.addTab(component, "LIBRARY", "library.gif");
        } else {
            this.addSplitTab(component, this.PLAYLIST_VIEW, "LIBRARY", "library.gif", 300);
        }
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        this.FRAME.getContentPane().add(this.STATUS_LINE);
        this.TABBED_PANE.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                GUIMediator.instance().handleTabSelection(jTabbedPane.getSelectedIndex());
            }
        });
        if (CommonUtils.isAnyMac()) {
            MacEventHandler macEventHandler = new MacEventHandler();
        }
        if (!CommonUtils.isMacClassic()) {
            if (!this.SETTINGS.getMonitorViewEnabled()) {
                this.setMonitorViewEnabled(false);
            }
            if (!this.SETTINGS.getConnectionViewEnabled()) {
                this.setConnectionViewEnabled(false);
            }
            if (!this.SETTINGS.getLibraryViewEnabled()) {
                this.setLibraryViewEnabled(false);
            }
        }
    }

    private final void addTab(Component component, String string, String string2) {
        String string3 = GUIMediator.getStringResource(string + "_TITLE");
        String string4 = GUIMediator.getStringResource(string + "_TIP");
        ImageIcon imageIcon = GUIMediator.getImageResource(string2);
        this.TABBED_PANE.addTab(string3, imageIcon, component, string4);
    }

    private final JSplitPane addSplitTab(Component component, Component component2, String string, String string2, int n) {
        JSplitPane jSplitPane = new JSplitPane(0, component, component2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(n);
        String string3 = GUIMediator.getStringResource(string + "_TITLE");
        String string4 = GUIMediator.getStringResource(string + "_TIP");
        ImageIcon imageIcon = GUIMediator.getImageResource(string2);
        this.TABBED_PANE.addTab(string3, imageIcon, jSplitPane, string4);
        return jSplitPane;
    }

    final void setSelectedIndex(int n) {
        if (n == 0) {
            this.TABBED_PANE.setSelectedIndex(n);
        } else if (n == 1) {
            if (this.showMonitorView) {
                this.TABBED_PANE.setSelectedIndex(n);
            }
        } else if (n == 2) {
            if (this.showConnectionView) {
                this.TABBED_PANE.setSelectedIndex(this.CONNECTION_VIEW_TAB_INDEX);
            }
        } else if (n == 3 && this.showLibraryView) {
            this.TABBED_PANE.setSelectedIndex(this.LIBRARY_VIEW_TAB_INDEX);
        }
    }

    private final void setFrameDimensions() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 0;
        int n2 = 0;
        if (this.SETTINGS.getRunOnce()) {
            n = this.SETTINGS.getAppWidth();
            n2 = this.SETTINGS.getAppHeight();
            ((Component)this.FRAME).setLocation(this.SETTINGS.getWindowX(), this.SETTINGS.getWindowY());
        } else {
            n = Math.min(dimension.width, 730);
            n2 = Math.min(dimension.height - 40, 600);
            ((Component)this.FRAME).setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        }
        ((Component)this.FRAME).setSize(new Dimension(n, n2));
    }

    private final JSplitPane insertSplitTab(int n, Component component, Component component2, String string, String string2, int n2) {
        JSplitPane jSplitPane = new JSplitPane(0, component, component2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(n2);
        String string3 = GUIMediator.getStringResource(string + "_TITLE");
        String string4 = GUIMediator.getStringResource(string + "_TIP");
        ImageIcon imageIcon = GUIMediator.getImageResource(string2);
        this.TABBED_PANE.insertTab(string3, imageIcon, jSplitPane, string4, n);
        return jSplitPane;
    }

    private final void insertTab(int n, Component component, String string, String string2) {
        String string3 = GUIMediator.getStringResource(string + "_TITLE");
        String string4 = GUIMediator.getStringResource(string + "_TIP");
        ImageIcon imageIcon = GUIMediator.getImageResource(string2);
        this.TABBED_PANE.insertTab(string3, imageIcon, component, string4, n);
    }

    void setMonitorViewEnabled(boolean bl) {
        if (this.showMonitorView != bl) {
            if (this.showMonitorView) {
                int n = this.TABBED_PANE.getSelectedIndex();
                if (n > this.MONITOR_VIEW_TAB_INDEX) {
                    this.TABBED_PANE.setSelectedIndex(--n);
                }
                this.TABBED_PANE.remove(this.MONITOR_VIEW_TAB_INDEX);
                --this.CONNECTION_VIEW_TAB_INDEX;
                --this.LIBRARY_VIEW_TAB_INDEX;
                this.MENU_MEDIATOR.removeNavMonitorMenuItem();
            } else {
                this.insertSplitTab(this.MONITOR_VIEW_TAB_INDEX, this.MONITOR_VIEW, this.UPLOAD_VIEW, "MONITOR", "monitor.gif", 300);
                ++this.CONNECTION_VIEW_TAB_INDEX;
                ++this.LIBRARY_VIEW_TAB_INDEX;
                int n = this.TABBED_PANE.getSelectedIndex();
                if (n >= this.MONITOR_VIEW_TAB_INDEX) {
                    this.TABBED_PANE.setSelectedIndex(++n);
                }
                this.MENU_MEDIATOR.insertNavMonitorMenuItem();
            }
            this.showMonitorView = bl;
            this.SETTINGS.setMonitorViewEnabled(this.showMonitorView);
        }
    }

    void setConnectionViewEnabled(boolean bl) {
        if (this.showConnectionView != bl) {
            if (this.showConnectionView) {
                this.TABBED_PANE.remove(this.CONNECTION_VIEW_TAB_INDEX);
                --this.LIBRARY_VIEW_TAB_INDEX;
                this.MENU_MEDIATOR.removeNavConnectionMenuItem();
            } else {
                this.insertTab(this.CONNECTION_VIEW_TAB_INDEX, this.CONNECTION_VIEW, "CONNECTIONS", "connections.gif");
                ++this.LIBRARY_VIEW_TAB_INDEX;
                int n = this.TABBED_PANE.getSelectedIndex();
                if (n == this.CONNECTION_VIEW_TAB_INDEX) {
                    this.TABBED_PANE.setSelectedIndex(++n);
                }
                this.MENU_MEDIATOR.insertNavConnectionMenuItem();
            }
            this.showConnectionView = bl;
            this.SETTINGS.setConnectionViewEnabled(this.showConnectionView);
        }
    }

    void setLibraryViewEnabled(boolean bl) {
        if (this.showLibraryView != bl) {
            if (this.showLibraryView) {
                this.TABBED_PANE.remove(this.LIBRARY_VIEW_TAB_INDEX);
                this.MENU_MEDIATOR.removeNavLibraryMenuItem();
            } else {
                Component component = this.LIBRARY_MEDIATOR.getComponent();
                if (CommonUtils.isMacClassic()) {
                    this.insertTab(this.LIBRARY_VIEW_TAB_INDEX, component, "LIBRARY", "library.gif");
                } else {
                    this.insertSplitTab(this.LIBRARY_VIEW_TAB_INDEX, component, this.PLAYLIST_VIEW, "LIBRARY", "library.gif", 300);
                }
                this.MENU_MEDIATOR.insertNavLibraryMenuItem();
            }
            this.showLibraryView = bl;
            this.SETTINGS.setLibraryViewEnabled(this.showLibraryView);
        }
    }

    final SearchView getSearchView() {
        return this.SEARCH_VIEW;
    }

    final DownloadMediator getDownloadMediator() {
        return this.DOWNLOAD_MEDIATOR;
    }

    final MonitorView getMonitorView() {
        return this.MONITOR_VIEW;
    }

    final UploadView getUploadView() {
        return this.UPLOAD_VIEW;
    }

    final ConnectionView getConnectionView() {
        return this.CONNECTION_VIEW;
    }

    final LibraryMediator getLibraryMediator() {
        return this.LIBRARY_MEDIATOR;
    }

    final StatusLine getStatusLine() {
        return this.STATUS_LINE;
    }

    final MenuMediator getMenuMediator() {
        return this.MENU_MEDIATOR;
    }

    final OptionsMediator getOptionsMediator() {
        return this.OPTIONS_MEDIATOR;
    }

    final StatisticsView getStatisticsView() {
        return this.STATISTICS_VIEW;
    }
}

