/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.LimeTheme;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.util.CommonUtils;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.plaf.metal.MetalLookAndFeel;

final class LimeLookAndFeel
extends MetalLookAndFeel {
    LimeLookAndFeel() {
        MetalLookAndFeel.setCurrentTheme(new LimeTheme());
    }

    public String getDescription() {
        return "Lime Look and Feel";
    }

    public String getID() {
        return "GoLime";
    }

    public String getName() {
        return "Lime Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "com.limegroup.gnutella.gui.";
        uIDefaults.put("ButtonUI", string + "LimeButtonUI");
        if (!CommonUtils.isMacClassic()) {
            uIDefaults.put("ClassLoader", this.getClass().getClassLoader());
        }
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        ResourceManager resourceManager = ResourceManager.instance();
        ImageIcon imageIcon = ResourceManager.getImageResource("question.gif");
        ImageIcon imageIcon2 = ResourceManager.getImageResource("warning.gif");
        ImageIcon imageIcon3 = ResourceManager.getImageResource("notsearching.gif");
        ImageIcon imageIcon4 = ResourceManager.getImageResource("dir_open.gif");
        ImageIcon imageIcon5 = ResourceManager.getImageResource("dir_closed.gif");
        FontUIResource fontUIResource = new FontUIResource("Dialog", 0, 11);
        uIDefaults.put("Tree.expandedIcon", imageIcon4);
        uIDefaults.put("Tree.collapsedIcon", imageIcon5);
        uIDefaults.put("TableHeader.background", new ColorUIResource(117, 142, 197));
        uIDefaults.put("OptionPane.questionIcon", imageIcon);
        uIDefaults.put("OptionPane.errorIcon", imageIcon2);
        uIDefaults.put("OptionPane.informationIcon", imageIcon3);
        uIDefaults.put("Tree.leafIcon", MetalIconFactory.getTreeFolderIcon());
        uIDefaults.put("Tree.rightChildIndent", new Integer(8));
        uIDefaults.put("Table.focusCellForeground", UIManager.getColor("Table.selectionForeground"));
        uIDefaults.put("Table.focusCellBackground", UIManager.getColor("Table.selectionBackground"));
        uIDefaults.put("RadioButton.foreground", MetalLookAndFeel.getSystemTextColor());
        uIDefaults.put("CheckBox.foreground", MetalLookAndFeel.getSystemTextColor());
        String string = System.getProperty("os.name");
        if (!string.startsWith("Windows")) {
            uIDefaults.put("Label.font", fontUIResource);
            uIDefaults.put("Button.font", fontUIResource);
        }
    }
}

