/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.VisualConnectionCallback;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.update.UpdateManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.MetaEnabledMessageRouter;
import com.limegroup.gnutella.xml.MetaFileManager;
import java.awt.Window;
import javax.swing.UIManager;

public final class Initializer {
    private Initializer() {
    }

    static void initialize() {
        try {
            Object object;
            Object object2;
            ResourceManager resourceManager = ResourceManager.instance();
            if (CommonUtils.isMacOSX()) {
                object2 = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel((String)object2);
            } else {
                UIManager.setLookAndFeel(resourceManager.getLookAndFeel());
            }
            object2 = new SplashWindow();
            SettingsManager.instance();
            MetaFileManager metaFileManager = new MetaFileManager();
            if (!SettingsManager.instance().getInstalled()) {
                object = new SetupManager();
            }
            object = GUIMediator.instance();
            UpdateManager updateManager = UpdateManager.instance();
            updateManager.doUpdate();
            VisualConnectionCallback visualConnectionCallback = new VisualConnectionCallback();
            MetaEnabledMessageRouter metaEnabledMessageRouter = new MetaEnabledMessageRouter(visualConnectionCallback, metaFileManager);
            RouterService routerService = new RouterService(visualConnectionCallback, metaEnabledMessageRouter, metaFileManager);
            Finalizer.initialize(routerService);
            ((GUIMediator)object).setRouterService(routerService);
            routerService.initialize();
            ((GUIMediator)object).startTimer();
            ((Window)object2).dispose();
            GUIMediator.setAppVisible(true);
            routerService.postGuiInit();
            NotifyUserProxy notifyUserProxy = NotifyUserProxy.instance();
            notifyUserProxy.hideNotify();
        }
        catch (Exception exception) {
            GUIMediator.showInternalError(exception);
        }
    }
}

