/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class GUIUtils {
    private static final JFileChooser _fileChooser = new JFileChooser();
    private ImageIcon _questionIcon;
    private ImageIcon _warningIcon;
    private ImageIcon _infoIcon;

    private GUIUtils() {
    }

    public static JFileChooser getFileChooser() {
        return _fileChooser;
    }

    public static String toKilobytes(int n) {
        double d = (double)n / 1024.0;
        if (d < 1.0 && d > 0.0) {
            d = 1.0;
        }
        StringBuffer stringBuffer = new StringBuffer(Integer.toString((int)d));
        if (d >= 1000.0) {
            stringBuffer.insert(stringBuffer.length() - 3, ",");
            if (d >= 1000000.0) {
                stringBuffer.insert(stringBuffer.length() - 7, ",");
            }
        }
        stringBuffer.append("KB");
        return stringBuffer.toString();
    }

    public static MultiLineLabel getSizedLabel(String string) {
        Dimension dimension = new Dimension();
        MultiLineLabel multiLineLabel = new MultiLineLabel(string);
        FontMetrics fontMetrics = ((Component)multiLineLabel).getFontMetrics(multiLineLabel.getFont());
        int n = fontMetrics.stringWidth(string);
        dimension.setSize(Integer.MAX_VALUE, n / 9);
        multiLineLabel.setPreferredSize(dimension);
        return multiLineLabel;
    }

    public static String speed2name(int n) {
        if (n <= 56) {
            return GUIConstants.MODEM_SPEED;
        }
        if (n <= 350) {
            return "Cable";
        }
        if (n <= 1000) {
            return GUIConstants.T1_SPEED;
        }
        return "T3";
    }
}

