/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.AboutWindow;
import com.limegroup.gnutella.gui.ConnectionView;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.RefreshTimer;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.StatisticsView;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.UploadView;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.SearchView;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Launcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public final class GUIMediator {
    private static GUIMediator _instance = null;
    private static boolean SHOW_ADS = true;
    public static final int YES_OPTION = 101;
    public static final int NO_OPTION = 102;
    public static final int SEARCH_INDEX = 0;
    public static final int MONITOR_INDEX = 1;
    public static final int CONNECTIONS_INDEX = 2;
    public static final int LIBRARY_INDEX = 3;
    private static final SettingsManager SETTINGS = SettingsManager.instance();
    private static final JFrame FRAME = new JFrame();
    private static final MessageService MESSAGE_SERVICE = new MessageService();
    private final MainFrame MAIN_FRAME = new MainFrame(FRAME);
    private final SearchView SEARCH_VIEW = this.MAIN_FRAME.getSearchView();
    private final DownloadMediator DOWNLOAD_MEDIATOR = this.MAIN_FRAME.getDownloadMediator();
    private final MonitorView MONITOR_VIEW = this.MAIN_FRAME.getMonitorView();
    private final UploadView UPLOAD_VIEW = this.MAIN_FRAME.getUploadView();
    private final ConnectionView CONNECTION_VIEW = this.MAIN_FRAME.getConnectionView();
    private final LibraryMediator LIBRARY_MEDIATOR = this.MAIN_FRAME.getLibraryMediator();
    private final StatisticsView STATISTICS_VIEW = this.MAIN_FRAME.getStatisticsView();
    private final OptionsMediator OPTIONS_MEDIATOR = this.MAIN_FRAME.getOptionsMediator();
    private final MenuMediator MENU_MEDIATOR = this.MAIN_FRAME.getMenuMediator();
    private final StatusLine STATUS_LINE = this.MAIN_FRAME.getStatusLine();
    private static final Component HORIZONTAL_SEPARATOR = Box.createRigidArea(new Dimension(6, 0));
    private static final Component VERTICAL_SEPARATOR = Box.createRigidArea(new Dimension(0, 6));
    private static final String APP_TITLE = GUIMediator.getStringResource("APP_TITLE");
    private RouterService _routerService;

    public static synchronized GUIMediator instance() {
        if (_instance == null) {
            _instance = new GUIMediator();
        }
        return _instance;
    }

    private GUIMediator() {
        FRAME.setTitle(APP_TITLE);
    }

    public final void startTimer() {
        RefreshTimer refreshTimer = new RefreshTimer();
        refreshTimer.startTimer();
    }

    public static final boolean getAppVisible() {
        return FRAME.isShowing();
    }

    public static final void setAppVisible(boolean bl) {
        ((Component)FRAME).setVisible(bl);
    }

    private final void setStatistics(String string) {
        if (this.getRouter().hasClientSupernodeConnection()) {
            FRAME.setTitle(APP_TITLE);
        } else {
            FRAME.setTitle(APP_TITLE + "  (" + string + ")");
        }
    }

    public static final Dimension getAppSize() {
        return FRAME.getSize();
    }

    public static final Point getAppLocation() {
        return FRAME.getLocation();
    }

    public final MainFrame getMainFrame() {
        return this.MAIN_FRAME;
    }

    public static final Frame getAppFrame() {
        return FRAME;
    }

    public final RouterService getRouter() {
        return this._routerService;
    }

    public final void setRouterService(RouterService routerService) {
        this._routerService = routerService;
    }

    public final void refreshGUI() {
        this.STATISTICS_VIEW.updateStatistics();
        this.CONNECTION_VIEW.updateConnectionStats();
        this.UPLOAD_VIEW.updateConnectionStats();
        DownloadMediator.updateConnectionStats();
        int n = (int)this._routerService.getNumHosts();
        long l = this._routerService.getNumFiles();
        long l2 = this._routerService.getTotalFileSize();
        int n2 = this._routerService.getNumSharedFiles();
        String string = this.STATUS_LINE.setStatistics(n, l, l2, n2);
        this.setStatistics(string);
        this._routerService.updateHorizon();
        this.setConnected(this.getRouter().isConnected());
    }

    public final void showOptionsWindow() {
        this.OPTIONS_MEDIATOR.setOptionsVisible(true);
    }

    public final void showStatisticsWindow() {
        this.STATISTICS_VIEW.setLocationRelativeTo(GUIMediator.getAppFrame());
        this.STATISTICS_VIEW.show();
    }

    public final void handleTabSelection(int n) {
        switch (n) {
            case 0: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 1: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 2: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 3: {
                this.MENU_MEDIATOR.handleLibrarySelection();
            }
        }
    }

    public final void setWindow(int n) {
        this.MAIN_FRAME.setSelectedIndex(n);
    }

    public final void clearConnections() {
        this.CONNECTION_VIEW.clearConnections();
    }

    public final void setKeepAliveText(String string) {
        this.CONNECTION_VIEW.setKeepAliveText(string);
    }

    public final void triggerSearch(String string) {
        this.SEARCH_VIEW.triggerSearch(string);
        this.MAIN_FRAME.setSelectedIndex(0);
    }

    public final void setConnected(boolean bl) {
        this.SEARCH_VIEW.setConnected(bl);
        this.MENU_MEDIATOR.setConnected(bl);
        this.STATUS_LINE.setConnected(bl);
    }

    public final int getTotalUploads() {
        return this.UPLOAD_VIEW.getTotalUploads();
    }

    public final int getCurrentUploads() {
        return this.UPLOAD_VIEW.getCurrentUploads();
    }

    public final int getTotalDownloads() {
        return DownloadMediator.getTotalDownloads();
    }

    public final int getCurrentDownloads() {
        return DownloadMediator.getCurrentDownloads();
    }

    public final void addSharedLibraryFolder() {
        this.LIBRARY_MEDIATOR.addSharedLibraryFolder();
    }

    public final void addNewLibraryFolder() {
        this.LIBRARY_MEDIATOR.addNewLibraryFolder();
    }

    public final void deleteLibraryFolder() {
        this.LIBRARY_MEDIATOR.deleteLibraryFolder();
    }

    public final void renameLibraryFolder() {
        this.LIBRARY_MEDIATOR.renameLibraryFolder();
    }

    public final void launchLibraryFile() {
        this.LIBRARY_MEDIATOR.launch();
    }

    public final void deleteLibraryFile() {
        this.LIBRARY_MEDIATOR.deleteLibraryFile();
    }

    public final void refreshLibrary() {
        this.LIBRARY_MEDIATOR.refresh();
    }

    public final void clearLibrary() {
        this.LIBRARY_MEDIATOR.clearLibrary();
    }

    private static void hideView() {
        if (CommonUtils.isMacClassic()) {
            GUIMediator.setAppVisible(false);
            return;
        }
        if (FRAME.getState() != 1) {
            FRAME.setState(1);
        }
        if (CommonUtils.supportsTray()) {
            GUIMediator.setAppVisible(false);
            GUIMediator.addNotify();
        }
    }

    public static void restoreView() {
        if (CommonUtils.supportsTray()) {
            GUIMediator.setAppVisible(true);
            GUIMediator.hideNotify();
        }
        Finalizer.cancelShutdown();
        if (CommonUtils.isMacClassic()) {
            GUIMediator.setAppVisible(true);
            return;
        }
        if (FRAME.getState() != 0) {
            FRAME.setState(0);
        }
    }

    public static void close() {
        if (SETTINGS.getMinimizeToTray()) {
            GUIMediator.hideView();
        } else if (SETTINGS.getShutdownAfterTransfers() && !CommonUtils.isMacClassic()) {
            GUIMediator.shutdownAfterTransfers();
        } else {
            GUIMediator.shutdown();
        }
    }

    public static void shutdown() {
        GUIMediator.cleanupOnExit();
        Finalizer.shutdown();
    }

    public static void shutdownAfterTransfers() {
        Finalizer.shutdownAfterTransfers();
        GUIMediator.hideView();
    }

    private static void cleanupOnExit() {
        StatusLine.cleanup();
    }

    public static final void showAboutWindow() {
        AboutWindow aboutWindow = new AboutWindow();
        aboutWindow.showDialog();
    }

    public static void updateNotifyImage(String string) {
        NotifyUserProxy.instance().updateImage(string);
    }

    public static void updateNotifyText(String string) {
        NotifyUserProxy.instance().updateDesc(string);
    }

    public static void updateNotify(String string, String string2) {
        NotifyUserProxy.instance().updateNotify(string, string2);
    }

    public static void hideNotify() {
        NotifyUserProxy.instance().hideNotify();
    }

    public static void addNotify() {
        NotifyUserProxy.instance().addNotify();
    }

    public static final ImageIcon getImageResource(String string) {
        return ResourceManager.getImageResource(string);
    }

    public static final String getStringResource(String string) {
        return ResourceManager.getStringResource(string);
    }

    public static final void showError(String string) {
        String string2 = GUIMediator.getStringResource(string);
        MESSAGE_SERVICE.showError(string2);
    }

    public static final void showError(String string, String string2) {
        String string3 = GUIMediator.getStringResource(string) + " " + string2;
        MESSAGE_SERVICE.showError(string3);
    }

    public static final void showError(String string, String string2, String string3) {
        String string4 = GUIMediator.getStringResource(string) + " " + string2 + " " + GUIMediator.getStringResource(string3);
        MESSAGE_SERVICE.showError(string4);
    }

    public static final void showMessage(String string) {
        String string2 = GUIMediator.getStringResource(string);
        MESSAGE_SERVICE.showMessage(string2);
    }

    public static final void showMessage(String string, String string2) {
        String string3 = GUIMediator.getStringResource(string) + " " + string2;
        MESSAGE_SERVICE.showMessage(string3);
    }

    public static final void showMessage(String string, String string2, String string3) {
        String string4 = GUIMediator.getStringResource(string) + " " + string2 + " " + GUIMediator.getStringResource(string3);
        MESSAGE_SERVICE.showMessage(string4);
    }

    public static final void showConfirmMessage(String string) {
        String string2 = GUIMediator.getStringResource(string);
        MESSAGE_SERVICE.showConfirmMessage(string2);
    }

    public static final void showConfirmMessage(String string, String string2) {
        String string3 = GUIMediator.getStringResource(string) + " " + string2;
        MESSAGE_SERVICE.showConfirmMessage(string3);
    }

    public static final void showConfirmMessage(String string, String string2, String string3) {
        String string4 = GUIMediator.getStringResource(string) + " " + string2 + " " + GUIMediator.getStringResource(string3);
        MESSAGE_SERVICE.showConfirmMessage(string4);
    }

    public static final int showYesNoMessage(String string) {
        String string2 = GUIMediator.getStringResource(string);
        return MESSAGE_SERVICE.showYesNoMessage(string2);
    }

    public static final int showYesNoMessage(String string, String string2) {
        String string3 = GUIMediator.getStringResource(string) + " " + string2;
        return MESSAGE_SERVICE.showYesNoMessage(string3);
    }

    public static final int showYesNoMessage(String string, String string2, String string3) {
        String string4 = GUIMediator.getStringResource(string) + " " + string2 + " " + GUIMediator.getStringResource(string3);
        return MESSAGE_SERVICE.showYesNoMessage(string4);
    }

    public static final void showInternalError(String string, Throwable throwable) {
        String string2 = GUIMediator.getStringResource(string);
        MESSAGE_SERVICE.showInternalError(string2, throwable);
    }

    public static final void showInternalError(Throwable throwable) {
        String string = GUIMediator.getStringResource("ERROR_INTERNAL");
        MESSAGE_SERVICE.showInternalError(string, throwable);
    }

    public static final int openURL(String string) throws IOException {
        return Launcher.openURL(string);
    }

    public static final int launchFile(File file) throws IOException {
        try {
            return Launcher.launchFile(file);
        }
        catch (SecurityException securityException) {
            GUIMediator.showError("MESSAGE_FILE_LAUNCHING_SECURITY_MESSAGE");
            return -1;
        }
    }

    public static final Component getHorizontalSeparator() {
        return HORIZONTAL_SEPARATOR;
    }

    public static final Component getVerticalSeparator() {
        return VERTICAL_SEPARATOR;
    }

    public void connect() {
        this._routerService.connect();
    }

    public void disconnect() {
        this._routerService.disconnect();
        this.setConnected(false);
    }

    public static boolean shouldShowAds() {
        return SHOW_ADS;
    }

    public void setMonitorViewEnabled(boolean bl) {
        this.MAIN_FRAME.setMonitorViewEnabled(bl);
    }

    public void setConnectionViewEnabled(boolean bl) {
        this.MAIN_FRAME.setConnectionViewEnabled(bl);
    }

    public void setLibraryViewEnabled(boolean bl) {
        this.MAIN_FRAME.setLibraryViewEnabled(bl);
    }

    public static void reloadAds() {
        StatusLine.reloadAds();
    }
}

