/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import java.awt.Dimension;
import java.awt.Point;

public final class Finalizer {
    private static boolean _wasConnected;
    private static boolean _shutdownImminent;
    private static boolean _uploadsComplete;
    private static boolean _downloadsComplete;
    private static RouterService _routerService;

    private Finalizer() {
    }

    public static void initialize(RouterService routerService) {
        _routerService = routerService;
    }

    public static boolean isShutdownImminent() {
        return _shutdownImminent;
    }

    public static void shutdown() {
        try {
            SettingsManager settingsManager = SettingsManager.instance();
            NotifyUserProxy.instance().removeNotify();
            if (GUIMediator.getAppVisible()) {
                Dimension dimension = GUIMediator.getAppSize();
                Point point = GUIMediator.getAppLocation();
                settingsManager.setAppWidth(dimension.width);
                settingsManager.setAppHeight(dimension.height);
                settingsManager.setWindowX(point.x);
                settingsManager.setWindowY(point.y);
                settingsManager.setRunOnce(true);
            }
            if (_routerService != null) {
                _routerService.shutdown();
            } else {
                settingsManager.writeProperties();
            }
            System.exit(0);
        }
        catch (Exception exception) {
            GUIMediator.showInternalError(exception);
            System.exit(0);
        }
    }

    public static void shutdownAfterTransfers() {
        _shutdownImminent = true;
        boolean bl = _wasConnected = _routerService.isConnected();
        if (_wasConnected) {
            _routerService.disconnect();
        }
        if (Finalizer.transfersComplete()) {
            GUIMediator.shutdown();
        }
    }

    public static void cancelShutdown() {
        _shutdownImminent = false;
        _uploadsComplete = false;
        _downloadsComplete = false;
        if (_wasConnected) {
            _routerService.connect();
        }
    }

    static void setDownloadsComplete() {
        _downloadsComplete = true;
        Finalizer.checkForShutdown();
    }

    static void setUploadsComplete() {
        _uploadsComplete = true;
        Finalizer.checkForShutdown();
    }

    private static boolean transfersComplete() {
        if (_routerService == null) {
            return true;
        }
        if (_routerService.getNumDownloads() == 0) {
            _downloadsComplete = true;
        }
        if (_routerService.getNumUploads() == 0) {
            _uploadsComplete = true;
        }
        return _uploadsComplete & _downloadsComplete;
    }

    private static void checkForShutdown() {
        if (_shutdownImminent && _uploadsComplete && _downloadsComplete) {
            GUIMediator.shutdown();
        }
    }
}

