/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadConnectionSettingException;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.util.ArrayListUtil;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;

public class ConnectionView
extends JPanel {
    private static final int COLUMNS = 7;
    private static final int HOST_COL = 0;
    private static final int TYPE_COL = 1;
    private static final int MESSAGES_COL = 2;
    private static final int BANDWIDTH_COL = 3;
    private static final int DROP_COL = 4;
    private static final int HORIZON_COL = 5;
    private static final int HOST_INFO = 6;
    private int rowNum;
    private JButton addButton;
    private JButton removeButton;
    private JTextField hostname;
    private JTextField port;
    private JTextField minConnections;
    private AbstractTableModel dataModel;
    private JTable tableView;
    private JScrollPane scrollpane;
    private JPanel tablepane;
    private JTabbedPane tabbedPane;
    private ConnectionList list;
    private boolean disableRemoteRemove = false;
    private SettingsManager settings;
    private boolean disableKeepAliveValidate = false;
    private KeepAliveDocumentListener keepAliveDocumentListener;
    private JButton options;
    private JPanel switchedPanel;
    private CardLayout switcher;
    private JLabel minLabel;
    NumberFormat formatter;

    public ConnectionView() {
        this.setLayout(new BorderLayout());
        String string = GUIMediator.getStringResource("CV_PANEL_TITLE");
        PaddedPanel paddedPanel = new PaddedPanel(string);
        this.settings = SettingsManager.instance();
        this.rowNum = 0;
        final String[] stringArray = new String[]{GUIMediator.getStringResource("CV_COLUMN_HOST"), GUIMediator.getStringResource("CV_COLUMN_STATUS"), GUIMediator.getStringResource("CV_COLUMN_MESSAGE"), GUIMediator.getStringResource("CV_COLUMN_BANDWIDTH"), GUIMediator.getStringResource("CV_COLUMN_DROPPED"), GUIMediator.getStringResource("CV_COLUMN_HOSTS"), GUIMediator.getStringResource("CV_COLUMN_PROTOCOL")};
        this.list = new ConnectionList();
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return stringArray.length;
            }

            public int getRowCount() {
                return ConnectionView.this.list.size();
            }

            public Object getValueAt(int n, int n2) {
                if (n < ConnectionView.this.list.size()) {
                    return ((ConnectionView)ConnectionView.this).list.get((int)n).displayed[n2];
                }
                return "";
            }

            public String getColumnName(int n) {
                return stringArray[n];
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (n >= ConnectionView.this.list.size()) {
                    return;
                }
                ((ConnectionView)ConnectionView.this).list.get((int)n).displayed[n2] = object;
                this.fireTableCellUpdated(n, n2);
            }
        };
        this.tableView = new JTable(this.dataModel);
        this.tableView.setShowGrid(false);
        this.scrollpane = new JScrollPane(this.tableView);
        this.scrollpane.setPreferredSize(new Dimension(440, 120));
        this.tablepane = new JPanel();
        this.tablepane.setLayout(new BorderLayout());
        this.tablepane.setBackground(Color.white);
        this.scrollpane.getViewport().setBackground(Color.white);
        this.tablepane.add((Component)this.scrollpane, "Center");
        this.tableView.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tableView.getColumnModel().getColumn(1).setPreferredWidth(45);
        this.tableView.getColumnModel().getColumn(5).setPreferredWidth(15);
        paddedPanel.add(this.tablepane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        String string2 = GUIMediator.getStringResource("CV_BUTTON_REMOVE");
        String string3 = GUIMediator.getStringResource("CV_BUTTON_TOOLTIP_REMOVE");
        String string4 = GUIMediator.getStringResource("CV_BUTTON_ADD");
        String string5 = GUIMediator.getStringResource("CV_BUTTON_TOOLTIP_ADD");
        this.removeButton = new JButton(string2);
        this.removeButton.setToolTipText(string3);
        this.addButton = new JButton(string4);
        this.addButton.setToolTipText(string5);
        this.hostname = new JTextField(20);
        this.port = new WholeNumberField(6346, 4);
        jPanel.add(this.removeButton);
        jPanel.add(this.addButton);
        jPanel.add(this.hostname);
        jPanel.add(this.port);
        paddedPanel.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        String string6 = GUIMediator.getStringResource("CV_LABEL_KEEP_BEGIN");
        String string7 = GUIMediator.getStringResource("CV_LABEL_KEEP_END");
        this.minLabel = new JLabel(string6 + " ");
        this.minConnections = new WholeNumberField(0, 2);
        JLabel jLabel = new JLabel(" " + string7);
        jPanel2.add(this.minLabel);
        jPanel2.add(this.minConnections);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(10));
        paddedPanel.add(jPanel2);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ConnectionView.this.tableView.getSelectedRows();
                ArrayList arrayList = ArrayListUtil.buildArray(nArray);
                Collections.sort((List)arrayList, (Comparator)ArrayListUtil.integerComparator());
                int n = nArray.length;
                int n2 = n - 1;
                while (n2 >= 0) {
                    int n3 = (Integer)arrayList.get(n2);
                    if (n3 >= 0 && n3 < ConnectionView.this.list.size()) {
                        ManagedConnection managedConnection = ((ConnectionView)ConnectionView.this).list.get((int)n3).connection;
                        ConnectionView.this.disableRemoteRemove = true;
                        GUIMediator.instance().getRouter().removeConnection(managedConnection);
                        ConnectionView.this.disableRemoteRemove = false;
                        ConnectionView.this.list.removeRow(n3);
                    }
                    --n2;
                }
                ConnectionView.this.validate();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ConnectionView.this.hostname.getText();
                String string2 = ConnectionView.this.port.getText();
                int n = -1;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    n = 6346;
                }
                if (!string.equals("")) {
                    ConnectionView.this.tryConnection(string, n);
                }
            }
        });
        this.hostname.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ConnectionView.this.hostname.getText();
                String string2 = ConnectionView.this.port.getText();
                int n = -1;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    n = 6346;
                }
                if (!string.equals("")) {
                    ConnectionView.this.tryConnection(string, n);
                }
            }
        });
        this.keepAliveDocumentListener = new KeepAliveDocumentListener();
        this.minConnections.getDocument().addDocumentListener(this.keepAliveDocumentListener);
        this.setKeepAliveText(Integer.toString(this.settings.getKeepAlive()));
        BoxPanel boxPanel = new BoxPanel(0);
        this.add((Component)paddedPanel, "Center");
        this.formatter = new DecimalFormat();
        this.formatter.setMaximumFractionDigits(1);
    }

    public void processKeepAliveChange(JTextField jTextField) {
        String string = jTextField.getText();
        if (string == null || string.equals("") || this.disableKeepAliveValidate) {
            return;
        }
        int n = Integer.parseInt(string);
        if (jTextField == this.minConnections) {
            try {
                GUIMediator.instance().getRouter().setKeepAlive(n);
                this.settings.setKeepAlive(n);
            }
            catch (BadConnectionSettingException badConnectionSettingException) {
                int n2 = badConnectionSettingException.getReason();
                if (n2 == 2) {
                    this.showMessage("ERROR_KEEP_ALIVE");
                } else if (n2 == 4) {
                    this.showMessage("ERROR_TOO_LOW_FOR_ULTRAPEER");
                } else if (n2 == 3) {
                    this.showMessage("ERROR_TOO_HIGH_FOR_LEAF");
                }
                this.processKeepAliveSuggestion(jTextField, badConnectionSettingException);
            }
        } else {
            Assert.that(false, "Unknown connection property");
        }
    }

    private void processKeepAliveSuggestion(JTextField jTextField, BadConnectionSettingException badConnectionSettingException) {
        final int n = badConnectionSettingException.getSuggestedOutgoing();
        this.settings.setKeepAlive(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectionView.this.disableKeepAliveValidate = true;
                ConnectionView.this.minConnections.setText(String.valueOf(n));
                ConnectionView.this.disableKeepAliveValidate = false;
            }
        });
        GUIMediator.instance().getRouter().forceKeepAlive(n);
    }

    public void setKeepAliveText(String string) {
        this.disableKeepAliveValidate = true;
        this.minConnections.setText(string);
        this.disableKeepAliveValidate = false;
    }

    public void validate() {
        this.dataModel.fireTableRowsUpdated(0, 10000);
        this.tablepane.validate();
        this.scrollpane.validate();
    }

    private void tryConnection(String string, int n) {
        GUIMediator.instance().getRouter().connectToHostAsynchronously(string, n);
    }

    public void clearConnections() {
        this.list.clear();
        this.setKeepAliveText("0");
    }

    public void addConnection(Connection connection) {
        if (!(connection instanceof ManagedConnection)) {
            return;
        }
        this.list.addRow((ManagedConnection)connection);
        this.dataModel.fireTableRowsInserted(0, 0);
        this.validate();
    }

    public void renameConnection(Connection connection) {
        this.list.renameConnection(connection);
        this.validate();
    }

    public void updateConnection(Connection connection) {
        this.list.updateConnection(connection);
        this.validate();
    }

    public void removeConnection(Connection connection) {
        if (this.disableRemoteRemove) {
            return;
        }
        this.list.removeConnection(connection);
        this.validate();
    }

    public void updateConnectionStats() {
        this.list.updateConnectionStats();
        this.validate();
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.showError(string);
            }
        });
    }

    private class ConnectionList {
        private ArrayList list;
        private NumberFormat formatter;
        private final String CONNECTING_STRING = GUIMediator.getStringResource("CV_TABLE_STRING_CONNECTING");

        public ConnectionList() {
            this.list = new ArrayList();
            this.formatter = NumberFormat.getInstance();
            this.formatter.setMinimumFractionDigits(3);
            this.formatter.setMaximumFractionDigits(3);
        }

        public void clear() {
            this.list.clear();
            ConnectionView.this.tableView.clearSelection();
            ConnectionView.this.dataModel.fireTableRowsDeleted(0, this.size());
        }

        public int size() {
            return this.list.size();
        }

        public void removeRow(int n) {
            this.list.remove(n);
            ConnectionView.this.dataModel.fireTableRowsDeleted(n, n);
        }

        public int findRow(Connection connection) {
            int n = -1;
            int n2 = this.list.size();
            int n3 = 0;
            while (n3 < n2) {
                Row row = (Row)this.list.get(n3);
                if (row.connection == connection) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            return n;
        }

        public void addRow(ManagedConnection managedConnection) {
            String string;
            Object[] objectArray;
            Assert.that(this.findRow(managedConnection) < 0);
            if (managedConnection.isOutgoing()) {
                objectArray = managedConnection.getOrigHost();
                if (objectArray.equals(SettingsManager.DEDICATED_LIMEWIRE_ROUTER)) {
                    objectArray = "router.limewire.com";
                }
                string = (String)objectArray + ":" + String.valueOf(managedConnection.getOrigPort());
            } else {
                string = managedConnection.getOrigHost();
            }
            objectArray = new Object[]{string, this.CONNECTING_STRING, "", "", "", "", this.getHostInfo(managedConnection)};
            this.list.add(0, (Object)new Row(objectArray, managedConnection));
        }

        private String getHostInfo(Connection connection) {
            if (connection instanceof ManagedConnection) {
                ManagedConnection managedConnection = (ManagedConnection)connection;
                if (managedConnection.isSupernodeClientConnection()) {
                    return GUIMediator.getStringResource("CV_TABLE_STRING_LEAF");
                }
                if (managedConnection.isSupernodeConnection()) {
                    return GUIMediator.getStringResource("CV_TABLE_STRING_ULTRAPEER");
                }
            }
            return GUIMediator.getStringResource("CV_TABLE_STRING_STANDARD");
        }

        public void updateConnection(Connection connection) {
            int n = this.findRow(connection);
            if (n == -1) {
                return;
            }
            Object[] objectArray = ((Row)this.list.get((int)n)).displayed;
            objectArray[1] = connection.isOutgoing() ? GUIMediator.getStringResource("CV_TABLE_STRING_OUTGOING") : GUIMediator.getStringResource("CV_TABLE_STRING_INCOMING");
            objectArray[6] = this.getHostInfo(connection);
        }

        public void renameConnection(Connection connection) {
            String string = connection.isOutgoing() ? connection.getInetAddress().getHostAddress() + ":" + connection.getOrigPort() : connection.getInetAddress().getHostAddress();
            int n = this.findRow(connection);
            if (n == -1) {
                return;
            }
            Object[] objectArray = ((Row)this.list.get((int)n)).displayed;
            if (!((String)objectArray[0]).startsWith("router.limewire.com")) {
                objectArray[0] = string;
            }
        }

        public void removeConnection(Connection connection) {
            int n = this.findRow(connection);
            if (n == -1) {
                return;
            }
            this.removeRow(n);
        }

        public Row get(int n) {
            if (n >= this.list.size() || n < 0) {
                return null;
            }
            return (Row)this.list.get(n);
        }

        public void updateConnectionStats() {
            ConnectionView.this.minLabel.setText((GUIMediator.instance().getRouter().isSupernode() ? GUIMediator.getStringResource("CV_STRING_ULTRAPEER") : GUIMediator.getStringResource("CV_STRING_CLIENT")) + "      " + GUIMediator.getStringResource("CV_LABEL_KEEP_BEGIN"));
            int n = 0;
            while (n < this.list.size()) {
                Row row = (Row)this.list.get(n);
                Object[] objectArray = row.displayed;
                ManagedConnection managedConnection = row.connection;
                if (!objectArray[1].equals(this.CONNECTING_STRING)) {
                    objectArray[2] = managedConnection.getNumMessagesReceived() + " / " + managedConnection.getNumMessagesSent();
                    objectArray[3] = this.formatter.format(managedConnection.getMeasuredDownstreamBandwidth()) + " / " + this.formatter.format(managedConnection.getMeasuredUpstreamBandwidth()) + GUIMediator.getStringResource("CV_TABLE_STRING_KBPSEC");
                    objectArray[4] = (int)managedConnection.getPercentReceivedDropped() + "% / " + (int)managedConnection.getPercentSentDropped() + "%";
                    objectArray[5] = !managedConnection.isClientSupernodeConnection() ? String.valueOf(managedConnection.getNumHosts()) : "?";
                    objectArray[6] = this.getHostInfo(managedConnection);
                }
                ++n;
            }
        }
    }

    private static class Row {
        Object[] displayed;
        ManagedConnection connection;

        Row(Object[] objectArray, ManagedConnection managedConnection) {
            this.displayed = objectArray;
            this.connection = managedConnection;
        }
    }

    private class KeepAliveDocumentListener
    implements DocumentListener {
        private KeepAliveDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ConnectionView.this.processKeepAliveChange(this.source(documentEvent));
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ConnectionView.this.processKeepAliveChange(this.source(documentEvent));
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private JTextField source(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            if (document == ConnectionView.this.minConnections.getDocument()) {
                return ConnectionView.this.minConnections;
            }
            Assert.that(false, "Unknown connection property");
            return null;
        }
    }
}

