/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.SpamFilter;

public class GreedyQueryFilter
extends SpamFilter {
    private static final int GREEDY_QUERY_MAX = 3;

    public boolean allow(Message message) {
        if (!(message instanceof QueryRequest)) {
            return true;
        }
        String string = ((QueryRequest)message).getQuery();
        int n = string.length();
        if (n == 1) {
            return false;
        }
        if ((n == 5 || n == 6) && string.charAt(1) == '.' && Character.isLetter(string.charAt(0))) {
            return false;
        }
        if (this.isVeryGeneralSearch(string)) {
            byte by = message.getHops();
            byte by2 = message.getTTL();
            if (by >= 3) {
                return false;
            }
            if (by + by2 > 3) {
                message.setTTL((byte)(3 - by));
            }
        }
        return true;
    }

    private boolean isVeryGeneralSearch(String string) {
        int n = string.length();
        if (n == 3 && (string.charAt(1) == '.' || string.equalsIgnoreCase("mp3") || string.equalsIgnoreCase("mpg"))) {
            return true;
        }
        if (n == 5) {
            String string2 = string.substring(2, 5);
            if (string.charAt(1) == '.' && (string2.equalsIgnoreCase("mp3") || string2.equalsIgnoreCase("mpg"))) {
                return true;
            }
        }
        return false;
    }
}

