/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.InvalidPathException;
import com.limegroup.gnutella.downloader.RemoteFileDesc2;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;

public class ManagedDownloader
implements Downloader,
Serializable {
    private DownloadManager manager;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager;
    private RemoteFileDesc[] allFiles;
    private static final int TRIES = 300;
    private static final int PUSH_TRIES = 2;
    private static final int NORMAL_CONNECT_TIME = 4000;
    private static final int PUSH_CONNECT_TIME = 10000;
    private static final int PUSH_INVALIDATE_TIME = 300;
    private static final int MIN_SPLIT_SIZE = 100000;
    private static final int DECENT_QUALITY = 2;
    private Thread dloaderManagerThread;
    private List dloaders;
    private boolean stopped;
    private Object pushLock = new Object();
    private String pushFile;
    private byte[] pushClientGUID = null;
    private long pushIndex;
    private Socket pushSocket;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();
    private int state;
    private long stateTime;
    private int retriesWaiting;
    private String currentFileName;
    private int currentFileSize;
    private String currentLocation;
    private DownloadChatList chatList;

    public ManagedDownloader(DownloadManager downloadManager, RemoteFileDesc[] remoteFileDescArray, FileManager fileManager, IncompleteFileManager incompleteFileManager) {
        this.allFiles = remoteFileDescArray;
        this.incompleteFileManager = incompleteFileManager;
        this.initialize(downloadManager, fileManager);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.allFiles);
        IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
        synchronized (incompleteFileManager) {
            objectOutputStream.writeObject(this.incompleteFileManager);
        }
        objectOutputStream.writeObject(this.bandwidthTracker);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.allFiles = (RemoteFileDesc[])objectInputStream.readObject();
        this.incompleteFileManager = (IncompleteFileManager)objectInputStream.readObject();
        this.bandwidthTracker = (BandwidthTrackerImpl)objectInputStream.readObject();
        this.pushLock = new Object();
    }

    public void initialize(DownloadManager downloadManager, FileManager fileManager) {
        this.manager = downloadManager;
        this.fileManager = fileManager;
        this.dloaders = new LinkedList();
        this.chatList = new DownloadChatList();
        this.stopped = false;
        this.setState(0);
        this.dloaderManagerThread = new Thread(){

            public void run() {
                try {
                    ManagedDownloader.this.tryAllDownloads();
                }
                catch (Exception exception) {
                    ManagedDownloader.this.manager.internalError(exception);
                }
            }
        };
        this.dloaderManagerThread.setDaemon(true);
        this.dloaderManagerThread.start();
    }

    public boolean conflicts(RemoteFileDesc remoteFileDesc) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            File file = this.incompleteFileManager.getFile(remoteFileDesc);
            int n = 0;
            while (n < this.allFiles.length) {
                RemoteFileDesc remoteFileDesc2 = this.allFiles[n];
                File file2 = this.incompleteFileManager.getFile(remoteFileDesc2);
                if (file2.equals(file)) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean acceptDownload(String string, Socket socket, int n, byte[] byArray) throws IOException {
        Object object = this.pushLock;
        synchronized (object) {
            if (this.pushFile == null || !this.pushFile.equals(string) || this.pushIndex != (long)n || !Arrays.equals((byte[])this.pushClientGUID, (byte[])byArray)) {
                boolean bl = false;
                return bl;
            }
            this.pushSocket = socket;
            this.pushLock.notify();
            boolean bl = true;
            return bl;
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            ((HTTPDownloader)iterator.next()).stop();
        }
        if (this.dloaderManagerThread != null) {
            this.dloaderManagerThread.interrupt();
        }
    }

    public synchronized boolean resume() throws AlreadyDownloadingException {
        if (this.state != 3 && this.state != 6 && this.state != 5) {
            return false;
        }
        String string = this.manager.conflicts(this.allFiles, this);
        if (string != null) {
            throw new AlreadyDownloadingException(string);
        }
        if (this.state == 6 || this.state == 5) {
            this.initialize(this.manager, this.fileManager);
        } else if (this.state == 3 && this.dloaderManagerThread != null) {
            this.dloaderManagerThread.interrupt();
        }
        return true;
    }

    public File getDownloadFragment() {
        if (this.currentFileName == null) {
            return null;
        }
        if (this.state != 4) {
            File file = this.incompleteFileManager.getFile(this.currentFileName, this.currentFileSize);
            File file2 = new File(file.getParent(), "Preview-" + file.getName());
            int n = this.amountForPreview(file);
            if (n <= 0) {
                return null;
            }
            if (CommonUtils.copy(file, n, file2) <= 0) {
                return null;
            }
            return file2;
        }
        File file = null;
        try {
            file = SettingsManager.instance().getSaveDirectory();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return new File(file, this.currentFileName);
    }

    private synchronized int amountForPreview(File file) {
        Object object;
        Iterator iterator;
        int n = 0;
        IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
        synchronized (incompleteFileManager) {
            iterator = this.incompleteFileManager.getBlocks(file);
            while (iterator.hasNext()) {
                object = (Interval)iterator.next();
                if (((Interval)object).low != 0) continue;
                n = ((Interval)object).high;
                break;
            }
        }
        iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            object = (HTTPDownloader)iterator.next();
            if (((HTTPDownloader)object).getInitialReadingPoint() != n) continue;
            return n + ((HTTPDownloader)object).getAmountRead();
        }
        return n;
    }

    private void tryAllDownloads() {
        List[] listArray = ManagedDownloader.bucket(this.allFiles, this.incompleteFileManager);
        while (true) {
            try {
                while (true) {
                    ManagedDownloader managedDownloader;
                    this.setState(0);
                    this.manager.waitForSlot(this);
                    boolean bl = false;
                    int n = 0;
                    while (n < listArray.length) {
                        if (listArray[n].size() > 0) {
                            managedDownloader = this;
                            synchronized (managedDownloader) {
                                RemoteFileDesc remoteFileDesc = (RemoteFileDesc)listArray[n].get(0);
                                this.currentFileName = remoteFileDesc.getFileName();
                                this.currentFileSize = remoteFileDesc.getSize();
                            }
                            int n2 = this.tryAllDownloads2(listArray[n]);
                            if (n2 == 4) {
                                this.setState(4);
                                this.manager.remove(this, true);
                                return;
                            }
                            if (n2 == 7) {
                                this.setState(7);
                                this.manager.remove(this, false);
                                return;
                            }
                            if (n2 == 3) {
                                bl = true;
                            } else {
                                Assert.that(n2 == 6, "Bad status from tad2: " + n2);
                            }
                        }
                        ++n;
                    }
                    this.manager.yieldSlot(this);
                    if (!bl) break;
                    managedDownloader = this;
                    synchronized (managedDownloader) {
                        this.retriesWaiting = 0;
                        int n3 = 0;
                        while (n3 < listArray.length) {
                            this.retriesWaiting += listArray[n3].size();
                            ++n3;
                        }
                    }
                    long l = this.calculateWaitTime();
                    this.setState(3, l);
                    Thread.sleep(l);
                }
                this.setState(6);
                this.manager.remove(this, false);
                return;
            }
            catch (InterruptedException interruptedException) {
                if (!this.stopped) continue;
                this.setState(5);
                this.manager.remove(this, false);
                return;
            }
            break;
        }
    }

    private long calculateWaitTime() {
        return 60000L;
    }

    private int tryAllDownloads2(List list) throws InterruptedException {
        File file;
        if (list.size() == 0) {
            return 6;
        }
        RemoteFileDesc remoteFileDesc = (RemoteFileDesc)list.get(0);
        int n = remoteFileDesc.getSize();
        String string = remoteFileDesc.getFileName();
        File file2 = this.incompleteFileManager.getFile(remoteFileDesc);
        try {
            File file3 = SettingsManager.instance().getSaveDirectory();
            file = new File(file3, string);
            String string2 = file3.getCanonicalPath();
            String string3 = new File(file.getParent()).getCanonicalPath();
            if (!string2.equals(string3)) {
                throw new InvalidPathException();
            }
        }
        catch (IOException iOException) {
            return 7;
        }
        int n2 = this.tryAllDownloads3(list);
        if (n2 != 4) {
            return n2;
        }
        file.delete();
        if (!file2.renameTo(file) && !CommonUtils.copy(file2, file)) {
            return 7;
        }
        if (CommonUtils.isAnyMac() && file.getName().toLowerCase().endsWith("mp3")) {
            try {
                MRJFileUtils.setFileTypeAndCreator((File)file, (MRJOSType)new MRJOSType("MPG3"), (MRJOSType)new MRJOSType("hook"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fileManager.addFileIfShared(file, this.getXMLDocuments());
        return 4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private int tryAllDownloads3(List var1_1) throws InterruptedException {
        var2_2 = new ArrayList();
        var3_3 = (RemoteFileDesc)var1_1.get(0);
        var4_4 = this.incompleteFileManager.getFile(var3_3);
        var5_5 /* !! */  = this.incompleteFileManager;
        synchronized (var5_5 /* !! */ ) {
            var6_6 /* !! */  = this.incompleteFileManager.getFreeBlocks(var4_4, var3_3.getSize());
            while (var6_6 /* !! */ .hasNext()) {
                var2_2.add((Object)((Interval)var6_6 /* !! */ .next()));
            }
        }
        var3_3 = new LinkedList();
        var4_4 = new LinkedList();
        while (true) {
            var5_5 /* !! */  = this;
            synchronized (var5_5 /* !! */ ) {
                if (this.dloaders.size() == 0 && var2_2.size() == 0) {
                    var6_7 = 4;
                    return var6_7;
                }
                if (this.dloaders.size() == 0 && var1_1.size() == 0 && var4_4.size() == 0) {
                    if (var3_3.size() > 0) {
                        var1_1.addAll((Collection)var3_3);
                        var6_8 = 3;
                        return var6_8;
                    }
                    var6_9 = 6;
                    return var6_9;
                }
            }
            while (this.allowAnotherDownload()) {
                try {
                    this.startBestDownload(var1_1, (List)var2_2, (List)var3_3, (List)var4_4);
                }
                catch (NoSuchElementException var6_10) {
                    // empty catch block
                    break;
                }
            }
            var6_6 /* !! */  = this;
            synchronized (var6_6 /* !! */ ) {
                if (!this.stopped) ** GOTO lbl53
                throw new InterruptedException();
lbl-1000:
                // 1 sources

                {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException var7_13) {
                        if (!this.stopped) continue;
                        throw var7_13;
                    }
lbl53:
                    // 3 sources

                    ** while (var4_4.size() == 0 && this.dloaders.size() != 0)
                }
lbl54:
                // 1 sources

                var7_12 = var4_4.iterator();
                while (var7_12.hasNext()) {
                    var8_14 = (HTTPDownloader)var7_12.next();
                    var9_16 = var8_14.getInitialReadingPoint();
                    var10_17 = new Interval(var9_16 + var8_14.getAmountRead(), var9_16 + var8_14.getAmountToRead());
                    if (var10_17.high - var10_17.low <= 0) continue;
                    var2_2.add((Object)var10_17);
                }
                var4_4.clear();
                if (this.stopped) {
                    throw new InterruptedException();
                }
            }
        }
    }

    private synchronized boolean allowAnotherDownload() {
        int n = this.dloaders.size();
        int n2 = SettingsManager.instance().getConnectionSpeed();
        if (n2 <= 56) {
            return n < 1;
        }
        if (n2 <= 1000) {
            return n < 4;
        }
        return n < 6;
    }

    private void startBestDownload(final List list, List list2, List list3, final List list4) throws NoSuchElementException, InterruptedException {
        HTTPDownloader hTTPDownloader;
        Object object;
        if (list2.size() > 0) {
            object = (Interval)list2.remove(0);
            try {
                hTTPDownloader = this.findConnectable(list, ((Interval)object).low, ((Interval)object).high, list3);
            }
            catch (NoSuchElementException noSuchElementException) {
                list2.add(object);
                throw noSuchElementException;
            }
            hTTPDownloader.stopAt(((Interval)object).high);
        } else {
            object = null;
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                Iterator iterator = this.dloaders.iterator();
                while (iterator.hasNext()) {
                    HTTPDownloader hTTPDownloader2 = (HTTPDownloader)iterator.next();
                    if (object != null && hTTPDownloader2.getAmountToRead() <= ((HTTPDownloader)object).getAmountToRead()) continue;
                    object = hTTPDownloader2;
                }
            }
            if (object == null) {
                throw new NoSuchElementException();
            }
            int n = ((HTTPDownloader)object).getAmountRead();
            int n2 = ((HTTPDownloader)object).getAmountToRead() - n;
            if (n2 < 100000) {
                throw new NoSuchElementException();
            }
            int n3 = ((HTTPDownloader)object).getInitialReadingPoint() + n + n2 / 2;
            int n4 = ((HTTPDownloader)object).getInitialReadingPoint() + ((HTTPDownloader)object).getAmountToRead();
            hTTPDownloader = this.findConnectable(list, n3, n4, list3);
            hTTPDownloader.stopAt(n4);
            ((HTTPDownloader)object).stopAt(n3);
        }
        this.setState(2);
        object = this;
        synchronized (object) {
            if (this.stopped) {
                throw new InterruptedException();
            }
            this.dloaders.add((Object)hTTPDownloader);
            this.chatList.addHost(hTTPDownloader);
        }
        final HTTPDownloader hTTPDownloader3 = hTTPDownloader;
        Thread thread = new Thread(){

            public void run() {
                try {
                    ManagedDownloader.this.tryOneDownload(hTTPDownloader3, list, list4);
                }
                catch (Exception exception) {
                    ManagedDownloader.this.manager.internalError(exception);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private HTTPDownloader findConnectable(List list, int n, int n2, List list2) throws NoSuchElementException, InterruptedException {
        while (true) {
            HTTPDownloader hTTPDownloader;
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                if (list.size() == 0) {
                    throw new NoSuchElementException();
                }
                if (this.stopped) {
                    throw new InterruptedException();
                }
            }
            RemoteFileDesc remoteFileDesc = this.removeBest(list);
            File file = this.incompleteFileManager.getFile(remoteFileDesc);
            boolean bl = ManagedDownloader.needsPush(remoteFileDesc);
            ManagedDownloader managedDownloader2 = this;
            synchronized (managedDownloader2) {
                this.currentLocation = remoteFileDesc.getHost();
                if (this.dloaders.size() == 0) {
                    this.setState(1, bl ? 10000L : 4000L);
                }
            }
            if (bl) {
                Object object = this.pushLock;
                synchronized (object) {
                    this.manager.sendPush(remoteFileDesc);
                    this.pushFile = remoteFileDesc.getFileName();
                    this.pushIndex = remoteFileDesc.getIndex();
                    this.pushClientGUID = remoteFileDesc.getClientGUID();
                    this.pushLock.wait(10000L);
                    if (this.pushSocket == null) {
                        continue;
                    }
                    this.pushFile = null;
                    this.pushIndex = 0L;
                    this.pushClientGUID = null;
                    hTTPDownloader = new HTTPDownloader(this.pushSocket, remoteFileDesc, file, n, n2);
                    this.pushSocket = null;
                }
            } else {
                hTTPDownloader = new HTTPDownloader(remoteFileDesc, file, n, n2);
            }
            try {
                hTTPDownloader.connect(4000);
                return hTTPDownloader;
            }
            catch (TryAgainLaterException tryAgainLaterException) {
                list2.add((Object)remoteFileDesc);
                continue;
            }
            catch (CantConnectException cantConnectException) {
                ManagedDownloader managedDownloader3 = this;
                synchronized (managedDownloader3) {
                    list.add((Object)new RemoteFileDesc2(remoteFileDesc, true));
                    continue;
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tryOneDownload(HTTPDownloader hTTPDownloader, List list, List list2) {
        ManagedDownloader managedDownloader;
        RemoteFileDesc remoteFileDesc;
        try {
            try {
                hTTPDownloader.doDownload();
            }
            catch (IOException iOException) {
                this.chatList.removeHost(hTTPDownloader);
                Object var6_5 = null;
                RemoteFileDesc remoteFileDesc3 = hTTPDownloader.getRemoteFileDesc();
                ManagedDownloader managedDownloader3 = this;
                synchronized (managedDownloader3) {
                    this.dloaders.remove((Object)hTTPDownloader);
                    list2.add((Object)hTTPDownloader);
                    list.add((Object)remoteFileDesc3);
                    int n = hTTPDownloader.getInitialReadingPoint();
                    this.incompleteFileManager.addBlock(this.incompleteFileManager.getFile(remoteFileDesc3), n, n + hTTPDownloader.getAmountRead());
                    this.notifyAll();
                    return;
                }
            }
            Object var6_4 = null;
            remoteFileDesc = hTTPDownloader.getRemoteFileDesc();
            managedDownloader = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            RemoteFileDesc remoteFileDesc2 = hTTPDownloader.getRemoteFileDesc();
            ManagedDownloader managedDownloader2 = this;
            synchronized (managedDownloader2) {
                this.dloaders.remove((Object)hTTPDownloader);
                list2.add((Object)hTTPDownloader);
                list.add((Object)remoteFileDesc2);
                int n = hTTPDownloader.getInitialReadingPoint();
                this.incompleteFileManager.addBlock(this.incompleteFileManager.getFile(remoteFileDesc2), n, n + hTTPDownloader.getAmountRead());
                this.notifyAll();
                throw throwable;
            }
        }
        synchronized (managedDownloader) {
            this.dloaders.remove((Object)hTTPDownloader);
            list2.add((Object)hTTPDownloader);
            list.add((Object)remoteFileDesc);
            int n = hTTPDownloader.getInitialReadingPoint();
            this.incompleteFileManager.addBlock(this.incompleteFileManager.getFile(remoteFileDesc), n, n + hTTPDownloader.getAmountRead());
            this.notifyAll();
            return;
        }
    }

    private static List[] bucket(RemoteFileDesc[] remoteFileDescArray, IncompleteFileManager incompleteFileManager) {
        List[] listArray;
        Iterator iterator;
        Object object;
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < remoteFileDescArray.length) {
            object = new RemoteFileDesc2(remoteFileDescArray[n], false);
            File file = incompleteFileManager.getFile((RemoteFileDesc)object);
            iterator = (List)hashMap.get((Object)file);
            if (iterator == null) {
                iterator = new ArrayList();
                hashMap.put((Object)file, (Object)iterator);
            }
            iterator.add(object);
            ++n;
        }
        object = new FilePair[hashMap.keySet().size()];
        int n2 = 0;
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            listArray = (List[])iterator.next();
            List list = (List)hashMap.get((Object)listArray);
            int n3 = ((RemoteFileDesc)list.get(0)).getSize() - incompleteFileManager.getBlockSize((File)listArray);
            int n4 = 1;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                RemoteFileDesc2 remoteFileDesc2 = (RemoteFileDesc2)iterator2.next();
                if (remoteFileDesc2.getQuality() < 2) continue;
                n4 += ManagedDownloader.normalize(remoteFileDesc2.getSpeed());
            }
            float f = (float)n3 / (float)n4;
            object[n2] = new FilePair((File)listArray, f);
            ++n2;
        }
        Arrays.sort((Object[])object);
        listArray = new List[((Object[])object).length];
        n2 = 0;
        while (n2 < ((Object[])object).length) {
            listArray[n2] = (List)hashMap.get((Object)((FilePair)object[n2]).file);
            ++n2;
        }
        return listArray;
    }

    private static int normalize(int n) {
        if (n < 56) {
            return 3;
        }
        if (n < 350) {
            return 30;
        }
        if (n < 1000) {
            return 40;
        }
        return 50;
    }

    private synchronized RemoteFileDesc removeBest(List list) {
        Iterator iterator = list.iterator();
        RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc2 = (RemoteFileDesc)iterator.next();
            if (remoteFileDesc2.getQuality() > remoteFileDesc.getQuality()) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getQuality() != remoteFileDesc.getQuality() || remoteFileDesc2.getSpeed() <= remoteFileDesc.getSpeed()) continue;
            remoteFileDesc = remoteFileDesc2;
        }
        list.remove((Object)remoteFileDesc);
        return remoteFileDesc;
    }

    private static boolean needsPush(RemoteFileDesc remoteFileDesc) {
        int n;
        String string = remoteFileDesc.getHost();
        if (new Endpoint(string, n = remoteFileDesc.getPort()).isPrivateAddress()) {
            return true;
        }
        if (remoteFileDesc instanceof RemoteFileDesc2) {
            return ((RemoteFileDesc2)remoteFileDesc).isUnreachable();
        }
        return false;
    }

    private LimeXMLDocument[] getXMLDocuments() {
        int n;
        LimeXMLDocument[] limeXMLDocumentArray = null;
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < this.allFiles.length) {
            if (this.allFiles[n2] != null) {
                limeXMLDocumentArray = this.allFiles[n2].getXMLDocs();
                n = 0;
                while (limeXMLDocumentArray != null && n < limeXMLDocumentArray.length) {
                    arrayList.add((Object)limeXMLDocumentArray[n]);
                    ++n;
                }
            }
            ++n2;
        }
        if (arrayList.size() > 0) {
            limeXMLDocumentArray = new LimeXMLDocument[arrayList.size()];
            n = 0;
            while (n < limeXMLDocumentArray.length) {
                limeXMLDocumentArray[n] = (LimeXMLDocument)arrayList.get(n);
                ++n;
            }
        } else {
            limeXMLDocumentArray = null;
        }
        return limeXMLDocumentArray;
    }

    private void setState(int n) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = n;
            this.stateTime = Long.MAX_VALUE;
        }
    }

    private void setState(int n, long l) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = n;
            this.stateTime = System.currentTimeMillis() + l;
        }
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case 1: 
            case 3: {
                long l = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(l, 0L) / 1000;
            }
        }
        return Integer.MAX_VALUE;
    }

    public synchronized String getFileName() {
        if (this.dloaders.size() == 0) {
            return this.allFiles[0].getFileName();
        }
        return ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc().getFileName();
    }

    public synchronized int getContentLength() {
        if (this.dloaders.size() == 0) {
            return this.allFiles[0].getSize();
        }
        return ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc().getSize();
    }

    public synchronized int getAmountRead() {
        if (this.dloaders.size() == 0) {
            return 0;
        }
        RemoteFileDesc remoteFileDesc = ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc();
        File file = this.incompleteFileManager.getFile(remoteFileDesc);
        int n = this.incompleteFileManager.getBlockSize(file);
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            n += ((HTTPDownloader)iterator.next()).getAmountRead();
        }
        return n;
    }

    public String getAddress() {
        return this.currentLocation;
    }

    public synchronized Iterator getHosts() {
        return this.getHosts(false);
    }

    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    private final Iterator getHosts(boolean bl) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.dloaders.iterator();
        while (iterator.hasNext()) {
            HTTPDownloader hTTPDownloader = (HTTPDownloader)iterator.next();
            if (!(bl ? hTTPDownloader.chatEnabled() : true)) continue;
            linkedList.add((Object)new Endpoint(hTTPDownloader.getInetAddress().getHostAddress(), hTTPDownloader.getPort()));
        }
        return linkedList.iterator();
    }

    public synchronized int getRetriesWaiting() {
        return this.retriesWaiting;
    }

    public void measureBandwidth() {
        this.bandwidthTracker.measureBandwidth(this.getAmountRead());
    }

    public float getMeasuredBandwidth() {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    private static class FilePair
    implements Comparable {
        float time;
        File file;

        public FilePair(File file, float f) {
            this.time = f;
            this.file = file;
        }

        public int compareTo(Object object) {
            float f = this.time - ((FilePair)object).time;
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            return 0;
        }
    }
}

