/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.util.FileComparator;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;

public class IncompleteFileManager
implements Serializable {
    static final String SEPARATOR = "-";
    public static final String PREVIEW_PREFIX = "Preview-";
    private Map blocks = new TreeMap((Comparator)new FileComparator());

    public synchronized boolean purge() {
        boolean bl = false;
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (file.exists() && !IncompleteFileManager.isOld(file)) continue;
            bl = true;
            file.delete();
            iterator.remove();
        }
        return bl;
    }

    private static final boolean isOld(File file) {
        long l = file.lastModified();
        int n = SettingsManager.instance().getIncompletePurgeTime();
        long l2 = System.currentTimeMillis() - (long)(n * 24 * 60 * 60 * 1000);
        return l < l2;
    }

    public File getFile(RemoteFileDesc remoteFileDesc) {
        return this.getFile(remoteFileDesc.getFileName(), remoteFileDesc.getSize());
    }

    public File getFile(String string, int n) {
        File file = null;
        try {
            file = SettingsManager.instance().getIncompleteDirectory();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return new File(file, "T-" + n + SEPARATOR + string);
    }

    public synchronized Iterator getBlocks(File file) {
        List list = (List)this.blocks.get((Object)file);
        if (list == null) {
            return new LinkedList().iterator();
        }
        return list.iterator();
    }

    public synchronized int getBlockSize(File file) {
        int n = 0;
        Iterator iterator = this.getBlocks(file);
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            n += interval.high - interval.low;
        }
        return n;
    }

    public synchronized void addBlock(File file, int n, int n2) throws IllegalArgumentException {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n == n2) {
            return;
        }
        List list = (List)this.blocks.get((Object)file);
        if (list == null) {
            list = new LinkedList();
            this.blocks.put((Object)file, (Object)list);
        }
        Interval interval = null;
        Interval interval2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Interval interval3 = (Interval)iterator.next();
            if (n <= interval3.low && interval3.high <= n2) {
                iterator.remove();
                continue;
            }
            if (n <= interval3.high && interval3.low < n) {
                interval = interval3;
            }
            if (interval3.low > n2 || interval3.high <= n2) continue;
            interval2 = interval3;
        }
        if (interval == null && interval2 == null) {
            list.add((Object)new Interval(n, n2));
        } else if (interval != null && interval2 != null) {
            list.remove(interval2);
            list.remove(interval);
            list.add((Object)new Interval(interval.low, interval2.high));
        } else if (interval2 != null) {
            list.remove(interval2);
            list.add((Object)new Interval(n, interval2.high));
        } else if (interval != null) {
            list.remove(interval);
            list.add((Object)new Interval(interval.low, n2));
        }
    }

    public synchronized Iterator getFreeBlocks(File file, int n) {
        List list = (List)this.blocks.get((Object)file);
        if (list == null || list.size() == 0) {
            Interval interval = new Interval(0, n);
            LinkedList linkedList = new LinkedList();
            linkedList.add((Object)interval);
            return linkedList.iterator();
        }
        Collections.sort((List)list, (Comparator)new IntervalComparator());
        LinkedList linkedList = new LinkedList();
        int n2 = 0;
        Interval interval = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            interval = (Interval)iterator.next();
            if (n2 < interval.low) {
                linkedList.add((Object)new Interval(n2, interval.low));
            }
            n2 = interval.high;
        }
        Assert.that(interval != null, "Null interval in getFreeBlocks");
        if (interval.high < n) {
            linkedList.add((Object)new Interval(interval.high, n));
        }
        return linkedList.iterator();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        boolean bl = true;
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            File file = (File)iterator.next();
            List list = (List)this.blocks.get((Object)file);
            stringBuffer.append(file);
            stringBuffer.append(":");
            stringBuffer.append(list.toString());
            bl = false;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private class IntervalComparator
    implements Comparator {
        private IntervalComparator() {
        }

        public int compare(Object object, Object object2) {
            Interval interval = (Interval)object;
            Interval interval2 = (Interval)object2;
            return interval.low - interval2.low;
        }
    }
}

