/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.ProblemReadingHeaderException;
import com.limegroup.gnutella.downloader.ReaderIsNullException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import java.io.IOException;
import java.util.StringTokenizer;

public class HeaderReader {
    private ByteReader _byteReader;
    private int _fileSize;
    private int _initialReadingPoint;
    private int _contentLength;

    public HeaderReader(ByteReader byteReader) throws IOException {
        this._byteReader = byteReader;
        if (this._byteReader == null) {
            throw new ReaderIsNullException();
        }
        this.readHeader();
    }

    public int getContentLength() {
        return this._contentLength;
    }

    public int getFileSize() {
        return this._fileSize;
    }

    public int getStart() {
        return this._initialReadingPoint;
    }

    private void readHeader() throws IOException {
        String string = this._byteReader.readLine();
        if (string == null || string.equals("")) {
            return;
        }
        this.parseConnect(string);
        do {
            if ((string = string.toUpperCase()).indexOf("CONTENT-LENGTH:") != -1) {
                this.parseContentLength(string);
            }
            if (string.indexOf("CONTENT-RANGE:") == -1) continue;
            this.parseContentRange(string);
        } while ((string = this._byteReader.readLine()) != null && !string.equals(""));
    }

    private void parseConnect(String string) throws IOException {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
        if (n < 200 || n > 300) {
            if (n == 404) {
                throw new FileNotFoundException();
            }
            if (n == 410) {
                throw new NotSharingException();
            }
            if (n == 503) {
                throw new TryAgainLaterException();
            }
            throw new IOException();
        }
    }

    private void parseContentRange(String string) throws IOException {
        int n;
        int n2;
        int n3;
        String string2;
        String string3;
        String string4;
        try {
            int n4 = string.indexOf("BYTES") + 5;
            string = string.substring(n4);
            int n5 = string.indexOf(45);
            int n6 = string.indexOf(47);
            string4 = string.substring(n6 + 1);
            string4 = string4.trim();
            string3 = string.substring(0, n5);
            string3 = string3.replace('=', ' ');
            string3 = string3.trim();
            string2 = string.substring(n5 + 1, n6);
            string2 = string2.trim();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        try {
            n3 = Integer.parseInt(string4);
            n2 = Integer.parseInt(string3);
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
        if (n == n3) {
            --n2;
            --n;
        }
        this._initialReadingPoint = n2;
        this._fileSize = n3;
    }

    private void parseContentLength(String string) throws IOException {
        int n;
        int n2 = string.indexOf(":");
        String string2 = string.substring(n2 + 1);
        string2 = string2.trim();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
        this._contentLength = n;
    }
}

