/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.FileIncompleteException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.ProblemReadingHeaderException;
import com.limegroup.gnutella.downloader.ReaderIsNullException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.SocketOpener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;

public class HTTPDownloader {
    public static final int BUF_LENGTH = 1024;
    private RemoteFileDesc _rfd;
    private boolean _isPush = true;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private volatile int _amountRead;
    private volatile int _amountToRead;
    private int _initialReadingPoint;
    private ByteReader _byteReader;
    private RandomAccessFile _fos;
    private Socket _socket;
    private File _incompleteFile;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;

    public HTTPDownloader(RemoteFileDesc remoteFileDesc, File file, int n, int n2) {
        this(null, remoteFileDesc, file, n, n2);
        this._isPush = false;
    }

    public HTTPDownloader(Socket socket, RemoteFileDesc remoteFileDesc, File file, int n, int n2) {
        this._rfd = remoteFileDesc;
        this._socket = socket;
        this._incompleteFile = file;
        this._filename = remoteFileDesc.getFileName();
        this._index = remoteFileDesc.getIndex();
        this._guid = remoteFileDesc.getClientGUID();
        this._amountToRead = remoteFileDesc.getSize();
        this._port = remoteFileDesc.getPort();
        this._host = remoteFileDesc.getHost();
        this._chatEnabled = remoteFileDesc.chatEnabled();
        this._amountRead = 0;
        this._amountToRead = n2 - n;
        this._initialReadingPoint = n;
    }

    public void connect() throws IOException {
        this.connect(0);
    }

    public void connect(int n) throws IOException {
        InputStream inputStream = null;
        try {
            if (this._socket == null) {
                this._socket = n == 0 ? new Socket(this._host, this._port) : new SocketOpener(this._host, this._port).connect(n);
            }
            inputStream = this._socket.getInputStream();
        }
        catch (Exception exception) {
            throw new CantConnectException();
        }
        this._byteReader = new ByteReader(inputStream);
        OutputStream outputStream = this._socket.getOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        String string = String.valueOf(this._initialReadingPoint);
        bufferedWriter.write("GET /get/" + this._index + "/" + this._filename + " HTTP/1.0\r\n");
        bufferedWriter.write("User-Agent: " + CommonUtils.getVendor() + "\r\n");
        bufferedWriter.write("Range: bytes=" + string + "-\r\n");
        SettingsManager settingsManager = SettingsManager.instance();
        if (settingsManager.getChatEnabled()) {
            String string2;
            int n2;
            if (settingsManager.getForceIPAddress()) {
                n2 = settingsManager.getForcedPort();
                string2 = settingsManager.getForcedIPAddressString();
            } else {
                n2 = settingsManager.getPort();
                string2 = this._socket.getLocalAddress().getHostAddress();
            }
            bufferedWriter.write("Chat: " + string2 + ":" + n2 + "\r\n");
        }
        bufferedWriter.write("\r\n");
        bufferedWriter.flush();
        this.readHeaders();
    }

    private void readHeaders() throws IOException {
        if (this._byteReader == null) {
            throw new ReaderIsNullException();
        }
        String string = this._byteReader.readLine();
        if (string == null || string.equals("")) {
            return;
        }
        int n = HTTPDownloader.parseHTTPCode(string);
        if (n < 200 || n > 300) {
            if (n == 404) {
                throw new FileNotFoundException();
            }
            if (n == 410) {
                throw new NotSharingException();
            }
            if (n == 503) {
                throw new TryAgainLaterException();
            }
            throw new IOException();
        }
        while ((string = this._byteReader.readLine()) != null && !string.equals("")) {
            int n2;
            if (!string.toUpperCase().startsWith("CONTENT-RANGE:") || (n2 = HTTPDownloader.parseContentRangeStart(string)) == this._initialReadingPoint) continue;
            throw new IOException("Unexpected start offset; too dumb to recover");
        }
    }

    private static int parseHTTPCode(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
    }

    private static int parseContentRangeStart(String string) throws IOException {
        int n;
        int n2;
        int n3;
        try {
            int n4 = string.indexOf("bytes") + 6;
            int n5 = string.indexOf(47);
            if (string.substring(n4, n5).equals("*")) {
                return 0;
            }
            int n6 = string.lastIndexOf("-");
            n3 = Integer.parseInt(string.substring(n4, n6));
            n2 = Integer.parseInt(string.substring(n6 + 1, n5));
            if (string.substring(n5 + 1).equals("*")) {
                return n3;
            }
            n = Integer.parseInt(string.substring(n5 + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
        if (n2 == n) {
            --n3;
            --n2;
        }
        return n3;
    }

    public void doDownload() throws IOException {
        int n;
        this._fos = new RandomAccessFile(this._incompleteFile, "rw");
        this._fos.seek(this._initialReadingPoint);
        int n2 = -1;
        byte[] byArray = new byte[1024];
        while (this._amountRead < this._amountToRead && (n2 = this._byteReader.read(byArray, 0, Math.min(1024, n = this._amountToRead - this._amountRead))) != -1) {
            this._fos.write(byArray, 0, n2);
            this._amountRead += n2;
        }
        this._byteReader.close();
        this._fos.close();
        if (this._amountRead != this._amountToRead) {
            throw new FileIncompleteException();
        }
    }

    public void stop() {
        if (this._byteReader != null) {
            this._byteReader.close();
        }
        try {
            if (this._fos != null) {
                this._fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stopAt(int n) {
        this._amountToRead = n - this._initialReadingPoint;
    }

    public int getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public int getAmountRead() {
        return this._amountRead;
    }

    public int getAmountToRead() {
        return this._amountToRead;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isPush() {
        return this._isPush;
    }
}

