/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.chat;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.util.StringComparator;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.net.Socket;

public class ChatManager {
    private static ChatManager _chatManager = new ChatManager();
    private List _chatsInProgress = Collections.synchronizedList((List)new LinkedList());
    private List _blockedHosts = Collections.synchronizedList((List)new LinkedList());
    private ActivityCallback _activityCallback;

    public static ChatManager instance() {
        return _chatManager;
    }

    public void setActivityCallback(ActivityCallback activityCallback) {
        this._activityCallback = activityCallback;
    }

    public void accept(Socket socket) {
        boolean bl = SettingsManager.instance().getChatEnabled();
        if (!bl) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        String string = socket.getInetAddress().getHostAddress();
        SettingsManager settingsManager = SettingsManager.instance();
        Object[] objectArray = settingsManager.getBannedIps();
        List list = Arrays.asList((Object[])objectArray);
        if (list.contains((Object)string)) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            InstantMessenger instantMessenger = new InstantMessenger(socket, this, this._activityCallback);
            this._chatsInProgress.add((Object)instantMessenger);
            this._activityCallback.acceptChat(instantMessenger);
            instantMessenger.start();
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }

    public Chatter request(String string, int n) {
        InstantMessenger instantMessenger = null;
        try {
            instantMessenger = new InstantMessenger(string, n, this, this._activityCallback);
            this._chatsInProgress.add((Object)instantMessenger);
            instantMessenger.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return instantMessenger;
    }

    public void removeChat(InstantMessenger instantMessenger) {
        this._chatsInProgress.remove((Object)instantMessenger);
    }

    public void blockHost(String string) {
        SettingsManager settingsManager = SettingsManager.instance();
        Object[] objectArray = settingsManager.getBannedIps();
        Arrays.sort((Object[])objectArray);
        ChatManager chatManager = this;
        synchronized (chatManager) {
            if (Arrays.binarySearch((Object[])objectArray, (Object)string, (Comparator)new StringComparator()) < 0) {
                String[] stringArray = new String[objectArray.length + 1];
                System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
                stringArray[objectArray.length] = string;
                settingsManager.setBannedIps(stringArray);
            }
        }
    }

    public void unblockHost(String string) {
        SettingsManager settingsManager = SettingsManager.instance();
        Object[] objectArray = settingsManager.getBannedIps();
        List list = Arrays.asList((Object[])objectArray);
        ChatManager chatManager = this;
        synchronized (chatManager) {
            if (list.remove((Object)string)) {
                settingsManager.setBannedIps((String[])list.toArray());
            }
        }
    }

    private ChatManager() {
    }
}

