/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.Buffer;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Date;

public class UploadManager
implements BandwidthTracker {
    private ActivityCallback _callback;
    private MessageRouter _router;
    private Acceptor _acceptor;
    private static final int PUSH_INVALIDATE_TIME = 300;
    private List _failedPushes = new LinkedList();
    private List _attemptingPushes = new LinkedList();
    private List _activeUploadList = new LinkedList();
    private static Map _uploadsInProgress = new HashMap();
    private volatile int _activeUploads = 0;
    private volatile boolean _hadSuccesfulUpload = false;
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    private Buffer speeds = new Buffer(5);
    private volatile int highestSpeed = -1;
    private static final float MINIMUM_UPLOAD_SPEED = 3.0f;
    private FileManager _fileManager;

    public void initialize(ActivityCallback activityCallback, MessageRouter messageRouter, Acceptor acceptor, FileManager fileManager) {
        this._fileManager = fileManager;
        this._callback = activityCallback;
        this._router = messageRouter;
        this._acceptor = acceptor;
    }

    public synchronized void acceptUpload(Socket socket) {
        GETLine gETLine;
        try {
            gETLine = this.parseGET(socket);
        }
        catch (IOException iOException) {
            return;
        }
        HTTPUploader hTTPUploader = new HTTPUploader(gETLine._file, socket, gETLine._index, this, this._fileManager);
        String string = socket.getInetAddress().getHostAddress();
        this.insertAndTest(hTTPUploader, string);
        UploadRunner uploadRunner = new UploadRunner(hTTPUploader, string, gETLine._index);
        Thread thread = new Thread(uploadRunner);
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void acceptPushUpload(String string, String string2, int n, int n2, String string3) {
        this.clearFailedPushes();
        HTTPUploader hTTPUploader = new HTTPUploader(string, string2, n, n2, string3, this, this._fileManager);
        if (!this.testAttemptedPush(string2, n2) || !this.testFailedPush(string2, n2)) {
            return;
        }
        this.insertAndTest(hTTPUploader, string2);
        this.insertAttemptedPush(string2, n2);
        UploadRunner uploadRunner = new UploadRunner(hTTPUploader, string2, n2);
        Thread thread = new Thread(uploadRunner);
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized boolean isBusy() {
        return !this.testTotalUploadLimit();
    }

    public int uploadsInProgress() {
        return this._activeUploads;
    }

    public boolean hadSuccesfulUpload() {
        return this._hadSuccesfulUpload;
    }

    private void insertAndTest(Uploader uploader, String string) {
        this.insertIntoMapAndList(uploader, string);
        if (!this.testPerHostLimit(string) || !this.testTotalUploadLimit()) {
            uploader.setState(2);
        }
        this._callback.addUpload(uploader);
    }

    private void insertIntoMapAndList(Uploader uploader, String string) {
        int n = 1;
        if (_uploadsInProgress.containsKey((Object)string)) {
            Integer n2 = (Integer)_uploadsInProgress.get((Object)string);
            n += n2.intValue();
        }
        _uploadsInProgress.put((Object)string, (Object)new Integer(n));
        this._activeUploadList.add((Object)uploader);
    }

    private void removeFromMapAndList(Uploader uploader, String string) {
        if (_uploadsInProgress.containsKey((Object)string)) {
            Integer n = (Integer)_uploadsInProgress.get((Object)string);
            int n2 = n;
            if (n2 == 1) {
                _uploadsInProgress.remove((Object)string);
            } else {
                _uploadsInProgress.put((Object)string, (Object)new Integer(--n2));
            }
        }
        this._activeUploadList.remove((Object)uploader);
        if (this._activeUploads == 0) {
            this._callback.uploadsComplete();
        }
    }

    private boolean testPerHostLimit(String string) {
        int n;
        Integer n2;
        int n3;
        return !_uploadsInProgress.containsKey((Object)string) || (n3 = (n2 = (Integer)_uploadsInProgress.get((Object)string)).intValue()) <= (n = SettingsManager.instance().getUploadsPerPerson());
    }

    private boolean testTotalUploadLimit() {
        SettingsManager settingsManager;
        int n = this.uploadsInProgress();
        if (n >= (settingsManager = SettingsManager.instance()).getMaxUploads()) {
            return false;
        }
        if (n < settingsManager.getSoftMaxUploads()) {
            return true;
        }
        float f = 0.0f;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            f = Math.max(f, bandwidthTracker.getMeasuredBandwidth());
        }
        return f > 3.0f;
    }

    private void insertFailedPush(String string, int n) {
        this._failedPushes.add((Object)new PushedFile(string, n));
    }

    private boolean testFailedPush(String string, int n) {
        PushedFile pushedFile = new PushedFile(string, n);
        Iterator iterator = this._failedPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile2 = (PushedFile)iterator.next();
            if (!pushedFile.equals(pushedFile2)) continue;
            return false;
        }
        return true;
    }

    private void insertAttemptedPush(String string, int n) {
        this._attemptingPushes.add((Object)new PushedFile(string, n));
    }

    private boolean testAttemptedPush(String string, int n) {
        PushedFile pushedFile = new PushedFile(string, n);
        Iterator iterator = this._attemptingPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile2 = (PushedFile)iterator.next();
            if (!pushedFile.equals(pushedFile2)) continue;
            return false;
        }
        return true;
    }

    private void removeAttemptedPush(String string, int n) {
        PushedFile pushedFile = new PushedFile(string, n);
        Iterator iterator = this._attemptingPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile2 = (PushedFile)iterator.next();
            if (!pushedFile.equals(pushedFile2)) continue;
            iterator.remove();
        }
    }

    private void clearFailedPushes() {
        Date date = new Date();
        date.setTime(date.getTime() - 300000L);
        Iterator iterator = this._failedPushes.iterator();
        while (iterator.hasNext()) {
            PushedFile pushedFile = (PushedFile)iterator.next();
            if (!pushedFile.before(date)) continue;
            iterator.remove();
        }
    }

    public int calculateBandwidth() {
        float f = this.getTotalBandwith();
        float f2 = f / (float)this.uploadsInProgress();
        return (int)f2;
    }

    private float getTotalBandwith() {
        SettingsManager settingsManager = SettingsManager.instance();
        float f = (float)settingsManager.getConnectionSpeed() / 8.0f;
        float f2 = settingsManager.getUploadSpeed();
        float f3 = f * (f2 / 100.0f);
        return f3;
    }

    public String getThisHost() {
        byte[] byArray = this._acceptor.getAddress();
        String string = Message.ip2string(byArray);
        return string;
    }

    public int getThisPort() {
        return this._acceptor.getPort();
    }

    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    private void reportUploadSpeed(long l, long l2) {
        if (l2 < 200000L) {
            return;
        }
        int n = 8 * (int)((float)l2 / (float)l);
        this.speeds.add(new Integer(n));
        if (this.speeds.size() >= 5) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.speeds.size()) {
                n2 = Math.max(n2, (Integer)this.speeds.get(n3));
                ++n3;
            }
            this.highestSpeed = n2;
        }
    }

    private GETLine parseGET(Socket socket) throws IOException {
        try {
            socket.setSoTimeout(SettingsManager.instance().getTimeout());
            InputStream inputStream = socket.getInputStream();
            ByteReader byteReader = new ByteReader(inputStream);
            String string = byteReader.readLine();
            if (string == null) {
                throw new IOException();
            }
            int n = string.indexOf("/get/");
            int n2 = string.indexOf("/", n + 5);
            String string2 = string.substring(n + 5, n2);
            int n3 = Integer.parseInt(string2);
            int n4 = string.indexOf(" HTTP/", n2);
            String string3 = string.substring(n2 + 1, n4);
            return new GETLine(n3, string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
    }

    public synchronized void measureBandwidth() {
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            bandwidthTracker.measureBandwidth();
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float f = 0.0f;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            f += bandwidthTracker.getMeasuredBandwidth();
        }
        return f;
    }

    private class PushedFile {
        private String _host;
        private int _index;
        private Date _time;

        public PushedFile(String string, int n) {
            this._host = string;
            this._index = n;
            this._time = new Date();
        }

        public boolean equals(Object object) {
            if (!(object instanceof PushedFile)) {
                return false;
            }
            PushedFile pushedFile = (PushedFile)object;
            return this._index == pushedFile._index && this._host.equals(pushedFile._host);
        }

        public boolean before(Date date) {
            return this._time.before(date);
        }
    }

    private class UploadRunner
    implements Runnable {
        private Uploader _up;
        private String _host;
        private int _index;

        public UploadRunner(Uploader uploader, String string, int n) {
            this._up = uploader;
            this._host = string;
            this._index = n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long l = -1L;
            try {
                try {
                    UploadManager uploadManager;
                    this._up.connect();
                    try {
                        UploadManager uploadManager2 = UploadManager.this;
                        synchronized (uploadManager2) {
                            UploadManager.this._activeUploads++;
                        }
                        l = System.currentTimeMillis();
                        this._up.start();
                        if (this._up.getState() == 4) {
                            UploadManager.this._hadSuccesfulUpload = true;
                        }
                        Object var6_4 = null;
                        uploadManager = UploadManager.this;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        UploadManager uploadManager2 = UploadManager.this;
                        synchronized (uploadManager2) {
                            UploadManager.this._activeUploads--;
                            throw throwable;
                        }
                    }
                    synchronized (uploadManager) {
                        UploadManager.this._activeUploads--;
                    }
                    Object var11_9 = null;
                }
                catch (IOException iOException) {
                    UploadManager uploadManager = UploadManager.this;
                    synchronized (uploadManager) {
                        UploadManager.this.insertFailedPush(this._host, this._index);
                    }
                    Object var11_10 = null;
                    long l2 = System.currentTimeMillis();
                    UploadManager uploadManager3 = UploadManager.this;
                    synchronized (uploadManager3) {
                        if (l > 0L) {
                            UploadManager.this.reportUploadSpeed(l2 - l, this._up.amountUploaded());
                        }
                        UploadManager.this.removeFromMapAndList(this._up, this._host);
                        UploadManager.this.removeAttemptedPush(this._host, this._index);
                        UploadManager.this._callback.removeUpload(this._up);
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                long l3 = System.currentTimeMillis();
                UploadManager uploadManager = UploadManager.this;
                synchronized (uploadManager) {
                    if (l > 0L) {
                        UploadManager.this.reportUploadSpeed(l3 - l, this._up.amountUploaded());
                    }
                    UploadManager.this.removeFromMapAndList(this._up, this._host);
                    UploadManager.this.removeAttemptedPush(this._host, this._index);
                    UploadManager.this._callback.removeUpload(this._up);
                    throw throwable;
                }
            }
            long l4 = System.currentTimeMillis();
            UploadManager uploadManager = UploadManager.this;
            synchronized (uploadManager) {
                if (l > 0L) {
                    UploadManager.this.reportUploadSpeed(l4 - l, this._up.amountUploaded());
                }
                UploadManager.this.removeFromMapAndList(this._up, this._host);
                UploadManager.this.removeAttemptedPush(this._host, this._index);
                UploadManager.this._callback.removeUpload(this._up);
                return;
            }
        }
    }

    private class GETLine {
        public int _index;
        public String _file;

        public GETLine(int n, String string) {
            this._index = n;
            this._file = string;
        }
    }
}

