/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public final class SupernodeAssigner
implements Runnable {
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private final int MINIMUM_REQUIRED_UPSTREAM_KBYTES_PER_SECOND = 10;
    private final int MINIMUM_REQUIRED_DOWNSTREAM_KBYTES_PER_SECOND = 15;
    private final int MINIMUM_AVERAGE_UPTIME = 1800;
    private final int MINIMUM_CURRENT_UPTIME = 1800;
    private boolean SUPERNODE_OS = CommonUtils.isSupernodeOS();
    private final int TIMER_DELAY = 1000;
    private final int TIMER_DELAY_IN_SECONDS = 1;
    private Timer _bandwidthTimer;
    private BandwidthTracker _uploadTracker;
    private BandwidthTracker _downloadTracker;
    private ConnectionManager _manager;
    private long _currentUptime = 0L;
    private int _maxUpstreamBytesPerSec = this.SETTINGS.getMaxUpstreamBytesPerSec();
    private int _maxDownstreamBytesPerSec = this.SETTINGS.getMaxDownstreamBytesPerSec();
    private volatile boolean _wasSupernodeCapable;

    public SupernodeAssigner(BandwidthTracker bandwidthTracker, BandwidthTracker bandwidthTracker2, ConnectionManager connectionManager) {
        this._uploadTracker = bandwidthTracker;
        this._downloadTracker = bandwidthTracker2;
        this._manager = connectionManager;
        this._wasSupernodeCapable = this._manager.isSupernode();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SupernodeAssigner.this.collectBandwidthData();
            }
        };
        this._bandwidthTimer = new Timer(1000, actionListener);
    }

    public void run() {
        this._bandwidthTimer.start();
    }

    public void setSupernodeCapable() {
        boolean bl;
        if (this.SETTINGS.getDisableSupernodeMode()) {
            this.SETTINGS.setEverSupernodeCapable(false);
            return;
        }
        boolean bl2 = bl = !(this._maxUpstreamBytesPerSec < 10 && this._maxDownstreamBytesPerSec < 15 || this.SETTINGS.getConnectionSpeed() <= 56 || this.SETTINGS.getAverageUptime() < 1800L && this._currentUptime < 1800L || !this.SETTINGS.getEverAcceptedIncoming() || !this.SUPERNODE_OS);
        if (bl) {
            this.SETTINGS.setEverSupernodeCapable(true);
        }
    }

    private void collectBandwidthData() {
        ++this._currentUptime;
        this._uploadTracker.measureBandwidth();
        this._downloadTracker.measureBandwidth();
        this._manager.measureBandwidth();
        int n = (int)this._uploadTracker.getMeasuredBandwidth() + (int)this._manager.getMeasuredUpstreamBandwidth();
        int n2 = (int)this._downloadTracker.getMeasuredBandwidth() + (int)this._manager.getMeasuredDownstreamBandwidth();
        if (n > this._maxUpstreamBytesPerSec) {
            this._maxUpstreamBytesPerSec = n;
            this.SETTINGS.setMaxUpstreamBytesPerSec(this._maxUpstreamBytesPerSec);
        }
        if (n2 > this._maxDownstreamBytesPerSec) {
            this._maxDownstreamBytesPerSec = n2;
            this.SETTINGS.setMaxDownstreamBytesPerSec(this._maxDownstreamBytesPerSec);
        }
        this.setSupernodeCapable();
    }
}

