/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.sun.java.util.collections.Iterator;
import java.io.IOException;

public class StandardMessageRouter
extends MessageRouter {
    private ActivityCallback _callback;
    private FileManager _fileManager;

    public StandardMessageRouter(ActivityCallback activityCallback, FileManager fileManager) {
        this._callback = activityCallback;
        this._fileManager = fileManager;
    }

    protected void handleQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection) {
        if (!managedConnection.isPersonalSpam(queryRequest)) {
            this._callback.handleQueryString(queryRequest.getQuery());
        }
        super.handleQueryRequest(queryRequest, managedConnection);
    }

    protected void respondToPingRequest(PingRequest pingRequest, Acceptor acceptor) {
        byte by;
        byte by2 = pingRequest.getHops();
        if (!(by2 + (by = pingRequest.getTTL()) <= 2 || this._manager.hasAvailableIncoming(false) || this._manager.isSupernode() && this._manager.hasAvailableIncoming(true))) {
            return;
        }
        int n = by2 + 1;
        if (by2 + by <= 2) {
            n = 1;
        }
        int n2 = this._fileManager.getNumFiles();
        int n3 = this._fileManager.getSize() / 1024;
        boolean bl = this._manager.isSupernode();
        PingReply pingReply = new PingReply(pingRequest.getGUID(), (byte)n, acceptor.getPort(), acceptor.getAddress(), n2, n3, bl);
        try {
            this.sendPingReply(pingReply);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void handlePingReply(PingReply pingReply, ManagedConnection managedConnection) {
        managedConnection.updateHorizonStats(pingReply);
        super.handlePingReply(pingReply, managedConnection);
    }

    public GroupPingRequest createGroupPingRequest(String string) {
        int n = this._fileManager.getNumFiles();
        int n2 = this._fileManager.getSize() / 1024;
        GroupPingRequest groupPingRequest = new GroupPingRequest(SettingsManager.instance().getTTL(), this._acceptor.getPort(), this._acceptor.getAddress(), n, n2, string + ":" + SettingsManager.instance().getEverSupernodeCapable());
        return groupPingRequest;
    }

    protected void handlePingReplyForMe(PingReply pingReply, ManagedConnection managedConnection) {
        SettingsManager settingsManager = SettingsManager.instance();
        if (pingReply.getHops() <= 1 && managedConnection.getNumMessagesReceived() <= 2 && !managedConnection.isOutgoing() && managedConnection.isKillable() && pingReply.getFiles() < (long)settingsManager.getFreeloaderFiles() && (int)(Math.random() * 100.0) > settingsManager.getFreeloaderAllowed()) {
            this._manager.remove(managedConnection);
        }
    }

    protected void respondToQueryRequest(QueryRequest queryRequest, Acceptor acceptor, byte[] byArray) {
        Response[] responseArray = this._fileManager.query(queryRequest);
        this.sendResponses(responseArray, queryRequest, acceptor, byArray);
    }

    public void sendResponses(Response[] responseArray, QueryRequest queryRequest, Acceptor acceptor, byte[] byArray) {
        if (responseArray == null || responseArray.length < 1) {
            return;
        }
        byte[] byArray2 = queryRequest.getGUID();
        byte by = (byte)(queryRequest.getHops() + 1);
        int n = acceptor.getPort();
        byte[] byArray3 = acceptor.getAddress();
        long l = this._uploadManager.measuredUploadSpeed();
        boolean bl = true;
        if (l == -1L) {
            l = SettingsManager.instance().getConnectionSpeed();
            bl = false;
        }
        boolean bl2 = responseArray.length;
        int n2 = 0;
        byte by2 = queryRequest.getHops();
        while (bl2 > false) {
            boolean bl3;
            Response[] responseArray2;
            boolean bl4 = bl2 < 255 != 0 ? bl2 : 255 != 0;
            if (n2 == 0 && bl4 < 255 != 0) {
                responseArray2 = responseArray;
            } else {
                responseArray2 = new Response[bl4];
                bl3 = false;
                while (bl3 < bl4) {
                    responseArray2[bl3] = responseArray[n2];
                    ++n2;
                    bl3 += 1;
                }
            }
            bl2 -= bl4;
            bl3 = this._uploadManager.isBusy();
            boolean bl5 = this._uploadManager.hadSuccesfulUpload();
            boolean bl6 = this._acceptor.acceptedIncoming();
            boolean bl7 = SettingsManager.instance().getChatEnabled();
            QueryReply queryReply = new QueryReply(byArray2, by, n, byArray3, l, responseArray2, byArray, !bl6, bl3, bl5, bl, bl7);
            try {
                this.sendQueryReply(queryReply);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (by2 > 2) break;
        }
    }

    protected void addQueryRoutingEntries(QueryRouteTable queryRouteTable) {
        Iterator iterator = this._fileManager.getKeyWords().iterator();
        while (iterator.hasNext()) {
            queryRouteTable.add((String)iterator.next());
        }
        Iterator iterator2 = this._fileManager.getIndivisibleKeyWords().iterator();
        while (iterator2.hasNext()) {
            queryRouteTable.addIndivisible((String)iterator2.next());
        }
    }

    protected void handleQueryReplyForMe(QueryReply queryReply, ManagedConnection managedConnection) {
        if (!managedConnection.isPersonalSpam(queryReply)) {
            this._callback.handleQueryReply(queryReply);
        }
    }

    protected void handlePushRequestForMe(PushRequest pushRequest, ManagedConnection managedConnection) {
        FileDesc fileDesc;
        byte[] byArray = pushRequest.getIP();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ByteOrder.ubyte2int(byArray[0]) + ".");
        stringBuffer.append(ByteOrder.ubyte2int(byArray[1]) + ".");
        stringBuffer.append(ByteOrder.ubyte2int(byArray[2]) + ".");
        stringBuffer.append(ByteOrder.ubyte2int(byArray[3]) + "");
        String string = stringBuffer.toString();
        int n = pushRequest.getPort();
        int n2 = (int)pushRequest.getIndex();
        String string2 = new GUID(pushRequest.getClientGUID()).toString();
        try {
            fileDesc = this._fileManager.get(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
        String string3 = fileDesc._name;
        if (!this._acceptor.isBannedIP(string)) {
            this._uploadManager.acceptPushUpload(string3, string, n, n2, string2);
        }
    }
}

