/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.filters.AllowFilter;
import com.limegroup.gnutella.filters.BearShareFilter;
import com.limegroup.gnutella.filters.BlackListFilter;
import com.limegroup.gnutella.filters.CompositeFilter;
import com.limegroup.gnutella.filters.DuplicateFilter;
import com.limegroup.gnutella.filters.GreedyQueryFilter;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.sun.java.util.collections.Vector;

public abstract class SpamFilter {
    public static SpamFilter newPersonalFilter() {
        SettingsManager settingsManager = SettingsManager.instance();
        String[] stringArray = settingsManager.getBannedWords();
        boolean bl = settingsManager.getFilterAdult();
        boolean bl2 = settingsManager.getFilterVbs();
        boolean bl3 = settingsManager.getFilterHtml();
        if (stringArray.length != 0 || bl || bl2 || bl3) {
            KeywordFilter keywordFilter = new KeywordFilter();
            int n = 0;
            while (n < stringArray.length) {
                keywordFilter.disallow(stringArray[n]);
                ++n;
            }
            if (bl) {
                keywordFilter.disallowAdult();
            }
            if (bl2) {
                keywordFilter.disallowVbs();
            }
            if (bl3) {
                keywordFilter.disallowHtml();
            }
            return keywordFilter;
        }
        return new AllowFilter();
    }

    public static SpamFilter newRouteFilter() {
        Object[] objectArray;
        SettingsManager settingsManager = SettingsManager.instance();
        Vector vector = new Vector();
        String[] stringArray = settingsManager.getBannedIps();
        if (stringArray.length != 0) {
            Object[] objectArray2 = objectArray = BlackListFilter.instance();
            synchronized (objectArray2) {
                objectArray.clear();
                int n = 0;
                while (n < stringArray.length) {
                    objectArray.add(stringArray[n]);
                    ++n;
                }
            }
            vector.add((Object)objectArray);
        }
        if (settingsManager.getFilterDuplicates()) {
            vector.add((Object)new DuplicateFilter());
        }
        if (settingsManager.getFilterGreedyQueries()) {
            vector.add((Object)new GreedyQueryFilter());
        }
        if (settingsManager.getFilterBearShareQueries()) {
            vector.add((Object)new BearShareFilter());
        }
        if (vector.size() == 0) {
            return new AllowFilter();
        }
        if (vector.size() == 1) {
            return (SpamFilter)vector.get(0);
        }
        objectArray = new SpamFilter[vector.size()];
        vector.copyInto(objectArray);
        return new CompositeFilter((SpamFilter[])objectArray);
    }

    public abstract boolean allow(Message var1);
}

