/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadConnectionSettingException;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.SpamFilter;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.xml.RichConnectionThread;
import com.limegroup.gnutella.xml.XMLHostCache;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Iterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class RouterService {
    private ActivityCallback callback;
    private HostCatcher catcher;
    private MessageRouter router;
    private Acceptor acceptor;
    private ConnectionManager manager;
    private ResponseVerifier verifier = new ResponseVerifier();
    private DownloadManager downloader;
    private UploadManager uploadManager;
    private FileManager fileManager;
    private ChatManager chatManager;
    private static final byte[] LOCALHOST = new byte[]{127, 0, 0, 1};

    public RouterService(ActivityCallback activityCallback, MessageRouter messageRouter, FileManager fileManager) {
        this.callback = activityCallback;
        this.router = messageRouter;
        this.fileManager = fileManager;
        Assert.setCallback(this.callback);
    }

    public void initialize() {
        int n;
        SettingsManager settingsManager = SettingsManager.instance();
        int n2 = settingsManager.getPort();
        this.acceptor = new Acceptor(n2, this.callback);
        this.manager = new ConnectionManager(this.callback);
        this.catcher = new HostCatcher(this.callback);
        this.downloader = new DownloadManager();
        this.uploadManager = new UploadManager();
        this.chatManager = ChatManager.instance();
        this.catcher.initialize(this.acceptor, this.manager, SettingsManager.instance().getHostList());
        this.router.initialize(this.acceptor, this.manager, this.catcher, this.uploadManager);
        this.manager.initialize(this.router, this.catcher);
        this.uploadManager.initialize(this.callback, this.router, this.acceptor, this.fileManager);
        this.acceptor.initialize(this.manager, this.router, this.downloader, this.uploadManager);
        this.chatManager.setActivityCallback(this.callback);
        this.downloader.initialize(this.callback, this.router, this.acceptor, this.fileManager);
        Thread thread = new Thread(new SupernodeAssigner(this.uploadManager, this.downloader, this.manager));
        thread.setDaemon(true);
        thread.start();
        if (settingsManager.getConnectOnStartup() && (n = settingsManager.getKeepAlive()) > 0) {
            this.connect();
        }
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void postGuiInit() {
        this.fileManager.initialize(this.callback);
        this.downloader.readSnapshot();
    }

    public ManagedConnection connectToHostBlocking(String string, int n) throws IOException {
        return this.manager.createConnectionBlocking(string, n);
    }

    public void connectToHostAsynchronously(String string, int n) {
        byte[] byArray = null;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        if (Arrays.equals((byte[])byArray, (byte[])LOCALHOST) && n == this.acceptor.getPort()) {
            return;
        }
        byte[] byArray2 = this.acceptor.getAddress();
        if (Arrays.equals((byte[])byArray, (byte[])byArray2) && n == this.acceptor.getPort()) {
            return;
        }
        if (!this.acceptor.isBannedIP(string)) {
            this.manager.createConnectionAsynchronously(string, n);
        }
    }

    public void connect() {
        this.manager.connect();
    }

    public void disconnect() {
        this.manager.disconnect();
    }

    public void removeConnection(ManagedConnection managedConnection) {
        this.manager.remove(managedConnection);
    }

    public void clearHostCatcher() {
        this.catcher.silentClear();
    }

    public int getRealNumHosts() {
        return this.catcher.getNumHosts();
    }

    public int getNumDownloads() {
        return this.downloader.downloadsInProgress();
    }

    public int getNumUploads() {
        return this.uploadManager.uploadsInProgress();
    }

    public void shutdown() {
        try {
            Object var3_1;
            try {
                this.catcher.write(SettingsManager.instance().getHostList());
            }
            catch (IOException iOException) {
                var3_1 = null;
                SettingsManager.instance().writeProperties();
            }
            var3_1 = null;
            SettingsManager.instance().writeProperties();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            SettingsManager.instance().writeProperties();
            throw throwable;
        }
        File file = null;
        try {
            file = SettingsManager.instance().getIncompleteDirectory();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("Preview-")) {
                File file2 = new File(file, stringArray[n]);
                file2.delete();
            }
            ++n;
        }
    }

    public void forceKeepAlive(int n) {
        this.manager.setKeepAlive(n);
    }

    public void setKeepAlive(int n) throws BadConnectionSettingException {
        if (n < 0) {
            throw new BadConnectionSettingException(1, SettingsManager.instance().getKeepAlive());
        }
        int n2 = SettingsManager.instance().maxConnections();
        if (this.manager.hasSupernodeClientConnection()) {
            if (n < 6) {
                throw new BadConnectionSettingException(4, 6);
            }
            if (n > 6 && n > n2) {
                throw new BadConnectionSettingException(2, 6 > n2 ? 6 : n2);
            }
        } else if (n > n2) {
            throw new BadConnectionSettingException(2, n2);
        }
        this.forceKeepAlive(n);
    }

    public void adjustSpamFilters() {
        Iterator iterator = this.manager.getConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            managedConnection.setPersonalFilter(SpamFilter.newPersonalFilter());
            managedConnection.setRouteFilter(SpamFilter.newRouteFilter());
        }
    }

    public void setListeningPort(int n) throws IOException {
        this.acceptor.setListeningPort(n);
    }

    public void setAlwaysNotifyKnownHost(boolean bl) {
        this.catcher.setAlwaysNotifyKnownHost(bl);
    }

    public boolean acceptedIncomingConnection() {
        return this.acceptor.acceptedIncoming();
    }

    public int getTotalMessages() {
        return this.router.getNumMessages();
    }

    public int getTotalDroppedMessages() {
        return this.router.getNumDroppedMessages();
    }

    public int getTotalRouteErrors() {
        return this.router.getNumRouteErrors();
    }

    public long getNumHosts() {
        long l = 0L;
        Iterator iterator = this.manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            l += ((ManagedConnection)iterator.next()).getNumHosts();
        }
        return l;
    }

    public long getNumFiles() {
        long l = 0L;
        Iterator iterator = this.manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            l += ((ManagedConnection)iterator.next()).getNumFiles();
        }
        return l;
    }

    public long getTotalFileSize() {
        long l = 0L;
        Iterator iterator = this.manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            l += ((ManagedConnection)iterator.next()).getTotalFileSize();
        }
        return l;
    }

    public void updateHorizon() {
        Iterator iterator = this.manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            ((ManagedConnection)iterator.next()).refreshHorizonStats();
        }
    }

    public byte[] query(String string, int n, MediaType mediaType) {
        QueryRequest queryRequest = new QueryRequest(SettingsManager.instance().getTTL(), n, string);
        this.verifier.record(queryRequest, mediaType);
        this.router.broadcastQueryRequest(queryRequest);
        return queryRequest.getGUID();
    }

    public byte[] query(String string, String string2, int n, MediaType mediaType, String string3) {
        QueryRequest queryRequest = new QueryRequest(SettingsManager.instance().getTTL(), n, string, string2);
        this.verifier.record(queryRequest, mediaType);
        this.router.broadcastQueryRequest(queryRequest);
        if (string3 != null) {
            try {
                XMLHostCache xMLHostCache = new XMLHostCache();
                String[] stringArray = xMLHostCache.getCachedHostsForURI(string3);
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        RichConnectionThread richConnectionThread = new RichConnectionThread(stringArray[n2], queryRequest, this.callback);
                        richConnectionThread.start();
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return queryRequest.getGUID();
    }

    public byte[] query(String string, int n) {
        return this.query(string, n, null);
    }

    public int score(byte[] byArray, Response response) {
        return this.verifier.score(byArray, response);
    }

    public boolean matchesType(byte[] byArray, Response response) {
        return this.verifier.matchesType(byArray, response);
    }

    public boolean isMandragoreWorm(byte[] byArray, Response response) {
        return this.verifier.isMandragoreWorm(byArray, response);
    }

    public byte[] browse(String string, int n) {
        Object object;
        Object object2;
        Object object3 = null;
        Iterator iterator = this.manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            object2 = (ManagedConnection)iterator.next();
            object = ((Connection)object2).getInetAddress().getHostAddress();
            if (!((String)object).equals(string) || ((Connection)object2).getOrigPort() != n) continue;
            object3 = object2;
            break;
        }
        if (object3 == null) {
            try {
                object3 = this.connectToHostBlocking(string, n);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        object2 = new QueryRequest(1, 0, "*.*");
        this.router.sendQueryRequest((QueryRequest)object2, (ManagedConnection)object3);
        try {
            ((ManagedConnection)object3).flush();
        }
        catch (IOException iOException) {
            return null;
        }
        if (this.manager.getNumConnections() > this.manager.getKeepAlive()) {
            object = null;
            long l = Long.MAX_VALUE;
            Iterator iterator2 = this.manager.getConnections().iterator();
            while (iterator2.hasNext()) {
                long l2;
                ManagedConnection managedConnection = (ManagedConnection)iterator2.next();
                if (managedConnection == object3 || (l2 = managedConnection.getNumFiles()) >= l) continue;
                object = managedConnection;
                l = l2;
            }
            if (object != null) {
                this.manager.remove((ManagedConnection)object);
            }
        }
        return ((Message)object2).getGUID();
    }

    public Iterator getHosts() {
        return this.catcher.getHosts();
    }

    public int getNumConnections() {
        return this.manager.getNumConnections();
    }

    public boolean isConnected() {
        return this.manager.isConnected();
    }

    public int getNumLocalSearches() {
        return this.router.getNumQueryRequests();
    }

    public void removeHost(String string, int n) {
        this.catcher.removeHost(string, n);
    }

    public int getNumSharedFiles() {
        return this.fileManager.getNumFiles();
    }

    public File[] getSharedFiles(File file) {
        return this.fileManager.getSharedFiles(file);
    }

    public Downloader download(RemoteFileDesc[] remoteFileDescArray, boolean bl) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        return this.downloader.getFiles(remoteFileDescArray, bl);
    }

    public void refreshBannedIPs() {
        this.acceptor.refreshBannedIPs();
    }

    public Chatter createChat(String string, int n) {
        Chatter chatter = ChatManager.instance().request(string, n);
        return chatter;
    }

    public boolean isSupernode() {
        return this.manager.isSupernode();
    }

    public boolean hasClientSupernodeConnection() {
        return this.manager.hasClientSupernodeConnection();
    }

    public boolean hasSupernodeClientConnection() {
        return this.manager.hasSupernodeClientConnection();
    }
}

