/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import com.limegroup.gnutella.util.ForgetfulHashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;

class RouteTable {
    private Map _map;

    public RouteTable(int n) {
        this(n, false);
    }

    public RouteTable(int n, boolean bl) {
        this._map = bl ? new FixedsizeForgetfulHashMap(n) : new ForgetfulHashMap(n);
    }

    public synchronized void routeReply(byte[] byArray, ReplyHandler replyHandler) {
        Assert.that(replyHandler != null);
        if (!replyHandler.isOpen()) {
            return;
        }
        GUID gUID = new GUID(byArray);
        this._map.put((Object)gUID, (Object)replyHandler);
    }

    public synchronized boolean tryToRouteReply(byte[] byArray, ReplyHandler replyHandler) {
        Assert.that(replyHandler != null);
        Assert.that(byArray != null, "Null GUID in tryToRouteReply");
        if (!replyHandler.isOpen()) {
            return false;
        }
        GUID gUID = new GUID(byArray);
        if (!this._map.containsKey((Object)gUID)) {
            this._map.put((Object)gUID, (Object)replyHandler);
            return true;
        }
        return false;
    }

    public synchronized ReplyHandler getReplyHandler(byte[] byArray) {
        return (ReplyHandler)this._map.get((Object)new GUID(byArray));
    }

    public synchronized void removeReplyHandler(ReplyHandler replyHandler) {
        Assert.that(replyHandler != null, "Null replyHandler in removeReplyHandler");
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Assert.that(object != null, "Null key in removeReplyHandler");
            Object object2 = this._map.get(object);
            if (object2 == null || !object2.equals(replyHandler)) continue;
            iterator.remove();
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        Iterator iterator = this._map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            stringBuffer.append(object);
            stringBuffer.append(" -> ");
            stringBuffer.append(this._map.get(object));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

