/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.util.ForgetfulHashMap;
import com.limegroup.gnutella.util.StringUtils;

public class ResponseVerifier {
    private ForgetfulHashMap mapper = new ForgetfulHashMap(15);
    private static final String DELIMITERS = "+ ";
    private static final long Mandragore_SIZE = 8192L;

    public synchronized void record(QueryRequest queryRequest) {
        this.record(queryRequest, null);
    }

    public synchronized void record(QueryRequest queryRequest, MediaType mediaType) {
        byte[] byArray = queryRequest.getGUID();
        this.mapper.put(new GUID(byArray), new RequestData(queryRequest.getQuery(), mediaType));
    }

    public synchronized int score(byte[] byArray, Response response) {
        int n = 0;
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null) {
            return 100;
        }
        String[] stringArray = requestData.queryWords;
        int n2 = stringArray.length;
        if (n2 == 0) {
            return 100;
        }
        String string = response.getName().toLowerCase();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (StringUtils.contains(string, string2)) {
                ++n;
            }
            ++n3;
        }
        return (int)((float)n * 100.0f / (float)n2);
    }

    public boolean matchesType(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null || requestData.type == null) {
            return true;
        }
        String string = response.getName();
        return requestData.type.matches(string);
    }

    public boolean isMandragoreWorm(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null) {
            return false;
        }
        return response.getSize() == 8192L && response.getName().equals(requestData.query + ".exe");
    }

    public String toString() {
        return this.mapper.toString();
    }

    private static class RequestData {
        String query;
        String[] queryWords;
        MediaType type;

        RequestData(String string, MediaType mediaType) {
            this.query = string;
            this.queryWords = StringUtils.split(string.toLowerCase(), ResponseVerifier.DELIMITERS);
            this.type = mediaType;
        }
    }
}

