/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.StringTokenizer;

public class Response {
    private long index;
    private long size;
    private byte[] nameBytes;
    private String name;
    private String metadata;
    private byte[] metaBytes;

    public Response(long l, long l2, String string) {
        Assert.that((l & 0xFFFFFFFF00000000L) == 0L, "Response constructor: index " + l + " too big!");
        Assert.that((l2 & 0xFFFFFFFF00000000L) == 0L, "Response constructor: size " + l2 + " too big!");
        this.index = l;
        this.size = l2;
        this.name = string;
        this.nameBytes = string.getBytes();
        this.metadata = "";
        this.metaBytes = this.metadata.getBytes();
    }

    public Response(long l, long l2, String string, String string2) {
        Assert.that((l & 0xFFFFFFFF00000000L) == 0L, "Response constructor: index too big!");
        Assert.that((l2 & 0xFFFFFFFF00000000L) == 0L, "Response constructor: size too big!");
        string2 = string2.trim();
        this.index = l;
        this.size = l2;
        this.name = string;
        this.nameBytes = string.getBytes();
        this.metadata = string2;
        this.metaBytes = string2.getBytes();
    }

    public Response(String string, long l, long l2, String string2) {
        int n;
        Assert.that((l & 0xFFFFFFFF00000000L) == 0L, "Response constructor: index too big!");
        Assert.that((l2 & 0xFFFFFFFF00000000L) == 0L, "Response constructor: size too big!");
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            string5 = stringTokenizer.nextToken();
            string6 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            string5 = "";
            string6 = "";
            string = "";
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string6.startsWith("kbps")) {
            bl = true;
        } else if (string5.endsWith("kbps")) {
            bl2 = true;
        }
        if (bl) {
            string4 = string5;
        } else if (bl2) {
            n = string5.indexOf("kbps");
            string4 = string5.substring(0, n);
        }
        if (bl || bl2) {
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
        } else if (string.endsWith("kHz")) {
            bl3 = true;
            string3 = string5;
            n = string6.indexOf("kbps");
            if (n > -1) {
                string4 = string6.substring(0, n);
            } else {
                bl3 = false;
            }
        }
        if (bl || bl2 || bl3) {
            this.metadata = "<audios xsi:noNamespaceSchemaLocation=\"http://www.limewire.com/schemas/audio.xsd\"><audio title=\"" + string2 + "\" bitrate=\"" + string4 + "\" seconds=\"" + string3 + "\">" + "</audio></audios>";
            this.metaBytes = this.metadata.getBytes();
        } else {
            this.metadata = "";
            this.metaBytes = this.metadata.getBytes();
        }
        this.index = l;
        this.size = l2;
        this.name = string2;
        this.nameBytes = string2.getBytes();
    }

    public void setMetadata(String string) {
        this.metadata = string;
        this.metaBytes = string.getBytes();
    }

    public long getIndex() {
        return this.index;
    }

    public long getSize() {
        return this.size;
    }

    public int getNameBytesSize() {
        return this.nameBytes.length;
    }

    public int getMetaBytesSize() {
        return this.metaBytes.length;
    }

    public byte[] getNameBytes() {
        return this.nameBytes;
    }

    public byte[] getMetaBytes() {
        return this.metaBytes;
    }

    public String getName() {
        return this.name;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Response)) {
            return false;
        }
        Response response = (Response)object;
        return response.getIndex() == this.getIndex() && response.getSize() == this.getSize() && response.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.name.hashCode() + (int)this.size + (int)this.index;
    }

    public static void main(String[] stringArray) {
        Response response = new Response(3L, 4096L, "A.mp3");
        int n = response.getNameBytesSize();
        Assert.that(n == 5);
        byte[] byArray = response.getNameBytes();
        Assert.that(byArray[0] == 65);
        Assert.that(new String(response.getMetaBytes()).equals(""), "Spurios meta");
        Assert.that(response.getMetaBytesSize() == 0, "Meta size not right");
        Response response2 = new Response("", 999L, 4L, "blah.txt");
        Assert.that(new String(response2.getMetaBytes()).equals(""), "bad meta");
        Assert.that(response2.getMetaBytesSize() == 0, "Meta size not right");
        String string = "Hello";
        Response response3 = new Response(string, 999L, 4L, "king.txt");
        Assert.that(new String(response3.getMetaBytes()).equals(""), "bad meta");
        Assert.that(response3.getMetaBytesSize() == 0, "Meta size not right");
        String[] stringArray2 = new String[]{"a kbps 44.1 kHz b", "akbps 44.1 kHz b", "b akbps 44.1kHz"};
        int n2 = 0;
        while (n2 < stringArray2.length) {
            Response response4 = new Response(stringArray2[n2], (long)(999 + n2), 4L, "abc.txt");
            LimeXMLDocument limeXMLDocument = null;
            String string2 = response4.getMetadata();
            try {
                limeXMLDocument = new LimeXMLDocument(string2);
            }
            catch (Exception exception) {
                Assert.that(false, "XML not created well from between nulls");
            }
            String string3 = limeXMLDocument.getValue("audios__audio__bitrate__");
            Assert.that(string3.equals("a"));
            String string4 = limeXMLDocument.getValue("audios__audio__seconds__");
            Assert.that(string4.equals("b"));
            ++n2;
        }
    }
}

