/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class QueryRequest
extends Message
implements Serializable {
    private byte[] payload;
    private String query = null;
    private String richQuery = null;

    public QueryRequest(byte by, int n, String string, String string2) {
        super((byte)-128, by, 2 + string.length() + 1 + string2.length() + 1);
        this.payload = new byte[2 + string.length() + 1 + string2.length() + 1];
        int n2 = 0;
        ByteOrder.short2leb((short)n, this.payload, 0);
        byte[] byArray = string.getBytes();
        System.arraycopy(byArray, 0, this.payload, n2 += 2, byArray.length);
        this.payload[n2 += byArray.length] = 0;
        byte[] byArray2 = string2.getBytes();
        System.arraycopy(byArray2, 0, this.payload, ++n2, byArray2.length);
        this.payload[n2 += byArray2.length] = 0;
        ++n2;
    }

    public QueryRequest(byte by, int n, String string) {
        this(by, n, string, "");
    }

    public QueryRequest(byte[] byArray, byte by, byte by2, byte[] byArray2) {
        super(byArray, (byte)-128, by, by2, byArray2.length);
        this.payload = byArray2;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.payload);
    }

    public synchronized String getQuery() {
        if (this.query != null) {
            return this.query;
        }
        int n = 2;
        while (n < this.payload.length && this.payload[n] != 0) {
            ++n;
        }
        this.query = new String(this.payload, 2, n - 2);
        return this.query;
    }

    public synchronized String getRichQuery() {
        if (this.richQuery != null) {
            return this.richQuery;
        }
        int n = 2;
        while (n < this.payload.length && this.payload[n] != 0) {
            ++n;
        }
        int n2 = ++n;
        while (n2 < this.payload.length && this.payload[n2] != 0) {
            ++n2;
        }
        this.richQuery = n2 < this.payload.length ? new String(this.payload, n, n2 - n) : "";
        return this.richQuery;
    }

    public int getQueryLength() {
        if (super.getLength() > 3 && this.payload[this.payload.length - 2] == 0) {
            return this.payload.length - 4;
        }
        return this.payload.length - 3;
    }

    public byte getQueryByteAt(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.getQueryLength() - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.payload[n + 2];
    }

    public int getMinSpeed() {
        short s = ByteOrder.leb2short(this.payload, 0);
        int n = ByteOrder.ubytes2int(s);
        Assert.that(n >= 0, "getMinSpeed got negative value");
        return n;
    }

    public String toString() {
        return "QueryRequest(" + this.getQuery() + ", " + this.getMinSpeed() + ", " + super.toString() + ")";
    }
}

