/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.Response;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class QueryReply
extends Message
implements Serializable {
    public static final int XML_MAX_SIZE = 32768;
    static final int COMMON_PAYLOAD_LEN = 4;
    private byte[] payload;
    private volatile boolean parsed = false;
    private volatile Response[] responses = null;
    private volatile String vendor = null;
    private volatile int pushFlag = -1;
    private volatile int busyFlag = -1;
    private volatile int uploadedFlag = -1;
    private volatile int measuredSpeedFlag = -1;
    private volatile int supportsChat = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNDEFINED = -1;
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;
    private byte[] _xmlBytes = new byte[0];
    public static boolean debugOn = false;

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, new byte[0], false, false, false, false, false, false);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, new byte[0], true, bl, bl2, bl3, bl4, bl5);
    }

    public QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws Exception {
        this(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5);
        if (byArray4.length > 32768) {
            throw new Exception();
        }
        this._xmlBytes = byArray4;
    }

    private QueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super(byArray, (byte)-127, by, (byte)0, 11 + QueryReply.rLength(responseArray) + QueryReply.qhdLength(bl, byArray4) + 16);
        if (byArray4.length > 32768) {
            return;
        }
        Assert.that((n & 0xFFFF0000) == 0);
        Assert.that(byArray2.length == 4);
        Assert.that((l & 0xFFFFFFFF00000000L) == 0L);
        int n2 = responseArray.length;
        Assert.that(n2 < 256);
        this.payload = new byte[this.getLength()];
        this.payload[0] = (byte)n2;
        ByteOrder.short2leb((short)n, this.payload, 1);
        this.payload[3] = byArray2[0];
        this.payload[4] = byArray2[1];
        this.payload[5] = byArray2[2];
        this.payload[6] = byArray2[3];
        ByteOrder.int2leb((int)l, this.payload, 7);
        int n3 = 11;
        int n4 = n2;
        while (n4 > 0) {
            Response response = responseArray[n2 - n4];
            ByteOrder.int2leb((int)response.getIndex(), this.payload, n3);
            ByteOrder.int2leb((int)response.getSize(), this.payload, n3 + 4);
            byte[] byArray5 = response.getNameBytes();
            System.arraycopy(byArray5, 0, this.payload, n3 += 8, byArray5.length);
            n3 += byArray5.length;
            this.payload[n3++] = 0;
            this.payload[n3++] = 0;
            --n4;
        }
        if (bl) {
            this.payload[n3++] = 76;
            this.payload[n3++] = 73;
            this.payload[n3++] = 77;
            this.payload[n3++] = 69;
            this.payload[n3++] = 4;
            this.payload[n3++] = (byte)((bl2 ? 1 : 0) | 4 | 8 | 0x10);
            this.payload[n3++] = (byte)(1 | (bl3 ? 4 : 0) | (bl4 ? 8 : 0) | (bl5 ? 16 : 0));
            int n5 = byArray4.length + 1;
            if (n5 > 32768) {
                n5 = 32768;
            }
            ByteOrder.short2leb((short)n5, this.payload, n3);
            n3 += 2;
            this.payload[n3++] = bl6 ? (byte)1 : 0;
            System.arraycopy(byArray4, 0, this.payload, n3, n5 - 1);
            n3 += n5 - 1;
            this.payload[n3++] = 0;
        }
        int n6 = 0;
        while (n6 < 16) {
            this.payload[n3 + n6] = byArray3[n6];
            ++n6;
        }
    }

    public QueryReply(byte[] byArray, QueryReply queryReply) {
        super(byArray, (byte)-127, queryReply.getTTL(), queryReply.getHops(), queryReply.getLength());
        this.payload = queryReply.payload;
    }

    private static int rLength(Response[] responseArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < responseArray.length) {
            n += 8 + responseArray[n2].getNameBytesSize() + 1 + 1;
            ++n2;
        }
        return n;
    }

    private static int qhdLength(boolean bl, byte[] byArray) {
        int n = 0;
        if (bl) {
            n += 4;
            ++n;
            n += 4;
            ++n;
            int n2 = byArray.length;
            n = n2 + 1 > 32768 ? (n += 32768) : (n += n2 + 1);
        }
        return n;
    }

    public QueryReply(byte[] byArray, byte by, byte by2, byte[] byArray2) {
        super(byArray, (byte)-127, by, by2, byArray2.length);
        this.payload = byArray2;
    }

    public void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.payload);
    }

    public byte[] getXMLBytes() {
        return this._xmlBytes;
    }

    public short getResultCount() {
        return (short)ByteOrder.ubyte2int(this.payload[0]);
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 1));
    }

    public String getIP() {
        byte[] byArray = new byte[]{this.payload[3], this.payload[4], this.payload[5], this.payload[6]};
        return Message.ip2string(byArray);
    }

    public long getSpeed() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 7));
    }

    public Iterator getResults() throws BadPacketException {
        this.parseResults();
        if (this.responses == null) {
            throw new BadPacketException();
        }
        List list = Arrays.asList((Object[])this.responses);
        return list.iterator();
    }

    public List getResultsAsList() throws BadPacketException {
        this.parseResults();
        if (this.responses == null) {
            throw new BadPacketException();
        }
        List list = Arrays.asList((Object[])this.responses);
        return list;
    }

    public String getVendor() throws BadPacketException {
        this.parseResults();
        if (this.vendor == null) {
            throw new BadPacketException();
        }
        return this.vendor;
    }

    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this.pushFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for push flag: " + this.pushFlag);
        return false;
    }

    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this.busyFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for busy flag: " + this.pushFlag);
        return false;
    }

    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this.uploadedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for uploaded flag: " + this.pushFlag);
        return false;
    }

    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this.measuredSpeedFlag) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for measured speed flag: " + this.pushFlag);
        return false;
    }

    public boolean getSupportsChat() throws BadPacketException {
        this.parseResults();
        switch (this.supportsChat) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        Assert.that(false, "Bad value for supportsChat: " + this.supportsChat);
        return false;
    }

    private void parseResults() {
        if (this.parsed) {
            return;
        }
        this.parseResults2();
        this.parsed = true;
    }

    private void parseResults2() {
        int n;
        int n2;
        int n3 = 11;
        int n4 = this.getResultCount();
        Response[] responseArray = new Response[n4];
        try {
            while (n4 > 0) {
                int n5;
                long l = ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, n3));
                long l2 = ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, n3 + 4));
                n2 = n3 += 8;
                while (this.payload[n2] != 0) {
                    ++n2;
                }
                String string = new String(this.payload, n3, n2 - n3);
                n = n5 = n2 + 1;
                while (true) {
                    if (n >= this.payload.length - 16) {
                        throw new BadPacketException("Missing null terminator filename");
                    }
                    if (this.payload[n] == 0) break;
                    ++n;
                }
                String string2 = new String(this.payload, n5, n - n5);
                responseArray[responseArray.length - n4] = string2 == null || string2.equals("") ? new Response(l, l2, string) : new Response(string2.toLowerCase(), l, l2, string);
                n3 = n + 1;
                --n4;
            }
            this.responses = responseArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (BadPacketException badPacketException) {
            return;
        }
        try {
            if (n3 >= this.payload.length - 16) {
                throw new BadPacketException("No QHD");
            }
            String string = null;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            n2 = -1;
            int n9 = -1;
            try {
                string = new String(this.payload, n3, 4, "ISO-8859-1");
                Assert.that(string.length() == 4, "Vendor length wrong.  Wrong character encoding?");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.that(false, "No support for ISO-8859-1 encoding");
            }
            int n10 = ByteOrder.ubyte2int(this.payload[n3 += 4]);
            if (n10 <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            if (++n3 + n10 > this.payload.length - 16) {
                throw new BadPacketException("Common payload length imprecise!");
            }
            int n11 = n6 = (this.payload[n3] & 1) == 1 ? 1 : 0;
            if (n10 > 1) {
                n = this.payload[n3];
                byte by = this.payload[n3 + 1];
                if ((n & 4) != 0) {
                    int n12 = n7 = (by & 4) != 0 ? 1 : 0;
                }
                if ((n & 8) != 0) {
                    int n13 = n8 = (by & 8) != 0 ? 1 : 0;
                }
                if ((n & 0x10) != 0) {
                    n2 = (by & 0x10) != 0 ? 1 : 0;
                }
                n3 += 2;
            }
            if (n10 > 2) {
                int n14;
                int n15;
                int n16;
                if ((n16 = (n = (n15 = ByteOrder.ubyte2int(this.payload[n3++]))) | (n14 = (n15 = ByteOrder.ubyte2int(this.payload[n3++])) << 8)) > 1) {
                    int n17 = this.payload.length - 16 - n16;
                    this._xmlBytes = new byte[n16 - 1];
                    System.arraycopy(this.payload, n17, this._xmlBytes, 0, n16 - 1);
                } else {
                    this._xmlBytes = new byte[0];
                }
            }
            if ((n = this.payload.length - n3) > 0 && string.equals("LIME")) {
                if (this.payload[n3] == 1) {
                    n9 = 1;
                } else if (this.payload[n3] == 0) {
                    n9 = 0;
                }
            }
            if (n3 > this.payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            Assert.that(string != null);
            this.vendor = string.toUpperCase();
            this.pushFlag = n6;
            this.busyFlag = n7;
            this.uploadedFlag = n8;
            this.measuredSpeedFlag = n2;
            this.supportsChat = n9;
            QueryReply.debug("QR.parseResults2(): returning w/o exception.");
        }
        catch (BadPacketException badPacketException) {
            QueryReply.debug("QR.parseResults2(): bpe = " + badPacketException);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            QueryReply.debug("QR.parseResults2(): index exception = " + indexOutOfBoundsException);
            return;
        }
    }

    public byte[] getClientGUID() {
        byte[] byArray = new byte[16];
        int n = super.getLength();
        System.arraycopy(this.payload, n - 16, byArray, 0, 16);
        return byArray;
    }

    public String toString() {
        return "QueryReply(" + this.getResultCount() + " hits, " + super.toString() + ")";
    }

    public static void debug(String string) {
        if (debugOn) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        byte[] byArray = new byte[]{-1, 0, 0, 1};
        long l = 0xFFFFFFFFL;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 1;
        byArray2[15] = -1;
        Response[] responseArray = new Response[0];
        QueryReply queryReply = new QueryReply(byArray2, 5, 62449, byArray, 1L, responseArray, byArray2);
        Assert.that(queryReply.getSpeed() == 1L);
        Assert.that(queryReply.getPort() == 62449, Integer.toHexString(queryReply.getPort()));
        try {
            Assert.that(!queryReply.getResults().hasNext());
        }
        catch (BadPacketException badPacketException) {
            Assert.that(false);
        }
        responseArray = new Response[]{new Response(11L, 22L, "Sample.txt"), new Response(12274L, 61727L, "Another file  ")};
        queryReply = new QueryReply(byArray2, 5, 65535, byArray, l, responseArray, byArray2);
        Assert.that(queryReply.getIP().equals("255.0.0.1"));
        Assert.that(queryReply.getPort() == 65535);
        Assert.that(queryReply.getSpeed() == l);
        Assert.that(Arrays.equals((byte[])queryReply.getClientGUID(), (byte[])byArray2));
        try {
            object4 = queryReply.getResults();
            object3 = (Response)object4.next();
            Assert.that(((Response)object3).equals(responseArray[0]));
            object2 = (Response)object4.next();
            Assert.that(((Response)object2).equals(responseArray[1]));
            Assert.that(!object4.hasNext());
        }
        catch (BadPacketException badPacketException) {
            Assert.that(false);
        }
        catch (NoSuchElementException noSuchElementException) {
            Assert.that(false);
        }
        object4 = new byte[38];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        try {
            object3 = queryReply.getResults();
            object2 = (Response)object3.next();
            Assert.that(((Response)object2).getName().equals("A"), "'" + ((Response)object2).getName() + "'");
            Assert.that(!object3.hasNext());
        }
        catch (BadPacketException badPacketException) {
            Assert.that(false);
        }
        try {
            queryReply.getVendor();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getNeedsPush();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        object4 = new byte[37];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        try {
            object3 = queryReply.getResults();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            object3 = queryReply.getResults();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getVendor();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        object4 = new byte[52];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        object4[22] = (Iterator)76;
        object4[23] = (Iterator)76;
        object4[24] = (Iterator)77;
        object4[25] = (Iterator)69;
        object4[26] = (Iterator)4;
        object4[29] = (Iterator)5;
        object4[30] = (Iterator)false;
        object4[31] = (Iterator)83;
        object4[32] = (Iterator)85;
        object4[33] = (Iterator)83;
        object4[34] = (Iterator)72;
        object4[35] = (Iterator)false;
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        try {
            object3 = queryReply.getResults();
            object2 = (Response)object3.next();
            Assert.that(((Response)object2).getNameBytesSize() == 1, "Sumeet test a");
            Assert.that(((Response)object2).getMetaBytesSize() == 0, "Sumeet test b");
            object = ((Response)object2).getNameBytes();
            Assert.that(object[0] == 65, "sumeet test c");
            Assert.that(((Response)object2).getName().equals("A"), "Sumeet test1");
            Assert.that(new String(queryReply.getXMLBytes()).equals("SUSH"), "SUSH is not " + new String(queryReply.getXMLBytes()));
        }
        catch (BadPacketException badPacketException) {
            System.out.println("MetaResponse not created well!");
        }
        object4 = new byte[51];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        object4[22] = (Iterator)76;
        object4[23] = (Iterator)105;
        object4[24] = (Iterator)77;
        object4[25] = (Iterator)69;
        object4[26] = (Iterator)4;
        object4[27] = (Iterator)-79;
        object4[29] = (Iterator)4;
        object4[30] = (Iterator)false;
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        try {
            object3 = queryReply.getVendor();
            Assert.that(((String)object3).equals("LIME"), (String)object3);
            object3 = queryReply.getVendor();
            Assert.that(((String)object3).equals("LIME"), (String)object3);
            Assert.that(queryReply.getNeedsPush());
        }
        catch (BadPacketException badPacketException) {
            System.out.println(badPacketException.toString());
            Assert.that(false);
        }
        object4 = new byte[20047];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        object4[22] = (Iterator)76;
        object4[23] = (Iterator)76;
        object4[24] = (Iterator)77;
        object4[25] = (Iterator)69;
        object4[26] = (Iterator)4;
        object4[27] = (Iterator)-16;
        object4[29] = (Iterator)32;
        object4[30] = (Iterator)78;
        int n = 0;
        while (n < 20000) {
            object4[31 + n] = (Iterator)97;
            ++n;
        }
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        try {
            object2 = queryReply.getVendor();
            Assert.that(((String)object2).equals("LLME"), (String)object2);
            object2 = queryReply.getVendor();
            Assert.that(((String)object2).equals("LLME"), (String)object2);
            Assert.that(!queryReply.getNeedsPush());
        }
        catch (BadPacketException badPacketException) {
            Assert.that(false);
            badPacketException.printStackTrace();
        }
        try {
            queryReply.getSupportsChat();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        object4 = new byte[45];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        object4[27] = (Iterator)true;
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        try {
            queryReply.getNeedsPush();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getVendor();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        object4 = new byte[44];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        object4[22] = (Iterator)76;
        object4[23] = (Iterator)105;
        object4[24] = (Iterator)77;
        object4[25] = (Iterator)69;
        object4[26] = (Iterator)2;
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        QueryReply.debug("QR.parseResults2(): returning w/o exception.");
        try {
            queryReply.getResults();
        }
        catch (BadPacketException badPacketException) {
            Assert.that(false);
        }
        try {
            queryReply.getVendor();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        object4 = new byte[48];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        object4[22] = (Iterator)76;
        object4[23] = (Iterator)105;
        object4[24] = (Iterator)77;
        object4[25] = (Iterator)69;
        object4[26] = (Iterator)4;
        object4[27] = (Iterator)false;
        object4[28] = (Iterator)false;
        object4[29] = (Iterator)true;
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        try {
            object2 = queryReply.getVendor();
            Assert.that(((String)object2).equals("LIME"), (String)object2);
            object2 = queryReply.getVendor();
            Assert.that(((String)object2).equals("LIME"), (String)object2);
        }
        catch (BadPacketException badPacketException) {
            System.out.println(badPacketException.toString());
            Assert.that(false);
        }
        try {
            Assert.that(!queryReply.getNeedsPush());
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getIsBusy();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getHadSuccessfulUpload();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getIsMeasuredSpeed();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        object4 = new byte[49];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        object4[22] = (Iterator)76;
        object4[23] = (Iterator)73;
        object4[24] = (Iterator)77;
        object4[25] = (Iterator)69;
        object4[26] = (Iterator)4;
        object4[27] = (Iterator)29;
        object4[28] = (Iterator)28;
        object4[29] = (Iterator)true;
        object4[31] = (Iterator)true;
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        try {
            object2 = queryReply.getVendor();
            Assert.that(((String)object2).equals("LIME"), (String)object2);
            Assert.that(queryReply.getNeedsPush());
            Assert.that(queryReply.getNeedsPush());
            Assert.that(queryReply.getIsBusy());
            Assert.that(queryReply.getIsBusy());
            Assert.that(queryReply.getIsMeasuredSpeed());
            Assert.that(queryReply.getIsMeasuredSpeed());
            Assert.that(queryReply.getHadSuccessfulUpload());
            Assert.that(queryReply.getHadSuccessfulUpload());
            Assert.that(queryReply.getSupportsChat());
        }
        catch (BadPacketException badPacketException) {
            System.out.println(badPacketException.toString());
            Assert.that(false);
        }
        object4 = new byte[48];
        object4[0] = (Iterator)true;
        object4[19] = (Iterator)65;
        object4[22] = (Iterator)76;
        object4[23] = (Iterator)105;
        object4[24] = (Iterator)77;
        object4[25] = (Iterator)69;
        object4[26] = (Iterator)4;
        object4[27] = (Iterator)28;
        object4[28] = (Iterator)false;
        object4[29] = (Iterator)true;
        queryReply = new QueryReply(new byte[16], 5, 0, (byte[])object4);
        try {
            object2 = queryReply.getVendor();
            Assert.that(((String)object2).equals("LIME"), (String)object2);
            Assert.that(!queryReply.getNeedsPush());
            Assert.that(!queryReply.getIsBusy());
            Assert.that(!queryReply.getIsMeasuredSpeed());
            Assert.that(!queryReply.getHadSuccessfulUpload());
        }
        catch (BadPacketException badPacketException) {
            System.out.println(badPacketException.toString());
            Assert.that(false);
        }
        try {
            queryReply.getSupportsChat();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        responseArray = new Response[]{new Response(11L, 22L, "Sample.txt"), new Response(12274L, 61727L, "Another file  ")};
        queryReply = new QueryReply(byArray2, 5, 65535, byArray, l, responseArray, byArray2, false, true, true, false, true);
        Assert.that(queryReply.getIP().equals("255.0.0.1"));
        Assert.that(queryReply.getPort() == 65535);
        Assert.that(queryReply.getSpeed() == l);
        Assert.that(Arrays.equals((byte[])queryReply.getClientGUID(), (byte[])byArray2));
        try {
            object2 = queryReply.getResults();
            object = (Response)object2.next();
            Assert.that(object.equals(responseArray[0]));
            Response response = (Response)object2.next();
            Assert.that(response.equals(responseArray[1]));
            Assert.that(!object2.hasNext());
            Assert.that(queryReply.getVendor().equals("LIME"));
            Assert.that(!queryReply.getNeedsPush());
            Assert.that(queryReply.getIsBusy());
            Assert.that(queryReply.getHadSuccessfulUpload());
            Assert.that(!queryReply.getIsMeasuredSpeed());
            Assert.that(queryReply.getSupportsChat());
        }
        catch (BadPacketException badPacketException) {
            Assert.that(false);
        }
        catch (NoSuchElementException noSuchElementException) {
            Assert.that(false);
        }
        responseArray = new Response[]{new Response(11L, 22L, "Sample.txt"), new Response(12274L, 61727L, "Another file  ")};
        queryReply = new QueryReply(byArray2, 5, 65535, byArray, l, responseArray, byArray2, true, false, false, true, false);
        try {
            Assert.that(queryReply.getVendor().equals("LIME"));
            Assert.that(queryReply.getNeedsPush());
            Assert.that(!queryReply.getIsBusy());
            Assert.that(!queryReply.getHadSuccessfulUpload());
            Assert.that(queryReply.getIsMeasuredSpeed());
            Assert.that(!queryReply.getSupportsChat());
        }
        catch (BadPacketException badPacketException) {
            Assert.that(false);
        }
        catch (NoSuchElementException noSuchElementException) {
            Assert.that(false);
        }
        object2 = new ByteArrayOutputStream();
        try {
            queryReply.write((OutputStream)object2);
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        object = ((ByteArrayOutputStream)object2).toByteArray();
        Assert.that(((byte[])object).length == 105);
        Assert.that(object[((byte[])object).length - 16 - 6] == 29);
        Assert.that(object[((byte[])object).length - 16 - 5] == 17);
        responseArray = new Response[]{new Response(11L, 22L, "Sample.txt"), new Response(12274L, 61727L, "Another file  ")};
        queryReply = new QueryReply(byArray2, 5, 65535, byArray, l, responseArray, byArray2);
        try {
            queryReply.getVendor();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getNeedsPush();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getIsBusy();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getHadSuccessfulUpload();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        try {
            queryReply.getIsMeasuredSpeed();
            Assert.that(false);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
    }
}

