/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PushRequest
extends Message
implements Serializable {
    private byte[] payload;

    public PushRequest(byte[] byArray, byte by, byte by2, byte[] byArray2) {
        super(byArray, (byte)64, by, by2, 26);
        Assert.that(byArray2.length == 26);
        this.payload = byArray2;
    }

    public PushRequest(byte[] byArray, byte by, byte[] byArray2, long l, byte[] byArray3, int n) {
        super(byArray, (byte)64, by, (byte)0, 26);
        Assert.that(byArray2.length == 16);
        Assert.that((l & 0xFFFFFFFF00000000L) == 0L);
        Assert.that(byArray3.length == 4);
        Assert.that((n & 0xFFFF0000) == 0);
        this.payload = new byte[26];
        System.arraycopy(byArray2, 0, this.payload, 0, 16);
        ByteOrder.int2leb((int)l, this.payload, 16);
        this.payload[20] = byArray3[0];
        this.payload[21] = byArray3[1];
        this.payload[22] = byArray3[2];
        this.payload[23] = byArray3[3];
        ByteOrder.short2leb((short)n, this.payload, 24);
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        int n = 0;
        while (n < this.payload.length) {
            outputStream.write(this.payload[n]);
            ++n;
        }
    }

    public byte[] getClientGUID() {
        byte[] byArray = new byte[16];
        System.arraycopy(this.payload, 0, byArray, 0, 16);
        return byArray;
    }

    public long getIndex() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 16));
    }

    public byte[] getIP() {
        byte[] byArray = new byte[]{this.payload[20], this.payload[21], this.payload[22], this.payload[23]};
        return byArray;
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 24));
    }

    public String toString() {
        return "PushRequest(" + super.toString() + ")";
    }
}

