/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PingReply
extends Message
implements Serializable {
    private byte[] payload;
    private String ip;

    public PingReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2) {
        super(byArray, (byte)1, by, (byte)0, 14);
        this.payload = new byte[14];
        ByteOrder.short2leb((short)n, this.payload, 0);
        this.payload[2] = byArray2[0];
        this.payload[3] = byArray2[1];
        this.payload[4] = byArray2[2];
        this.payload[5] = byArray2[3];
        ByteOrder.int2leb((int)l, this.payload, 6);
        ByteOrder.int2leb((int)l2, this.payload, 10);
    }

    public PingReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl) {
        this(byArray, by, n, byArray2, l, bl ? PingReply.mark(l2) : l2);
    }

    public PingReply(byte[] byArray, byte by, byte by2, byte[] byArray2) {
        super(byArray, (byte)1, by, by2, 14);
        this.payload = byArray2;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.payload);
    }

    public String toString() {
        return "PingReply(" + this.getIP() + ":" + this.getPort() + ", " + super.toString() + ")";
    }

    public int getPort() {
        return ByteOrder.ubytes2int(ByteOrder.leb2short(this.payload, 0));
    }

    public synchronized String getIP() {
        if (this.ip == null) {
            this.ip = Message.ip2string(this.payload, 2);
        }
        return this.ip;
    }

    public byte[] getIPBytes() {
        byte[] byArray = new byte[]{this.payload[2], this.payload[3], this.payload[4], this.payload[5]};
        return byArray;
    }

    public long getFiles() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 6));
    }

    public long getKbytes() {
        return ByteOrder.ubytes2long(ByteOrder.leb2int(this.payload, 10));
    }

    public boolean isMarked() {
        long l = this.getKbytes();
        if (l < 8L) {
            return false;
        }
        return PingReply.isPowerOf2(ByteOrder.long2int(l));
    }

    private static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        switch (n) {
            case -2147483648: 
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: 
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 524288: 
            case 0x100000: 
            case 0x200000: 
            case 0x400000: 
            case 0x800000: 
            case 0x1000000: 
            case 0x2000000: 
            case 0x4000000: 
            case 0x8000000: 
            case 0x10000000: 
            case 0x20000000: 
            case 0x40000000: {
                return true;
            }
        }
        return false;
    }

    private static long mark(long l) {
        int n = ByteOrder.long2int(l);
        if (n < 12) {
            return 8L;
        }
        if (n < 24) {
            return 16L;
        }
        if (n < 48) {
            return 32L;
        }
        if (n < 96) {
            return 64L;
        }
        if (n < 192) {
            return 128L;
        }
        if (n < 384) {
            return 256L;
        }
        if (n < 768) {
            return 512L;
        }
        if (n < 1536) {
            return 1024L;
        }
        if (n < 3072) {
            return 2048L;
        }
        if (n < 6144) {
            return 4096L;
        }
        if (n < 12288) {
            return 8192L;
        }
        if (n < 24576) {
            return 16384L;
        }
        if (n < 49152) {
            return 32768L;
        }
        if (n < 98304) {
            return 65536L;
        }
        if (n < 196608) {
            return 131072L;
        }
        if (n < 393216) {
            return 262144L;
        }
        if (n < 786432) {
            return 524288L;
        }
        if (n < 0x180000) {
            return 0x100000L;
        }
        if (n < 0x300000) {
            return 0x200000L;
        }
        if (n < 0x600000) {
            return 0x400000L;
        }
        if (n < 0xC00000) {
            return 0x800000L;
        }
        if (n < 0x1800000) {
            return 0x1000000L;
        }
        if (n < 0x3000000) {
            return 0x2000000L;
        }
        if (n < 0x6000000) {
            return 0x4000000L;
        }
        if (n < 0xC000000) {
            return 0x8000000L;
        }
        if (n < 0x18000000) {
            return 0x10000000L;
        }
        if (n < 0x30000000) {
            return 0x20000000L;
        }
        return 0x40000000L;
    }
}

