/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.routing.ManagedConnectionQueryInfo;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;

public abstract class MessageRouter {
    protected HostCatcher _catcher;
    protected ConnectionManager _manager;
    protected Acceptor _acceptor;
    private byte[] _clientGUID;
    private ForMeReplyHandler _forMeReplyHandler = new ForMeReplyHandler();
    private Object queryUpdateLock = new Object();
    private long nextQueryUpdateTime = 0L;
    private long QUERY_ROUTE_UPDATE_TIME = 300000L;
    private RouteTable _pingRouteTable = new RouteTable(2048);
    private RouteTable _queryRouteTable = new RouteTable(2048);
    private RouteTable _pushRouteTable = new RouteTable(2048, true);
    private volatile int _numMessages;
    private volatile int _numPingRequests;
    private volatile int _numPingReplies;
    private volatile int _numQueryRequests;
    private volatile int _numQueryReplies;
    private volatile int _numPushRequests;
    private volatile int _numFilteredMessages;
    private volatile int _numRouteErrors;
    protected UploadManager _uploadManager;

    protected MessageRouter() {
        try {
            this._clientGUID = new GUID(GUID.fromHexString(SettingsManager.instance().getClientID())).bytes();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._clientGUID = Message.makeGuid();
        }
    }

    public void initialize(Acceptor acceptor, ConnectionManager connectionManager, HostCatcher hostCatcher, UploadManager uploadManager) {
        this._acceptor = acceptor;
        this._manager = connectionManager;
        this._catcher = hostCatcher;
        this._uploadManager = uploadManager;
    }

    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    public void removeConnection(ManagedConnection managedConnection) {
        this._pingRouteTable.removeReplyHandler(managedConnection);
        this._queryRouteTable.removeReplyHandler(managedConnection);
        this._pushRouteTable.removeReplyHandler(managedConnection);
    }

    public void handleMessage(Message message, ManagedConnection managedConnection) {
        if (!managedConnection.isSupernodeClientConnection()) {
            message.hop();
        }
        if (message instanceof PingRequest) {
            this.handlePingRequestPossibleDuplicate((PingRequest)message, managedConnection);
        } else if (message instanceof PingReply) {
            this.handlePingReply((PingReply)message, managedConnection);
        } else if (message instanceof QueryRequest) {
            this.handleQueryRequestPossibleDuplicate((QueryRequest)message, managedConnection);
        } else if (message instanceof QueryReply) {
            this.handleQueryReply((QueryReply)message, managedConnection);
        } else if (message instanceof PushRequest) {
            this.handlePushRequest((PushRequest)message, managedConnection);
        } else if (message instanceof RouteTableMessage) {
            this.handleRouteTableMessage((RouteTableMessage)message, managedConnection);
        }
        this.forwardQueryRouteTables();
    }

    final void handlePingRequestPossibleDuplicate(PingRequest pingRequest, ManagedConnection managedConnection) {
        if (this._pingRouteTable.tryToRouteReply(pingRequest.getGUID(), managedConnection)) {
            this.handlePingRequest(pingRequest, managedConnection);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest queryRequest, ManagedConnection managedConnection) {
        if (this._queryRouteTable.tryToRouteReply(queryRequest.getGUID(), managedConnection)) {
            this.handleQueryRequest(queryRequest, managedConnection);
        }
    }

    protected void handlePingRequest(PingRequest pingRequest, ManagedConnection managedConnection) {
        ++this._numPingRequests;
        if (pingRequest.getTTL() > 0) {
            this.broadcastPingRequest(pingRequest, managedConnection, this._manager);
        }
        this.respondToPingRequest(pingRequest, this._acceptor);
    }

    protected void handleQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection) {
        ++this._numQueryRequests;
        if (managedConnection.getNumMessagesReceived() <= 2 && queryRequest.getHops() <= 1 && queryRequest.getQuery().equals("    ")) {
            managedConnection.setKillable(false);
        }
        if (queryRequest.getTTL() > 0) {
            this.broadcastQueryRequest(queryRequest, managedConnection, this._manager);
        }
        this.respondToQueryRequest(queryRequest, this._acceptor, this._clientGUID);
    }

    public void sendPingRequest(PingRequest pingRequest, ManagedConnection managedConnection) {
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this._forMeReplyHandler);
        managedConnection.send(pingRequest);
    }

    public void sendQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection) {
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this._forMeReplyHandler);
        managedConnection.send(queryRequest);
    }

    public void broadcastPingRequest(PingRequest pingRequest) {
        this._pingRouteTable.routeReply(pingRequest.getGUID(), this._forMeReplyHandler);
        this.broadcastPingRequest(pingRequest, null, this._manager);
    }

    public void broadcastQueryRequest(QueryRequest queryRequest) {
        this._queryRouteTable.routeReply(queryRequest.getGUID(), this._forMeReplyHandler);
        this.broadcastQueryRequest(queryRequest, null, this._manager);
    }

    protected void broadcastPingRequest(PingRequest pingRequest, ManagedConnection managedConnection, ConnectionManager connectionManager) {
        List list = connectionManager.getInitializedConnections2();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection2 = (ManagedConnection)list.get(n);
            if (managedConnection == null || managedConnection2 != managedConnection && !managedConnection2.isClientSupernodeConnection()) {
                managedConnection2.send(pingRequest);
            }
            ++n;
        }
    }

    protected void broadcastQueryRequest(QueryRequest queryRequest, ManagedConnection managedConnection, ConnectionManager connectionManager) {
        List list = this._manager.getInitializedConnections2();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection2 = (ManagedConnection)list.get(n);
            if (managedConnection == null || managedConnection2 != managedConnection && !managedConnection2.isClientSupernodeConnection()) {
                managedConnection2.send(queryRequest);
            }
            ++n;
        }
        list = this._manager.getInitializedClientConnections2();
        int n2 = 0;
        while (n2 < list.size()) {
            ManagedConnection managedConnection3 = (ManagedConnection)list.get(n2);
            if (managedConnection3 != managedConnection) {
                ManagedConnectionQueryInfo managedConnectionQueryInfo = managedConnection3.getQueryRouteState();
                if (managedConnectionQueryInfo == null || managedConnectionQueryInfo.lastReceived == null) {
                    return;
                }
                if (managedConnectionQueryInfo.lastReceived.contains(queryRequest)) {
                    managedConnection3.send(queryRequest);
                }
            }
            ++n2;
        }
    }

    protected abstract void respondToPingRequest(PingRequest var1, Acceptor var2);

    protected abstract void respondToQueryRequest(QueryRequest var1, Acceptor var2, byte[] var3);

    protected void handlePingReply(PingReply pingReply, ManagedConnection managedConnection) {
        boolean bl = this._catcher.add(pingReply, managedConnection);
        ReplyHandler replyHandler = this._pingRouteTable.getReplyHandler(pingReply.getGUID());
        if (replyHandler != null) {
            ++this._numPingReplies;
            replyHandler.handlePingReply(pingReply, managedConnection);
        } else {
            ++this._numRouteErrors;
            managedConnection.countDroppedMessage();
        }
        if (bl && pingReply.isMarked()) {
            List list = this._manager.getInitializedClientConnections2();
            int n = 0;
            while (n < list.size()) {
                ManagedConnection managedConnection2 = (ManagedConnection)list.get(n);
                if (managedConnection2 != managedConnection && managedConnection2 != replyHandler) {
                    managedConnection2.send(pingReply);
                }
                ++n;
            }
        }
    }

    public void handleQueryReply(QueryReply queryReply, ManagedConnection managedConnection) {
        ReplyHandler replyHandler = this._queryRouteTable.getReplyHandler(queryReply.getGUID());
        if (replyHandler != null) {
            ++this._numQueryReplies;
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), managedConnection);
            replyHandler.handleQueryReply(queryReply, managedConnection);
        } else {
            ++this._numRouteErrors;
            managedConnection.countDroppedMessage();
        }
    }

    public void handlePushRequest(PushRequest pushRequest, ManagedConnection managedConnection) {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(pushRequest.getClientGUID());
        if (replyHandler != null) {
            ++this._numPingReplies;
            replyHandler.handlePushRequest(pushRequest, managedConnection);
        } else {
            ++this._numRouteErrors;
            managedConnection.countDroppedMessage();
        }
    }

    public void sendPingReply(PingReply pingReply) throws IOException {
        ReplyHandler replyHandler = this._pingRouteTable.getReplyHandler(pingReply.getGUID());
        if (replyHandler == null) {
            throw new IOException();
        }
        replyHandler.handlePingReply(pingReply, null);
    }

    public void sendQueryReply(QueryReply queryReply) throws IOException {
        ReplyHandler replyHandler = this._queryRouteTable.getReplyHandler(queryReply.getGUID());
        if (replyHandler == null) {
            throw new IOException();
        }
        this._pushRouteTable.routeReply(queryReply.getClientGUID(), this._forMeReplyHandler);
        replyHandler.handleQueryReply(queryReply, null);
    }

    public void sendPushRequest(PushRequest pushRequest) throws IOException {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(pushRequest.getClientGUID());
        if (replyHandler == null) {
            throw new IOException();
        }
        replyHandler.handlePushRequest(pushRequest, null);
    }

    public abstract GroupPingRequest createGroupPingRequest(String var1);

    public void handleRouteTableMessage(RouteTableMessage routeTableMessage, ManagedConnection managedConnection) {
        if (!managedConnection.isSupernodeClientConnection()) {
            return;
        }
        Object object = this.queryUpdateLock;
        synchronized (object) {
            ManagedConnectionQueryInfo managedConnectionQueryInfo = managedConnection.getQueryRouteState();
            if (managedConnectionQueryInfo == null) {
                managedConnectionQueryInfo = new ManagedConnectionQueryInfo();
                managedConnection.setQueryRouteState(managedConnectionQueryInfo);
            }
            if (managedConnectionQueryInfo.lastReceived == null) {
                managedConnectionQueryInfo.lastReceived = new QueryRouteTable(16384, 7);
            }
            try {
                managedConnectionQueryInfo.lastReceived.update(routeTableMessage);
            }
            catch (BadPacketException badPacketException) {
                // empty catch block
            }
        }
    }

    public void forwardQueryRouteTables() {
        if (!this._manager.hasClientSupernodeConnection()) {
            return;
        }
        Object object = this.queryUpdateLock;
        synchronized (object) {
            List list = this._manager.getInitializedConnections();
            int n = 0;
            while (n < list.size()) {
                long l;
                ManagedConnection managedConnection = (ManagedConnection)list.get(n);
                if (managedConnection.isClientSupernodeConnection() && managedConnection.isQueryRoutingEnabled() && (l = System.currentTimeMillis()) >= managedConnection.getNextQRPForwardTime()) {
                    managedConnection.setNextQRPForwardTime(l + this.QUERY_ROUTE_UPDATE_TIME);
                    ManagedConnectionQueryInfo managedConnectionQueryInfo = managedConnection.getQueryRouteState();
                    if (managedConnectionQueryInfo == null) {
                        managedConnectionQueryInfo = new ManagedConnectionQueryInfo();
                        managedConnection.setQueryRouteState(managedConnectionQueryInfo);
                    }
                    QueryRouteTable queryRouteTable = this.createRouteTable(managedConnection);
                    Iterator iterator = queryRouteTable.encode(managedConnectionQueryInfo.lastSent);
                    while (iterator.hasNext()) {
                        RouteTableMessage routeTableMessage = (RouteTableMessage)iterator.next();
                        managedConnection.send(routeTableMessage);
                    }
                    managedConnectionQueryInfo.lastSent = queryRouteTable;
                }
                ++n;
            }
        }
    }

    private QueryRouteTable createRouteTable(ManagedConnection managedConnection) {
        QueryRouteTable queryRouteTable = new QueryRouteTable(16384, 7);
        this.addQueryRoutingEntries(queryRouteTable);
        return queryRouteTable;
    }

    protected abstract void addQueryRoutingEntries(QueryRouteTable var1);

    protected abstract void handlePingReplyForMe(PingReply var1, ManagedConnection var2);

    protected abstract void handleQueryReplyForMe(QueryReply var1, ManagedConnection var2);

    protected abstract void handlePushRequestForMe(PushRequest var1, ManagedConnection var2);

    public void countMessage() {
        ++this._numMessages;
    }

    public void countFilteredMessage() {
        ++this._numFilteredMessages;
    }

    public int getNumPingRequests() {
        return this._numPingRequests;
    }

    public int getNumPingReplies() {
        return this._numPingReplies;
    }

    public int getNumQueryRequests() {
        return this._numQueryRequests;
    }

    public int getNumQueryReplies() {
        return this._numQueryReplies;
    }

    public int getNumPushRequests() {
        return this._numPushRequests;
    }

    public int getNumFilteredMessages() {
        return this._numFilteredMessages;
    }

    public int getNumRouteErrors() {
        return this._numRouteErrors;
    }

    public int getNumDroppedMessages() {
        return this._numFilteredMessages + this._numRouteErrors;
    }

    public int getNumMessages() {
        return this._numMessages;
    }

    public byte[] getAddress() {
        return this._acceptor.getAddress();
    }

    public int getPort() {
        return this._acceptor.getPort();
    }

    private final class ForMeReplyHandler
    implements ReplyHandler {
        public void handlePingReply(PingReply pingReply, ManagedConnection managedConnection) {
            MessageRouter.this.handlePingReplyForMe(pingReply, managedConnection);
        }

        public void handleQueryReply(QueryReply queryReply, ManagedConnection managedConnection) {
            MessageRouter.this.handleQueryReplyForMe(queryReply, managedConnection);
        }

        public void handlePushRequest(PushRequest pushRequest, ManagedConnection managedConnection) {
            MessageRouter.this.handlePushRequestForMe(pushRequest, managedConnection);
        }

        public boolean isOpen() {
            return true;
        }
    }
}

