/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.routing.RouteTableMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class Message
implements Serializable {
    public static final byte F_PING = 0;
    public static final byte F_PING_REPLY = 1;
    public static final byte F_PUSH = 64;
    public static final byte F_QUERY = -128;
    public static final byte F_QUERY_REPLY = -127;
    public static final byte F_ROUTE_TABLE_UPDATE = 48;
    private byte[] guid;
    private byte func;
    private byte ttl;
    private byte hops;
    private int length;

    static byte[] makeGuid() {
        return GUID.makeGuid();
    }

    protected void repOk() {
        Assert.that(this.guid.length == 16);
        Assert.that(this.func == 0 || this.func == 1 || this.func == 64 || this.func == -128 || this.func == -127, "Bad function code");
        if (this.func == 1) {
            Assert.that(this.length == 14, "Bad pong length: " + this.length);
        }
        if (this.func == 64) {
            Assert.that(this.length == 26, "Bad push length: " + this.length);
        }
        Assert.that(this.ttl >= 0, "Negative TTL: " + this.ttl);
        Assert.that(this.hops >= 0, "Negative hops: " + this.hops);
        Assert.that(this.length >= 0, "Negative length: " + this.length);
    }

    protected Message(byte by, byte by2, int n) {
        this(Message.makeGuid(), by, by2, 0, n);
    }

    protected Message(byte[] byArray, byte by, byte by2, byte by3, int n) {
        this.guid = byArray;
        this.func = by;
        this.ttl = by2;
        this.hops = by3;
        this.length = n;
    }

    public static Message read(InputStream inputStream) throws BadPacketException, IOException {
        return Message.read(inputStream, new byte[23]);
    }

    static Message read(InputStream inputStream, byte[] byArray) throws BadPacketException, IOException {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < 23) {
            int n4;
            try {
                n4 = inputStream.read(byArray, n3, 23 - n3);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (n3 == 0) {
                    return null;
                }
                throw interruptedIOException;
            }
            if (n4 == -1) {
                throw new IOException("Connection closed.");
            }
            n3 += n4;
        }
        byte[] byArray2 = new byte[16];
        int n5 = 0;
        while (n5 < 16) {
            byArray2[n5] = byArray[n5];
            ++n5;
        }
        byte by = byArray[16];
        byte by2 = byArray[17];
        byte by3 = byArray[18];
        int n6 = ByteOrder.leb2int(byArray, 19);
        if (n6 < 0 || n6 > SettingsManager.instance().getMaxLength()) {
            throw new IOException("Unreasonable message length: " + n6);
        }
        byte[] byArray3 = null;
        if (n6 != 0) {
            byArray3 = new byte[n6];
            n2 = 0;
            while (n2 < n6) {
                n = inputStream.read(byArray3, n2, n6 - n2);
                if (n == -1) {
                    throw new IOException("Connection closed.");
                }
                n2 += n;
            }
        }
        n2 = SettingsManager.instance().getSoftMaxTTL();
        n = SettingsManager.instance().getMaxTTL();
        if (by3 < 0) {
            throw new BadPacketException("Negative (or very large) hops");
        }
        if (by2 < 0) {
            throw new BadPacketException("Negative (or very large) TTL");
        }
        if (by3 > n2) {
            throw new BadPacketException("Hops already exceeds soft maximum");
        }
        if (by2 + by3 > n) {
            throw new BadPacketException("TTL+hops exceeds hard max; probably spam");
        }
        if (by2 + by3 > n2) {
            by2 = (byte)(n2 - by3);
            Assert.that(by2 >= 0);
        }
        switch (by) {
            case 0: {
                if (n6 >= 15) {
                    return new GroupPingRequest(byArray2, by2, by3, byArray3);
                }
                if (n6 > 0) break;
                return new PingRequest(byArray2, by2, by3);
            }
            case 1: {
                if (n6 != 14) break;
                return new PingReply(byArray2, by2, by3, byArray3);
            }
            case -128: {
                if (n6 < 3) break;
                return new QueryRequest(byArray2, by2, by3, byArray3);
            }
            case -127: {
                if (n6 < 26) break;
                return new QueryReply(byArray2, by2, by3, byArray3);
            }
            case 64: {
                if (n6 != 26) break;
                return new PushRequest(byArray2, by2, by3, byArray3);
            }
            case 48: {
                return RouteTableMessage.read(byArray2, by2, by3, byArray3);
            }
        }
        throw new BadPacketException("Unrecognized function code: " + by);
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[23];
        int n = 0;
        while (n < 16) {
            byArray[n] = this.guid[n];
            ++n;
        }
        byArray[16] = this.func;
        byArray[17] = this.ttl;
        byArray[18] = this.hops;
        ByteOrder.int2leb(this.length, byArray, 19);
        outputStream.write(byArray);
        this.writePayload(outputStream);
    }

    protected abstract void writePayload(OutputStream var1) throws IOException;

    public byte[] getGUID() {
        return this.guid;
    }

    public byte getFunc() {
        return this.func;
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) throws IllegalArgumentException {
        if (by < 0) {
            throw new IllegalArgumentException();
        }
        this.ttl = by;
    }

    public byte getHops() {
        return this.hops;
    }

    public int getLength() {
        return this.length;
    }

    public int getTotalLength() {
        return 23 + this.length;
    }

    static final String ip2string(byte[] byArray) {
        return Message.ip2string(byArray, 0);
    }

    static final String ip2string(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n + 1]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n + 2]));
        stringBuffer.append('.');
        stringBuffer.append(ByteOrder.ubyte2int(byArray[n + 3]));
        return stringBuffer.toString();
    }

    public byte hop() {
        this.hops = (byte)(this.hops + 1);
        if (this.ttl > 0) {
            byte by = this.ttl;
            this.ttl = (byte)(by - 1);
            return by;
        }
        return this.ttl;
    }

    public String toString() {
        return "{guid=" + new GUID(this.guid).toString() + ", ttl=" + this.ttl + "}";
    }
}

