/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

public class MediaType {
    private String description;
    private String[] extensions;
    private static final String ANY_TYPE = "MEDIA_ANY_TYPE";
    private static final String DOCUMENTS = "MEDIA_DOCUMENTS";
    private static final String PROGRAMS = "MEDIA_PROGRAMS";
    private static final String AUDIO = "MEDIA_AUDIO";
    private static final String VIDEO = "MEDIA_VIDEO";
    private static final String IMAGES = "MEDIA_IMAGES";
    private static MediaType[] allMediaTypes = null;

    public MediaType(String string, String[] stringArray) {
        this.description = string;
        this.extensions = stringArray;
    }

    public boolean matches(String string) {
        if (this.extensions == null) {
            return true;
        }
        int n = string.lastIndexOf(".");
        if (n == -1 || n == string.length()) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        int n2 = 0;
        while (n2 < this.extensions.length) {
            if (string2.equals(this.extensions[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        return this.description;
    }

    public static MediaType[] getDefaultMediaTypes() {
        if (allMediaTypes == null) {
            allMediaTypes = MediaType.getTypes();
        }
        return allMediaTypes;
    }

    public static MediaType getAudioMediaType() {
        return MediaType.getDefaultMediaTypes()[3];
    }

    public static MediaType getVideoMediaType() {
        return MediaType.getDefaultMediaTypes()[4];
    }

    private static MediaType[] getTypes() {
        MediaType mediaType = new MediaType(ANY_TYPE, null);
        MediaType mediaType2 = new MediaType(DOCUMENTS, new String[]{"html", "htm", "xml", "txt", "pdf", "ps", "rtf", "doc", "tex"});
        MediaType mediaType3 = new MediaType(PROGRAMS, new String[]{"exe", "zip", "gz", "gzip", "hqx", "tar", "tgz", "z", "sit", "hqx", "bin", "dmg"});
        MediaType mediaType4 = new MediaType(AUDIO, new String[]{"mp3", "wav", "au", "aif", "aiff", "ra", "ram", "rmj", "lqt", "ogg"});
        MediaType mediaType5 = new MediaType(VIDEO, new String[]{"mpg", "mpeg", "asf", "qt", "mov", "avi", "mpe", "swf", "dcr", "rm", "ram", "jve"});
        MediaType mediaType6 = new MediaType(IMAGES, new String[]{"gif", "jpg", "jpeg", "jpe", "png", "tif", "tiff"});
        return new MediaType[]{mediaType, mediaType2, mediaType3, mediaType4, mediaType5, mediaType6};
    }
}

