/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.HandshakeResponder;
import com.limegroup.gnutella.HandshakeResponse;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.SpamFilter;
import com.limegroup.gnutella.routing.ManagedConnectionQueryInfo;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;

public class ManagedConnection
extends Connection
implements ReplyHandler {
    private MessageRouter _router;
    private ConnectionManager _manager;
    private volatile SpamFilter _routeFilter = SpamFilter.newRouteFilter();
    private volatile SpamFilter _personalFilter = SpamFilter.newPersonalFilter();
    private static final int QUEUE_TIME = 750;
    private static final int BATCH_SIZE = 50;
    private static final int QUEUE_SIZE = 500;
    private Object _outputQueueLock = new Object();
    private volatile Buffer _outputQueue = new Buffer(500);
    private volatile Buffer _oldOutputQueue = new Buffer(500);
    private volatile boolean _flushImmediately = false;
    private Object _flushLock = new Object();
    private static final int REJECT_TIMEOUT = 500;
    private int _numMessagesSent;
    private int _numMessagesReceived;
    private int _numReceivedMessagesDropped;
    private int _numSentMessagesDropped;
    private int _lastReceived;
    private int _lastRecvDropped;
    private int _lastSent;
    private int _lastSentDropped;
    private boolean _horizonEnabled = true;
    private static final long HORIZON_UPDATE_TIME = 600000L;
    private long _lastRefreshHorizonTime = System.currentTimeMillis();
    private boolean _refreshedHorizonStats = false;
    private static final int MAX_PING_REPLIES = 4000;
    private Set _pingReplies = new HashSet();
    private long _totalHorizonFileSize = 0L;
    private long _numHorizonFiles = 0L;
    private long _numHorizonHosts = 0L;
    private long _nextTotalHorizonFileSize = 0L;
    private long _nextNumHorizonFiles = 0L;
    private long _nextNumHorizonHosts = 0L;
    private volatile ManagedConnectionQueryInfo queryInfo = null;
    private long _nextQRPForwardTime;
    private volatile long _bytesSent;
    private BandwidthTrackerImpl _upBandwidthTracker = new BandwidthTrackerImpl();
    private volatile long _bytesReceived;
    private BandwidthTrackerImpl _downBandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isRouter = false;
    private boolean _isKillable = true;
    private Boolean _isSupernodeClientConnection = null;
    private Boolean _isClientSupernodeConnection = null;

    ManagedConnection(String string, int n, MessageRouter messageRouter, ConnectionManager connectionManager) {
        this(string, n, messageRouter, connectionManager, false);
    }

    ManagedConnection(String string, int n, MessageRouter messageRouter, ConnectionManager connectionManager, boolean bl) {
        super(string, n, bl ? null : (connectionManager.isSupernode() ? new SupernodeProperties(messageRouter) : new ClientProperties(messageRouter)), bl ? null : (connectionManager.isSupernode() ? new SupernodeHandshakeResponder(connectionManager) : new ClientHandshakeResponder(connectionManager)), !bl);
        this._router = messageRouter;
        this._manager = connectionManager;
        this._isRouter = bl;
        new OutputRunner();
    }

    ManagedConnection(Socket socket, MessageRouter messageRouter, ConnectionManager connectionManager) {
        super(socket, connectionManager.isSupernode() ? new SupernodeHandshakeResponder(connectionManager) : new ClientHandshakeResponder(connectionManager));
        this._router = messageRouter;
        this._manager = connectionManager;
        new OutputRunner();
    }

    public Message receive() throws IOException, BadPacketException {
        Message message = null;
        try {
            message = super.receive();
            this._bytesReceived += (long)message.getTotalLength();
        }
        catch (IOException iOException) {
            this._manager.remove(this);
            throw iOException;
        }
        ++this._numMessagesReceived;
        this._router.countMessage();
        return message;
    }

    public Message receive(int n) throws IOException, BadPacketException, InterruptedIOException {
        Message message = null;
        try {
            message = super.receive(n);
            this._bytesReceived += (long)message.getTotalLength();
        }
        catch (IOException iOException) {
            this._manager.remove(this);
            throw iOException;
        }
        ++this._numMessagesReceived;
        this._router.countMessage();
        return message;
    }

    public void send(Message message) {
        Object object = this._outputQueueLock;
        synchronized (object) {
            ++this._numMessagesSent;
            this._router.countMessage();
            if (this._outputQueue.isFull()) {
                ++this._numSentMessagesDropped;
                if (ManagedConnection.isDisposeable(message)) {
                    return;
                }
                int n = this._outputQueue.getSize() - 1;
                while (n >= 0) {
                    Message message2 = (Message)this._outputQueue.get(n);
                    if (ManagedConnection.isDisposeable(message2)) break;
                    --n;
                }
                if (n >= 0) {
                    this._outputQueue.set(n, message);
                } else {
                    this._outputQueue.addFirst(message);
                }
            } else {
                this._outputQueue.addFirst(message);
                if (this._outputQueue.getSize() >= 50) {
                    this._outputQueueLock.notify();
                }
            }
        }
    }

    public void flush() throws IOException {
        Object object = this._outputQueueLock;
        synchronized (object) {
            this._flushImmediately = true;
            this._outputQueueLock.notify();
        }
        Object object2 = this._flushLock;
        synchronized (object2) {
            while (!this._outputQueue.isEmpty() || !this._oldOutputQueue.isEmpty()) {
                try {
                    this._flushLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                super.flush();
            }
        }
    }

    private void superSend(Message message) throws IOException {
        super.send(message);
        this._bytesSent += (long)message.getTotalLength();
    }

    private void superFlush() throws IOException {
        super.flush();
    }

    private static boolean isDisposeable(Message message) {
        return message instanceof PingRequest && message.getHops() != 0 || message instanceof PingReply;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loopToReject(HostCatcher hostCatcher) {
        try {
            try {
                int n = 0;
                while (n < 10) {
                    Message message = null;
                    try {
                        message = super.receive(500);
                        if (message == null) {
                            Object var8_5 = null;
                            this.close();
                            return;
                        }
                    }
                    catch (BadPacketException badPacketException) {
                        Object var8_6 = null;
                        this.close();
                        return;
                    }
                    if (message instanceof PingRequest && message.getHops() == 0) {
                        Iterator iterator = hostCatcher.getNormalHosts(10);
                        while (true) {
                            if (!iterator.hasNext()) break;
                            Endpoint endpoint = (Endpoint)iterator.next();
                            PingReply pingReply = new PingReply(message.getGUID(), 1, endpoint.getPort(), endpoint.getHostBytes(), 0L, 0L);
                            super.send(pingReply);
                        }
                        super.flush();
                        Object var8_7 = null;
                        this.close();
                        return;
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                Object var8_9 = null;
                this.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.close();
            throw throwable;
        }
        Object var8_8 = null;
        this.close();
    }

    void loopForMessages() throws IOException {
        while (true) {
            Message message = null;
            try {
                message = this.receive();
                if (message == null) {
                }
            }
            catch (BadPacketException badPacketException) {}
            continue;
            if (!this._routeFilter.allow(message)) {
                this._router.countFilteredMessage();
                ++this._numReceivedMessagesDropped;
                continue;
            }
            this._router.handleMessage(message, this);
        }
    }

    public void countDroppedMessage() {
        ++this._numReceivedMessagesDropped;
    }

    public boolean isPersonalSpam(Message message) {
        return !this._personalFilter.allow(message);
    }

    public void setRouteFilter(SpamFilter spamFilter) {
        this._routeFilter = spamFilter;
    }

    public void setPersonalFilter(SpamFilter spamFilter) {
        this._personalFilter = spamFilter;
    }

    public void handlePingReply(PingReply pingReply, ManagedConnection managedConnection) {
        this.send(pingReply);
    }

    public void handleQueryReply(QueryReply queryReply, ManagedConnection managedConnection) {
        this.send(queryReply);
    }

    public void handlePushRequest(PushRequest pushRequest, ManagedConnection managedConnection) {
        this.send(pushRequest);
    }

    public int getNumMessagesSent() {
        return this._numMessagesSent;
    }

    public int getNumMessagesReceived() {
        return this._numMessagesReceived;
    }

    public int getNumSentMessagesDropped() {
        return this._numSentMessagesDropped;
    }

    public long getNumReceivedMessagesDropped() {
        return this._numReceivedMessagesDropped;
    }

    public synchronized float getPercentReceivedDropped() {
        int n = this._numMessagesReceived - this._lastReceived;
        int n2 = this._numReceivedMessagesDropped - this._lastRecvDropped;
        float f = n == 0 ? 0.0f : (float)n2 / (float)n * 100.0f;
        this._lastReceived = this._numMessagesReceived;
        this._lastRecvDropped = this._numReceivedMessagesDropped;
        return f;
    }

    public synchronized float getPercentSentDropped() {
        int n = this._numMessagesSent - this._lastSent;
        int n2 = this._numSentMessagesDropped - this._lastSentDropped;
        float f = n == 0 ? 0.0f : (float)n2 / (float)n * 100.0f;
        this._lastSent = this._numMessagesSent;
        this._lastSentDropped = this._numSentMessagesDropped;
        return f;
    }

    public void measureBandwidth() {
        this._upBandwidthTracker.measureBandwidth(ByteOrder.long2int(this._bytesSent));
        this._downBandwidthTracker.measureBandwidth(ByteOrder.long2int(this._bytesReceived));
    }

    public float getMeasuredUpstreamBandwidth() {
        return this._upBandwidthTracker.getMeasuredBandwidth();
    }

    public float getMeasuredDownstreamBandwidth() {
        return this._downBandwidthTracker.getMeasuredBandwidth();
    }

    public synchronized void setHorizonEnabled(boolean bl) {
        this._horizonEnabled = bl;
    }

    public synchronized void updateHorizonStats(PingReply pingReply) {
        if (!this._horizonEnabled) {
            return;
        }
        Endpoint endpoint = new Endpoint(pingReply.getIP(), pingReply.getPort());
        if (this._pingReplies.size() < 4000 && this._pingReplies.add((Object)endpoint)) {
            this._nextTotalHorizonFileSize += pingReply.getKbytes();
            this._nextNumHorizonFiles += pingReply.getFiles();
            ++this._nextNumHorizonHosts;
        }
    }

    public synchronized void refreshHorizonStats() {
        long l = System.currentTimeMillis();
        long l2 = l - this._lastRefreshHorizonTime;
        if (l2 < 600000L) {
            return;
        }
        this._lastRefreshHorizonTime = l;
        this._numHorizonHosts = this._nextNumHorizonHosts;
        this._numHorizonFiles = this._nextNumHorizonFiles;
        this._totalHorizonFileSize = this._nextTotalHorizonFileSize;
        this._nextNumHorizonHosts = 0L;
        this._nextNumHorizonFiles = 0L;
        this._nextTotalHorizonFileSize = 0L;
        this._pingReplies.clear();
        this._refreshedHorizonStats = true;
    }

    public synchronized long getNumHosts() {
        if (this._refreshedHorizonStats) {
            return this._numHorizonHosts;
        }
        return this._nextNumHorizonHosts;
    }

    public synchronized long getNumFiles() {
        if (this._refreshedHorizonStats) {
            return this._numHorizonFiles;
        }
        return this._nextNumHorizonFiles;
    }

    public synchronized long getTotalFileSize() {
        if (this._refreshedHorizonStats) {
            return this._totalHorizonFileSize;
        }
        return this._nextTotalHorizonFileSize;
    }

    public boolean isRouterConnection() {
        return this._isRouter;
    }

    public boolean isClientConnection() {
        String string = this.getProperty("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string) == false;
    }

    public boolean isSupernodeConnection() {
        String string = this.getProperty("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isClientSupernodeConnection() {
        if (this._isClientSupernodeConnection == null) {
            this._isClientSupernodeConnection = new Boolean(this.isClientSupernodeConnection2());
        }
        return this._isClientSupernodeConnection;
    }

    private boolean isClientSupernodeConnection2() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string) == false;
    }

    public boolean isSupernodeClientConnection() {
        if (this._isSupernodeClientConnection == null) {
            this._isSupernodeClientConnection = new Boolean(this.isSupernodeClientConnection2());
        }
        return this._isSupernodeClientConnection;
    }

    private boolean isSupernodeClientConnection2() {
        if (!this.isClientConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        if (!Boolean.valueOf(string).booleanValue()) {
            return false;
        }
        return this.isQueryRoutingEnabled();
    }

    boolean isQueryRoutingEnabled() {
        String string = this.getProperty("X-Query-Routing");
        if (string == null) {
            return false;
        }
        try {
            Float f = new Float(string);
            return f.floatValue() >= 0.1f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public long getNextQRPForwardTime() {
        return this._nextQRPForwardTime;
    }

    public void setNextQRPForwardTime(long l) {
        this._nextQRPForwardTime = l;
    }

    public void setKillable(boolean bl) {
        this._isKillable = bl;
    }

    public boolean isKillable() {
        return this._isKillable;
    }

    private static void addHostAddresses(Properties properties, ConnectionManager connectionManager) {
        Endpoint endpoint;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = connectionManager.getNormalHosts(10);
        while (iterator.hasNext()) {
            endpoint = (Endpoint)iterator.next();
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(endpoint.getHostname());
            stringBuffer.append(":");
            stringBuffer.append(endpoint.getPort());
        }
        ((Hashtable)properties).put("X-Try", stringBuffer.toString());
        endpoint = connectionManager.getSupernodeEndpoints();
        if (endpoint.size() < 0) {
            return;
        }
        stringBuffer = new StringBuffer();
        bl = true;
        Iterator iterator2 = endpoint.iterator();
        while (iterator2.hasNext()) {
            Endpoint endpoint2 = (Endpoint)iterator2.next();
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(endpoint2.getHostname());
            stringBuffer.append(":");
            stringBuffer.append(endpoint2.getPort());
        }
        ((Hashtable)properties).put("X-Try-Ultrapeers", stringBuffer.toString());
    }

    private static void addCommonProperties(Properties properties) {
        ((Hashtable)properties).put("X-Query-Routing", "0.1");
        ((Hashtable)properties).put("User-Agent", CommonUtils.getVendor());
    }

    public ManagedConnectionQueryInfo getQueryRouteState() {
        return this.queryInfo;
    }

    void setQueryRouteState(ManagedConnectionQueryInfo managedConnectionQueryInfo) {
        this.queryInfo = managedConnectionQueryInfo;
    }

    private static class ClientHandshakeResponder
    implements HandshakeResponder {
        ConnectionManager _manager;

        public ClientHandshakeResponder(ConnectionManager connectionManager) {
            this._manager = connectionManager;
        }

        public HandshakeResponse respond(HandshakeResponse handshakeResponse, boolean bl) throws IOException {
            if (bl) {
                return new HandshakeResponse(new Properties());
            }
            Properties properties = new Properties();
            ((Hashtable)properties).put("X-Ultrapeer", "False");
            ManagedConnection.addCommonProperties(properties);
            ManagedConnection.addHostAddresses(properties, this._manager);
            if (this._manager.hasClientSupernodeConnection()) {
                return new HandshakeResponse(503, "I am a shielded leaf node", properties);
            }
            return new HandshakeResponse(properties);
        }
    }

    private static class SupernodeHandshakeResponder
    implements HandshakeResponder {
        ConnectionManager _manager;

        public SupernodeHandshakeResponder(ConnectionManager connectionManager) {
            this._manager = connectionManager;
        }

        public HandshakeResponse respond(HandshakeResponse handshakeResponse, boolean bl) {
            if (!bl) {
                Properties properties = new Properties();
                ((Hashtable)properties).put("X-Ultrapeer", "True");
                ManagedConnection.addCommonProperties(properties);
                ((Hashtable)properties).put("X-Ultrapeer-Needed", new Boolean(this._manager.supernodeNeeded()).toString());
                ((Hashtable)properties).put("X-My-Address", this._manager.getSelfAddress().getHostname() + ":" + this._manager.getSelfAddress().getPort());
                ManagedConnection.addHostAddresses(properties, this._manager);
                if (!this._manager.hasAvailableIncoming(false) && !this._manager.hasAvailableIncoming(true)) {
                    return new HandshakeResponse(503, "Service unavailable", properties);
                }
                return new HandshakeResponse(properties);
            }
            Properties properties = new Properties();
            String string = handshakeResponse.getHeaders().getProperty("X-Ultrapeer-Needed");
            if (string != null && !Boolean.valueOf(string).booleanValue() && this._manager.allowClientMode()) {
                ((Hashtable)properties).put("X-Ultrapeer", "False");
            }
            return new HandshakeResponse(properties);
        }
    }

    private static class ClientProperties
    extends LazyProperties {
        public ClientProperties(MessageRouter messageRouter) {
            super(messageRouter);
            ((Hashtable)this).put("X-Ultrapeer", "False");
            ManagedConnection.addCommonProperties(this);
        }
    }

    private static class SupernodeProperties
    extends LazyProperties {
        public SupernodeProperties(MessageRouter messageRouter) {
            super(messageRouter);
            ((Hashtable)this).put("X-Ultrapeer", "True");
            ManagedConnection.addCommonProperties(this);
        }
    }

    private static class LazyProperties
    extends Properties {
        private MessageRouter router;

        LazyProperties(MessageRouter messageRouter) {
            this.router = messageRouter;
            if (messageRouter != null) {
                ((Hashtable)this).put("X-My-Address", "");
            }
        }

        public String getProperty(String string, String string2) {
            if (this.router != null && string.equals("X-My-Address")) {
                Endpoint endpoint = new Endpoint(this.router.getAddress(), this.router.getPort());
                return endpoint.getHostname() + ":" + endpoint.getPort();
            }
            return super.getProperty(string, string2);
        }

        public String getProperty(String string) {
            if (this.router != null && string.equals("X-My-Address")) {
                Endpoint endpoint = new Endpoint(this.router.getAddress(), this.router.getPort());
                return endpoint.getHostname() + ":" + endpoint.getPort();
            }
            return super.getProperty(string);
        }
    }

    private class OutputRunner
    extends Thread {
        public OutputRunner() {
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (ManagedConnection.this.isOpen()) {
                Object object;
                Object object2 = ManagedConnection.this._outputQueueLock;
                synchronized (object2) {
                    try {
                        if (!ManagedConnection.this._flushImmediately && ManagedConnection.this._outputQueue.getSize() < 50) {
                            ManagedConnection.this._outputQueueLock.wait(750L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ManagedConnection.this._flushImmediately = false;
                    if (ManagedConnection.this._outputQueue.isEmpty()) {
                        continue;
                    }
                    object = ManagedConnection.this._outputQueue;
                    ManagedConnection.this._outputQueue = ManagedConnection.this._oldOutputQueue;
                    ManagedConnection.this._outputQueue.clear();
                    ManagedConnection.this._oldOutputQueue = (Buffer)object;
                }
                try {
                    while (!ManagedConnection.this._oldOutputQueue.isEmpty()) {
                        ManagedConnection.this.superSend((Message)ManagedConnection.this._oldOutputQueue.removeLast());
                    }
                    ManagedConnection.this.superFlush();
                }
                catch (IOException iOException) {
                    ManagedConnection.this._manager.remove(ManagedConnection.this);
                }
                object = ManagedConnection.this._flushLock;
                synchronized (object) {
                    if (ManagedConnection.this._outputQueue.isEmpty()) {
                        ManagedConnection.this._flushLock.notify();
                    }
                }
            }
        }
    }
}

