/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.StandardMessageRouter;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.chat.Chatter;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class Main
implements ActivityCallback {
    public static void main(String[] stringArray) {
        Main main = new Main();
        FileManager fileManager = new FileManager();
        RouterService routerService = new RouterService(main, new StandardMessageRouter(main, fileManager), fileManager);
        routerService.initialize();
        routerService.postGuiInit();
        System.out.println("For a command list type help.");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("LimeRouter> ");
            try {
                Iterator iterator;
                String string = bufferedReader.readLine();
                if (string == null) break;
                if (string.equals("help")) {
                    System.out.println("catcher                  Print host catcher.");
                    System.out.println("connect <host> [<port>]  Connect to a host[:port].");
                    System.out.println("help                     Print this message.");
                    System.out.println("listen <port>            Set the port you are listening on.");
                    System.out.println("query <string>           Send a query to the network.");
                    System.out.println("quit                     Quit the application.");
                    System.out.println("update                   Send pings to update the statistics.");
                } else {
                    if (string.equals("quit")) break;
                    if (string.equals("stat")) {
                        System.out.println("Number of hosts: " + routerService.getNumHosts());
                        System.out.println("Number of files: " + routerService.getNumFiles());
                        System.out.println("Size of files: " + routerService.getTotalFileSize());
                    } else if (string.equals("update")) {
                        routerService.updateHorizon();
                    } else if (string.equals("catcher")) {
                        iterator = routerService.getHosts();
                        while (iterator.hasNext()) {
                            System.out.println(iterator.next().toString());
                        }
                    }
                }
                iterator = Main.split(string);
                if (((Iterator)iterator).length >= 2 && iterator[0].equals("connect")) {
                    try {
                        int n = 6346;
                        if (((Iterator)iterator).length >= 3) {
                            n = Integer.parseInt((String)iterator[2]);
                        }
                        routerService.connectToHostBlocking((String)iterator[1], n);
                    }
                    catch (IOException iOException) {
                        System.out.println("Couldn't establish connection.");
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Please specify a valid port.");
                    }
                    continue;
                }
                if (((Iterator)iterator).length >= 2 && iterator[0].equals("query")) {
                    int n = string.indexOf(32);
                    Assert.that(n != -1 && n < string.length());
                    String string2 = string.substring(n + 1);
                    routerService.query(string2, 0);
                    continue;
                }
                if (((Iterator)iterator).length != 2 || !iterator[0].equals("listen")) continue;
                try {
                    int n = Integer.parseInt((String)iterator[1]);
                    routerService.setListeningPort(n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Please specify a valid port.");
                }
                catch (IOException iOException) {
                    System.out.println("Couldn't change port.  Try another value.");
                }
            }
            catch (IOException iOException) {
                System.exit(1);
            }
        }
        System.out.println("Good bye.");
        routerService.shutdown();
    }

    public void connectionInitializing(Connection connection) {
        String string = connection.getOrigHost();
        int n = connection.getOrigPort();
        String string2 = null;
        String string3 = null;
        if (connection.isOutgoing()) {
            string2 = "outgoing";
            string3 = "to ";
        } else {
            string2 = "incoming";
            string3 = "from ";
        }
    }

    public void connectionInitialized(Connection connection) {
        String string = connection.getOrigHost();
        int n = connection.getOrigPort();
    }

    public void connectionClosed(Connection connection) {
        String string = connection.getOrigHost();
        int n = connection.getOrigPort();
    }

    public void knownHost(Endpoint endpoint) {
    }

    public void handleQueryReply(QueryReply queryReply) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("Query reply from " + queryReply.getIP() + ":" + queryReply.getPort() + ":");
            try {
                Iterator iterator = queryReply.getResults();
                while (iterator.hasNext()) {
                    System.out.println("   " + ((Response)iterator.next()).getName());
                }
            }
            catch (BadPacketException badPacketException) {
                // empty catch block
            }
        }
    }

    public void handleQueryString(String string) {
    }

    public void error(int n) {
        this.error(n, null);
    }

    public void error(Throwable throwable) {
    }

    public void error(int n, Throwable throwable) {
        System.out.println("Error: " + n);
    }

    public static String[] split(String string) {
        int n = (string = string.trim()).length();
        if (n == 0) {
            return new String[0];
        }
        Vector vector = new Vector();
        int n2 = 0;
        block0: while (n2 < n) {
            Assert.that(string.charAt(n2) != ' ');
            int n3 = string.indexOf(32, n2 + 1);
            if (n3 == -1) {
                n3 = n;
            }
            vector.add((Object)string.substring(n2, n3));
            n2 = n3 + 1;
            while (n3 < n) {
                if (string.charAt(n2) != ' ') continue block0;
                ++n2;
            }
        }
        String[] stringArray = new String[vector.size()];
        int n4 = 0;
        while (n4 < stringArray.length) {
            stringArray[n4] = (String)vector.get(n4);
            ++n4;
        }
        return stringArray;
    }

    public boolean overwriteFile(String string) {
        return false;
    }

    public void addDownload(Downloader downloader) {
    }

    public void removeDownload(Downloader downloader) {
    }

    public void addUpload(Uploader uploader) {
    }

    public void removeUpload(Uploader uploader) {
    }

    public void setPort(int n) {
    }

    public int getNumUploads() {
        return 0;
    }

    public void addSharedDirectory(File file, File file2) {
    }

    public void addSharedFile(File file, File file2) {
    }

    public void clearSharedFiles() {
    }

    public void acceptChat(Chatter chatter) {
    }

    public void receiveMessage(Chatter chatter) {
    }

    public void chatUnavailable(Chatter chatter) {
    }

    public void chatErrorMessage(Chatter chatter, String string) {
    }

    public void downloadsComplete() {
    }

    public void uploadsComplete() {
    }
}

