/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.PingReply;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.BucketQueue;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostCatcher {
    private static final int GOOD_SIZE = 50;
    private static final int NORMAL_SIZE = 50;
    private static final int BAD_SIZE = 10;
    private static final int SIZE = 110;
    public static final int GOOD_PRIORITY = 2;
    public static final int NORMAL_PRIORITY = 1;
    public static final int BAD_PRIORITY = 0;
    private BucketQueue queue = new BucketQueue(new int[]{10, 50, 50});
    private Set set = new HashSet();
    private Acceptor acceptor;
    private ConnectionManager manager;
    private ActivityCallback callback;
    private SettingsManager settings = SettingsManager.instance();
    private Thread routerConnectorThread;
    private boolean stale = true;
    private Object staleLock = new Object();
    private int staleWaiters = 0;
    private Object staleWaitersLock = new Object();
    private boolean gotGoodPong = false;
    private Object gotGoodPongLock = new Object();
    private static final int STALE_TIME = 172800000;
    private static final int RETRY_TIME = 300000;
    private static final int CONNECT_TIME = 6000;
    private boolean alwaysNotifyKnownHost = false;
    private boolean routerConnectorThreadStarted = false;

    public HostCatcher(ActivityCallback activityCallback) {
        this.callback = activityCallback;
        this.routerConnectorThread = new RouterConnectorThread();
    }

    public void initialize(Acceptor acceptor, ConnectionManager connectionManager) {
        this.acceptor = acceptor;
        this.manager = connectionManager;
    }

    public void connectToRouter() {
        this.routerConnectorThread.setDaemon(true);
        this.routerConnectorThread.start();
        this.routerConnectorThreadStarted = true;
    }

    public void initialize(Acceptor acceptor, ConnectionManager connectionManager, String string) {
        this.acceptor = acceptor;
        this.manager = connectionManager;
        try {
            this.read(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void read(String string) throws FileNotFoundException, IOException {
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while (n < 110) {
            block9: {
                String string2 = bufferedReader.readLine();
                if (string2 == null) break;
                int n2 = string2.indexOf(58);
                if (n2 != -1) {
                    String string3 = string2.substring(0, n2);
                    int n3 = 0;
                    try {
                        n3 = Integer.parseInt(string2.substring(n2 + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block9;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        break block9;
                    }
                    Endpoint endpoint = new Endpoint(string3, n3);
                    if (endpoint.isPrivateAddress()) {
                        endpoint.setWeight(0);
                    } else {
                        endpoint.setWeight(1);
                    }
                    if (!this.set.contains((Object)endpoint) && !this.isMe(string3, n3)) {
                        Endpoint endpoint2 = this.queue.insert(endpoint);
                        if (endpoint2 != null) {
                            this.set.remove((Object)endpoint2);
                        }
                        this.set.add((Object)endpoint);
                        this.notify();
                    }
                }
            }
            ++n;
        }
    }

    public synchronized void write(String string) throws IOException {
        Endpoint endpoint;
        FileWriter fileWriter = new FileWriter(string);
        HashSet hashSet = new HashSet();
        Iterator iterator = this.manager.getInitializedConnections().iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!connection.isOutgoing()) continue;
            endpoint = new Endpoint(connection.getInetAddress().getHostAddress(), connection.getPort());
            hashSet.add((Object)endpoint);
            this.writeInternal(fileWriter, endpoint);
        }
        int n = this.queue.size() - 1;
        while (n >= 0) {
            endpoint = this.queue.extractMax();
            if (!hashSet.contains((Object)endpoint)) {
                this.writeInternal(fileWriter, endpoint);
            }
            --n;
        }
        fileWriter.close();
    }

    private void writeInternal(Writer writer, Endpoint endpoint) throws IOException {
        writer.write(endpoint.getHostname() + ":" + endpoint.getPort() + "\n");
    }

    public boolean add(PingReply pingReply, ManagedConnection managedConnection) {
        Endpoint endpoint = new Endpoint(pingReply.getIP(), pingReply.getPort(), pingReply.getFiles(), pingReply.getKbytes());
        return this.add(endpoint, pingReply.isMarked());
    }

    public boolean add(Endpoint endpoint, boolean bl) {
        if (bl) {
            endpoint.setWeight(2);
        } else if (endpoint.isPrivateAddress()) {
            endpoint.setWeight(0);
        } else {
            endpoint.setWeight(1);
        }
        return this.add(endpoint);
    }

    private boolean add(Endpoint endpoint) {
        Object object;
        if (this.manager.isConnected(endpoint)) {
            return false;
        }
        if (this.isMe(endpoint.getHostname(), endpoint.getPort())) {
            return false;
        }
        try {
            if (HostCatcher.isRouter(endpoint.getHostBytes())) {
                return false;
            }
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (!this.set.contains((Object)endpoint)) {
                bl = true;
                this.set.add((Object)endpoint);
                object = this.queue.insert(endpoint);
                if (object != null) {
                    this.set.remove(object);
                }
                if (object == null) {
                    bl2 = true;
                }
                this.notify();
            }
        }
        object = this.gotGoodPongLock;
        synchronized (object) {
            this.gotGoodPong = true;
            this.gotGoodPongLock.notify();
        }
        if (this.alwaysNotifyKnownHost) {
            this.callback.knownHost(endpoint);
        } else if (bl2) {
            this.callback.knownHost(endpoint);
        }
        return bl;
    }

    private boolean hasRouterHost() {
        if (!this.queue.isEmpty()) {
            Endpoint endpoint = this.queue.getMax();
            return endpoint.getWeight() == 2;
        }
        return false;
    }

    public Endpoint getAnEndpoint() throws InterruptedException {
        Object object;
        Object object2;
        if (this.settings.getUseQuickConnect() && this.stale) {
            Object object3;
            try {
                object2 = this.staleWaitersLock;
                synchronized (object2) {
                    ++this.staleWaiters;
                    this.staleWaitersLock.notify();
                }
                object = this.staleLock;
                synchronized (object) {
                    if (this.stale) {
                        this.staleLock.wait(6000L);
                    }
                }
                Object var5_6 = null;
                object3 = this.staleWaitersLock;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                Object object4 = this.staleWaitersLock;
                synchronized (object4) {
                    --this.staleWaiters;
                }
                throw throwable;
            }
            synchronized (object3) {
                --this.staleWaiters;
            }
        }
        object2 = null;
        object = this;
        synchronized (object) {
            while (true) {
                try {
                    object2 = this.getAnEndpointInternal();
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.wait();
                    continue;
                }
                break;
            }
        }
        return object2;
    }

    private Endpoint getAnEndpointInternal() throws NoSuchElementException {
        if (!this.queue.isEmpty()) {
            Endpoint endpoint = this.queue.extractMax();
            boolean bl = this.set.remove((Object)endpoint);
            Assert.that(bl, "Rep. invariant for HostCatcher broken.");
            return endpoint;
        }
        throw new NoSuchElementException();
    }

    public int getNumHosts() {
        return this.queue.size();
    }

    public synchronized Iterator getHosts() {
        return new BucketQueue(this.queue).iterator();
    }

    public synchronized Iterator getUltrapeerHosts(int n) {
        BucketQueue bucketQueue = new BucketQueue(this.queue);
        return bucketQueue.iterator(2, Math.min(n, bucketQueue.size(2)));
    }

    public synchronized Iterator getNormalHosts(int n) {
        BucketQueue bucketQueue = new BucketQueue(this.queue);
        return bucketQueue.iterator(1, n);
    }

    public synchronized void removeHost(String string, int n) {
        boolean bl;
        Endpoint endpoint = new Endpoint(string, n);
        boolean bl2 = this.set.remove((Object)endpoint);
        Assert.that(bl2 == (bl = this.queue.removeAll(endpoint)), "Rep. invariant for HostCatcher broken.");
    }

    public synchronized void clear() {
        this.queue.clear();
        this.set.clear();
        this.expire();
    }

    public synchronized void silentClear() {
        this.queue.clear();
        this.set.clear();
    }

    public synchronized void expire() {
        if (this.routerConnectorThreadStarted) {
            this.routerConnectorThread.interrupt();
        } else {
            this.connectToRouter();
        }
    }

    private boolean isMe(String string, int n) {
        byte[] byArray;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray[0] == 127) {
            return n == this.acceptor.getPort();
        }
        byte[] byArray2 = this.acceptor.getAddress();
        return Arrays.equals((byte[])byArray, (byte[])byArray2) && n == this.acceptor.getPort();
    }

    private static boolean isRouter(byte[] byArray) {
        return byArray[0] == 64 && byArray[1] == 61 && byArray[2] == 25 && (byArray[3] == -85 || byArray[3] >= -117 && byArray[3] <= -113);
    }

    public String toString() {
        return this.queue.toString();
    }

    public void setAlwaysNotifyKnownHost(boolean bl) {
        this.alwaysNotifyKnownHost = bl;
    }

    private class RouterConnectorThread
    extends Thread {
        RouterConnectorThread() {
            this.setDaemon(true);
            this.setName("RouterConnectorThread");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                HostCatcher.this.stale = true;
                Object object = HostCatcher.this.staleWaitersLock;
                synchronized (object) {
                    while (HostCatcher.this.staleWaiters == 0) {
                        try {
                            HostCatcher.this.staleWaitersLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.connectUntilPong();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                try {
                    Thread.sleep(172800000L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void connectUntilPong() throws InterruptedException {
            HostCatcher.this.gotGoodPong = false;
            while (!HostCatcher.this.gotGoodPong) {
                Object object;
                String[] stringArray = HostCatcher.this.settings.getQuickConnectHosts();
                int n = 0;
                while (n < stringArray.length && !HostCatcher.this.gotGoodPong) {
                    block14: {
                        try {
                            object = new Endpoint(stringArray[n]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            break block14;
                        }
                        try {
                            HostCatcher.this.manager.createRouterConnection(((Endpoint)object).getHostname(), ((Endpoint)object).getPort());
                        }
                        catch (IOException iOException) {
                            break block14;
                        }
                        Object object2 = HostCatcher.this.gotGoodPongLock;
                        synchronized (object2) {
                            if (!HostCatcher.this.gotGoodPong) {
                                HostCatcher.this.gotGoodPongLock.wait(6000L);
                            }
                        }
                    }
                    ++n;
                }
                if (HostCatcher.this.stale) {
                    object = HostCatcher.this.staleLock;
                    synchronized (object) {
                        HostCatcher.this.stale = false;
                        HostCatcher.this.staleLock.notifyAll();
                    }
                }
                if (HostCatcher.this.gotGoodPong) continue;
                Thread.sleep(300000L);
            }
        }
    }
}

