/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.sun.java.util.collections.Random;

public class GUID {
    private static final int SZ = 16;
    private static Random rand = new Random();
    private byte[] bytes;

    public GUID(byte[] byArray) {
        Assert.that(byArray.length == 16);
        this.bytes = byArray;
    }

    public static byte[] makeGuid() {
        byte[] byArray = new byte[16];
        rand.nextBytes(byArray);
        byArray[8] = -1;
        byArray[15] = 0;
        short s = ByteOrder.leb2short(byArray, 4);
        short s2 = ByteOrder.leb2short(byArray, 6);
        short s3 = GUID.tag(s, s2);
        ByteOrder.short2leb(s3, byArray, 9);
        return byArray;
    }

    private static short tag(short s, short s2) {
        int n = (s + 2) * (s2 + 3);
        short s3 = (short)(n >> 8);
        return s3;
    }

    public boolean isLimeGUID() {
        return GUID.isLimeGUID(this.bytes);
    }

    public static boolean isLimeGUID(byte[] byArray) {
        short s;
        short s2 = ByteOrder.leb2short(byArray, 4);
        short s3 = ByteOrder.leb2short(byArray, 6);
        short s4 = ByteOrder.leb2short(byArray, 9);
        return s4 == (s = GUID.tag(s2, s3));
    }

    public final boolean isWindowsGUID() {
        return GUID.isWindowsGUID(this.bytes);
    }

    public static boolean isWindowsGUID(byte[] byArray) {
        return (byArray[8] & 0xC0) == 128;
    }

    public final boolean isNewGUID() {
        return GUID.isNewGUID(this.bytes);
    }

    public static boolean isNewGUID(byte[] byArray) {
        return byArray[8] == -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GUID)) {
            return false;
        }
        Assert.that(object != null, "Null o in GUID.equals");
        byte[] byArray = ((GUID)object).bytes();
        Assert.that(this.bytes != null, "Null bytes in GUID.equals");
        Assert.that(byArray != null, "Null bytes2 in GUID.equals");
        int n = 0;
        while (n < 16) {
            if (this.bytes[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < 16) {
            n += this.bytes[n2];
            ++n2;
        }
        return n;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public String toString() {
        return this.toHexString();
    }

    public String toHexString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 16) {
            int n2 = ByteOrder.ubyte2int(this.bytes[n]);
            String string = Integer.toHexString(n2);
            while (string.length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static byte[] fromHexString(String string) throws IllegalArgumentException {
        byte[] byArray = new byte[16];
        try {
            int n = 0;
            while (n < 16) {
                byArray[n] = (byte)Integer.parseInt(string.substring(n * 2, n * 2 + 2), 16);
                ++n;
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }
}

