/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.FileComparator;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.IntSet;
import com.limegroup.gnutella.util.StringComparator;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import com.sun.java.util.collections.TreeSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class FileManager {
    public static final String INDEXING_QUERY = "    ";
    public static final String BROWSE_QUERY = "*.*";
    private long _size = 0L;
    private int _numFiles = 0;
    private ArrayList _files;
    private Trie _index;
    private Set _extensions;
    private Map _sharedDirectories;
    private Thread _loadThread;
    private Object _loadThreadLock = new Object();
    private static ActivityCallback _callback;
    public static final String DELIMETERS = " -._+/*()\\";
    private static boolean debugOn;

    private static final boolean isDelimeter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public FileManager() {
        this._files = new ArrayList();
        this._index = new Trie(true);
        this._extensions = new TreeSet((Comparator)new StringComparator());
        this._sharedDirectories = new TreeMap((Comparator)new FileComparator());
    }

    public void initialize(ActivityCallback activityCallback) {
        _callback = activityCallback;
        this.loadSettings(false);
    }

    public int getSize() {
        return ByteOrder.long2int(this._size);
    }

    public int getNumFiles() {
        return this._numFiles;
    }

    public FileDesc get(int n) throws IndexOutOfBoundsException {
        FileDesc fileDesc = (FileDesc)this._files.get(n);
        if (fileDesc == null) {
            throw new IndexOutOfBoundsException();
        }
        return fileDesc;
    }

    public synchronized File[] getSharedFiles(File file) {
        Object object;
        if (file != null) {
            try {
                file = FileManager.getCanonicalFile(file);
            }
            catch (IOException iOException) {
                return null;
            }
            IntSet intSet = (IntSet)this._sharedDirectories.get((Object)file);
            if (intSet == null) {
                return null;
            }
            File[] fileArray = new File[intSet.size()];
            IntSet.IntSetIterator intSetIterator = intSet.iterator();
            int n = 0;
            while (intSetIterator.hasNext()) {
                FileDesc fileDesc = (FileDesc)this._files.get(intSetIterator.next());
                Assert.that(fileDesc != null, "Directory has null entry");
                fileArray[n] = new File(fileDesc._path);
                ++n;
            }
            return fileArray;
        }
        ArrayList arrayList = new ArrayList(this._files.size());
        int n = 0;
        while (n < this._files.size()) {
            object = (FileDesc)this._files.get(n);
            if (object != null) {
                arrayList.add((Object)new File(object._path));
            }
            ++n;
        }
        object = new File[arrayList.size()];
        Object[] objectArray = arrayList.toArray(object);
        Assert.that(objectArray == object, "Couldn't fit list in returned value");
        return object;
    }

    public static File[] getFilesRecursive(File file, String[] stringArray) {
        FileManager.debug("FileManager.getFilesRecursive(): entered.");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        File[] fileArray = null;
        if (file.exists() && file.isDirectory()) {
            arrayList.add((Object)file);
        }
        while (arrayList.size() > 0) {
            File file2 = (File)arrayList.remove(0);
            FileManager.debug("FileManager.getFilesRecursive(): currDir = " + file2);
            String[] stringArray2 = file2.list();
            int n = 0;
            while (n < stringArray2.length) {
                File file3 = new File(file2, stringArray2[n]);
                if (file3.isDirectory()) {
                    arrayList.add((Object)file3);
                } else if (file3.isFile()) {
                    boolean bl = false;
                    if (stringArray == null) {
                        bl = true;
                    } else {
                        String string = FileManager.getFileExtension(file3);
                        int n2 = 0;
                        while (n2 < stringArray.length && string != null) {
                            if (string.equalsIgnoreCase(stringArray[n2])) {
                                bl = true;
                            }
                            ++n2;
                        }
                    }
                    if (bl) {
                        arrayList2.add((Object)file3);
                    }
                }
                ++n;
            }
        }
        if (!arrayList2.isEmpty()) {
            fileArray = new File[arrayList2.size()];
            int n = 0;
            while (n < fileArray.length) {
                fileArray[n] = (File)arrayList2.get(n);
                ++n;
            }
        }
        FileManager.debug("FileManager.getFilesRecursive(): returning.");
        return fileArray;
    }

    private static String getFileExtension(File file) {
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".");
        if (stringTokenizer.countTokens() > 1) {
            stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
        }
        return string;
    }

    public static void debug(String string) {
        if (debugOn) {
            System.out.println(string);
        }
    }

    public void loadSettings(boolean bl) {
        Object object = this._loadThreadLock;
        synchronized (object) {
            if (this._loadThread != null) {
                this._loadThread.interrupt();
                try {
                    this._loadThread.join();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            final boolean bl2 = bl;
            this._loadThread = new Thread("FileManager.loadSettingsBlocking"){

                public void run() {
                    FileManager.this.loadSettingsBlocking(bl2);
                }
            };
            this._loadThread.start();
        }
    }

    protected void loadSettingsBlocking(boolean bl) {
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        FileManager fileManager = this;
        synchronized (fileManager) {
            this._size = 0L;
            this._numFiles = 0;
            this._files = new ArrayList();
            this._index = new Trie(true);
            this._extensions = new TreeSet((Comparator)new StringComparator());
            this._sharedDirectories = new TreeMap((Comparator)new FileComparator());
            if (this._loadThread.isInterrupted()) {
                return;
            }
            objectArray2 = StringUtils.split(SettingsManager.instance().getExtensions().trim(), ';');
            n = 0;
            while (n < objectArray2.length && !this._loadThread.isInterrupted()) {
                this._extensions.add((Object)objectArray2[n].toLowerCase());
                ++n;
            }
            if (this._loadThread.isInterrupted()) {
                return;
            }
            Object[] objectArray3 = SettingsManager.instance().getDirectories();
            if (this._loadThread.isInterrupted()) {
                return;
            }
            Arrays.sort((Object[])objectArray3, (Comparator)new Comparator(){

                public int compare(Object object, Object object2) {
                    return object.toString().length() - object2.toString().length();
                }
            });
            objectArray = objectArray3;
        }
        objectArray2 = objectArray;
        if (bl) {
            _callback.clearSharedFiles();
        }
        n = 0;
        while (n < objectArray2.length && !this._loadThread.isInterrupted()) {
            this.addDirectory((File)objectArray2[n], null);
            ++n;
        }
        if (!this._loadThread.isInterrupted()) {
            this.trim();
        }
    }

    private void addDirectory(File file, File file2) {
        try {
            file = FileManager.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return;
        }
        File[] fileArray = FileManager.listFiles(file);
        if (fileArray == null) {
            return;
        }
        int n = fileArray.length;
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._sharedDirectories.get((Object)file) != null) {
                return;
            }
            this._sharedDirectories.put((Object)file, (Object)new IntSet());
            if (_callback != null) {
                _callback.addSharedDirectory(file, file2);
            }
        }
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n && !this._loadThread.isInterrupted()) {
            if (fileArray[n2].isDirectory()) {
                arrayList.add((Object)fileArray[n2]);
            } else {
                this.addFile(fileArray[n2]);
            }
            ++n2;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && !this._loadThread.isInterrupted()) {
            this.addDirectory((File)iterator.next(), file);
        }
    }

    public synchronized boolean addFileIfShared(File file) {
        File file2 = null;
        try {
            file2 = FileManager.getCanonicalFile(file);
            if (!file2.exists()) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        File file3 = FileManager.getParentFile(file);
        if (file3 == null) {
            return false;
        }
        if (this._sharedDirectories.containsKey((Object)file3)) {
            return this.addFile(file);
        }
        return false;
    }

    public synchronized boolean addFileIfShared(File file, LimeXMLDocument[] limeXMLDocumentArray) {
        return this.addFileIfShared(file);
    }

    private synchronized boolean addFile(File file) {
        String string = file.getAbsolutePath();
        String string2 = file.getName();
        if (this.hasExtension(string2)) {
            long l = file.length();
            if (l > Integer.MAX_VALUE || l < 0L) {
                return false;
            }
            this._size += l;
            this._files.add((Object)new FileDesc(this._files.size(), string2, string, (int)l));
            ++this._numFiles;
            int n = this._files.size() - 1;
            File file2 = FileManager.getParentFile(file);
            Assert.that(file2 != null, "Null parent to \"" + file + "\"");
            IntSet intSet = (IntSet)this._sharedDirectories.get((Object)file2);
            Assert.that(intSet != null, "Add directory \"" + file2 + "\" not in " + this._sharedDirectories);
            boolean bl = intSet.add(n);
            Assert.that(bl, "File " + n + " already found in " + intSet);
            if (_callback != null) {
                _callback.addSharedFile(file, file2);
            }
            String[] stringArray = StringUtils.split(string, DELIMETERS);
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                IntSet intSet2 = (IntSet)this._index.get(string3);
                if (intSet2 == null) {
                    intSet2 = new IntSet();
                    this._index.add(string3, intSet2);
                }
                intSet2.add(n);
                ++n2;
            }
            return true;
        }
        return false;
    }

    public synchronized boolean removeFileIfShared(File file) {
        try {
            file = FileManager.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            return false;
        }
        int n = 0;
        while (n < this._files.size()) {
            File file2;
            FileDesc fileDesc = (FileDesc)this._files.get(n);
            if (fileDesc != null && file.equals(file2 = new File(fileDesc._path))) {
                this._files.set(n, null);
                --this._numFiles;
                this._size -= (long)fileDesc._size;
                File file3 = FileManager.getParentFile(file);
                IntSet intSet = (IntSet)this._sharedDirectories.get((Object)file3);
                Assert.that(intSet != null, "Rem directory \"" + file3 + "\" not in " + this._sharedDirectories);
                boolean bl = intSet.remove(n);
                Assert.that(bl, "File " + n + " not found in " + intSet);
                String[] stringArray = StringUtils.split(fileDesc._path, DELIMETERS);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = stringArray[n2];
                    IntSet intSet2 = (IntSet)this._index.get(string);
                    if (intSet2 != null) {
                        intSet2.remove(n);
                    }
                    ++n2;
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean renameFileIfShared(File file, File file2) {
        boolean bl;
        ActivityCallback activityCallback;
        block5: {
            boolean bl2;
            block4: {
                activityCallback = _callback;
                _callback = null;
                try {
                    boolean bl3 = this.removeFileIfShared(file);
                    if (!bl3) {
                        boolean bl4 = false;
                        Object var10_6 = null;
                        _callback = activityCallback;
                        return bl4;
                    }
                    boolean bl5 = this.addFileIfShared(file2);
                    if (!bl5) {
                        bl2 = false;
                        break block4;
                    }
                    bl = true;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    _callback = activityCallback;
                    throw throwable;
                }
            }
            Object var10_7 = null;
            _callback = activityCallback;
            return bl2;
        }
        Object var10_8 = null;
        _callback = activityCallback;
        return bl;
    }

    private synchronized void trim() {
        this._index.trim(new Function(){

            public Object apply(Object object) {
                ((IntSet)object).trim();
                return object;
            }
        });
    }

    private boolean hasExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        return this._extensions.contains((Object)string2);
    }

    public static File getParentFile(File file) {
        String string = file.getParent();
        if (string == null) {
            return null;
        }
        try {
            return FileManager.getCanonicalFile(new File(string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File[] listFiles(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(file, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    public List getKeyWords() {
        File[] fileArray = this.getSharedFiles(null);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < fileArray.length) {
            arrayList.add((Object)fileArray[n].getAbsolutePath());
            ++n;
        }
        return arrayList;
    }

    public List getIndivisibleKeyWords() {
        return new ArrayList();
    }

    public static File getCanonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public synchronized Response[] query(QueryRequest queryRequest) {
        String string = queryRequest.getQuery();
        if (string.equals(INDEXING_QUERY) || string.equals(BROWSE_QUERY)) {
            if (this._numFiles == 0) {
                return null;
            }
            Response[] responseArray = new Response[this._numFiles];
            int n = 0;
            int n2 = 0;
            while (n2 < this._files.size()) {
                FileDesc fileDesc = (FileDesc)this._files.get(n2);
                if (fileDesc != null) {
                    Response response;
                    Assert.that(n < responseArray.length, "_numFiles is too small");
                    responseArray[n] = response = new Response(fileDesc._index, fileDesc._size, fileDesc._name);
                    ++n;
                }
                ++n2;
            }
            Assert.that(n == responseArray.length, "_numFiles is too large");
            return responseArray;
        }
        IntSet intSet = this.search(string);
        if (intSet == null) {
            return null;
        }
        Response[] responseArray = new Response[intSet.size()];
        int n = 0;
        IntSet.IntSetIterator intSetIterator = intSet.iterator();
        while (intSetIterator.hasNext()) {
            int n3 = intSetIterator.next();
            FileDesc fileDesc = (FileDesc)this._files.get(n3);
            responseArray[n] = new Response(fileDesc._index, fileDesc._size, fileDesc._name);
            ++n;
        }
        return responseArray;
    }

    public FileDesc file2index(String string) {
        int n = 0;
        while (n < this._files.size()) {
            FileDesc fileDesc = (FileDesc)this._files.get(n);
            if (fileDesc != null && fileDesc._path.equals(string)) {
                return fileDesc;
            }
            ++n;
        }
        return null;
    }

    protected IntSet search(String string) {
        IntSet intSet = null;
        int n = 0;
        while (n < string.length()) {
            if (FileManager.isDelimeter(string.charAt(n))) {
                ++n;
                continue;
            }
            int n2 = n + 1;
            while (n2 < string.length()) {
                if (FileManager.isDelimeter(string.charAt(n2))) break;
                ++n2;
            }
            Iterator iterator = this._index.getPrefixedBy(string, n, n2);
            if (iterator.hasNext()) {
                IntSet intSet2 = null;
                while (iterator.hasNext()) {
                    IntSet intSet3 = (IntSet)iterator.next();
                    if (intSet2 == null) {
                        if (n == 0 && n2 == string.length() && !iterator.hasNext()) {
                            return intSet3;
                        }
                        intSet2 = new IntSet();
                    }
                    intSet2.addAll(intSet3);
                }
                if (intSet == null) {
                    intSet = intSet2;
                } else {
                    intSet.retainAll(intSet2);
                }
            } else {
                return null;
            }
            if (intSet.size() == 0) {
                return null;
            }
            n = n2;
        }
        if (intSet == null || intSet.size() == 0) {
            return null;
        }
        return intSet;
    }

    public InputStream getInputStream(FileDesc fileDesc) throws IOException {
        String string = fileDesc._path;
        File file = new File(string);
        return new FileInputStream(file);
    }

    static {
        debugOn = false;
    }
}

