/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;

public class DownloadManager
implements BandwidthTracker {
    private ActivityCallback callback;
    private MessageRouter router;
    private Acceptor acceptor;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager = new IncompleteFileManager();
    private List active = new LinkedList();
    private List waiting = new LinkedList();

    public void initialize(ActivityCallback activityCallback, MessageRouter messageRouter, Acceptor acceptor, FileManager fileManager) {
        this.callback = activityCallback;
        this.router = messageRouter;
        this.acceptor = acceptor;
        this.fileManager = fileManager;
    }

    public int downloadsInProgress() {
        return this.active.size() + this.waiting.size();
    }

    private synchronized boolean writeSnapshot() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll((Collection)this.active);
        arrayList.addAll((Collection)this.waiting);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(SettingsManager.instance().getDownloadSnapshotFile()));
            objectOutputStream.writeObject(arrayList);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                objectOutputStream.writeObject(this.incompleteFileManager);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized boolean readSnapshot() {
        ObjectInputStream objectInputStream;
        List list = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(SettingsManager.instance().getDownloadSnapshotFile()));
            list = (List)objectInputStream.readObject();
            this.incompleteFileManager = (IncompleteFileManager)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if (this.incompleteFileManager.purge()) {
            this.writeSnapshot();
        }
        try {
            objectInputStream = list.iterator();
            while (objectInputStream.hasNext()) {
                ManagedDownloader managedDownloader = (ManagedDownloader)objectInputStream.next();
                this.waiting.add((Object)managedDownloader);
                managedDownloader.initialize(this, this.fileManager);
                this.callback.addDownload(managedDownloader);
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public synchronized Downloader getFiles(RemoteFileDesc[] remoteFileDescArray, boolean bl) throws FileExistsException, AlreadyDownloadingException, FileNotFoundException {
        Serializable serializable;
        String string = this.conflicts(remoteFileDescArray, null);
        if (string != null) {
            throw new AlreadyDownloadingException(string);
        }
        if (!bl) {
            serializable = SettingsManager.instance().getSaveDirectory();
            int n = 0;
            while (n < remoteFileDescArray.length) {
                String string2 = remoteFileDescArray[n].getFileName();
                File file = new File((File)serializable, string2);
                if (file.exists()) {
                    throw new FileExistsException(string2);
                }
                ++n;
            }
        }
        this.incompleteFileManager.purge();
        serializable = new ManagedDownloader(this, remoteFileDescArray, this.fileManager, this.incompleteFileManager);
        this.waiting.add((Object)serializable);
        this.callback.addDownload((Downloader)((Object)serializable));
        this.writeSnapshot();
        return serializable;
    }

    public synchronized String conflicts(RemoteFileDesc[] remoteFileDescArray, ManagedDownloader managedDownloader) {
        int n = 0;
        while (n < remoteFileDescArray.length) {
            Object object;
            Iterator iterator = this.active.iterator();
            while (iterator.hasNext()) {
                object = (ManagedDownloader)iterator.next();
                if (managedDownloader != null && object == managedDownloader || !((ManagedDownloader)object).conflicts(remoteFileDescArray[n])) continue;
                return remoteFileDescArray[n].getFileName();
            }
            object = this.waiting.iterator();
            while (object.hasNext()) {
                ManagedDownloader managedDownloader2 = (ManagedDownloader)object.next();
                if (managedDownloader != null && managedDownloader2 == managedDownloader || !managedDownloader2.conflicts(remoteFileDescArray[n])) continue;
                return remoteFileDescArray[n].getFileName();
            }
            ++n;
        }
        return null;
    }

    public void acceptDownload(Socket socket) {
        try {
            GIVLine gIVLine = DownloadManager.parseGIV(socket);
            String string = gIVLine.file;
            int n = gIVLine.index;
            byte[] byArray = gIVLine.clientGUID;
            DownloadManager downloadManager = this;
            synchronized (downloadManager) {
                Object object;
                Iterator iterator = this.active.iterator();
                while (iterator.hasNext()) {
                    object = (ManagedDownloader)iterator.next();
                    if (!((ManagedDownloader)object).acceptDownload(string, socket, n, byArray)) continue;
                    return;
                }
                object = this.waiting.iterator();
                while (object.hasNext()) {
                    ManagedDownloader managedDownloader = (ManagedDownloader)object.next();
                    if (!managedDownloader.acceptDownload(string, socket, n, byArray)) continue;
                    return;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean hasFreeSlot() {
        SettingsManager settingsManager = SettingsManager.instance();
        return this.active.size() < settingsManager.getMaxSimDownload();
    }

    public synchronized void waitForSlot(ManagedDownloader managedDownloader) throws InterruptedException {
        while (!this.hasFreeSlot()) {
            this.wait();
        }
        this.waiting.remove((Object)managedDownloader);
        this.active.add((Object)managedDownloader);
    }

    public synchronized void yieldSlot(ManagedDownloader managedDownloader) {
        Assert.that(managedDownloader != null, "Null downloader");
        Assert.that(this.active != null, "Null active");
        Assert.that(this.waiting != null, "Null waiting");
        this.active.remove((Object)managedDownloader);
        this.waiting.add((Object)managedDownloader);
        this.notify();
    }

    public synchronized void remove(ManagedDownloader managedDownloader, boolean bl) {
        this.active.remove((Object)managedDownloader);
        this.waiting.remove((Object)managedDownloader);
        this.notify();
        this.callback.removeDownload(managedDownloader);
        this.writeSnapshot();
        if (this.active.isEmpty() && this.waiting.isEmpty()) {
            this.callback.downloadsComplete();
        }
    }

    public boolean sendPush(RemoteFileDesc remoteFileDesc) {
        PushRequest pushRequest = new PushRequest(GUID.makeGuid(), SettingsManager.instance().getTTL(), remoteFileDesc.getClientGUID(), remoteFileDesc.getIndex(), this.acceptor.getAddress(), this.acceptor.getPort());
        try {
            this.router.sendPushRequest(pushRequest);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static GIVLine parseGIV(Socket socket) throws IOException {
        socket.setSoTimeout(SettingsManager.instance().getTimeout());
        InputStream inputStream = null;
        try {
            inputStream = socket.getInputStream();
        }
        catch (Exception exception) {
            throw new IOException();
        }
        ByteReader byteReader = new ByteReader(inputStream);
        String string = byteReader.readLine();
        if (string == null) {
            throw new IOException();
        }
        String string2 = byteReader.readLine();
        if (string2 == null || !string2.equals("")) {
            throw new IOException();
        }
        try {
            int n = string.indexOf(":");
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = string.indexOf("/", n);
            byte[] byArray = GUID.fromHexString(string.substring(n + 1, n3));
            String string3 = string.substring(n3 + 1);
            return new GIVLine(string3, n2, byArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException();
        }
    }

    public synchronized void measureBandwidth() {
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            bandwidthTracker.measureBandwidth();
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float f = 0.0f;
        Iterator iterator = this.active.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            f += bandwidthTracker.getMeasuredBandwidth();
        }
        return f;
    }

    public void internalError(Throwable throwable) {
        this.callback.error(3, throwable);
    }

    private static class GIVLine {
        String file;
        int index;
        byte[] clientGUID;

        GIVLine(String string, int n, byte[] byArray) {
            this.clientGUID = byArray;
            this.file = string;
            this.index = n;
            this.clientGUID = byArray;
        }
    }
}

