/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingRequest;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;

public class ConnectionWatchdog
implements Runnable {
    private static final int EVALUATE_TIME = 10000;
    private static final int REEVALUATE_TIME = 8000;
    private ConnectionManager manager;
    private MessageRouter router;

    public ConnectionWatchdog(ConnectionManager connectionManager, MessageRouter messageRouter) {
        this.manager = connectionManager;
        this.router = messageRouter;
    }

    private List findDuds() {
        ManagedConnection managedConnection;
        HashMap hashMap = new HashMap();
        Iterator iterator = this.allConnections();
        while (iterator.hasNext()) {
            managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isKillable()) continue;
            hashMap.put((Object)managedConnection, (Object)new ConnectionState(managedConnection));
        }
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        managedConnection = new ArrayList();
        Iterator iterator2 = this.allConnections();
        while (iterator2.hasNext()) {
            ConnectionState connectionState;
            ConnectionState connectionState2;
            Object object;
            ManagedConnection managedConnection2 = (ManagedConnection)iterator2.next();
            if (!managedConnection2.isKillable() || (object = hashMap.get((Object)managedConnection2)) == null || !(connectionState2 = new ConnectionState(managedConnection2)).notProgressedSince(connectionState = (ConnectionState)object)) continue;
            managedConnection.add(managedConnection2);
        }
        return managedConnection;
    }

    private void killIfStillDud(List list) {
        ManagedConnection managedConnection;
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isKillable()) continue;
            hashMap.put((Object)managedConnection, (Object)new ConnectionState(managedConnection));
            managedConnection.setHorizonEnabled(false);
            this.router.sendPingRequest(new PingRequest(2), managedConnection);
        }
        try {
            Thread.currentThread();
            Thread.sleep(8000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        managedConnection = list.iterator();
        while (managedConnection.hasNext()) {
            ConnectionState connectionState;
            ConnectionState connectionState2;
            ManagedConnection managedConnection2 = (ManagedConnection)managedConnection.next();
            if (!managedConnection2.isKillable()) continue;
            managedConnection2.setHorizonEnabled(true);
            Object object = hashMap.get((Object)managedConnection2);
            if (object == null || !(connectionState2 = new ConnectionState(managedConnection2)).notProgressedSince(connectionState = (ConnectionState)object)) continue;
            this.manager.remove(managedConnection2);
        }
    }

    public void run() {
        while (true) {
            List list;
            if ((list = this.findDuds()).size() <= 0) {
                continue;
            }
            this.killIfStillDud(list);
        }
    }

    private Iterator allConnections() {
        List list = this.manager.getInitializedConnections();
        List list2 = this.manager.getInitializedClientConnections();
        ArrayList arrayList = new ArrayList(list.size() + list2.size());
        arrayList.addAll((Collection)list);
        arrayList.addAll((Collection)list2);
        return arrayList.iterator();
    }

    private static class ConnectionState {
        long sentDropped;
        long sent;
        long received;

        ConnectionState(ManagedConnection managedConnection) {
            this.sentDropped = managedConnection.getNumSentMessagesDropped();
            this.sent = managedConnection.getNumMessagesSent();
            this.received = managedConnection.getNumMessagesReceived();
        }

        boolean notProgressedSince(ConnectionState connectionState) {
            long l = this.sent - connectionState.sent;
            long l2 = this.sentDropped - connectionState.sentDropped;
            long l3 = this.received - connectionState.received;
            if (l == l2 && l != 0L) {
                return true;
            }
            return l3 == 0L;
        }

        public String toString() {
            return "{sent: " + this.sent + ", sdropped: " + this.sentDropped + "}";
        }
    }
}

