/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GroupPingRequest;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.SettingsManager;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConnectionManager {
    private volatile List _initializedConnections = new ArrayList();
    private volatile List _connections = new ArrayList();
    private volatile Set _endpoints = new HashSet();
    private List _fetchers = new ArrayList();
    private List _initializingFetchedConnections = new ArrayList();
    private volatile List _initializedClientConnections = new ArrayList();
    private volatile int _keepAlive = 0;
    private volatile int _incomingConnections = 0;
    private volatile int _incomingClientConnections = 0;
    private Object _incomingConnectionsLock = new Object();
    private MessageRouter _router;
    private HostCatcher _catcher;
    private ActivityCallback _callback;
    private SettingsManager _settings;
    private ConnectionWatchdog _watchdog;
    private Runnable _ultraFastCheck;
    public static final int MIN_CONNECTIONS_FOR_SUPERNODE = 6;
    public static final int PREFERRED_CONNECTIONS_FOR_LEAF = 3;
    private int MAX_SUPERNODE_ENDPOINTS = 10;

    public ConnectionManager(ActivityCallback activityCallback) {
        this._callback = activityCallback;
        this._settings = SettingsManager.instance();
    }

    public void initialize(MessageRouter messageRouter, HostCatcher hostCatcher) {
        this._router = messageRouter;
        this._catcher = hostCatcher;
        this._watchdog = new ConnectionWatchdog(this, this._router);
        Thread thread = new Thread(this._watchdog);
        thread.setDaemon(true);
        thread.start();
        if (this._settings.getConnectOnStartup()) {
            this.setKeepAlive(this._settings.getKeepAlive());
        }
    }

    public ManagedConnection createConnectionBlocking(String string, int n) throws IOException {
        ManagedConnection managedConnection = new ManagedConnection(string, n, this._router, this);
        this.initializeExternallyGeneratedConnection(managedConnection);
        new OutgoingConnectionThread(managedConnection, false);
        return managedConnection;
    }

    public void createConnectionAsynchronously(String string, int n) {
        new OutgoingConnectionThread(new ManagedConnection(string, n, this._router, this), true);
    }

    public ManagedConnection createRouterConnection(String string, int n) throws IOException {
        if (string.equals("router.limewire.com")) {
            string = SettingsManager.DEDICATED_LIMEWIRE_ROUTER;
        }
        ManagedConnection managedConnection = new ManagedConnection(string, n, this._router, this, true);
        this.initializeExternallyGeneratedConnection(managedConnection);
        new OutgoingConnectionThread(managedConnection, false);
        return managedConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void acceptConnection(Socket socket) {
        Connection connection = null;
        try {
            connection = new ManagedConnection(socket, this._router, this);
            this.initializeExternallyGeneratedConnection((ManagedConnection)connection);
        }
        catch (IOException iOException) {
            if (connection == null) return;
            connection.close();
            return;
        }
        try {
            try {
                Object object2 = this._incomingConnectionsLock;
                // MONITORENTER : object2
                if (((ManagedConnection)connection).isSupernodeClientConnection()) {
                    ++this._incomingClientConnections;
                } else {
                    ++this._incomingConnections;
                }
                // MONITOREXIT : object2
                if (((ManagedConnection)connection).isSupernodeClientConnection()) {
                    this.ensureConnectionsForSupernode();
                }
                this.sendInitialPingRequest((ManagedConnection)connection);
                ((ManagedConnection)connection).loopForMessages();
            }
            catch (IOException iOException) {
                Object var6_7 = null;
                Object object = this._incomingConnectionsLock;
                // MONITORENTER : object
                if (((ManagedConnection)connection).isSupernodeClientConnection()) {
                    --this._incomingClientConnections;
                } else {
                    --this._incomingConnections;
                }
                if (((ManagedConnection)connection).isClientSupernodeConnection()) {
                    this.lostShieldedClientSupernodeConnection();
                }
                // MONITOREXIT : object
                return;
            }
            catch (Exception exception) {
                this._callback.error(2, exception);
                Object var6_8 = null;
                Object object = this._incomingConnectionsLock;
                // MONITORENTER : object
                if (((ManagedConnection)connection).isSupernodeClientConnection()) {
                    --this._incomingClientConnections;
                } else {
                    --this._incomingConnections;
                }
                if (((ManagedConnection)connection).isClientSupernodeConnection()) {
                    this.lostShieldedClientSupernodeConnection();
                }
                // MONITOREXIT : object
                return;
            }
            Object var6_6 = null;
            Object object = this._incomingConnectionsLock;
            // MONITORENTER : object
            if (((ManagedConnection)connection).isSupernodeClientConnection()) {
                --this._incomingClientConnections;
            } else {
                --this._incomingConnections;
            }
            if (((ManagedConnection)connection).isClientSupernodeConnection()) {
                this.lostShieldedClientSupernodeConnection();
            }
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Object object4 = this._incomingConnectionsLock;
            // MONITORENTER : object4
            if (((ManagedConnection)connection).isSupernodeClientConnection()) {
                --this._incomingClientConnections;
            } else {
                --this._incomingConnections;
            }
            if (((ManagedConnection)connection).isClientSupernodeConnection()) {
                this.lostShieldedClientSupernodeConnection();
            }
            // MONITOREXIT : object4
            throw throwable;
        }
    }

    public synchronized void remove(ManagedConnection managedConnection) {
        this.removeInternal(managedConnection);
        this.adjustConnectionFetchers();
    }

    public int getKeepAlive() {
        return this._keepAlive;
    }

    public synchronized void reduceConnections() {
        int n = Math.min(this._keepAlive, 2);
        this.setKeepAlive(n);
    }

    public synchronized void setKeepAlive(int n) {
        this._keepAlive = n;
        this.adjustConnectionFetchers();
    }

    public synchronized void ensureConnectionsForSupernode() {
        if (this._incomingClientConnections > 0 && this._keepAlive < 6) {
            this.setKeepAlive(6);
        }
    }

    public boolean isSupernode() {
        boolean bl = SettingsManager.instance().getEverSupernodeCapable();
        return bl && !this.hasClientSupernodeConnection();
    }

    public boolean hasClientSupernodeConnection() {
        List list = this.getInitializedConnections();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (managedConnection.isClientSupernodeConnection()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasSupernodeClientConnection() {
        return this._incomingClientConnections > 0;
    }

    public boolean isConnected(Endpoint endpoint) {
        return this._endpoints.contains((Object)endpoint);
    }

    public int getNumConnections() {
        return this._connections.size();
    }

    private int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    public boolean isConnected() {
        return this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0;
    }

    public void measureBandwidth() {
        List list = this.getInitializedConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            managedConnection.measureBandwidth();
        }
    }

    public float getMeasuredUpstreamBandwidth() {
        float f = 0.0f;
        List list = this.getInitializedConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            f += managedConnection.getMeasuredUpstreamBandwidth();
        }
        return f;
    }

    public float getMeasuredDownstreamBandwidth() {
        float f = 0.0f;
        List list = this.getInitializedConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            f += managedConnection.getMeasuredDownstreamBandwidth();
        }
        return f;
    }

    public boolean hasAvailableIncoming(boolean bl) {
        SettingsManager settingsManager = SettingsManager.instance();
        if (this._keepAlive <= 0) {
            return false;
        }
        if (this.hasClientSupernodeConnection()) {
            return false;
        }
        if (bl) {
            int n = SettingsManager.instance().getMaxShieldedClientConnections();
            return this._incomingClientConnections < n;
        }
        return this._incomingConnections < this._keepAlive;
    }

    public boolean supernodeNeeded() {
        return this.isSupernode() && (double)this._incomingClientConnections > (double)SettingsManager.instance().getMaxShieldedClientConnections() * 0.7;
    }

    public List getInitializedConnections() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll((Collection)this._initializedConnections);
        return arrayList;
    }

    public List getInitializedClientConnections() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll((Collection)this._initializedClientConnections);
        return arrayList;
    }

    List getInitializedConnections2() {
        return this._initializedConnections;
    }

    List getInitializedClientConnections2() {
        return this._initializedClientConnections;
    }

    public List getConnections() {
        ArrayList arrayList = new ArrayList((Collection)this._connections);
        return arrayList;
    }

    public Set getSupernodeEndpoints() {
        ManagedConnection managedConnection;
        HashSet hashSet = new HashSet();
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeConnection()) continue;
            hashSet.add((Object)new Endpoint(managedConnection.getInetAddress().getAddress(), managedConnection.getOrigPort()));
        }
        managedConnection = this._catcher.getUltrapeerHosts(this.MAX_SUPERNODE_ENDPOINTS);
        while (managedConnection.hasNext()) {
            Endpoint endpoint = (Endpoint)managedConnection.next();
            hashSet.add((Object)endpoint);
        }
        return hashSet;
    }

    public Endpoint getSelfAddress() {
        return new Endpoint(this._router.getAddress(), this._router.getPort());
    }

    private void connectionInitializing(Connection connection) {
        ArrayList arrayList = new ArrayList((Collection)this._connections);
        arrayList.add((Object)connection);
        this._connections = arrayList;
    }

    private void connectionInitialized(ManagedConnection managedConnection) {
        if (this._connections.contains((Object)managedConnection)) {
            ArrayList arrayList;
            if (!managedConnection.isSupernodeClientConnection()) {
                arrayList = new ArrayList((Collection)this._initializedConnections);
                arrayList.add((Object)managedConnection);
                this._initializedConnections = arrayList;
            } else {
                arrayList = new ArrayList((Collection)this._initializedClientConnections);
                arrayList.add((Object)managedConnection);
                this._initializedClientConnections = arrayList;
            }
            arrayList = new HashSet((Collection)this._endpoints);
            arrayList.add((Object)new Endpoint(managedConnection.getInetAddress().getHostAddress(), managedConnection.getPort()));
            this._endpoints = arrayList;
        }
        if (this._ultraFastCheck != null) {
            this._ultraFastCheck.run();
        }
    }

    public void activateUltraFastConnectShutdown() {
        this._ultraFastCheck = new AllowUltraFastConnect();
    }

    public void deactivateUltraFastConnectShutdown() {
        this._ultraFastCheck = null;
    }

    public synchronized void disconnect() {
        this.deactivateUltraFastConnectShutdown();
        SettingsManager settingsManager = SettingsManager.instance();
        int n = settingsManager.getKeepAlive();
        this.setKeepAlive(0);
        Iterator iterator = this.getConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            this.remove(managedConnection);
        }
    }

    public synchronized void connect() {
        boolean bl;
        SettingsManager settingsManager = SettingsManager.instance();
        boolean bl2 = bl = !settingsManager.getUseQuickConnect() && this._catcher.getNumHosts() == 0;
        if (bl) {
            settingsManager.setUseQuickConnect(true);
            this.disconnect();
        }
        this._catcher.expire();
        int n = settingsManager.getKeepAlive();
        if (n < 1) {
            n = 4;
            settingsManager.setKeepAlive(n);
        }
        if (n < 10) {
            n = 10;
            this.activateUltraFastConnectShutdown();
        }
        this.setKeepAlive(n);
        if (bl) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SettingsManager.instance().setUseQuickConnect(false);
        }
    }

    private void sendInitialPingRequest(ManagedConnection managedConnection) {
        PingRequest pingRequest = this.getNumInitializedConnections() >= this._keepAlive ? new PingRequest(1) : new PingRequest(SettingsManager.instance().getTTL());
        managedConnection.send(pingRequest);
        try {
            managedConnection.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeInternal(ManagedConnection managedConnection) {
        int n;
        ArrayList arrayList;
        int n2;
        boolean bl = false;
        if (!managedConnection.isSupernodeClientConnection()) {
            n2 = this._initializedConnections.indexOf((Object)managedConnection);
            if (n2 != -1) {
                bl = true;
                arrayList = new ArrayList();
                arrayList.addAll((Collection)this._initializedConnections);
                arrayList.remove((Object)managedConnection);
                this._initializedConnections = arrayList;
            }
        } else {
            n2 = this._initializedClientConnections.indexOf((Object)managedConnection);
            if (n2 != -1) {
                bl = true;
                arrayList = new ArrayList();
                arrayList.addAll((Collection)this._initializedClientConnections);
                arrayList.remove((Object)managedConnection);
                this._initializedClientConnections = arrayList;
            }
        }
        if (bl) {
            HashSet hashSet = new HashSet();
            hashSet.addAll((Collection)this._endpoints);
            hashSet.remove((Object)new Endpoint(managedConnection.getInetAddress().getHostAddress(), managedConnection.getPort()));
            this._endpoints = hashSet;
        }
        if ((n = this._connections.indexOf((Object)managedConnection)) != -1) {
            arrayList = new ArrayList((Collection)this._connections);
            arrayList.remove((Object)managedConnection);
            this._connections = arrayList;
        }
        managedConnection.close();
        this._router.removeConnection(managedConnection);
        this._callback.connectionClosed(managedConnection);
    }

    private void adjustConnectionFetchers() {
        int n = this.getNumConnections() - this._initializedClientConnections.size();
        int n2 = this._keepAlive - n - this._fetchers.size();
        while (n2 > 0) {
            new ConnectionFetcher();
            --n2;
        }
        int n3 = this._fetchers.size();
        while (n2 < 0 && n3 > 0) {
            ConnectionFetcher connectionFetcher = (ConnectionFetcher)this._fetchers.remove(--n3);
            connectionFetcher.interrupt();
            ++n2;
        }
        int n4 = this._initializingFetchedConnections.size();
        while (n2 < 0 && n4 > 0) {
            ManagedConnection managedConnection = (ManagedConnection)this._initializingFetchedConnections.remove(--n4);
            this.removeInternal(managedConnection);
            ++n2;
        }
    }

    private void initializeFetchedConnection(ManagedConnection managedConnection, ConnectionFetcher connectionFetcher) throws IOException {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (connectionFetcher.isInterrupted()) {
                throw new IOException();
            }
            this._initializingFetchedConnections.add((Object)managedConnection);
            this._fetchers.remove((Object)connectionFetcher);
            this.connectionInitializing(managedConnection);
        }
        this._callback.connectionInitializing(managedConnection);
        try {
            try {
                managedConnection.initialize();
            }
            catch (IOException iOException) {
                ConnectionManager connectionManager2 = this;
                synchronized (connectionManager2) {
                    this._initializingFetchedConnections.remove((Object)managedConnection);
                    this.removeInternal(managedConnection);
                    this.adjustConnectionFetchers();
                }
                throw iOException;
            }
            Object var8_7 = null;
            this.processConnectionHeaders(managedConnection);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.processConnectionHeaders(managedConnection);
            throw throwable;
        }
        boolean bl = false;
        ConnectionManager connectionManager3 = this;
        synchronized (connectionManager3) {
            this._initializingFetchedConnections.remove((Object)managedConnection);
            if (this._connections.contains((Object)managedConnection)) {
                this.connectionInitialized(managedConnection);
                bl = true;
            }
        }
        if (bl) {
            this._callback.connectionInitialized(managedConnection);
            if (managedConnection.isClientSupernodeConnection()) {
                this.gotShieldedClientSupernodeConnection(managedConnection);
            }
        }
    }

    private synchronized void gotShieldedClientSupernodeConnection(ManagedConnection managedConnection) {
        boolean bl = this._ultraFastCheck != null && this._keepAlive > 0;
        this.deactivateUltraFastConnectShutdown();
        if (bl) {
            this.setKeepAlive(3);
        }
    }

    private synchronized void lostShieldedClientSupernodeConnection() {
        if (this._keepAlive > 0 && !this.hasClientSupernodeConnection()) {
            this.connect();
        }
    }

    private void processConnectionHeaders(ManagedConnection managedConnection) {
        Properties properties = managedConnection.getHeaders();
        if (properties == null) {
            return;
        }
        this.updateHostCache(properties, managedConnection);
        String string = properties.getProperty("X-My-Address");
        if (string != null && !managedConnection.isOutgoing()) {
            try {
                managedConnection.setOrigPort(Integer.parseInt(string.substring(string.indexOf(58) + 1).trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean allowClientMode() {
        return !this._settings.getForceSupernodeMode() && (!this.isSupernode() || this._incomingClientConnections <= 0);
    }

    private void updateHostCache(Properties properties, ManagedConnection managedConnection) {
        this.updateHostCache(properties.getProperty("X-Try-Ultrapeers"), managedConnection, true);
        this.updateHostCache(properties.getProperty("X-Try"), managedConnection, false);
    }

    private void updateHostCache(String string, ManagedConnection managedConnection, boolean bl) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Endpoint endpoint;
            String string2 = stringTokenizer.nextToken().trim();
            try {
                endpoint = new Endpoint(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            this._catcher.add(endpoint, bl);
        }
    }

    private void initializeExternallyGeneratedConnection(ManagedConnection managedConnection) throws IOException {
        ConnectionManager connectionManager;
        if (managedConnection.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializing(managedConnection);
                this.adjustConnectionFetchers();
            }
            this._callback.connectionInitializing(managedConnection);
        }
        try {
            try {
                managedConnection.initialize();
            }
            catch (IOException iOException) {
                this.remove(managedConnection);
                throw iOException;
            }
            Object var5_7 = null;
            this.processConnectionHeaders(managedConnection);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.processConnectionHeaders(managedConnection);
            throw throwable;
        }
        if (!managedConnection.isOutgoing() && !this.hasAvailableIncoming(managedConnection.isSupernodeClientConnection())) {
            managedConnection.loopToReject(this._catcher);
            throw new IOException("No space for connection");
        }
        if (!managedConnection.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializing(managedConnection);
                this.adjustConnectionFetchers();
            }
            this._callback.connectionInitializing(managedConnection);
        }
        boolean bl = false;
        ConnectionManager connectionManager2 = this;
        synchronized (connectionManager2) {
            if (this._connections.contains((Object)managedConnection)) {
                this.connectionInitialized(managedConnection);
                bl = true;
            }
        }
        if (bl) {
            this._callback.connectionInitialized(managedConnection);
            if (managedConnection.isClientSupernodeConnection()) {
                this.gotShieldedClientSupernodeConnection(managedConnection);
            }
        }
    }

    public ManagedConnection createGroupConnectionBlocking(String string, int n, GroupPingRequest groupPingRequest) throws IOException {
        ManagedConnection managedConnection = new ManagedConnection(string, n, this._router, this, true);
        this.initializeExternallyGeneratedConnection(managedConnection);
        new GroupOutgoingConnectionThread(managedConnection, groupPingRequest);
        return managedConnection;
    }

    public synchronized Iterator getNormalHosts(int n) {
        return this._catcher.getNormalHosts(n);
    }

    private class ConnectionFetcher
    extends Thread {
        public ConnectionFetcher() {
            ConnectionManager.this._fetchers.add((Object)this);
            this.setDaemon(true);
            this.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Endpoint endpoint = null;
            do {
                try {
                    endpoint = ConnectionManager.this._catcher.getAnEndpoint();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            } while (ConnectionManager.this.isConnected(endpoint));
            Assert.that(endpoint != null);
            ManagedConnection managedConnection = new ManagedConnection(endpoint.getHostname(), endpoint.getPort(), ConnectionManager.this._router, ConnectionManager.this);
            try {
                try {
                    ConnectionManager.this.initializeFetchedConnection(managedConnection, this);
                    ConnectionManager.this.sendInitialPingRequest(managedConnection);
                    managedConnection.loopForMessages();
                }
                catch (IOException iOException) {
                    Object var6_5 = null;
                    if (!managedConnection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                catch (Exception exception) {
                    ConnectionManager.this._callback.error(2, exception);
                    Object var6_6 = null;
                    if (!managedConnection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                Object var6_4 = null;
                if (!managedConnection.isClientSupernodeConnection()) return;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!managedConnection.isClientSupernodeConnection()) throw throwable;
                ConnectionManager.this.lostShieldedClientSupernodeConnection();
                throw throwable;
            }
            ConnectionManager.this.lostShieldedClientSupernodeConnection();
        }
    }

    private class GroupOutgoingConnectionThread
    extends Thread {
        private ManagedConnection _connection;
        private PingRequest _specialPing;

        public GroupOutgoingConnectionThread(ManagedConnection managedConnection, PingRequest pingRequest) {
            this._connection = managedConnection;
            this._specialPing = pingRequest;
            this.setDaemon(true);
            this.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    ConnectionManager.this._router.sendPingRequest(this._specialPing, this._connection);
                    this._connection.loopForMessages();
                }
                catch (IOException iOException) {
                    Object var4_2 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                catch (Exception exception) {
                    ConnectionManager.this._callback.error(2, exception);
                    Object var4_3 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                Object var4_1 = null;
                if (!this._connection.isClientSupernodeConnection()) return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!this._connection.isClientSupernodeConnection()) throw throwable;
                ConnectionManager.this.lostShieldedClientSupernodeConnection();
                throw throwable;
            }
            ConnectionManager.this.lostShieldedClientSupernodeConnection();
        }
    }

    private class OutgoingConnectionThread
    extends Thread {
        private ManagedConnection _connection;
        private boolean _doInitialization;

        public OutgoingConnectionThread(ManagedConnection managedConnection, boolean bl) {
            this._connection = managedConnection;
            this._doInitialization = bl;
            this.setDaemon(true);
            this.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    String string;
                    if (this._doInitialization) {
                        ConnectionManager.this.initializeExternallyGeneratedConnection(this._connection);
                    }
                    if ((string = this._connection.getOrigHost()) != null && string.equals(SettingsManager.DEDICATED_LIMEWIRE_ROUTER)) {
                        String string2 = "none:" + ConnectionManager.this._settings.getConnectionSpeed();
                        GroupPingRequest groupPingRequest = ConnectionManager.this._router.createGroupPingRequest(string2);
                        this._connection.send(groupPingRequest);
                        this._connection.flush();
                    } else {
                        ConnectionManager.this.sendInitialPingRequest(this._connection);
                    }
                    this._connection.loopForMessages();
                }
                catch (IOException iOException) {
                    Object var5_7 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                catch (Exception exception) {
                    ConnectionManager.this._callback.error(2, exception);
                    Object var5_8 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                Object var5_6 = null;
                if (!this._connection.isClientSupernodeConnection()) return;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (!this._connection.isClientSupernodeConnection()) throw throwable;
                ConnectionManager.this.lostShieldedClientSupernodeConnection();
                throw throwable;
            }
            ConnectionManager.this.lostShieldedClientSupernodeConnection();
        }
    }

    private class AllowUltraFastConnect
    implements Runnable {
        private AllowUltraFastConnect() {
        }

        public void run() {
            SettingsManager settingsManager = SettingsManager.instance();
            int n = settingsManager.getKeepAlive();
            int n2 = Math.min(n, 3);
            Iterator iterator = ConnectionManager.this.getConnections().iterator();
            while (iterator.hasNext()) {
                ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                if (managedConnection.getNumMessagesReceived() < 4) continue;
                --n2;
            }
            if (n2 <= 0) {
                ConnectionManager.this.setKeepAlive(n);
                ConnectionManager.this.deactivateUltraFastConnectShutdown();
            }
        }
    }
}

