/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.HandshakeResponder;
import com.limegroup.gnutella.HandshakeResponse;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.SettingsManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Connection {
    private String _host;
    private int _port;
    private Socket _socket;
    private InputStream _in;
    private OutputStream _out;
    private boolean _outgoing;
    private volatile boolean _closed = false;
    private Properties _propertiesRead;
    private Properties _propertiesWrittenP;
    private HandshakeResponder _propertiesWrittenR;
    private Properties _propertiesWrittenTotal = new Properties();
    private boolean _negotiate = false;
    public static final String GNUTELLA_CONNECT_04 = "GNUTELLA CONNECT/0.4";
    public static final String GNUTELLA_OK_04 = "GNUTELLA OK";
    public static final String GNUTELLA_CONNECT_06 = "GNUTELLA CONNECT/0.6";
    public static final String GNUTELLA_OK_06 = "GNUTELLA/0.6 200 OK";
    public static final String GNUTELLA_06 = "GNUTELLA/0.6";
    public static final String _200_OK = " 200 OK";
    public static final String CONNECT = "CONNECT/";
    public static final String CRLF = "\r\n";
    public static final String LF = "\n";
    private byte[] HEADER_BUF = new byte[23];

    public Connection(String string, int n) {
        this(string, n, null, null, false);
    }

    public Connection(String string, int n, Properties properties, HandshakeResponder handshakeResponder, boolean bl) {
        this._host = string;
        this._port = n;
        this._outgoing = true;
        this._negotiate = bl;
        this._propertiesWrittenP = properties;
        this._propertiesWrittenR = handshakeResponder;
    }

    public Connection(Socket socket) {
        this(socket, null);
    }

    public Connection(Socket socket, HandshakeResponder handshakeResponder) {
        this._host = socket.getInetAddress().getHostAddress();
        this._port = socket.getPort();
        this._socket = socket;
        this._outgoing = false;
        this._propertiesWrittenR = handshakeResponder;
    }

    public void initialize() throws IOException {
        try {
            this.initializeWithoutRetry();
        }
        catch (NoGnutellaOkException noGnutellaOkException) {
            throw noGnutellaOkException;
        }
        catch (BadHandshakeException badHandshakeException) {
            this._propertiesRead = null;
            if (this._negotiate && this.isOutgoing() && this._propertiesWrittenP != null && this._propertiesWrittenR != null) {
                this._propertiesWrittenP = null;
                this._propertiesWrittenR = null;
                this.initializeWithoutRetry();
            }
            throw badHandshakeException;
        }
    }

    private void initializeWithoutRetry() throws IOException {
        SettingsManager settingsManager = SettingsManager.instance();
        if (this.isOutgoing()) {
            this._socket = new Socket(this._host, this._port);
        }
        if (this._closed) {
            this._socket.close();
            throw new IOException();
        }
        try {
            Acceptor.setAddress(this._socket.getLocalAddress().getAddress());
            this._in = new BufferedInputStream(this._socket.getInputStream());
            this._out = new BufferedOutputStream(this._socket.getOutputStream());
            if (this._in == null || this._out == null) {
                throw new IOException();
            }
        }
        catch (Exception exception) {
            throw new IOException();
        }
        try {
            if (this.isOutgoing()) {
                this.initializeOutgoing();
            } else {
                this.initializeIncoming();
            }
        }
        catch (NoGnutellaOkException noGnutellaOkException) {
            this._socket.close();
            throw noGnutellaOkException;
        }
        catch (IOException iOException) {
            this._socket.close();
            throw new BadHandshakeException();
        }
    }

    private void initializeOutgoing() throws IOException {
        if (this._propertiesWrittenP == null || this._propertiesWrittenR == null) {
            this.sendString("GNUTELLA CONNECT/0.4\n\n");
            if (!this.readLine().equals(GNUTELLA_OK_04)) {
                throw new IOException("Bad connect string");
            }
            if (!this.readLine().equals("")) {
                throw new IOException("Bad connect string");
            }
        } else {
            this.sendString("GNUTELLA CONNECT/0.6\r\n");
            this.sendHeaders(this._propertiesWrittenP);
            String string = this.readLine();
            if (!string.startsWith(GNUTELLA_06)) {
                throw new IOException("Bad connect string");
            }
            this._propertiesRead = new Properties();
            this.readHeaders();
            if (!string.equals(GNUTELLA_OK_06)) {
                throw new NoGnutellaOkException();
            }
            HandshakeResponse handshakeResponse = this._propertiesWrittenR.respond(new HandshakeResponse(this._propertiesRead), true);
            this.sendString("GNUTELLA/0.6 " + handshakeResponse.getStatusLine() + CRLF);
            this.sendHeaders(handshakeResponse.getHeaders());
        }
    }

    private void initializeIncoming() throws IOException {
        String string = this.readLine();
        if (GNUTELLA_CONNECT_04.endsWith(string)) {
            if (!this.readLine().equals("")) {
                throw new IOException("Bad connect string");
            }
            this.sendString("GNUTELLA OK\n\n");
            this._propertiesWrittenP = null;
            this._propertiesWrittenR = null;
        } else if (Connection.notLessThan06(string)) {
            this._propertiesRead = new Properties();
            this.readHeaders();
            if (this._propertiesWrittenR == null) {
                this.sendString("GNUTELLA/0.6 200 OK\r\n");
                this.sendString(CRLF);
            } else {
                HandshakeResponse handshakeResponse = this._propertiesWrittenR.respond(new HandshakeResponse(this._propertiesRead), false);
                this.sendString("GNUTELLA/0.6 " + handshakeResponse.getStatusLine() + CRLF);
                this.sendHeaders(handshakeResponse.getHeaders());
                if (handshakeResponse.notOKStatusCode()) {
                    throw new NoGnutellaOkException();
                }
            }
            string = this.readLine();
            if (!string.startsWith(GNUTELLA_06)) {
                throw new IOException("Unexpected response");
            }
            if (!string.equals(GNUTELLA_OK_06)) {
                throw new NoGnutellaOkException();
            }
            this.readHeaders();
        } else {
            throw new IOException("Unexpected connect string");
        }
    }

    private static boolean notLessThan06(String string) {
        int n = string.indexOf(CONNECT);
        if (n < 0) {
            return false;
        }
        try {
            Float f = new Float(string.substring(n + CONNECT.length()));
            float f2 = f.floatValue();
            return f2 >= 0.6f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void sendHeaders(Properties properties) throws IOException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                string2 = "";
            }
            this.sendString(string + ": " + string2 + CRLF);
            ((Hashtable)this._propertiesWrittenTotal).put(string, string2);
        }
        this.sendString(CRLF);
    }

    private void readHeaders() throws IOException {
        while (true) {
            String string;
            if ((string = this.readLine()) == null) {
                throw new IOException();
            }
            if (string.equals("")) {
                return;
            }
            int n = string.indexOf(58);
            if (n < 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1).trim();
            ((Hashtable)this._propertiesRead).put(string2, string3);
        }
    }

    private void sendString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this._out.write(byArray);
        this._out.flush();
    }

    private String readLine() throws IOException {
        String string;
        int n = this._socket.getSoTimeout();
        try {
            this._socket.setSoTimeout(SettingsManager.instance().getTimeout());
            String string2 = new ByteReader(this._in).readLine();
            if (string2 == null) {
                throw new IOException();
            }
            string = string2;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._socket.setSoTimeout(n);
            throw throwable;
        }
        this._socket.setSoTimeout(n);
        return string;
    }

    public boolean isOutgoing() {
        return this._outgoing;
    }

    public Message receive() throws IOException, BadPacketException {
        if (this._closed) {
            throw new IOException();
        }
        Message message = null;
        while (message == null) {
            message = Message.read(this._in, this.HEADER_BUF);
        }
        return message;
    }

    public Message receive(int n) throws IOException, BadPacketException, InterruptedIOException {
        Message message;
        if (this._closed) {
            throw new IOException();
        }
        int n2 = this._socket.getSoTimeout();
        this._socket.setSoTimeout(n);
        try {
            Message message2 = Message.read(this._in);
            if (message2 == null) {
                throw new InterruptedIOException();
            }
            message = message2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._socket.setSoTimeout(n2);
            throw throwable;
        }
        this._socket.setSoTimeout(n2);
        return message;
    }

    public void send(Message message) throws IOException {
        message.write(this._out);
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public String getOrigHost() {
        return this._host;
    }

    public int getOrigPort() {
        return this._port;
    }

    void setOrigPort(int n) {
        this._port = n;
    }

    public int getPort() {
        return this._socket.getPort();
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    public String getProperty(String string) {
        if (this._propertiesRead == null) {
            return null;
        }
        return this._propertiesRead.getProperty(string);
    }

    public Properties getHeaders() {
        if (this._propertiesRead == null) {
            return null;
        }
        return (Properties)((Hashtable)this._propertiesRead).clone();
    }

    public String getPropertyWritten(String string) {
        return this._propertiesWrittenTotal.getProperty(string);
    }

    public boolean isOpen() {
        return !this._closed;
    }

    public void close() {
        this._closed = true;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "host=" + this._host + " port=" + this._port;
    }

    private static class NoGnutellaOkException
    extends IOException {
        private NoGnutellaOkException() {
        }
    }

    private static class BadHandshakeException
    extends IOException {
        private BadHandshakeException() {
        }
    }
}

