/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

public class ByteOrder {
    public static byte[] reverse(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n - n2 - 1];
            ++n2;
        }
        return byArray2;
    }

    public static short leb2short(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] << 8;
        return (short)(n3 | n2);
    }

    public static int leb2int(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] << 8 & 0xFF00;
        int n4 = byArray[n + 2] << 16 & 0xFF0000;
        int n5 = byArray[n + 3] << 24;
        return n5 | n4 | n3 | n2;
    }

    public static void short2leb(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s & 0xFF);
        byArray[n + 1] = (byte)((short)(s >> 8) & 0xFF);
    }

    public static void int2leb(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    public static int ubyte2int(byte by) {
        return by & 0xFF;
    }

    public static int ubytes2int(short s) {
        return s & 0xFFFF;
    }

    public static long ubytes2long(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int long2int(long l) {
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }
}

