/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.io.Serializable;

public class BandwidthTrackerImpl
implements Serializable {
    long lastTime;
    int lastAmountRead;
    float measuredBandwidth;

    public synchronized void measureBandwidth(int n) {
        long l = System.currentTimeMillis();
        if (this.lastAmountRead == 0 || l == this.lastTime) {
            this.measuredBandwidth = 0.0f;
        } else {
            this.measuredBandwidth = (float)(n - this.lastAmountRead) / (float)(l - this.lastTime);
            this.measuredBandwidth = Math.max(this.measuredBandwidth, 0.0f);
        }
        this.lastTime = l;
        this.lastAmountRead = n;
    }

    public synchronized float getMeasuredBandwidth() {
        return this.measuredBandwidth;
    }
}

