//=============================================================================
// LanScan.c
// ணࠬ ᪠஢  Ethernet ⥬ 뤠 ARP-ᮢ
//=============================================================================
#define PURE_32
#define INCL_WIN
#define INCL_GPIBITMAPS
#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSDATETIME
#define INCL_REXXSAA

#include <os2.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <types.h>
#include <sys\socket.h>
#include <sys\ioctl.h>
#include <netinet\in.h>
#include <net\route.h>
#include <net\if.h>
#include <net\if_arp.h>
#ifndef TCPV40HDRS   // ᪫  TCP/IP 4.0
#include <arpa\inet.h>
#include <unistd.h>
#endif               // TCPV40HDRS
#include <netcons.h>
#include <wksta.h>
#include <access.h>
#include <server.h>
#include <ncb.h>
#include <netbios.h>
#include <neterr.h>
#include <ctype.h>
#include <rexxsaa.h>   // needed for RexxStart()
#include <netinet\in_systm.h>
#include <netinet\ip.h>
#include <netinet\ip_icmp.h>
#include "LanScan.h"

//-----------------------------------------------------------------------------
// Prototypes and Variablies
//-----------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);
BOOL GetStorage(HWND);
void SendErrMsg(HWND, char *);
void APIENTRY DoScan(ULONG);
void PostErrMsg(ULONG, char *);
void InitContainer(HWND);
_inline void InsertRecord(HWND, int, int);
void DeleteRecords(HWND);
_inline ULONG GetNBnames(HWND, char *, ULONG);
int TCPBEUIscan(HWND);
int NETBEUIscan(HWND, int);
BOOL GetFileName(void);
BOOL DoSave(HWND, char *, char *);
BOOL TestAddr(HWND, int);
BOOL TestInt(int, int);
BOOL TestPing(int);
void FormNCB(HWND);
void GetIPaddr(HWND, short);
_inline void GetIPname(HWND, char *, u_long);
_inline u_short in_cksum(u_short *, int);
void PingRange(HWND, int);
HWND hwndFrame, hwndMLE;
HPOINTER hIcon;
char pszCnrTitle[256] = "Network(s) -";
typedef struct _USERRECORD
  { RECORDCORE  recordCore;
    PSZ         IPaddress;
    PSZ         MACaddress;
    PSZ         FQDName;
    PSZ         CompName;
    PSZ         NBname;
  } USERRECORD, *PUSERRECORD;
PCHAR pB;
char *IPfirst,   *MACfirst,   *FQDNfirst,  *NBfirst,
     *NBIPfirst, *NETBNfirst, *MACNBfirst, *CompNfirst,
     *IP,        *MAC,        *FQDN,       *NB,
     *NBIP,      *NETBN,      *MACNB,      *CompN;
int ac, sock, CurrNum = 0, NumIPadr = 0, NumNCB = 0, NumPing = 0;
char **av;
char NBact = FALSE; // we don't interesting for NetBIOS names
struct sockaddr_in sin[MAXIPADR] = { {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0} };
struct in_addr *inadr;
struct in_addr *inaddr[MAXIPADR] = { (struct in_addr *)&sin[0].sin_addr,
                                     (struct in_addr *)&sin[1].sin_addr,
                                     (struct in_addr *)&sin[2].sin_addr,
                                     (struct in_addr *)&sin[3].sin_addr,
                                     (struct in_addr *)&sin[4].sin_addr,
                                     (struct in_addr *)&sin[5].sin_addr,
                                     (struct in_addr *)&sin[6].sin_addr,
                                     (struct in_addr *)&sin[7].sin_addr };
unsigned long *paddr[MAXIPADR] = { (unsigned long *)&sin[0].sin_addr,
                                   (unsigned long *)&sin[1].sin_addr,
                                   (unsigned long *)&sin[2].sin_addr,
                                   (unsigned long *)&sin[3].sin_addr,
                                   (unsigned long *)&sin[4].sin_addr,
                                   (unsigned long *)&sin[5].sin_addr,
                                   (unsigned long *)&sin[6].sin_addr,
                                   (unsigned long *)&sin[7].sin_addr };
ULONG ulEntriesAvailable, ulEntriesRead;
unsigned char *Net32Buf, DCName[UNCLEN+1];
struct wksta_info_10 *pWkInf;
HEV hevEventHandle = 0;
TID tid = 0;
HTIMER phtimer = 0;
static ULONG ulPostCnt = 1;
time_t ltime;
CHAR szFullPath[CCHMAXPATH] = "";
#ifndef TCPV40HDRS   // ᪫  TCP/IP 4.0
struct statatreq AddrInfoIP[MAXIPADR], *AdrInfo;
#else                //   TCP/IP 4.0
#pragma pack(1)
struct statatreq
  { u_long addr;
    short interface;
    u_long mask;
    u_long broadcast;
  } AddrInfoIP[MAXIPADR], *AdrInfo;
#pragma pack()
#endif               // TCPV40HDRS
unsigned char buf[L1024], *ptr, ErrMsg[L160];
char ARPmsg[L24] = "ARP ";
char DNSmsg[L24] = "DNS ";
char PINGmsg[L24] = "PING ";
char TCPBmsg[L32] = "TCPBEUI   ";
char NETBmsg[L32] = "NETBEUI   ";
static char LineSep[] = "------------";
short int *pi = (short int *)&buf;
char MyMAC[MAXIPADR*L6], *bufFind;
struct ncb NCBB[MAXIPADR] = { {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0} };
char NetName[MAXIPADR*(NETBIOS_NAME_LEN+1)];
struct netbios_info_1 *NBI1;
char ChkTCPB[MAXIPADR] = { '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0' };
int Interv[MAXIPADR] = { 0, 0, 0, 0, 0, 0, 0, 0 };
struct _HostInt
  { u_long start[NUMINTERV];
    u_long stop[NUMINTERV];
  } HostInt[MAXIPADR] =  { {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0} };
unsigned long PingStart[MAXIPADR];
unsigned long PingStop[MAXIPADR];
char AutoRun = FALSE;
char AutoLog = FALSE;
char CommonLog = TRUE;
char useDNS = TRUE;
unsigned int Interval = 15;
struct tm *timeptr;
struct protoent *proto;
int NumOUI = 0;
struct timeval pingtv;
static int len = L254*sizeof(struct netbios_info_1);
static int dontblock = 1;
static char ErrSIOSTATAT[] = "Error in <os2_>ioctl(SIOSTATAT)";
static char ErrDosSetPriority[] = "Error in DosSetPriority";
static char ErrSock_Init[] = "Error in sock_init";
static char ErrSocket[] = "Error in socket";
static char ErrSoclose[] = "Error in soclose";
static char ErrSendTo[] = "Error in sendto";
static char ErrSIOSTATIF42[] = "Error in <os2_>ioctl(SIOSTATIF42)";
static char ErrGetProtoByName[] = "Error in getprotobyname";
static char ErrSetSockOptRCVTIMEO[] = "Error in setsockopt(SO_RCVTIMEO)";
static char ErrFIONBIO[] = "Error in ioctl(FIONBIO)";

RXSTRING arg;            // argument string for REXX
RXSTRING rexxretval;     // return value from REXX
UCHAR    *strC = "C";    // Log   騩 䠩
UCHAR    *strS = "S";    // Log   ⤥ 䠩
APIRET   rc;             // return code from REXX
SHORT    rexxrc = 0;     // return code from function

//=============================================================================
// Main procedure
//=============================================================================
void main(int argc, char *argv[])
     {
     HAB   hab;                    // Anchor
     HMQ   hmq;                    // Message queue handle
     QMSG  qmsg;                   // Message struct
     HWND  hwndClient;             // Client window handles
     ULONG flFrameFlags = FCF_TITLEBAR   | FCF_SYSMENU | FCF_SHELLPOSITION |
                          FCF_SIZEBORDER | FCF_MINMAX  | FCF_TASKLIST      |
                          FCF_ACCELTABLE | FCF_MENU    | FCF_AUTOICON;
     ULONG DataLen;

     ac = argc;
     av = argv;
//-----------------------------------------------------------------------------
// Restore Options from OS2.INI
//-----------------------------------------------------------------------------
     if ( PrfQueryProfileSize( HINI_USERPROFILE, APPNAME, AUTORUN, &DataLen) )
       if ( DataLen == sizeof(AutoRun) )
         PrfQueryProfileData( HINI_USERPROFILE,
                              APPNAME,
                              AUTORUN,
                              &AutoRun,
                              &DataLen );

     if ( PrfQueryProfileSize( HINI_USERPROFILE, APPNAME, AUTOLOG, &DataLen) )
       if ( DataLen == sizeof(AutoLog) )
         PrfQueryProfileData( HINI_USERPROFILE,
                              APPNAME,
                              AUTOLOG,
                              &AutoLog,
                              &DataLen );

     if ( PrfQueryProfileSize(HINI_USERPROFILE, APPNAME, COMMONLOG, &DataLen) )
       if ( DataLen == sizeof(CommonLog) )
         PrfQueryProfileData( HINI_USERPROFILE,
                              APPNAME,
                              COMMONLOG,
                              &CommonLog,
                              &DataLen );

     if ( PrfQueryProfileSize( HINI_USERPROFILE, APPNAME, INTERVAL, &DataLen) )
       if ( DataLen == sizeof(Interval) )
         PrfQueryProfileData( HINI_USERPROFILE,
                              APPNAME,
                              INTERVAL,
                              &Interval,
                              &DataLen );

     if ( PrfQueryProfileSize( HINI_USERPROFILE, APPNAME, USEDNS, &DataLen) )
       if ( DataLen == sizeof(useDNS) )
         PrfQueryProfileData( HINI_USERPROFILE,
                              APPNAME,
                              USEDNS,
                              &useDNS,
                              &DataLen );

     pingtv.tv_sec = L1;    //  㬮砭 㤥  1 ᥪ㭤
     pingtv.tv_usec = L0;

     if ( PrfQueryProfileSize( HINI_USERPROFILE, APPNAME, PINGTO, &DataLen) )
       if ( DataLen == sizeof(pingtv.tv_sec) )
         PrfQueryProfileData( HINI_USERPROFILE,
                              APPNAME,
                              PINGTO,
                              &pingtv.tv_sec,
                              &DataLen );
//-----------------------------------------------------------------------------
// Check (and correct) Interval & Timeout
//-----------------------------------------------------------------------------
     Interval = ( Interval > L60 ) ? L60 : Interval;
     Interval = ( Interval < L5 ) ? L5 : Interval;
     Interval = (Interval / L5) * L5;

     pingtv.tv_sec = ( pingtv.tv_sec > L10) ? L10 : pingtv.tv_sec;
     pingtv.tv_sec = ( pingtv.tv_sec < L1) ? L1 : pingtv.tv_sec;
//-----------------------------------------------------------------------------
// Initialize application and create message queue
//-----------------------------------------------------------------------------
     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);
//-----------------------------------------------------------------------------
// Register class and create window
//-----------------------------------------------------------------------------
     WinRegisterClass (hab, "LanScan", ClientWndProc, CS_SIZEREDRAW, 0);
     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,     // Parent
                                     0,                // Style (unvisible)
                                     &flFrameFlags,    // Creation flags
                                     "LanScan",        // Class name
                                     TitleBar,         // Titlebar text
                                     0,                // Client style
                                     NULLHANDLE,       // Resource handle
                                     MAIN_ID,          // Frame ID
                                     &hwndClient);     // Client handle
//-----------------------------------------------------------------------------
// Restore size & place from OS2.INI
//-----------------------------------------------------------------------------
     if ( !WinRestoreWindowPos(APPNAME, WINPOS, hwndFrame) )
       WinSetWindowPos( hwndFrame,
                        NULLHANDLE,
                        Win_X, Win_Y, Win_CX, Win_CY,
                        SWP_ACTIVATE | SWP_MOVE | SWP_SIZE | SWP_SHOW );
     WinShowWindow(hwndFrame, TRUE);       // Make the window visible
//-----------------------------------------------------------------------------
// Set icon
//-----------------------------------------------------------------------------
     hIcon = (HPOINTER)WinLoadPointer(HWND_DESKTOP, NULLHANDLE, ICON_ID);
     WinPostMsg(hwndFrame, WM_SETICON, (MPARAM)hIcon, 0L);
//-----------------------------------------------------------------------------
// Message loop
//-----------------------------------------------------------------------------
     while (WinGetMsg (hab, &qmsg, 0, 0, 0)) WinDispatchMsg (hab, &qmsg);
//-----------------------------------------------------------------------------
// Clean up (destroy window, queue and hab)
//-----------------------------------------------------------------------------
     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     }

//=============================================================================
// Window procedure
//=============================================================================
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     static HWND hwndButtonRun, hwndButtonSave, hwndButtonExit, hwndStaticTxt;
     static HWND hwndCntnr;
     static char Font[] = FontName;
     int i, j;
     ULONG Post;
     struct in_addr IndClient;
     char FileName[32], DateTime[32];

     switch (msg)
          {
//-----------------------------------------------------------------------------
// Fill client with default color
//-----------------------------------------------------------------------------
          case WM_ERASEBACKGROUND:
          return MRFROMSHORT(TRUE);
//-----------------------------------------------------------------------------
// WM_CREATE occurs only during creation
//-----------------------------------------------------------------------------
          case WM_CREATE:
               {
               hwndButtonRun  =
               WinCreateWindow(hwnd,              // Parent handle
                               WC_BUTTON,         // Window class
                               "~Run",             // Window text
                               WS_VISIBLE | BS_PUSHBUTTON | WS_DISABLED,
                               0, 0, 0, 0,        // no size or position now
                               hwnd,              // Owner handle
                               HWND_TOP,          // Z-order ontop
                               PB_RUN,            // Window ID
                               0,                 // Control
                               0);                // Presentation Parameters
               hwndButtonSave  =
               WinCreateWindow(hwnd,              // Parent handle
                               WC_BUTTON,         // Window class
                               "~Save",            // Window text
                               WS_VISIBLE | BS_PUSHBUTTON | WS_DISABLED,
                               0, 0, 0, 0,        // no size or position now
                               hwnd,              // Owner handle
                               HWND_TOP,          // Z-order ontop
                               PB_SAVE,           // Window ID
                               0,                 // Control
                               0);                // Presentation Parameters
               hwndButtonExit  =
               WinCreateWindow(hwnd,              // Parent handle
                               WC_BUTTON,         // Window class
                               "~Exit",           // Window text
                               WS_VISIBLE | BS_PUSHBUTTON, // Button flags
                               0, 0, 0, 0,        // no size or position now
                               hwnd,              // Owner handle
                               HWND_TOP,          // Z-order ontop
                               PB_EXIT,           // Window ID
                               0,                 // Control
                               0);                // Presentation Parameters
               hwndCntnr = WinCreateWindow(hwnd,  // Parent
                               WC_CONTAINER,      // Window class
                               NULL,              // Window text
                               CCS_READONLY | CCS_SINGLESEL | WS_VISIBLE,
                               0, 0, 0, 0,        // no size or position now
                               hwnd,              // Owner handle
                               HWND_TOP,          // Z-order ontop
                               CONTAINER_ID,      // Window ID
                               0,                 // Control
                               0);                // Presentation Parameters
               hwndStaticTxt  =
               WinCreateWindow(hwnd,              // Parent handle
                               WC_STATIC,         // Window class
                               "",                // Window text
                               WS_VISIBLE | SS_TEXT | DT_LEFT | DT_VCENTER,
                               0, 0, 0, 0,        // no size or position now
                               hwnd,              // Owner handle
                               HWND_TOP,          // Z-order ontop
                               STATIC_ID,         // Window ID
                               0,                 // Control
                               0);                // Presentation Parameters
//-----------------------------------------------------------------------------
// Test Parameters and Get Storage
//-----------------------------------------------------------------------------
               if ( ac < 2 )
                 {
                 SendErrMsg(hwnd, "Syntax: LanScan <IP addresses> [T]");
                 break;
                 }

#ifdef TCPV40HDRS    //   TCP/IP 4.0
               if ( sock_init() != 0 )
                 {
                 SendErrMsg(hwnd, ErrSock_Init);
                 break;
                 }
#endif               // TCPV40HDRS

               if ( (sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0 )
                 {
                 SendErrMsg(hwnd, ErrSocket);
                 break;
                 }

               for ( i=0; i < (ac-1); i++ )
                 {
                 if ( strcmpi(av[i+1], "T") == 0 )
                   {
                   NBact=TRUE;
                   break;
                   }

                 if ( toupper(*av[i+1]) == 'I' )
                   {
                   if ( !TestInt(i, NumIPadr) )
                     {
                     SendErrMsg(hwnd, "Wrong Interval(s)");
                     break;
                     }
                   continue;
                   }

                 if ( toupper(*av[i+1]) == 'P' )
                   {
                   if ( !TestPing(i) )
                     {
                     SendErrMsg(hwnd, "Wrong PING range");
                     break;
                     }
                   continue;
                   }

                 if ( NumIPadr == MAXIPADR ) break; // ᫨誮  IP-ᮢ

                 if ( (strcmpi(av[i+1], "L0") >= 0) &&
                      (strcmpi(av[i+1], "L7") <= 0) )
                   {
                   GetIPaddr( hwnd, av[i+1][1]-'0' );
                   continue;
                   }

                 sin[NumIPadr].sin_family = AF_INET;
                 if ((sin[NumIPadr].sin_addr.s_addr=inet_addr(av[i+1])) == -1)
                   {
                   SendErrMsg(hwnd, "Wrong IP-address");
                   break;
                   }
                 if ( !TestAddr(hwnd, NumIPadr) )
                   {
                   SendErrMsg(hwnd, "Illegal IP-address");
                   break;
                   }
                 NumIPadr++;
                 }

               if ( !GetStorage(hwnd) )
                    {
                    SendErrMsg(hwnd, "Error in DosAllocMem");
                    break;
                    }

               if ( soclose(sock) != 0 )
                    {
                    SendErrMsg(hwnd, ErrSoclose);
                    break;
                    }
//-----------------------------------------------------------------------------
// Initiate Container and Set Font
//-----------------------------------------------------------------------------
               for ( i=0, j=strlen(pszCnrTitle); i<NumIPadr; i++ )
                 {
                 *paddr[i] &= htonl(AddrInfoIP[i].mask);
                 sprintf(pszCnrTitle+j, " %s", inet_ntoa(*inaddr[i]));
                 j = strlen(pszCnrTitle);
                 }

               for ( i=0; i<NumPing; i++ )
                 {
                 j=strlen(pszCnrTitle);
                 sprintf( pszCnrTitle+j, " %s",
                          inet_ntoa(*(struct in_addr *)&PingStart[i]) );
                 j = strlen(pszCnrTitle);
                 sprintf( pszCnrTitle+j, "-%s",
                          inet_ntoa(*(struct in_addr *)&PingStop[i]) );
                 }

               if ( NBact )
                 {
                 j = Net32WkstaGetInfo( NULL,
                                        L10,
                                        Net32Buf,
                                        L1024,
                                        &ulEntriesAvailable );
                 if ( (j == 0)&&(pWkInf->wki10_logon_domain[0] != '\0') )
                   {
                   FormNCB(hwnd);
                   sprintf( pszCnrTitle+strlen(pszCnrTitle),
                            "     Domain - %s     Computer - %s",
                            pWkInf->wki10_logon_domain,
                            pWkInf->wki10_computername );
                   }
                 else NBact = FALSE;
                 }

               InitContainer(hwndCntnr);
               WinSetPresParam(hwnd, PP_FONTNAMESIZE, sizeof(Font), Font);
//-----------------------------------------------------------------------------
// Set Priority for current Thread, Create Semaphor and the second Thread
//-----------------------------------------------------------------------------
               if ( DosSetPriority(PRTYS_THREAD,
                                   PRTYC_REGULAR,
                                   L16,
                                   0L) != NO_ERROR )
                 {
                 SendErrMsg(hwnd, ErrDosSetPriority);
                 break;
                 }

               DosCreateEventSem( (ULONG)NULL,
                                  &hevEventHandle,
                                  DC_SEM_SHARED,
                                  TRUE );
               DosCreateThread( &tid,
                                (PFNTHREAD) DoScan,
                                hwnd,
                                CREATE_READY | STACK_SPARSE,
                                L65536 );
               WinSetFocus( HWND_DESKTOP, hwndCntnr );  // ⠭ 䮪
               break;
               }
//-----------------------------------------------------------------------------
// WM_SIZE occurs during every resize, size setting event
//-----------------------------------------------------------------------------
          case WM_SIZE:
               {
               int x = (SHORT1FROMMP(mp2)-(3*PB_CX))/4;

               WinSetWindowPos(hwndButtonRun,      // Place and size button
                               HWND_TOP,           // ONTOP in Z-order
                               x,                  // x coord
                               Y,                  // y coord
                               PB_CX,              // cx size
                               PB_CY,              // cy size
                               SWP_SIZE|SWP_MOVE); // Change size|move
               WinSetWindowPos(hwndButtonSave,     // Place and size button
                               HWND_TOP,           // ONTOP in Z-order
                               2*x+PB_CX,          // x coord
                               Y,                  // y coord
                               PB_CX,              // cx size
                               PB_CY,              // cy size
                               SWP_SIZE|SWP_MOVE); // Change size|move
               WinSetWindowPos(hwndButtonExit,     // Place and size button
                               HWND_TOP,           // ONTOP in Z-order
                               3*x+2*PB_CX,        // x coord
                               Y,                  // y coord
                               PB_CX,              // cx size
                               PB_CY,              // cy size
                               SWP_SIZE|SWP_MOVE); // Change size|move
               WinSetWindowPos(hwndCntnr,          // Place and size container
                               HWND_TOP,           // ONTOP in Z-order
                               0,                  // x coord
                               Y+PB_CY+Y+Txt_Y,    // y coord
                               SHORT1FROMMP(mp2),  // cx size
                               SHORT2FROMMP(mp2)-(Y+PB_CY+Y+Txt_Y),
                               SWP_SIZE|SWP_MOVE); // Change size|move
               WinSetWindowPos(hwndStaticTxt,      // Place and size container
                               HWND_TOP,           // ONTOP in Z-order
                               0,                  // x coord
                               Y+PB_CY+Y,          // y coord
                               SHORT1FROMMP(mp2),  // cx size
                               Txt_Y,              // cy size
                               SWP_SIZE|SWP_MOVE); // Change size|move
               break;
               }
//-----------------------------------------------------------------------------
// Set color
//-----------------------------------------------------------------------------
          case WM_PAINT:
               {
               RECTL rectl;
               HPS hps;

               hps = WinBeginPaint(hwnd, (HPS)NULL, &rectl);
               WinFillRect(hps, (PRECTL)&rectl, CLR_PALEGRAY);
               WinEndPaint(hps);
               return MRFROMSHORT(TRUE);
               }
//-----------------------------------------------------------------------------
// Save the window size and position on exit
//-----------------------------------------------------------------------------
          case WM_SAVEAPPLICATION:
               {
//-----------------------------------------------------------------------------
// Check if window is minimized and restore to original size
//-----------------------------------------------------------------------------
               if ( WinQueryWindowULong(hwndFrame, QWL_STYLE) & WS_MINIMIZED )
                 WinSetWindowPos(hwndFrame, HWND_TOP, 0, 0, 0, 0, SWP_RESTORE);
//-----------------------------------------------------------------------------
// Store window information in OS2.INI
//-----------------------------------------------------------------------------
               WinStoreWindowPos( APPNAME,
                                  WINPOS,
                                  WinQueryWindow(hwnd, QW_PARENT) );
               break;
               }
//-----------------------------------------------------------------------------
// ନ஢ ப 襭
//-----------------------------------------------------------------------------
          case WM_USER_LINE_DONE:
               {
               InsertRecord( hwnd, LONGFROMMP(mp1), LONGFROMMP(mp2) );
               break;
               }
//-----------------------------------------------------------------------------
// ஢ 襭
//-----------------------------------------------------------------------------
          case WM_USER_SCAN_DONE:
            {
            WinSetWindowText(hwndStaticTxt, "");
            if ( AutoLog )
              {
              if ( CommonLog )
                {
                DoSave(hwnd, "LanScan.Log", "a");
                MAKERXSTRING(arg, strC, strlen(strC)); // create argument
                }
              else
                {
                timeptr=localtime(&ltime);
                strftime(DateTime,sizeof(DateTime)-1,"%Y%m%d-%H%M%S",timeptr);
                sprintf(FileName,"LanScan-%s.Log",DateTime);
                DoSave(hwnd, FileName, "w");
                MAKERXSTRING(arg, strS, strlen(strS)); // create argument
                }
              rc = RexxStart( L1,                    // number of args
                              (PRXSTRING) &arg,      // array of arguments
                              (PSZ) "LanScanP.cmd",  // name of REXX file
                              (PRXSTRING) 0,         // No INSTORE used
                              (PSZ) 0,           // Default Command env.
                              (LONG) RXCOMMAND,  // Code for how invoked
                              (PRXSYSEXIT) 0,    // No EXITs on this call
                              (PSHORT) &rexxrc,          // Rexx output
                              (PRXSTRING) &rexxretval ); // Rexx output
              }
            WinEnableControl(hwnd, PB_RUN, TRUE);
            WinEnableControl(hwnd, PB_SAVE, TRUE);
            WinSetPointer( HWND_DESKTOP,
                           WinQuerySysPointer(HWND_DESKTOP,SPTR_ARROW,FALSE) );
            WinInvalidateRegion(hwnd, NULLHANDLE, TRUE); // 
            if ( AutoRun ) DosAsyncTimer( (ULONG)Interval*60000L,
                                          (HSEM)hevEventHandle,
                                          &phtimer );
            break;
            }
//-----------------------------------------------------------------------------
// 믮塞  ARP
//-----------------------------------------------------------------------------
          case WM_USER_ARP:
               {
               IndClient.s_addr = LONGFROMMP(mp1);
               strcpy(ARPmsg+L4, inet_ntoa(IndClient));
               WinSetWindowText(hwndStaticTxt, ARPmsg);
               break;
               }
//-----------------------------------------------------------------------------
// 믮塞  DNS
//-----------------------------------------------------------------------------
          case WM_USER_DNS:
               {
               IndClient.s_addr = LONGFROMMP(mp1);
               strcpy(DNSmsg+L4, inet_ntoa(IndClient));
               WinSetWindowText(hwndStaticTxt, DNSmsg);
               break;
               }
//-----------------------------------------------------------------------------
// 믮塞  PING
//-----------------------------------------------------------------------------
          case WM_USER_PING:
               {
               IndClient.s_addr = htonl(LONGFROMMP(mp1));
               strcpy(PINGmsg+L5, inet_ntoa(IndClient));
               WinSetWindowText(hwndStaticTxt, PINGmsg);
               break;
               }
//-----------------------------------------------------------------------------
// 믮塞  TCPBEUI
//-----------------------------------------------------------------------------
          case WM_USER_TCPBEUI:
               {
               strcpy( TCPBmsg+L10, pB+LONGFROMMP(mp1)*(UNCLEN-1) );
               WinSetWindowText(hwndStaticTxt, TCPBmsg);
               break;
               }
//-----------------------------------------------------------------------------
// 믮塞  NETBEUI
//-----------------------------------------------------------------------------
          case WM_USER_NETBEUI:
               {
               strcpy( NETBmsg+L10, pB+LONGFROMMP(mp1)*(UNCLEN-1) );
               WinSetWindowText(hwndStaticTxt, NETBmsg);
               break;
               }
//-----------------------------------------------------------------------------
// 訡  ᪠஢
//-----------------------------------------------------------------------------
          case WM_USER_SCAN_ERROR:
               {
               SendErrMsg(hwnd, ErrMsg);
               break;
               }
//-----------------------------------------------------------------------------
// ࠡ⪠ 
//-----------------------------------------------------------------------------
          case WM_INITMENU:
               {
               switch (SHORT1FROMMP(mp1))
                    {
                    case SUBMENU_FILE:
                         {
                         DosQueryEventSem( hevEventHandle, &Post );
                         WinEnableMenuItem((HWND)mp2, ITEM_RUN, Post == 0);
                         WinEnableMenuItem((HWND)mp2, ITEM_SAVE, Post == 0);
                         WinEnableMenuItem((HWND)mp2, ITEM_SAVEAS, Post == 0);
                         break;
                         }
                    case SUBMENU_OPTIONS:
                         {
                         WinCheckMenuItem((HWND)mp2, ITEM_AUTORUN, AutoRun);
                         WinCheckMenuItem((HWND)mp2, ITEM_AUTOLOG, AutoLog);
                         WinCheckMenuItem((HWND)mp2, ITEM_COMMON_LOG, CommonLog);
                         WinCheckMenuItem((HWND)mp2, ITEM_DNS, useDNS);
                         break;
                         }
                    case SUBMENU_INTERVAL:
                         {
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_05,Interval== 5);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_10,Interval==10);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_15,Interval==15);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_20,Interval==20);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_25,Interval==25);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_30,Interval==30);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_35,Interval==35);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_40,Interval==40);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_45,Interval==45);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_50,Interval==50);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_55,Interval==55);
                         WinCheckMenuItem((HWND)mp2,ITEM_MIN_60,Interval==60);

                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_05,Interval!= 5);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_10,Interval!=10);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_15,Interval!=15);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_20,Interval!=20);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_25,Interval!=25);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_30,Interval!=30);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_35,Interval!=35);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_40,Interval!=40);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_45,Interval!=45);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_50,Interval!=50);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_55,Interval!=55);
                         WinEnableMenuItem((HWND)mp2,ITEM_MIN_60,Interval!=60);
                         break;
                         }
                    case SUBMENU_TIMEOUT:
                         {
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_01,
                                           pingtv.tv_sec == L1 );
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_02,
                                           pingtv.tv_sec == L2 );
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_03,
                                           pingtv.tv_sec == L3 );
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_04,
                                           pingtv.tv_sec == L4 );
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_05,
                                           pingtv.tv_sec == L5 );
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_06,
                                           pingtv.tv_sec == L6 );
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_07,
                                           pingtv.tv_sec == L7 );
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_08,
                                           pingtv.tv_sec == L8 );
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_09,
                                           pingtv.tv_sec == L9 );
                         WinCheckMenuItem( (HWND)mp2, ITEM_SEC_10,
                                           pingtv.tv_sec == L10 );

                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_01,
                                            pingtv.tv_sec!= L1 );
                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_02,
                                            pingtv.tv_sec!= L2 );
                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_03,
                                            pingtv.tv_sec!= L3 );
                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_04,
                                            pingtv.tv_sec!= L4 );
                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_05,
                                            pingtv.tv_sec!= L5 );
                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_06,
                                            pingtv.tv_sec!= L6 );
                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_07,
                                            pingtv.tv_sec!= L7 );
                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_08,
                                            pingtv.tv_sec!= L8 );
                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_09,
                                            pingtv.tv_sec!= L9 );
                         WinEnableMenuItem( (HWND)mp2, ITEM_SEC_10,
                                            pingtv.tv_sec!=L10 );
                         break;
                         }
                    break;
                    }
               }
          break;
//-----------------------------------------------------------------------------
// ࠡ⪠ 誨
//-----------------------------------------------------------------------------
          case WM_CONTROLPOINTER:
               {
               unsigned int idCtl = SHORT1FROMMP(mp1);
               if ( (idCtl != PB_RUN) && (idCtl != PB_SAVE) &&
                    (idCtl != CONTAINER_ID) && (idCtl != STATIC_ID) ) break;
               }
          case WM_MOUSEMOVE:
	            {
               DosQueryEventSem(hevEventHandle, &Post);
               WinSetPointer( HWND_DESKTOP,
                              WinQuerySysPointer(HWND_DESKTOP,
                                                 Post ? SPTR_WAIT : SPTR_ARROW,
                                                 FALSE) );
               }
          return (MRESULT) TRUE;
//-----------------------------------------------------------------------------
// Handling of the menu-items and the button by WM_COMMAND
//-----------------------------------------------------------------------------
          case WM_COMMAND:
               {
               switch(SHORT1FROMMP(mp1))
                    {
//-----------------------------------------------------------------------------
// Close the dialog
//-----------------------------------------------------------------------------
                    case PB_EXIT:
                    case ITEM_EXIT:
                         {
                         WinPostMsg(hwnd, WM_CLOSE, 0L, 0L);
                         break;
                         }
//-----------------------------------------------------------------------------
//  㭪  ( Checked)
//-----------------------------------------------------------------------------
                    case ITEM_AUTORUN:
                         {
                         AutoRun = (AutoRun == FALSE);
                         break;
                         }
                    case ITEM_AUTOLOG:
                         {
                         AutoLog = (AutoLog == FALSE);
                         break;
                         }
                    case ITEM_COMMON_LOG:
                         {
                         CommonLog = (CommonLog == FALSE);
                         break;
                         }
                    case ITEM_DNS:
                         {
                         useDNS = (useDNS == FALSE);
                         break;
                         }
//-----------------------------------------------------------------------------
// Save Options to OS2.INI
//-----------------------------------------------------------------------------
                    case ITEM_SAVE_OPTIONS:
                         {
                         PrfWriteProfileData( HINI_USERPROFILE,
                                              APPNAME,
                                              AUTORUN,
                                              &AutoRun,
                                              sizeof(AutoRun) );
                         PrfWriteProfileData( HINI_USERPROFILE,
                                              APPNAME,
                                              AUTOLOG,
                                              &AutoLog,
                                              sizeof(AutoLog) );
                         PrfWriteProfileData( HINI_USERPROFILE,
                                              APPNAME,
                                              COMMONLOG,
                                              &CommonLog,
                                              sizeof(CommonLog) );
                         PrfWriteProfileData( HINI_USERPROFILE,
                                              APPNAME,
                                              INTERVAL,
                                              &Interval,
                                              sizeof(Interval) );
                         PrfWriteProfileData( HINI_USERPROFILE,
                                              APPNAME,
                                              USEDNS,
                                              &useDNS,
                                              sizeof(useDNS) );
                         PrfWriteProfileData( HINI_USERPROFILE,
                                              APPNAME,
                                              PINGTO,
                                              &pingtv.tv_sec,
                                              sizeof(pingtv.tv_sec) );
                         break;
                         }
//-----------------------------------------------------------------------------
// ࠡ⠥ 祭 ࢠ
//-----------------------------------------------------------------------------
                    case ITEM_MIN_05: { Interval =  5; break; }
                    case ITEM_MIN_10: { Interval = 10; break; }
                    case ITEM_MIN_15: { Interval = 15; break; }
                    case ITEM_MIN_20: { Interval = 20; break; }
                    case ITEM_MIN_25: { Interval = 25; break; }
                    case ITEM_MIN_30: { Interval = 30; break; }
                    case ITEM_MIN_35: { Interval = 35; break; }
                    case ITEM_MIN_40: { Interval = 40; break; }
                    case ITEM_MIN_45: { Interval = 45; break; }
                    case ITEM_MIN_50: { Interval = 50; break; }
                    case ITEM_MIN_55: { Interval = 55; break; }
                    case ITEM_MIN_60: { Interval = 60; break; }
//-----------------------------------------------------------------------------
// ࠡ⠥ 祭 Time-out'
//-----------------------------------------------------------------------------
                    case ITEM_SEC_01: { pingtv.tv_sec =  L1; break; }
                    case ITEM_SEC_02: { pingtv.tv_sec =  L2; break; }
                    case ITEM_SEC_03: { pingtv.tv_sec =  L3; break; }
                    case ITEM_SEC_04: { pingtv.tv_sec =  L4; break; }
                    case ITEM_SEC_05: { pingtv.tv_sec =  L5; break; }
                    case ITEM_SEC_06: { pingtv.tv_sec =  L6; break; }
                    case ITEM_SEC_07: { pingtv.tv_sec =  L7; break; }
                    case ITEM_SEC_08: { pingtv.tv_sec =  L8; break; }
                    case ITEM_SEC_09: { pingtv.tv_sec =  L9; break; }
                    case ITEM_SEC_10: { pingtv.tv_sec = L10; break; }
//-----------------------------------------------------------------------------
// 뢥 Help
//-----------------------------------------------------------------------------
                    case ITEM_GENERAL_HELP:
                         {
                         UCHAR LoadError[CCHMAXPATH] = { 0 };
                         RESULTCODES ChieldRC = { 0 };
                         char CommandLine[] = "view.exe\0LanScan.Inf\0";

                         DosExecPgm( LoadError,
                                     sizeof(LoadError),
                                     EXEC_ASYNC,
                                     CommandLine,
                                     (PSZ)NULL,
                                     &ChieldRC,
                                     CommandLine );
                         break;
                         }
//-----------------------------------------------------------------------------
// ᪠  ᥡ
//-----------------------------------------------------------------------------
                    case ITEM_ABOUT:
                         {
                         WinDlgBox( HWND_DESKTOP,
                                    hwnd,
                                    WinDefDlgProc,
                                    NULLHANDLE,
                                    ABOUT_ID,
                                    0 );
                         break;
                         }
//-----------------------------------------------------------------------------
// 믮 ࠭ १⮢ ᪠஢
//-----------------------------------------------------------------------------
                    case ITEM_SAVEAS:
                         {
                         if ( !GetFileName() ) break;
                         }
                    case PB_SAVE:
                    case ITEM_SAVE:
                         {
                         DosQueryEventSem( hevEventHandle, &Post );
                         if ( Post == 0 )
                           {
                           if ( szFullPath[0] != '\0' )
                             DoSave(hwnd, szFullPath, "a");
                           else
                             if ( GetFileName() ) DoSave(hwnd,szFullPath,"a");
                           WinSetFocus( HWND_DESKTOP, hwndCntnr );
                           }
                         break;
                         }
//-----------------------------------------------------------------------------
// 믮 ᪠஢
//-----------------------------------------------------------------------------
                    case PB_RUN:
                    case ITEM_RUN:
                         {
                         DosQueryEventSem( hevEventHandle, &Post );
                         if ( Post == 0 )
                           {
                           DosPostEventSem(hevEventHandle);
                           WinSetFocus( HWND_DESKTOP, hwndCntnr );
                           }
                         break;
                         }
                    }
               }
          break;
          }
     return (WinDefWindowProc (hwnd,msg,mp1,mp2));
     }

//=============================================================================
// DoScan - ணࠬ ᪠஢ 
//=============================================================================
void APIENTRY DoScan(ULONG parmHwnd)
{
BOOL varTRUE = TRUE;
struct servent *WINSprot;
int i, j, k, l, m, n, NumNBN, NumNBNn, CNI, FirstCNI, LastCNI;
unsigned long num;
unsigned long numMax[MAXIPADR] = { ~AddrInfoIP[0].mask,
                                   ~AddrInfoIP[1].mask,
                                   ~AddrInfoIP[2].mask,
                                   ~AddrInfoIP[3].mask,
                                   ~AddrInfoIP[4].mask,
                                   ~AddrInfoIP[5].mask,
                                   ~AddrInfoIP[6].mask,
                                   ~AddrInfoIP[7].mask };
unsigned long Mask[MAXIPADR] = { htonl(AddrInfoIP[0].mask),
                                 htonl(AddrInfoIP[1].mask),
                                 htonl(AddrInfoIP[2].mask),
                                 htonl(AddrInfoIP[3].mask),
                                 htonl(AddrInfoIP[4].mask),
                                 htonl(AddrInfoIP[5].mask),
                                 htonl(AddrInfoIP[6].mask),
                                 htonl(AddrInfoIP[7].mask) };
struct arpreq myarp = { 0 };
char ReverseMAC[L6], *pp, BufDNname[DNLEN];

if ( DosSetPriority(PRTYS_THREAD, PRTYC_REGULAR, L15, 0L) != NO_ERROR )
  PostErrMsg(parmHwnd, ErrDosSetPriority);

while(varTRUE)
   {
   DosWaitEventSem(hevEventHandle, SEM_INDEFINITE_WAIT);

   DosStopTimer(phtimer);   // ⠭ ⠩
//-----------------------------------------------------------------------------
// 믮 ⮢   ᪠஢
//-----------------------------------------------------------------------------
   WinEnableControl(parmHwnd, PB_RUN, FALSE);
   WinEnableControl(parmHwnd, PB_SAVE, FALSE);
   DeleteRecords(parmHwnd);
   WinInvalidateRegion(parmHwnd, NULLHANDLE, TRUE); // 
//-----------------------------------------------------------------------------
// 筥 ᪠஢
//-----------------------------------------------------------------------------
   time(&ltime);

   IP=IPfirst;
   MAC=MACfirst;
   FQDN=FQDNfirst;
   NB=NBfirst;
   NBIP=NBIPfirst;
   NETBN=NETBNfirst;
   MACNB=MACNBfirst;

   if ( (proto = getprotobyname("udp")) == NULL )
     PostErrMsg(parmHwnd, ErrGetProtoByName);

#ifdef TCPV40HDRS    //   TCP/IP 4.0
   if ( sock_init() != 0 ) PostErrMsg(parmHwnd, ErrSock_Init);
#endif               // TCPV40HDRS

   if ( (sock = socket(AF_INET, SOCK_DGRAM, proto->p_proto)) < 0 )
     PostErrMsg(parmHwnd, ErrSocket);

   if ( (WINSprot = getservbyname("netbios-ns", "udp")) == NULL )
     PostErrMsg(parmHwnd, "Error in getservbyname");

   for ( i=0; i<NumIPadr; i++) sin[i].sin_port = WINSprot->s_port;
//-----------------------------------------------------------------------------
// Get all interface addresses
//-----------------------------------------------------------------------------
#ifndef TCPV40HDRS   // ᪫  TCP/IP 4.0
   if ( os2_ioctl(sock, SIOSTATAT, (char *)buf, sizeof(buf)) != 0 )
     PostErrMsg(parmHwnd, ErrSIOSTATAT);
#else                //   TCP/IP 4.0
   if ( ioctl(sock, SIOSTATAT, (char *)buf, sizeof(buf)) != 0 )
     PostErrMsg(parmHwnd, ErrSIOSTATAT);
#endif               // TCPV40HDRS
   for ( i=0, AdrInfo=(struct statatreq *)&buf[2]; i < *pi;
         i++, AdrInfo++,
         IP += IPLEN, MAC += MACLEN, FQDN += FQDNLEN, NETBN += UNCLEN )
     {
     inadr = (struct in_addr *)AdrInfo;
     strcpy(IP, inet_ntoa(*inadr));

     *MAC = '\0';
     CNI = NumOUI;
     if ( (l=AdrInfo->interface) < MAXIPADR )
       {
       sprintf( MAC, "%2.2x%2.2x-%2.2x%2.2x-%2.2x%2.2x",
                MyMAC[l*L6],   MyMAC[l*L6+1], MyMAC[l*L6+2],
                MyMAC[l*L6+3], MyMAC[l*L6+4], MyMAC[l*L6+5] );

       FirstCNI = 0;
       CNI, LastCNI = NumOUI;
       while ( FirstCNI <= LastCNI )
         {
         CNI = (FirstCNI+LastCNI)/2;
         n = memcmp(MAC, CompNfirst+COMPNLEN*CNI, L7);
         if ( n < 0 ) LastCNI = CNI-1;
         else
           if ( n > 0 ) FirstCNI = CNI+1;
           else break;
         CNI = NumOUI;
         }
       }

     GetIPname(parmHwnd, (char *)inadr, inadr->s_addr);
     *NETBN = '\0';
     WinPostMsg ( parmHwnd,
                  WM_USER_LINE_DONE,
                  MPFROMLONG(CurrNum++),
                  MPFROMLONG(CNI) );
     }
//-----------------------------------------------------------------------------
// 㥬  TCPBEUI  NETBEUI
//-----------------------------------------------------------------------------
   NumNBN, NumNBNn = 0;
   if ( NBact )
     {
     ulEntriesRead = GetNBnames(parmHwnd, pWkInf->wki10_logon_domain, L0);

     if ( strlen(pWkInf->wki10_oth_domains) != 0 )
       {
       for ( pp=pWkInf->wki10_oth_domains; ; pp=ptr+1 )
         {
         memset(BufDNname, '\0', sizeof(BufDNname));
         if ( (ptr=strchr(pp, ' ')) != NULL )
           {
           strncpy(BufDNname, pp, ptr-pp);
           ulEntriesRead += GetNBnames(parmHwnd, BufDNname, ulEntriesRead);
           continue;
           }
         else
           {
           ulEntriesRead += GetNBnames(parmHwnd, pp, ulEntriesRead);
           break;
           }
         }
       }

     if ( ulEntriesRead != 0 )
       {
       NumNBN = TCPBEUIscan(parmHwnd);
       NumNBNn = NETBEUIscan(parmHwnd, NumNBN);
       }
     }
//-----------------------------------------------------------------------------
// 㥬 ⥬ ࠡ  襬 ARP
//-----------------------------------------------------------------------------
   for ( k=0; k<NumIPadr; k++ )
     {
//-----------------------------------------------------------------------------
// 뢥 ࠧ⥫ । ᪠஢  
//-----------------------------------------------------------------------------
     strcpy(IP, LineSep);
     strcpy(MAC, LineSep);
     strcpy(FQDN, LineSep);
     *NETBN = '\0';
     IP += IPLEN;
     MAC += MACLEN;
     FQDN += FQDNLEN;
     NETBN += UNCLEN;
     WinPostMsg ( parmHwnd,
                  WM_USER_LINE_DONE,
                  MPFROMLONG(CurrNum++),
                  MPFROMLONG(NumOUI) );

     if ( Interv[k] == 0 )
       {
       HostInt[k].start[Interv[k]] = 1;
       HostInt[k].stop[Interv[k]]  = numMax[k]-1;
       Interv[k] = 1;
       }

     for ( m=0; m<Interv[k]; m++ )
       {
       for ( num = HostInt[k].start[m];
             (num <= HostInt[k].stop[m]) & (CurrNum < NUMADR); num++ )
         {
         *paddr[k] &= Mask[k];
         *paddr[k] |= htonl(num);
         memset( &myarp, 0, sizeof(myarp) );
         memcpy( &myarp.arp_pa, &sin[k], sizeof(myarp.arp_pa) );
         WinPostMsg (parmHwnd, WM_USER_ARP, MPFROMLONG(*paddr[k]), 0L);

         ptr = &myarp.arp_ha.sa_data[0];
#ifdef TCPV40HDRS    //   TCP/IP 4.0
//-----------------------------------------------------------------------------
//     ARP
//-----------------------------------------------------------------------------
         ioctl(sock, SIOCDARP, (char *)&myarp, sizeof(myarp));
//-----------------------------------------------------------------------------
// 뤠  ARP
//-----------------------------------------------------------------------------
         if ( sendto(sock,
                     (char *)&num,
                     sizeof(num),
                     0,
                     (struct sockaddr *)&sin[k],
                     sizeof(struct sockaddr)) == -1 )
           PostErrMsg(parmHwnd, ErrSendTo);
//-----------------------------------------------------------------------------
// ⠥    ARP
//-----------------------------------------------------------------------------
         DosSleep(10L);
         if ( ioctl(sock, SIOCGARP, (char *)&myarp, sizeof(myarp)) != 0 )
           continue;
         if ( memcmp(ptr, "\0\0\0\0\0", L6) == 0 )
           {   //     ARP
           ioctl(sock, SIOCDARP, (char *)&myarp, sizeof(myarp));
           continue;
           }
#else                // ᪫  TCP/IP 4.0
//-----------------------------------------------------------------------------
//     ARP
//-----------------------------------------------------------------------------
         ioctl(sock, SIOCDARP, &myarp);
//-----------------------------------------------------------------------------
// 뤠  ARP
//-----------------------------------------------------------------------------
         if ( ioctl(sock, SIOCARP, inaddr[k]) != 0 )
           PostErrMsg(parmHwnd, "Error in ioctl(SIOCARP)");
//-----------------------------------------------------------------------------
// ⠥    ARP
//-----------------------------------------------------------------------------
         DosSleep(5L);   //  5 ᥪ㭤
         if ( ioctl(sock, SIOCGARP, &myarp) != 0 ) continue;
#endif               // TCPV40HDRS
         strcpy(IP, inet_ntoa(*inaddr[k]));

         sprintf(MAC, "%2.2x%2.2x-%2.2x%2.2x-%2.2x%2.2x",
                 *ptr, *(ptr+1), *(ptr+2), *(ptr+3), *(ptr+4), *(ptr+5));

         GetIPname(parmHwnd, (char *)paddr[k], *paddr[k]);
//-----------------------------------------------------------------------------
// 뢮 १ ᪠஢
//-----------------------------------------------------------------------------
         *NETBN = '\0';
         if ( NBact )
           {
           for (j=0, NBIP=NBIPfirst, NB=NBfirst, MACNB=MACNBfirst; j<NumNBNn;
                j++, NBIP+=IPLEN, NB+=UNCLEN, MACNB+=MACLEN)
             {
             if ( j < NumNBN )
               {
               if ( strcmp(NBIP, IP) == 0 )
                 {
                 strcpy(NETBN, NB);
                 break;
                 }
               }
             else
               {
               for (i=0; i<L6; i++) ReverseMAC[L5-i]=MACNB[i];
                 if ( (memcmp(MACNB, ptr, L6) == 0) ||
                      (memcmp(ReverseMAC, ptr, L6) == 0) )
                   {
                   strcpy(NETBN, NB);
                   break;
                   }
               }
             }
           }

         FirstCNI = 0;
         CNI, LastCNI = NumOUI;
         while ( FirstCNI <= LastCNI )
           {
           CNI = (FirstCNI+LastCNI)/2;
           n = memcmp(MAC, CompNfirst+COMPNLEN*CNI, L7);
           if ( n < 0 ) LastCNI = CNI-1;
           else
             if ( n > 0 ) FirstCNI = CNI+1;
             else break;
           CNI = NumOUI;
           }

         IP += IPLEN;
         MAC += MACLEN;
         FQDN += FQDNLEN;
         NETBN += UNCLEN;
         WinPostMsg ( parmHwnd,
                      WM_USER_LINE_DONE,
                      MPFROMLONG(CurrNum++),
                      MPFROMLONG(CNI) );
         }
       }
     }
//-----------------------------------------------------------------------------
// ஥ socket
//-----------------------------------------------------------------------------
   if ( soclose(sock) != 0 ) PostErrMsg(parmHwnd, ErrSoclose);
//-----------------------------------------------------------------------------
// 믮 Ping
//-----------------------------------------------------------------------------
   for ( i=0; i<NumPing; i++) PingRange(parmHwnd, i);
//-----------------------------------------------------------------------------
// 訬 ᪠஢
//-----------------------------------------------------------------------------
   DosResetEventSem( hevEventHandle, &ulPostCnt);
   WinPostMsg (parmHwnd, WM_USER_SCAN_DONE, 0L, 0L);
   }
}

//=============================================================================
// GetNBnames - ணࠬ 祭  NetBIOS
//=============================================================================
_inline ULONG GetNBnames(HWND hwndNum, char *ptrDN, ULONG j)
{
   int i;
   ULONG eSave;

   if ( (i=Net32GetDCName(NULL, ptrDN, DCName, sizeof(DCName))) != 0 )
     if ( i != NERR_DCNotFound )
       {
       sprintf(ErrMsg, "Error in Net32GetDCName, rc=%d", i);
       PostErrMsg(hwndNum, ErrMsg);
       }

   if ( i == 0 )
     i = Net32ServerEnum2( DCName,
                           L0,
                           pB+j*(UNCLEN-1),
                           (UNCLEN-1)*(L254-j),
                           &eSave,
                           &ulEntriesAvailable,
                           0xFFFFFFFF,
                           ptrDN );
   else
     i = Net32ServerEnum2( NULL,
                           L0,
                           pB+j*(UNCLEN-1),
                           (UNCLEN-1)*(L254-j),
                           &eSave,
                           &ulEntriesAvailable,
                           0xFFFFFFFF,
                           ptrDN);

   if ( (i != 0) && ((i+NERR_BASE) != NERR_NoNetworkResource) )
     {
     sprintf(ErrMsg, "Error in Net32ServerEnum2, rc=%d", i);
     PostErrMsg(hwndNum, ErrMsg);
     }

   return eSave;
}

//=============================================================================
// TCPBEUIscan - ணࠬ ᪠஢  ⮪ TCPBEUI
//=============================================================================
int TCPBEUIscan(HWND hwndNum)
{
   int i, j, k, NumberNBN = 0;
   struct timeval tv;
   struct {
     short int Id;
     short int Flag;
     short int NQ;
     short int NAnsRR;
     short int NAutRR;
     short int NAddRR;
     char NBname[34];
     short int QT;
     short int QC; } NBQ;
//               123456789x123456789x123456789x123
   char NBN[] = " CACACACACACACACACACACACACACACACA";
   char buff[PACKETSIZE];
   struct sockaddr_in client;

   NBQ.Id     = 10001;
   NBQ.Flag   = htons(0x0110);
   NBQ.NQ     = htons(0x0001);
   NBQ.NAnsRR = 0;
   NBQ.NAutRR = 0;
   NBQ.NAddRR = 0;
   NBQ.QT     = htons(0x0020);
   NBQ.QC     = htons(0x0001);
#ifndef TCPV40HDRS   // ᪫  TCP/IP 4.0
   tv.tv_sec = 0;
   tv.tv_usec = 10000; // 㤥  10 ᥪ㭤

   if ( setsockopt(sock,
                   SOL_SOCKET,
                   SO_RCVTIMEO,
                   (char *)&tv,
                   sizeof(struct timeval)) != 0 )
     PostErrMsg(hwndNum, ErrSetSockOptRCVTIMEO);
#else                //   TCP/IP 4.0
   if ( ioctl(sock, FIONBIO, (char *)&dontblock, sizeof(dontblock)) != 0 )
     PostErrMsg(hwndNum, ErrFIONBIO);
#endif               // TCPV40HDRS
   for ( k=0; k<NumIPadr; k++ ) *paddr[k] |= htonl(~AddrInfoIP[k].mask);

   for (i=0; i<ulEntriesRead; i++)
     {
     WinPostMsg ( hwndNum, WM_USER_TCPBEUI, MPFROMLONG((long)i), 0L );

     strcpy(NBQ.NBname,NBN);
     for (j=0; j<strlen(pB+i*(UNCLEN-1)); j++)
       {
       NBQ.NBname[2*j+1] = (pB[i*(UNCLEN-1)+j]>>4)+'A';
       NBQ.NBname[2*j+2] = (pB[i*(UNCLEN-1)+j]&0x0F)+'A';
       }

     for ( k=0; k<NumIPadr; k++ )
       {
       if ( ChkTCPB[k] )
         {
         if ( setsockopt(sock,
                         SOL_SOCKET,
                         SO_BROADCAST,
                         (char *)&sin[k].sin_addr.s_addr,
                         sizeof(sin[0].sin_addr.s_addr)) != 0 )
           PostErrMsg(hwndNum, "Error in setsockopt(SO_BROADCAST)");

         if ( sendto(sock,
                     (char *)&NBQ,
                     sizeof(NBQ),
                     0,
                     (struct sockaddr *)&sin[k],
                     sizeof(struct sockaddr)) == -1 )
           PostErrMsg(hwndNum, ErrSendTo);

         memset(buff, 0, PACKETSIZE);
#ifdef TCPV40HDRS    //   TCP/IP 4.0
         DosSleep(10L);
#endif               // TCPV40HDRS
         if ( recvfrom(sock, buff, PACKETSIZE, 0, 0, 0) == -1 ) continue;

         memcpy((char *)&client.sin_addr, buff+58, L4);
         strcpy(NBIP, inet_ntoa(client.sin_addr));
         for (j=13; j<=44; j+=2)
           {
           if ( (buff[j] < 'A') || (buff[j] > 'P') ||
                (buff[j+1] < 'A') || (buff[j+1] > 'P') )
             {
             NB[(j-13)/2] = '\0';
             break;
             }
           NB[(j-13)/2] = ((buff[j]-'A')<<4)+(buff[j+1]-'A');
           if ( NB[(j-13)/2] == ' ' )
             {
             NB[(j-13)/2] = '\0';
             break;
             }
           }
         NB += UNCLEN;
         NBIP += IPLEN;
         NumberNBN++;
         }
       }
     }
   return NumberNBN;
}

//=============================================================================
// NETBEUIscan - ணࠬ ᪠஢  ⮪ NETBEUI
//=============================================================================
int NETBEUIscan(HWND hwndNum, int NumberNBN)
{
   unsigned long handle[MAXIPADR] = { 0, 0, 0, 0, 0, 0, 0, 0 };
   int i, k;

   for ( k=0; k<NumNCB; k++ )
     if ( NetBios32Open(NetName+k*(NETBIOS_NAME_LEN+1),
          NULL,
          L1,
          &handle[k]) != 0 )
       PostErrMsg(hwndNum, "Error in NetBios32Open");

   for (i=0; i<ulEntriesRead; i++)
     {
     WinPostMsg ( hwndNum, WM_USER_NETBEUI, MPFROMLONG((long)i), 0L );

     for ( k=0; k<NumNCB; k++ )
       {
       NCBB[k].ncb_length = len;
       memset(NCBB[k].ncb_callname, ' ', NCBNAMSZ);
       strncpy(NCBB[k].ncb_callname, pB+i*(UNCLEN-1), strlen(pB+i*(UNCLEN-1)));
       if ( NetBios32Submit(handle[k], L0, &NCBB[k]) == 0 )
         {
         strcpy(NB, pB+i*(UNCLEN-1));
         memcpy(MACNB, bufFind, L6);
         NB += UNCLEN;
         MACNB += MACLEN;
         NumberNBN++;
         break;
         }
       }
     }

   for ( k=0; k<NumNCB; k++ )
     if ( NetBios32Close(handle[k], L0) != 0 )
       PostErrMsg(hwndNum, "Error in NetBios32Close");

   return NumberNBN;
}

//=============================================================================
// InitContainer - ணࠬ 樠樨 ⥩
//=============================================================================
void InitContainer(HWND hwnd)
{
  static CNRINFO cnrinfo;
  static PFIELDINFO pFieldInfo, firstFieldInfo;
  static FIELDINFOINSERT fieldInfoInsert;
  static PFIELDINFOINSERT pFieldInfoInsert;
  static char pszColumnText1[]= "          IP address          ";
  static char pszColumnText2[]= "Host name                    ";
  static char pszColumnText3[]= "       MAC address       ";
  static char pszColumnText4[]= "Manufacturer";
  static char pszColumnText5[]= "NetBIOS name";
  u_long MsgFlg = CMA_FLWINDOWATTR | CMA_CNRTITLE;

  cnrinfo.pszCnrTitle = pszCnrTitle;
  cnrinfo.flWindowAttr = CV_DETAIL | CA_CONTAINERTITLE |
                         CA_TITLESEPARATOR | CA_DETAILSVIEWTITLES;

  pFieldInfo = WinSendMsg(hwnd, CM_ALLOCDETAILFIELDINFO, MPFROMLONG(L5), NULL);

  firstFieldInfo = pFieldInfo;

  pFieldInfo->cb = sizeof(FIELDINFO);
  pFieldInfo->flData = CFA_STRING|CFA_HORZSEPARATOR|CFA_LEFT|CFA_SEPARATOR;
  pFieldInfo->flTitle = CFA_CENTER;
  pFieldInfo->pTitleData = (PVOID) pszColumnText1;
  pFieldInfo->offStruct = FIELDOFFSET(USERRECORD,IPaddress);
  pFieldInfo = pFieldInfo->pNextFieldInfo;

  pFieldInfo->cb = sizeof(FIELDINFO);
  pFieldInfo->flData = CFA_STRING|CFA_HORZSEPARATOR|CFA_LEFT|CFA_SEPARATOR;
  pFieldInfo->flTitle = CFA_CENTER;
  pFieldInfo->pTitleData = (PVOID) pszColumnText2;
  pFieldInfo->offStruct = FIELDOFFSET(USERRECORD,FQDName);
  pFieldInfo = pFieldInfo->pNextFieldInfo;

  pFieldInfo->cb = sizeof(FIELDINFO);
  pFieldInfo->flData = CFA_STRING|CFA_HORZSEPARATOR|CFA_LEFT|CFA_SEPARATOR;
  pFieldInfo->flTitle = CFA_LEFT;
  pFieldInfo->pTitleData = (PVOID) pszColumnText3;
  pFieldInfo->offStruct = FIELDOFFSET(USERRECORD,MACaddress);
  pFieldInfo = pFieldInfo->pNextFieldInfo;

  pFieldInfo->cb = sizeof(FIELDINFO);
  pFieldInfo->flTitle = CFA_LEFT;
  pFieldInfo->pTitleData = (PVOID) pszColumnText4;
  pFieldInfo->offStruct = FIELDOFFSET(USERRECORD,CompName);

  if ( NBact )
    {
    pFieldInfo->flData = CFA_STRING|CFA_HORZSEPARATOR|CFA_LEFT|CFA_SEPARATOR;

    cnrinfo.pFieldInfoLast = pFieldInfo;
    cnrinfo.xVertSplitbar = L198;
    MsgFlg |= CMA_PFIELDINFOLAST | CMA_XVERTSPLITBAR;

    pFieldInfo = pFieldInfo->pNextFieldInfo;

    pFieldInfo->cb = sizeof(FIELDINFO);
    pFieldInfo->flData = CFA_STRING | CFA_HORZSEPARATOR | CFA_LEFT;
    pFieldInfo->flTitle = CFA_LEFT;
    pFieldInfo->pTitleData = (PVOID) pszColumnText5;
    pFieldInfo->offStruct = FIELDOFFSET(USERRECORD,NBname);

    fieldInfoInsert.cFieldInfoInsert = L5;
    }
  else
    {
    pFieldInfo->flData = CFA_STRING | CFA_HORZSEPARATOR | CFA_LEFT;
    fieldInfoInsert.cFieldInfoInsert = L4;
    }

  fieldInfoInsert.cb = (ULONG)(sizeof(FIELDINFOINSERT));
  fieldInfoInsert.pFieldInfoOrder = (PFIELDINFO)CMA_FIRST;
  fieldInfoInsert.fInvalidateFieldInfo = TRUE;

  pFieldInfoInsert = &fieldInfoInsert;

  WinPostMsg( hwnd,
              CM_INSERTDETAILFIELDINFO,
              MPFROMP(firstFieldInfo),
              MPFROMP(pFieldInfoInsert) );

  WinPostMsg( hwnd, CM_SETCNRINFO, &cnrinfo, MPFROMLONG(MsgFlg) );
}

//=============================================================================
// InsertRecord - ணࠬ    ⥩
//=============================================================================
void InsertRecord(HWND hwnd, int i, int j)
{
  ULONG  cbRecordData;
  static PUSERRECORD pUserRecord;
  static RECORDINSERT recordInsert;
  static char pszViewText[] = "Text View";
  static char pszViewIcon[] = "Icon View";
  static char pszViewName[] = "Name View";

  cbRecordData = (LONG) (sizeof(USERRECORD) - sizeof(RECORDCORE));
  pUserRecord = WinSendDlgItemMsg( hwnd,
                                   CONTAINER_ID,
                                   CM_ALLOCRECORD,
                                   MPFROMLONG(cbRecordData),
                                   MPFROMSHORT(L1) );

  pUserRecord->recordCore.cb       = sizeof(RECORDCORE);
  pUserRecord->recordCore.pszText  = pszViewText;
  pUserRecord->recordCore.pszIcon  = pszViewIcon;
  pUserRecord->recordCore.pszName  = pszViewName;
  pUserRecord->recordCore.hptrIcon = hIcon;

  pUserRecord->IPaddress  = (PSZ)IPfirst+IPLEN*i;
  pUserRecord->MACaddress = (PSZ)MACfirst+MACLEN*i;
  pUserRecord->FQDName    = (PSZ)FQDNfirst+FQDNLEN*i;
  pUserRecord->CompName   = (PSZ)CompNfirst+COMPNLEN*j+L7;
  pUserRecord->NBname     = (PSZ)NETBNfirst+UNCLEN*i;

  recordInsert.cb                = sizeof(RECORDINSERT);
  recordInsert.pRecordParent     = NULL;
  recordInsert.pRecordOrder      = (PRECORDCORE)CMA_END;
  recordInsert.zOrder            = CMA_TOP;
  recordInsert.cRecordsInsert    = L1;
  recordInsert.fInvalidateRecord = TRUE;

  WinPostMsg( WinWindowFromID(hwnd, CONTAINER_ID),
              CM_INSERTRECORD,
              (PRECORDCORE)pUserRecord,
              &recordInsert );
}

//=============================================================================
// DeleteRecords - ணࠬ 㤠 ᥩ  ⥩
//=============================================================================
void DeleteRecords(HWND hwnd)
{
  USHORT fRemoveRecord;

  CurrNum = 0;           // 0 砥 㤠  ᥩ
//-----------------------------------------------------------------------------
// ⨬ ⥩  ᢮ 
//-----------------------------------------------------------------------------
  fRemoveRecord = CM_INVALIDATERECORD | CMA_FREE;
  WinPostMsg( WinWindowFromID(hwnd, CONTAINER_ID),
              CM_REMOVERECORD,
              NULL,
              MPFROM2SHORT(0, fRemoveRecord) );
}

//=============================================================================
// GetStorage - ணࠬ 祭   ᢮ MAC-ᮢ
//=============================================================================
BOOL GetStorage(HWND hwnd)
{
  int i;
  struct ifmib *stat;
  FILE *FileOUI;

  if ( (pB=calloc((UNCLEN-1)*L254, L1)) == NULL ) return FALSE;
  if ( (Net32Buf=calloc(L1024, L1)) == NULL ) return FALSE;
  pWkInf = (struct wksta_info_10 *)Net32Buf;

  if ( (IPfirst=malloc(IPLEN*NUMADR))     == NULL ) return FALSE;
  if ( (MACfirst=malloc(MACLEN*NUMADR))   == NULL ) return FALSE;
  if ( (FQDNfirst=malloc(FQDNLEN*NUMADR)) == NULL ) return FALSE;
  if ( (NETBNfirst=malloc(UNCLEN*NUMADR)) == NULL ) return FALSE;
  if ( (NBfirst=malloc(UNCLEN*L254))      == NULL ) return FALSE;
  if ( (NBIPfirst=malloc(IPLEN*L254))     == NULL ) return FALSE;
  if ( (MACNBfirst=malloc(MACLEN*L254))   == NULL ) return FALSE;

//-----------------------------------------------------------------------------
// ନ㥬 ᨢ " "
//-----------------------------------------------------------------------------
  if ( (FileOUI = fopen("oui.lst", "r")) == NULL )
    {
    if ( (CompNfirst=calloc(COMPNLEN*NumOUI+L7, L1)) == NULL ) return FALSE;
    }
  else
    {
    for (; fgets(IPfirst, COMPNLEN, FileOUI) != NULL; NumOUI++) ;

    if ( (CompNfirst=calloc(COMPNLEN*NumOUI+L1, L1)) == NULL ) return FALSE;
    rewind(FileOUI);

    for (i=0, CompN = CompNfirst; i<NumOUI; i++, CompN+=COMPNLEN)
      {
      fgets(CompN, COMPNLEN, FileOUI);
      CompN[strlen(CompN)-1] = '\0';
      }

    if ( fclose(FileOUI) )
      {
      SendErrMsg(hwnd, "Error in fclose for oui.lst");
      return FALSE;
      }
    }

//-----------------------------------------------------------------------------
//  ᢮ MAC-
//-----------------------------------------------------------------------------
  if ( (stat=malloc(sizeof(struct ifmib))) == NULL ) return FALSE;

  if ( (NBI1=malloc(L254*sizeof(struct netbios_info_1)))==NULL ) return FALSE;
  bufFind=(char *)NBI1;

#ifdef TCPV40HDRS    //   TCP/IP 4.0
  if ( ioctl(sock, SIOSTATIF42, (char *)stat, sizeof(struct ifmib)) != 0 )
    {
    SendErrMsg(hwnd, ErrSIOSTATIF42);
    return FALSE;
    }

  memset(MyMAC, 0, sizeof(MyMAC));
  for( i=0; i < MAXIPADR; i++)
    if ( stat->iftable[i].ifMtu != 0 )
      memcpy(&MyMAC[i*L6], stat->iftable[i].ifPhysAddr, L6);
#else                // ᪫  TCP/IP 4.0
  if ( os2_ioctl(sock, SIOSTATIF42, (char *)stat, sizeof(struct ifmib)) != 0 )
    {
    SendErrMsg(hwnd, ErrSIOSTATIF42);
    return FALSE;
    }

//-----------------------------------------------------------------------------
//  ᢮ MAC-
//-----------------------------------------------------------------------------
  memset(MyMAC, 0, sizeof(MyMAC));
  for( i=0; i < MAXIPADR; i++)
    if ( stat->iftable[i].iftMtu != 0 )
      memcpy(&MyMAC[i*L6], stat->iftable[i].iftPhysAddr, L6);
#endif               // TCPV40HDRS
  free(stat);
  return TRUE;
}

//=============================================================================
// SendErrMsg - ணࠬ 뤠 ᮮ饭  訡
//=============================================================================
void SendErrMsg(HWND hwnd, char *ptr)
{
   WinMessageBox( HWND_DESKTOP,
                  hwnd,
                  ptr,
                  "LanScan Message",
                  0,
                  MB_OK | MB_APPLMODAL | MB_ERROR );
   WinPostMsg(hwnd, WM_CLOSE, 0L, 0L);
}

//=============================================================================
// PostErrMsg - ணࠬ ନ஢  稨 訡
//=============================================================================
void PostErrMsg(ULONG pHwnd, char *ptr)
{
   DosResetEventSem( hevEventHandle, &ulPostCnt );
   strcpy(ErrMsg, ptr);
   WinPostMsg( pHwnd, WM_USER_SCAN_ERROR, 0L, 0L );
   DosSuspendThread(tid);
}

//=============================================================================
// GetFileName - ணࠬ 맮  Save As ...
//=============================================================================
BOOL GetFileName(void)
{
   FILEDLG fileDialog;
   CHAR szTitle[] = "Save LanScan results as ...", szButton[] = "Ok";

   fileDialog.cbSize = sizeof(FILEDLG);       // Size of FILEDLG structure
   fileDialog.fl = FDS_SAVEAS_DIALOG | FDS_ENABLEFILELB; // FDS_ flags.
   fileDialog.ulUser = 0UL;           // User defined field
   fileDialog.lReturn = 0L;           // Result code from dialog dismissal
   fileDialog.lSRC = 0L;              // System return code
   fileDialog.pszTitle = szTitle;     // String to display in title bar
   fileDialog.pszOKButton = szButton; // String to display in OK button
   fileDialog.pfnDlgProc = NULL;      // Entry point to custom dialog proc.
   fileDialog.pszIType = NULL;        // Pointer to string containing initial
                                      // EA type filter. Type does not have
                                      // to exist in list.
   fileDialog.papszITypeList = NULL;  // Pointer to table of pointers that
                                      // point to null terminated Type strings.
                                      // End of table is marked by a NULL ptr.
   fileDialog.pszIDrive = NULL;  // Pointer to string containing initial drive.
                                 // Drive does not have to exist in drive list.
   fileDialog.papszIDriveList = NULL; // Pointer to table of pointers that
                                      // point to null terminated Drive strings
                                      // End of table is marked by a NULL ptr.
   fileDialog.hMod = (HMODULE)0;              // Custom File Dialog template
   strcpy(fileDialog.szFullFile, szFullPath); // Initial or selected fully
                                              // qualified path and file.
   fileDialog.papszFQFilename = NULL; // Pointer to table of pointers that
                                      // point to null terminated FQFname
                                      // strings. End of table is marked
                                      // by a NULL pointer.
   fileDialog.ulFQFCount = 0UL;               // Number of files selected
   fileDialog.usDlgId = IDD_FILESAVE;         // Custom dialog id.
   fileDialog.x = 0;                          // X coordinate of the dialog
   fileDialog.y = 0;                          // Y coordinate of the dialog
   fileDialog.sEAType = 0;                    // Selected file's EA Type.
//-----------------------------------------------------------------------------
// Get the file name
//-----------------------------------------------------------------------------
   if (!WinFileDlg(HWND_DESKTOP, hwndMLE, (PFILEDLG)&fileDialog)) return FALSE;
   if (fileDialog.lReturn != ID_OK) return FALSE;
//-----------------------------------------------------------------------------
// Copy file name and path returned into buffers
//-----------------------------------------------------------------------------
   strcpy(szFullPath, fileDialog.szFullFile);
   return TRUE;
}

//=============================================================================
// DoSave - ணࠬ ࠭ १⮢ ᪠஢
//=============================================================================
BOOL DoSave(HWND hwnd, char *File, char *mode)
{
  FILE *OutFile;
  char temp[32];
  int i;

  timeptr=localtime(&ltime);
  strftime(temp, sizeof(temp)-1, "%d/%m/%Y %T",timeptr);
  if ( (OutFile = fopen(File, mode)) == NULL )
    {
    SendErrMsg(hwnd, "Error in fopen");
    return FALSE;
    }
  fprintf(OutFile, "%s %s\n%s\n", TitleBar, temp, pszCnrTitle);
  fprintf(OutFile,
          "IP address       MAC address   NetBIOS name     Host name\n");
//         123.123.123.123 1234-1234-1234 123456789x123456

  IP=IPfirst;
  MAC=MACfirst;
  FQDN=FQDNfirst;
  NETBN=NETBNfirst;
  for (i = 0; i < CurrNum;
       i++, IP += IPLEN, MAC += MACLEN, FQDN += FQDNLEN, NETBN += UNCLEN)
  fprintf(OutFile, "%-15s %-14s %-16s %s\n", IP, MAC, NETBN, FQDN);

  if ( fclose(OutFile) )
    {
    sprintf(ErrMsg, "Error in fclose for %s", File);
    SendErrMsg(hwnd, ErrMsg);
    return FALSE;
    }
  return TRUE;
}

//=============================================================================
// TestAddr - ணࠬ ஢ન  IP-  ᯨ᪥ 䥩ᮢ
//=============================================================================
BOOL TestAddr(HWND hwnd, int k)
{
int i;

#ifndef TCPV40HDRS   // ᪫  TCP/IP 4.0
   if ( os2_ioctl(sock, SIOSTATAT, (char *)buf, sizeof(buf)) != 0 )
        {
        SendErrMsg(hwnd, ErrSIOSTATAT);
        return FALSE;
        }
#else                //   TCP/IP 4.0
   if ( ioctl(sock, SIOSTATAT, (char *)buf, sizeof(buf)) != 0 )
        {
        SendErrMsg(hwnd, ErrSIOSTATAT);
        return FALSE;
        }
#endif               // TCPV40HDRS

   for ( i=0, AdrInfo=(struct statatreq *)&buf[2]; i < *pi; i++, AdrInfo++ )
        {
        if ( (sin[k].sin_addr.s_addr == AdrInfo->addr) &&
             (AdrInfo->interface >= 0) &&       //  
             (AdrInfo->interface < MAXIPADR) )  // lan0 - lan7
             {
             memcpy((char *)&AddrInfoIP[k], AdrInfo, sizeof(struct statatreq));
             return TRUE;
             }
        }
   return FALSE;
}

//=============================================================================
// FormNCB - ணࠬ ஥  NCB  ⮢  TCPBEUI
//=============================================================================
void FormNCB(HWND hwnd)
{
  int i, j, k;
  unsigned long ERead, EAvailable;

  if ( NetBios32Enum(NULL, L1, bufFind, len, &ERead, &EAvailable) != 0 )
    {
    SendErrMsg(hwnd, "Error in NetBios32Enum");
    return;
    }

  for ( i=0; i<ERead; i++)
    {
    if (strcmpi(NBI1[i].nb1_driver_name, "NETBEUI$") == 0)
      {
      for ( j=0; j<NumIPadr; j++ )
        if ( NBI1[i].nb1_lana_num == AddrInfoIP[j].interface )
          {
          strcpy(NetName+NumNCB*(NETBIOS_NAME_LEN+1), NBI1[i].nb1_net_name);
          NCBB[NumNCB].ncb_command = NCBASTAT;    // NCB.STATUS
          NCBB[NumNCB].ncb_buffer = bufFind;
          NCBB[NumNCB].ncb_lana_num = NBI1[i].nb1_lana_num;
          NumNCB++;
          for ( k=0; k<j; k++ ) // ⬥ NETBEUI  㡫 䥩ᮢ
            if ( AddrInfoIP[k].addr == AddrInfoIP[j].addr )
              {
              NumNCB--;
              break;
              }
          break;
          }
      }
    else
      if (strcmpi(NBI1[i].nb1_driver_name, "TCPBEUI$") == 0)
        {
        for ( j=0; j<NumIPadr; j++ )
          {
          if ( NBI1[i].nb1_lana_num == AddrInfoIP[j].interface )
            ChkTCPB[j] = TRUE;

          for ( k=0; k<j; k++ ) // ⬥ TCPBEUI  㡫 䥩ᮢ
            if ( AddrInfoIP[k].addr == AddrInfoIP[j].addr )
              {
              ChkTCPB[j] = FALSE;
              break;
              }
          }
        }
    }
}

//=============================================================================
// TestInt - ணࠬ ஢ન  ࢠ
//=============================================================================
BOOL TestInt(int i, int j)
{
  char *p, argi[L32];

  if ( j == 0 ) return FALSE;

  j--;   // NumIPadr ᥣ  1 , 祬 

  if ( Interv[j] == NUMINTERV ) return FALSE;

  if ( strlen(av[i+1]) >= sizeof(argi) ) return FALSE;
  strcpy(argi, av[i+1]+1);
  if ( (p=strchr(argi, '-')) == NULL ) return FALSE;
  *p++='\0';

  if ( (HostInt[j].start[Interv[j]]=inet_addr(argi)) == -1 ) return FALSE;
  if ( (HostInt[j].stop[Interv[j]]=inet_addr(p)) == -1 ) return FALSE;

  HostInt[j].start[Interv[j]] = htonl(HostInt[j].start[Interv[j]]);
  HostInt[j].stop[Interv[j]]  = htonl(HostInt[j].stop[Interv[j]]);

  if ( (HostInt[j].start[Interv[j]] == 0) ||
       (HostInt[j].start[Interv[j]] >  HostInt[j].stop[Interv[j]]) ||
       (HostInt[j].stop[Interv[j]]  >= ~AddrInfoIP[j].mask) ) return FALSE;

  Interv[j]++;
  return TRUE;
}

//=============================================================================
// GetIPaddr - ணࠬ 宦 IP-   䥩
//=============================================================================
void GetIPaddr(HWND hwnd, short j)
{
int i;

#ifndef TCPV40HDRS   // ᪫  TCP/IP 4.0
  if ( os2_ioctl(sock, SIOSTATAT, (char *)buf, sizeof(buf)) != 0 )
    {
    SendErrMsg(hwnd, ErrSIOSTATAT);
    return;
    }
#else                //   TCP/IP 4.0
  if ( ioctl(sock, SIOSTATAT, (char *)buf, sizeof(buf)) != 0 )
    {
    SendErrMsg(hwnd, ErrSIOSTATAT);
    return;
    }
#endif               // TCPV40HDRS

  for ( i=0, AdrInfo=(struct statatreq *)&buf[2]; i < *pi; i++, AdrInfo++ )
    {
    if ( AdrInfo->interface == j )
      {
      sin[NumIPadr].sin_family = AF_INET;
      sin[NumIPadr].sin_addr.s_addr = AdrInfo->addr;
      memcpy((char *)&AddrInfoIP[NumIPadr], AdrInfo, sizeof(struct statatreq));
      NumIPadr++;
      if ( NumIPadr == MAXIPADR ) return;
      }
    }
}

//=============================================================================
// GetIPname - ணࠬ 宦  
//=============================================================================
_inline void GetIPname(HWND hwnd, char *ptr, u_long i)
{
struct hostent *hent;

   *FQDN = '\0';
   if ( !useDNS ) return;

   WinPostMsg (hwnd, WM_USER_DNS, MPFROMLONG(i), 0L);
   if ( (hent = gethostbyaddr(ptr, L4, AF_INET)) != NULL )
     {
     if ( strlen(hent->h_name) >= FQDNLEN )
       {
       memset(FQDN, 0, FQDNLEN);
       strncpy(FQDN, hent->h_name, FQDNLEN-1);
       }
       else strcpy(FQDN, hent->h_name);
     }
   return;
}

//=============================================================================
// TestPing - ணࠬ । ࢠ  PING
//=============================================================================
BOOL TestPing(int i)
{
  char *p, argi[L32];

  if ( NumPing == MAXIPADR ) return FALSE;

  if ( strlen(av[i+1]) >= sizeof(argi) ) return FALSE;
  strcpy(argi, av[i+1]+1);
  if ( (p=strchr(argi, '-')) == NULL ) return FALSE;
  *p++='\0';

  if ( (PingStart[NumPing]=inet_addr(argi)) == -1 ) return FALSE;
  if ( (PingStop[NumPing]=inet_addr(p)) == -1 ) return FALSE;

  if ( (PingStart[NumPing] == 0) ||
       (htonl(PingStart[NumPing]) > htonl(PingStop[NumPing])) ) return FALSE;

  NumPing++;
  return TRUE;
}

//=============================================================================
//	   I N _ C K S U M
// Checksum routine for Internet Protocol family headers (C Version)
//=============================================================================
_inline u_short in_cksum(u_short* addr, int len)
{
   register int nleft = len;
   register u_short *w = addr;
   register int sum = 0;
   u_short answer = 0;

//-----------------------------------------------------------------------------
// Our algorithm is simple, using a 32 bit accumulator (sum),
// we add sequential 16 bit words to it, and at the end,
// fold back all the carry bits from the top 16 bits into the lower 16 bits.
//-----------------------------------------------------------------------------
   while( nleft > 1 )
      {
      sum += *w++;
      nleft -= 2;
      }

//-----------------------------------------------------------------------------
// mop up an odd byte, if necessary
//-----------------------------------------------------------------------------
   if ( nleft == 1 )
      {
      *(u_char *)(&answer) = *(u_char *)w ;
      sum += answer;
      }

//-----------------------------------------------------------------------------
// add back carry outs from top 16 bits to low 16 bits
//-----------------------------------------------------------------------------
   sum = (sum >> 16) + (sum & 0xffff); // add hi 16 to low 16
   sum += (sum >> 16);                 // add possible carry
   answer = (u_short)~sum;             // ones complement & truncate to 16 bits
   return (answer);
}

//=============================================================================
// PingRange - ணࠬ 믮 ping   ᮢ
//=============================================================================
void PingRange(HWND hwnd, int j)
{
u_long len, num, start, stop;
struct sockaddr_in whereto;   // Who to ping
u_char outpack[PING_MAXPACKET];
struct icmp *icp = (struct icmp *)outpack;
u_char *datap = (u_char *)(icp->icmp_data);
u_char inpack[PING_MAXPACKET];
struct ip *ip = (struct ip *)inpack;

   strcpy(IP, LineSep);
   strcpy(MAC, LineSep);
   strcpy(FQDN, LineSep);
   *NETBN = '\0';
   IP += IPLEN;
   MAC += MACLEN;
   FQDN += FQDNLEN;
   NETBN += UNCLEN;
   WinPostMsg ( hwnd,
                WM_USER_LINE_DONE,
                MPFROMLONG(CurrNum++),
                MPFROMLONG(NumOUI) );

   start = htonl(PingStart[j]);
   stop = htonl(PingStop[j]);

   if ( (proto = getprotobyname("icmp")) == NULL )
     PostErrMsg(hwnd, ErrGetProtoByName);

#ifdef TCPV40HDRS    //   TCP/IP 4.0
   if ( sock_init() != 0 ) PostErrMsg(hwnd, ErrSock_Init);
#endif               // TCPV40HDRS

   if ( (sock = socket(PF_INET, SOCK_RAW, proto->p_proto)) < 0 )
     PostErrMsg(hwnd, ErrSocket);

   memset( (char *)&whereto, 0, sizeof(struct sockaddr_in) );
   whereto.sin_family = PF_INET;
   strcpy(icp->icmp_data, TitleBar);
   strcat(icp->icmp_data, " ABCDEFGHIJKLMNOPRSTUVWXYZ 0123456789 Verify");
   len = strlen(icp->icmp_data) + 1 + (datap-outpack);
   icp->icmp_type = ICMP_ECHO;
   icp->icmp_code = 0;
   icp->icmp_id = 0x3554; // identitier for outbound packet
   icp->icmp_seq = 1;     // sequence number for outbound packet

#ifndef TCPV40HDRS   // ᪫  TCP/IP 4.0
   if ( setsockopt(sock,
                   SOL_SOCKET,
                   SO_RCVTIMEO,
                   (char *)&pingtv,
                   sizeof(struct timeval)) != 0 )
     PostErrMsg(hwnd, ErrSetSockOptRCVTIMEO);
#else                //   TCP/IP 4.0
   if ( ioctl(sock, FIONBIO, (char *)&dontblock, sizeof(dontblock)) != 0 )
     PostErrMsg(hwnd, ErrFIONBIO);
#endif               // TCPV40HDRS

   for (num=start; (num<=stop) && (CurrNum<NUMADR); num++)
     {
     WinPostMsg (hwnd, WM_USER_PING, MPFROMLONG(num), 0L);
     whereto.sin_addr.s_addr = htonl(num);
     icp->icmp_cksum = 0;
     icp->icmp_cksum = in_cksum( (u_short*)icp, len ); // Compute ICMP CheckSum

     if ( sendto(sock,
                 (char *)outpack,
                 len,
                 0,
                 (struct sockaddr *)&whereto,
                 sizeof(struct sockaddr_in))==-1 ) PostErrMsg(hwnd,ErrSendTo);

#ifdef TCPV40HDRS    //   TCP/IP 4.0
     DosSleep(1000*pingtv.tv_sec);
#endif               // TCPV40HDRS

     if ( recvfrom(sock, inpack, PING_MAXPACKET, 0, 0, 0) == -1) continue;
     sprintf( IP, "%s", inet_ntoa(ip->ip_src) );

     GetIPname(hwnd,(char *)&whereto.sin_addr.s_addr,whereto.sin_addr.s_addr);
     *MAC = '\0';
     *NETBN = '\0';
     IP += IPLEN;
     MAC += MACLEN;
     FQDN += FQDNLEN;
     NETBN += UNCLEN;
     WinPostMsg ( hwnd,
                  WM_USER_LINE_DONE,
                  MPFROMLONG(CurrNum++),
                  MPFROMLONG(NumOUI) );
     continue;
     }
   if ( soclose(sock) != 0 ) PostErrMsg(hwnd, ErrSoclose);
}
